CREATE TABLE Detail
(
	Id bigint not null,
	Name varchar(60) not null,
	Note varchar(2000),
	Catalog_Nr smallint,
	constraint [Detail pk]
		primary key (Id),
	constraint [Detail to Catalog ref]
		foreign key (Catalog_Nr)
			references Main_Catalog
)
go


SELECT cast(I.object_id as bigint) * 100000 + (I.index_id % 30000) as Combi_Id,
       T.type as The_Type
FROM [master].sys.all_objects as T,
     [master].sys.indexes as I
WHERE T.schema_id = @theSchemaId
  and T.type in ('U','S','IT','V','TT')
  and T.object_id = I.object_id
  and I.type != 0
go  