/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.instrumentation;

import com.intellij.compiler.instrumentation.InstrumentationClassFinder;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class JrtLoader
extends InstrumentationClassFinder.ClassFinderClasspath.Loader {
    private static final URI ROOT_URI = URI.create("jrt:/");
    private static final InstrumentationClassFinder.Resource NULL_RESOURCE = () -> null;
    private List<Path> myRoots;
    private final Map<String, InstrumentationClassFinder.Resource> myCache = new HashMap<String, InstrumentationClassFinder.Resource>();

    public JrtLoader(URL url, int index) {
        super(url, index);
    }

    public InstrumentationClassFinder.Resource getResource(String name) {
        InstrumentationClassFinder.Resource cached = this.myCache.get(name);
        if (cached != null) {
            return cached != NULL_RESOURCE ? cached : null;
        }
        try {
            for (Path root : this.getRoots()) {
                Path path = root.resolve(name);
                if (!Files.exists(path, new LinkOption[0])) continue;
                InstrumentationClassFinder.Resource res = () -> Files.newInputStream(path, StandardOpenOption.READ);
                this.myCache.put(name, res);
                return res;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.myCache.put(name, NULL_RESOURCE);
        return null;
    }

    public synchronized void releaseResources() {
        this.myCache.clear();
        List<Path> roots = this.myRoots;
        if (roots != null) {
            try {
                if (!roots.isEmpty()) {
                    roots.iterator().next().getFileSystem().close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                roots.clear();
                this.myRoots = null;
            }
        }
    }

    private synchronized List<Path> getRoots() throws IOException {
        List<Path> cached = this.myRoots;
        if (cached != null) {
            return cached;
        }
        FileSystem fs = FileSystems.newFileSystem(ROOT_URI, Collections.singletonMap("java.home", this.getBaseURL().getPath()));
        final ArrayList<Path> roots = new ArrayList<Path>();
        final Path modulesDir = fs.getPath("modules", new String[0]);
        Files.walkFileTree(modulesDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                if (!modulesDir.equals(dir)) {
                    roots.add(dir);
                    return FileVisitResult.SKIP_SUBTREE;
                }
                return FileVisitResult.CONTINUE;
            }
        });
        this.myRoots = roots;
        return roots;
    }
}

