/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl.light.nodes;

import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.MissingNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.io.URLUtil;
import com.jetbrains.jsonSchema.impl.EnumArrayValueWrapper;
import com.jetbrains.jsonSchema.impl.EnumObjectValueWrapper;
import com.jetbrains.jsonSchema.impl.light.RawJsonSchemaNodeAccessor;
import com.jetbrains.jsonSchema.impl.light.nodes.SchemaParsingUtilsKt;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0004\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c0\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u001a\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u00022\b\u0010\u000b\u001a\u0004\u0018\u00010\bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\bH\u0016J\u001c\u0010\u000e\u001a\u0004\u0018\u00010\b2\u0006\u0010\n\u001a\u00020\u00022\b\u0010\u000b\u001a\u0004\u0018\u00010\bH\u0016J\u001c\u0010\u000f\u001a\u0004\u0018\u00010\b2\u0006\u0010\n\u001a\u00020\u00022\b\u0010\u000b\u001a\u0004\u0018\u00010\bH\u0016J!\u0010\u0010\u001a\u0004\u0018\u00010\r2\u0006\u0010\n\u001a\u00020\u00022\b\u0010\u000b\u001a\u0004\u0018\u00010\bH\u0016\u00a2\u0006\u0002\u0010\u0011J\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\n\u001a\u00020\u00022\b\u0010\u000b\u001a\u0004\u0018\u00010\bH\u0016J\"\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u00152\u0006\u0010\n\u001a\u00020\u00022\b\u0010\u000b\u001a\u0004\u0018\u00010\bH\u0016J.\u0010\u0017\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00020\u0018\u0018\u00010\u00152\u0006\u0010\n\u001a\u00020\u00022\b\u0010\u000b\u001a\u0004\u0018\u00010\bH\u0016J4\u0010\u0019\u001a\u001c\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u001a0\u0018\u0018\u00010\u00152\u0006\u0010\n\u001a\u00020\u00022\b\u0010\u000b\u001a\u0004\u0018\u00010\bH\u0016J\"\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00152\u0006\u0010\n\u001a\u00020\u00022\b\u0010\u000b\u001a\u0004\u0018\u00010\bH\u0016J\u001c\u0010\u001c\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u00022\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\bH\u0002J\"\u0010\u001e\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00152\u0006\u0010\n\u001a\u00020\u00022\b\u0010\u000b\u001a\u0004\u0018\u00010\bH\u0002J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u00162\u0006\u0010\n\u001a\u00020\u0002H\u0002J\u0012\u0010 \u001a\u0004\u0018\u00010\b2\u0006\u0010!\u001a\u00020\u0002H\u0002J\u0012\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020\bH\u0002J\u0010\u0010%\u001a\u00020\r2\u0006\u0010&\u001a\u00020\bH\u0002J\u0010\u0010'\u001a\u00020\b2\u0006\u0010(\u001a\u00020\bH\u0002\u00a8\u0006)"}, d2={"Lcom/jetbrains/jsonSchema/impl/light/nodes/JacksonSchemaNodeAccessor;", "Lcom/jetbrains/jsonSchema/impl/light/RawJsonSchemaNodeAccessor;", "Lcom/fasterxml/jackson/databind/JsonNode;", "<init>", "()V", "resolveNode", "rootNode", "absoluteNodeJsonPointer", "", "resolveRelativeNode", "node", "relativeChildPath", "hasChildNode", "", "readUntypedNodeValueAsText", "readTextNodeValue", "readBooleanNodeValue", "(Lcom/fasterxml/jackson/databind/JsonNode;Ljava/lang/String;)Ljava/lang/Boolean;", "readNumberNodeValue", "", "readUntypedNodesCollection", "Lkotlin/sequences/Sequence;", "", "readNodeAsMapEntries", "Lkotlin/Pair;", "readNodeAsMultiMapEntries", "", "readNodeKeys", "getExistingChildByNonEmptyPathOrSelf", "directChildName", "getChildArrayItems", "readAnything", "asDoubleQuotedTextOrNull", "jsonNode", "escapeAndCompileJsonPointer", "Lcom/fasterxml/jackson/core/JsonPointer;", "unescapedPointer", "fastCheckIfCorrectPointer", "maybeIncorrectPointer", "adaptJsonPointerToJacksonImplementation", "oldPointer", "intellij.json.backend"})
@SourceDebugExtension(value={"SMAP\nschemaParsingUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 schemaParsingUtils.kt\ncom/jetbrains/jsonSchema/impl/light/nodes/JacksonSchemaNodeAccessor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,133:1\n1#2:134\n18#3:135\n37#4,2:136\n23#5:138\n*S KotlinDebug\n*F\n+ 1 schemaParsingUtils.kt\ncom/jetbrains/jsonSchema/impl/light/nodes/JacksonSchemaNodeAccessor\n*L\n91#1:135\n103#1:136,2\n117#1:138\n*E\n"})
public final class JacksonSchemaNodeAccessor
implements RawJsonSchemaNodeAccessor<JsonNode> {
    @NotNull
    public static final JacksonSchemaNodeAccessor INSTANCE = new JacksonSchemaNodeAccessor();

    private JacksonSchemaNodeAccessor() {
    }

    @Override
    @Nullable
    public JsonNode resolveNode(@NotNull JsonNode rootNode, @NotNull String absoluteNodeJsonPointer) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)rootNode, (String)"rootNode");
        Intrinsics.checkNotNullParameter((Object)absoluteNodeJsonPointer, (String)"absoluteNodeJsonPointer");
        JsonPointer jsonPointer2 = this.escapeAndCompileJsonPointer(absoluteNodeJsonPointer);
        if (jsonPointer2 == null) {
            return null;
        }
        JsonPointer compiledPointer = jsonPointer2;
        JsonNode jsonNode = rootNode.at(compiledPointer);
        if (jsonNode != null) {
            JsonNode jsonNode2;
            JsonNode it = jsonNode2 = jsonNode;
            boolean bl = false;
            object = !(it instanceof MissingNode) ? jsonNode2 : null;
        } else {
            object = null;
        }
        return object;
    }

    @Override
    @NotNull
    public JsonNode resolveRelativeNode(@NotNull JsonNode node, @Nullable String relativeChildPath) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return this.getExistingChildByNonEmptyPathOrSelf(node, relativeChildPath);
    }

    @Override
    public boolean hasChildNode(@NotNull JsonNode node, @NotNull String relativeChildPath) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)relativeChildPath, (String)"relativeChildPath");
        return node.isObject() && !this.getExistingChildByNonEmptyPathOrSelf(node, relativeChildPath).isMissingNode();
    }

    @Override
    @Nullable
    public String readUntypedNodeValueAsText(@NotNull JsonNode node, @Nullable String relativeChildPath) {
        JsonNode jsonNode;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (!node.isObject() && relativeChildPath != null) {
            return null;
        }
        JsonNode it = jsonNode = this.getExistingChildByNonEmptyPathOrSelf(node, relativeChildPath);
        boolean bl = false;
        JsonNode jsonNode2 = !(it instanceof MissingNode) ? jsonNode : null;
        return jsonNode2 != null ? jsonNode2.toPrettyString() : null;
    }

    @Override
    @Nullable
    public String readTextNodeValue(@NotNull JsonNode node, @Nullable String relativeChildPath) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (!node.isObject() && relativeChildPath != null) {
            return null;
        }
        JsonNode maybeString = this.getExistingChildByNonEmptyPathOrSelf(node, relativeChildPath);
        return maybeString.isTextual() ? maybeString.asText() : null;
    }

    @Override
    @Nullable
    public Boolean readBooleanNodeValue(@NotNull JsonNode node, @Nullable String relativeChildPath) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (!(node.isObject() || node.isBoolean() && relativeChildPath == null)) {
            return null;
        }
        JsonNode maybeBoolean = relativeChildPath == null ? node : this.getExistingChildByNonEmptyPathOrSelf(node, relativeChildPath);
        return maybeBoolean.isBoolean() ? Boolean.valueOf(maybeBoolean.asBoolean()) : null;
    }

    @Override
    @Nullable
    public Number readNumberNodeValue(@NotNull JsonNode node, @Nullable String relativeChildPath) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (!node.isObject() && relativeChildPath != null) {
            return null;
        }
        JsonNode maybeNumber = this.getExistingChildByNonEmptyPathOrSelf(node, relativeChildPath);
        return maybeNumber.isInt() ? (Number)maybeNumber.asInt() : (Number)(maybeNumber.isDouble() ? (Number)maybeNumber.asDouble() : (Number)(maybeNumber.isLong() ? (Number)maybeNumber.asLong() : null));
    }

    @Override
    @Nullable
    public Sequence<Object> readUntypedNodesCollection(@NotNull JsonNode node, @Nullable String relativeChildPath) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Sequence<JsonNode> sequence = this.getChildArrayItems(node, relativeChildPath);
        return sequence != null ? SequencesKt.mapNotNull(sequence, (Function1)((Function1)new Function1<JsonNode, Object>((Object)INSTANCE){

            public final Object invoke(JsonNode p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return JacksonSchemaNodeAccessor.access$readAnything((JacksonSchemaNodeAccessor)this.receiver, p0);
            }
        })) : null;
    }

    @Override
    @Nullable
    public Sequence<Pair<String, JsonNode>> readNodeAsMapEntries(@NotNull JsonNode node, @Nullable String relativeChildPath) {
        Sequence sequence;
        Object object;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (!node.isObject() && relativeChildPath != null) {
            return null;
        }
        JsonNode it = object = this.getExistingChildByNonEmptyPathOrSelf(node, relativeChildPath);
        boolean bl = false;
        JsonNode jsonNode = it.isObject() ? object : null;
        return jsonNode != null && (object = jsonNode.properties()) != null && (sequence = CollectionsKt.asSequence((Iterable)((Iterable)object))) != null ? SequencesKt.map((Sequence)sequence, JacksonSchemaNodeAccessor::readNodeAsMapEntries$lambda$1) : null;
    }

    @Override
    @Nullable
    public Sequence<Pair<String, List<String>>> readNodeAsMultiMapEntries(@NotNull JsonNode node, @Nullable String relativeChildPath) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Sequence<Pair<String, JsonNode>> sequence = this.readNodeAsMapEntries(node, relativeChildPath);
        return sequence != null ? SequencesKt.mapNotNull(sequence, JacksonSchemaNodeAccessor::readNodeAsMultiMapEntries$lambda$0) : null;
    }

    @Override
    @Nullable
    public Sequence<String> readNodeKeys(@NotNull JsonNode node, @Nullable String relativeChildPath) {
        Iterator iterator;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        JsonNode expandedNode = this.getExistingChildByNonEmptyPathOrSelf(node, relativeChildPath);
        Iterator p0 = iterator = expandedNode.fieldNames();
        boolean bl = false;
        Iterator iterator2 = p0.hasNext() ? iterator : null;
        return iterator2 != null ? SequencesKt.asSequence((Iterator)iterator2) : null;
    }

    private final JsonNode getExistingChildByNonEmptyPathOrSelf(JsonNode node, String directChildName) {
        JsonNode jsonNode;
        if (directChildName == null) {
            jsonNode = node;
        } else {
            JsonNode jsonNode2 = node.get(directChildName);
            if (jsonNode2 == null) {
                jsonNode2 = (JsonNode)MissingNode.getInstance();
            }
            JsonNode jsonNode3 = jsonNode2;
            Intrinsics.checkNotNull((Object)jsonNode3);
            jsonNode = jsonNode3;
        }
        return jsonNode;
    }

    static /* synthetic */ JsonNode getExistingChildByNonEmptyPathOrSelf$default(JacksonSchemaNodeAccessor jacksonSchemaNodeAccessor, JsonNode jsonNode, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        return jacksonSchemaNodeAccessor.getExistingChildByNonEmptyPathOrSelf(jsonNode, string);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Sequence<JsonNode> getChildArrayItems(JsonNode node, String relativeChildPath) {
        void $this$asSafely$iv;
        JsonNode jsonNode;
        if (!node.isObject() && relativeChildPath != null) {
            return null;
        }
        JsonNode it = jsonNode = this.getExistingChildByNonEmptyPathOrSelf(node, relativeChildPath);
        boolean bl = false;
        if (!it.isArray()) return null;
        JsonNode jsonNode2 = jsonNode;
        JsonNode jsonNode3 = jsonNode2;
        if (jsonNode3 == null) return null;
        it = jsonNode3;
        boolean $i$f$asSafely = false;
        Object v1 = $this$asSafely$iv;
        if (!(v1 instanceof ArrayNode)) {
            v1 = null;
        }
        if ((jsonNode = (ArrayNode)v1) == null) return null;
        Iterator iterator = jsonNode.elements();
        if (iterator == null) return null;
        Sequence sequence = SequencesKt.asSequence((Iterator)iterator);
        return sequence;
    }

    private final Object readAnything(JsonNode node) {
        Object object;
        if (node.isTextual()) {
            object = this.asDoubleQuotedTextOrNull(node);
        } else if (node.isNull()) {
            object = node.asText();
        } else if (node.isInt()) {
            object = node.asInt();
        } else if (node.isLong()) {
            object = node.asLong();
        } else if (node.isDouble()) {
            object = node.asDouble();
        } else if (node.isBoolean()) {
            object = node.asBoolean();
        } else if (node.isObject()) {
            Set set = node.properties();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"properties(...)");
            object = new EnumObjectValueWrapper(MapsKt.toMap((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)set), JacksonSchemaNodeAccessor::readAnything$lambda$0)));
        } else if (node.isArray()) {
            Iterator iterator = node.elements();
            Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"elements(...)");
            Collection $this$toTypedArray$iv = SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.asSequence((Iterator)iterator), (Function1)((Function1)new Function1<JsonNode, Object>((Object)INSTANCE){

                public final Object invoke(JsonNode p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return JacksonSchemaNodeAccessor.access$readAnything((JacksonSchemaNodeAccessor)this.receiver, p0);
                }
            })));
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            EnumArrayValueWrapper enumArrayValueWrapper = new EnumArrayValueWrapper(thisCollection$iv.toArray(new Object[0]));
            object = enumArrayValueWrapper;
        } else {
            object = null;
        }
        return object;
    }

    private final String asDoubleQuotedTextOrNull(JsonNode jsonNode) {
        String string;
        if (!jsonNode.isTextual()) {
            string = null;
        } else {
            String string2 = jsonNode.asText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asText(...)");
            string = SchemaParsingUtilsKt.asDoubleQuotedString(string2);
        }
        return string;
    }

    private final JsonPointer escapeAndCompileJsonPointer(String unescapedPointer) {
        JsonPointer jsonPointer2;
        if (!this.fastCheckIfCorrectPointer(unescapedPointer)) {
            jsonPointer2 = null;
        } else {
            JsonPointer jsonPointer3;
            try {
                jsonPointer3 = JsonPointer.compile((String)this.adaptJsonPointerToJacksonImplementation(unescapedPointer));
            }
            catch (IllegalArgumentException exception) {
                JacksonSchemaNodeAccessor $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(JacksonSchemaNodeAccessor.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn("Unable to compile json pointer. Resolve aborted.", (Throwable)exception);
                jsonPointer3 = null;
            }
            jsonPointer2 = jsonPointer3;
        }
        return jsonPointer2;
    }

    private final boolean fastCheckIfCorrectPointer(String maybeIncorrectPointer) {
        return StringsKt.startsWith$default((String)maybeIncorrectPointer, (String)"/", (boolean)false, (int)2, null);
    }

    private final String adaptJsonPointerToJacksonImplementation(String oldPointer) {
        String string;
        if (Intrinsics.areEqual((Object)oldPointer, (Object)"/")) {
            string = "";
        } else {
            String string2 = URLUtil.unescapePercentSequences((String)oldPointer);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"unescapePercentSequences(...)");
        }
        return string;
    }

    private static final Pair readNodeAsMapEntries$lambda$1(Map.Entry it) {
        return TuplesKt.to(it.getKey(), it.getValue());
    }

    private static final String readNodeAsMultiMapEntries$lambda$0$0(JsonNode it) {
        return it.isTextual() ? it.asText() : null;
    }

    private static final Pair readNodeAsMultiMapEntries$lambda$0(Pair pair) {
        Intrinsics.checkNotNullParameter((Object)pair, (String)"<destruct>");
        String stringKey = (String)pair.component1();
        JsonNode arrayValue = (JsonNode)pair.component2();
        if (!arrayValue.isArray()) {
            return null;
        }
        Iterator iterator = arrayValue.elements();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"elements(...)");
        return TuplesKt.to((Object)stringKey, (Object)SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.asSequence((Iterator)iterator), JacksonSchemaNodeAccessor::readNodeAsMultiMapEntries$lambda$0$0)));
    }

    private static final Pair readAnything$lambda$0(Map.Entry it) {
        Object k = it.getKey();
        Object v = it.getValue();
        Intrinsics.checkNotNullExpressionValue(v, (String)"<get-value>(...)");
        return TuplesKt.to(k, (Object)INSTANCE.readAnything((JsonNode)v));
    }

    public static final /* synthetic */ Object access$readAnything(JacksonSchemaNodeAccessor $this, JsonNode node) {
        return $this.readAnything(node);
    }
}

