// Copyright 2000-2024 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license.
package com.jetbrains.jsonSchema.impl.light

internal const val SCHEMA_ROOT_POINTER = "/"
internal const val DEPRECATION = "deprecationMessage"
internal const val LANGUAGE = "language"
internal const val PREFIX = "prefix"
internal const val SUFFIX = "suffix"
internal const val TYPE = "type"
internal const val MULTIPLE_OF = "multipleOf"
internal const val MAXIMUM = "maximum"
internal const val MINIMUM = "minimum"
internal const val EXCLUSIVE_MAXIMUM = "exclusiveMaximum"
internal const val EXCLUSIVE_MINIMUM = "exclusiveMinimum"
internal const val MAX_LENGTH = "maxLength"
internal const val MIN_LENGTH = "minLength"
internal const val PATTERN = "pattern"
internal const val ADDITIONAL_PROPERTIES = "additionalProperties"
internal const val PROPERTY_NAMES = "propertyNames"
internal const val ADDITIONAL_ITEMS = "additionalItems"
internal const val PREFIX_ITEMS = "prefixItems"
internal const val ITEMS = "items"
internal const val CONTAINS = "contains"
internal const val MAX_ITEMS = "maxItems"
internal const val MIN_ITEMS = "minItems"
internal const val UNIQUE_ITEMS = "uniqueItems"
internal const val MAX_PROPERTIES = "maxProperties"
internal const val MIN_PROPERTIES = "minProperties"
internal const val REQUIRED = "required"
internal const val REF = "\$ref"
internal const val DYNAMIC_REF = "\$dynamicRef"
internal const val DYNAMIC_ANCHOR = "\$dynamicAnchor"
internal const val RECURSIVE_REF = "\$recursiveRef"
internal const val RECURSIVE_ANCHOR = "\$recursiveAnchor"
internal const val VOCABULARY = "\$vocabulary"
internal const val DEFAULT = "default"
internal const val FORMAT = "format"
internal const val ANCHOR = "\$anchor"
internal const val DESCRIPTION = "description"
internal const val TITLE = "title"
internal const val PATTERN_PROPERTIES = "patternProperties"
internal const val DEPENDENCIES = "dependencies"
internal const val DEPENDENT_SCHEMAS = "dependentSchemas"
internal const val DEPENDENT_REQUIRED = "dependentRequired"
internal const val ENUM = "enum"
internal const val CONST = "const"
internal const val ALL_OF = "allOf"
internal const val ANY_OF = "anyOf"
internal const val ONE_OF = "oneOf"
internal const val NOT = "not"
internal const val IF = "if"
internal const val THEN = "then"
internal const val ELSE = "else"
internal const val DEFS = "\$defs"
internal const val EXAMPLE = "example"
internal const val JSON_ID = "id"
internal const val JSON_DOLLAR_ID = "\$id"
internal const val UNEVALUATED_ITEMS = "unevaluatedItems"
internal const val UNEVALUATED_PROPERTIES = "unevaluatedProperties"

internal const val SCHEMA_KEYWORD_INVARIANT = "\$schema"

const val INSTANCE_OF = "instanceof"
const val TYPE_OF = "typeof"
const val JSON_DEFINITIONS = "definitions"
const val JSON_PROPERTIES = "properties"
const val X_INTELLIJ_HTML_DESCRIPTION = "x-intellij-html-description"
const val X_INTELLIJ_LANGUAGE_INJECTION = "x-intellij-language-injection"
const val X_INTELLIJ_CASE_INSENSITIVE = "x-intellij-case-insensitive"
const val X_INTELLIJ_ENUM_METADATA = "x-intellij-enum-metadata"
const val X_INTELLIJ_ENUM_ORDER_SENSITIVE = "x-intellij-enum-order-sensitive"
const val X_INTELLIJ_METADATA = "x-intellij-metadata"

internal val ROOT_POINTER_VARIANTS = setOf(SCHEMA_ROOT_POINTER, "#/", "#", "")