// Copyright 2000-2025 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license.
package com.jetbrains.performancePlugin;

import com.jetbrains.performancePlugin.commands.*;
import org.jetbrains.annotations.NotNull;

import java.util.Map;

public final class BaseCommandProvider implements CommandProvider {
  @Override
  public @NotNull Map<String, CreateCommand> getCommands() {
    return Map.<String, CreateCommand>ofEntries(
      Map.entry(RunConfigurationCommand.PREFIX, RunConfigurationCommand::new),
      Map.entry(TakeScreenshotCommand.PREFIX, TakeScreenshotCommand::new),
      Map.entry(OpenFileCommand.PREFIX, OpenFileCommand::new),
      Map.entry(StartProfileCommand.PREFIX, StartProfileCommand::new),
      Map.entry(StopProfileCommand.PREFIX, StopProfileCommand::new),
      Map.entry(InspectionCommand.PREFIX, InspectionCommand::new),
      Map.entry(InspectionCommandEx.PREFIX, InspectionCommandEx::new),
      Map.entry(ConfigureNamedScopeCommand.PREFIX, ConfigureNamedScopeCommand::new),
      Map.entry(ReformatCommand.PREFIX, ReformatCommand::new),
      Map.entry(GoToCommand.PREFIX, GoToCommand::new),
      Map.entry(ScrollEditorCommand.PREFIX, ScrollEditorCommand::new),
      Map.entry(DoLocalInspection.PREFIX, DoLocalInspection::new),
      Map.entry(CompletionCommand.PREFIX, CompletionCommand::new),
      Map.entry(DelayTypeCommand.PREFIX, DelayTypeCommand::new),
      Map.entry(ReplaceTextCommand.PREFIX, ReplaceTextCommand::new),
      Map.entry(ExitAppCommand.PREFIX, ExitAppCommand::new),
      Map.entry(ExitAppWithTimeoutCommand.PREFIX, ExitAppWithTimeoutCommand::new),
      Map.entry(OpenFileWithTerminateCommand.PREFIX, OpenFileWithTerminateCommand::new),
      Map.entry(WaitForSmartCommand.PREFIX, WaitForSmartCommand::new),
      Map.entry(WaitForInitialRefreshCommand.PREFIX, WaitForInitialRefreshCommand::new),
      Map.entry(RefreshFilesInVfsCommand.PREFIX, RefreshFilesInVfsCommand::new),
      Map.entry(SingleInspectionCommand.PREFIX, SingleInspectionCommand::new),
      Map.entry(StartPowerSave.PREFIX, StartPowerSave::new),
      Map.entry(StopPowerSave.PREFIX, StopPowerSave::new),
      Map.entry(MemoryDumpCommand.PREFIX, MemoryDumpCommand::new),
      Map.entry(CleanCaches.PREFIX, CleanCaches::new),
      Map.entry(FindUsagesCommand.PREFIX, FindUsagesCommand::new),
      Map.entry(FindUsagesInBackgroundCommand.PREFIX, FindUsagesInBackgroundCommand::new),
      Map.entry(FindUsagesInToolWindowCommand.PREFIX, FindUsagesInToolWindowCommand::new),
      Map.entry(FindUsagesInToolWindowWaitCommand.PREFIX, FindUsagesInToolWindowWaitCommand::new),
      Map.entry(IdeEditorKeyCommand.PREFIX, IdeEditorKeyCommand::new),
      Map.entry(ShowAltEnter.PREFIX, ShowAltEnter::new),
      Map.entry(SelectCommand.PREFIX, SelectCommand::new),
      Map.entry(CompareIndicesKt.PREFIX, CompareIndices::new),
      Map.entry(StoreIndices.PREFIX, StoreIndices::new),
      Map.entry(OpenProjectViewCommand.PREFIX, OpenProjectViewCommand::new),
      Map.entry(MoveDirectoryCommand.PREFIX, MoveDirectoryCommand::new),
      Map.entry(RunClassInPlugin.PREFIX, RunClassInPlugin::new),
      Map.entry(RunServiceInPlugin.PREFIX, RunServiceInPlugin::new),
      Map.entry(SetupProjectSdkCommand.PREFIX, SetupProjectSdkCommand::new),
      Map.entry(OpenProjectCommand.PREFIX, OpenProjectCommand::new),
      Map.entry(CloseProjectCommand.PREFIX, CloseProjectCommand::new),
      Map.entry(CloseOtherProjectsCommand.PREFIX, CloseOtherProjectsCommand::new),
      Map.entry(CodeAnalysisCommand.PREFIX, CodeAnalysisCommand::new),
      Map.entry(DumpProjectFiles.PREFIX, DumpProjectFiles::new),
      Map.entry(CompareProjectFiles.PREFIX, CompareProjectFiles::new),
      Map.entry(RecordCounterCollectorBaselinesCommand.PREFIX, RecordCounterCollectorBaselinesCommand::new),
      Map.entry(RecordStateCollectorsCommand.PREFIX, RecordStateCollectorsCommand::new),
      Map.entry(FlushFusEventsCommand.PREFIX, FlushFusEventsCommand::new),
      Map.entry(CreateAllServicesAndExtensionsCommand.PREFIX, CreateAllServicesAndExtensionsCommand::new),
      Map.entry(RecoveryActionCommand.PREFIX, RecoveryActionCommand::new),
      Map.entry(CorruptIndexesCommand.PREFIX, CorruptIndexesCommand::new),
      Map.entry(FlushIndexesCommand.PREFIX, FlushIndexesCommand::new),
      Map.entry(SearchEverywhereCommand.PREFIX, SearchEverywhereCommand::new),
      Map.entry(SelectFileInProjectViewCommand.PREFIX, SelectFileInProjectViewCommand::new),
      Map.entry(ExpandProjectMenuCommand.PREFIX, ExpandProjectMenuCommand::new),
      Map.entry(ReloadFilesCommand.PREFIX, ReloadFilesCommand::new),
      Map.entry(AddFileCommand.PREFIX, AddFileCommand::new),
      Map.entry(RenameFileCommand.PREFIX, RenameFileCommand::new),
      Map.entry(DeleteFileCommand.PREFIX, DeleteFileCommand::new),
      Map.entry(ExpandMainMenuCommand.PREFIX, ExpandMainMenuCommand::new),
      Map.entry(ExpandEditorMenuCommand.PREFIX, ExpandEditorMenuCommand::new),
      Map.entry(OpenRandomFileCommand.PREFIX, OpenRandomFileCommand::new),
      Map.entry(WaitForDumbCommand.PREFIX, WaitForDumbCommand::new),
      Map.entry(GoToNextPsiElement.PREFIX, GoToNextPsiElement::new),
      Map.entry(GoToNamedElementCommand.PREFIX, GoToNamedElementCommand::new),
      Map.entry(MeasureVFSUpdateCommand.PREFIX, MeasureVFSUpdateCommand::new),
      Map.entry(ShowFileStructurePopupCommand.PREFIX, ShowFileStructurePopupCommand::new),
      Map.entry(StartInlineRenameCommand.PREFIX, StartInlineRenameCommand::new),
      Map.entry(FinishInlineRename.PREFIX, FinishInlineRename::new),
      Map.entry(AssertOpenedFileInSpecificRoot.PREFIX, AssertOpenedFileInSpecificRoot::new),
      Map.entry(CloseAllTabsCommand.PREFIX, CloseAllTabsCommand::new),
      Map.entry(HideAllToolWindowsCommand.PREFIX, HideAllToolWindowsCommand::new),
      Map.entry(CollectAllFilesCommand.PREFIX, CollectAllFilesCommand::new),
      Map.entry(ExecuteEditorActionCommand.PREFIX, ExecuteEditorActionCommand::new),
      Map.entry(AssertCompletionCommand.PREFIX, AssertCompletionCommand::new),
      Map.entry(ChooseCompletionCommand.PREFIX, ChooseCompletionCommand::new),
      Map.entry(AssertFindUsagesCommand.PREFIX, AssertFindUsagesCommand::new),
      Map.entry(AssertFindUsagesEntryCommand.PREFIX, AssertFindUsagesEntryCommand::new),
      Map.entry(SetBreakpointCommand.PREFIX, SetBreakpointCommand::new),
      Map.entry(DebugRunConfigurationCommand.PREFIX, DebugRunConfigurationCommand::new),
      Map.entry(DebugStepCommand.PREFIX, DebugStepCommand::new),
      Map.entry(StopDebugProcessCommand.PREFIX, StopDebugProcessCommand::new),
      Map.entry(WaitJpsBuildCommand.PREFIX, WaitJpsBuildCommand::new),
      Map.entry(WaitForFinishedCodeAnalysis.PREFIX, WaitForFinishedCodeAnalysis::new),
      Map.entry(ConditionalMemoryDumpCommand.PREFIX, ConditionalMemoryDumpCommand::new),
      Map.entry(AcceptDecompileNotice.PREFIX, AcceptDecompileNotice::new),
      Map.entry(InstallCustomJBR.PREFIX, InstallCustomJBR::new),
      Map.entry(ShowEvaluateExpressionCommand.PREFIX, ShowEvaluateExpressionCommand::new),
      Map.entry(EvaluateExpressionCompletionCommand.PREFIX, EvaluateExpressionCompletionCommand::new),
      Map.entry(CollectFilesNotMarkedAsIndex.PREFIX, CollectFilesNotMarkedAsIndex::new),
      Map.entry(RemoveBreakpointCommand.PREFIX, RemoveBreakpointCommand::new),
      Map.entry(DropErrorCommand.PREFIX, DropErrorCommand::new),
      Map.entry(SaveDocumentsAndSettingsCommand.PREFIX, SaveDocumentsAndSettingsCommand::new),
      Map.entry(FreezeUICommand.PREFIX, FreezeUICommand::new),
      Map.entry(MoveCaretCommand.PREFIX, MoveCaretCommand::new),
      Map.entry(TakeThreadDumpCommand.PREFIX, TakeThreadDumpCommand::new),
      Map.entry(CaptureMemoryMetricsCommand.PREFIX, CaptureMemoryMetricsCommand::new),
      Map.entry(SleepCommand.PREFIX, SleepCommand::new),
      Map.entry(AssertEncodingFileCommand.PREFIX, AssertEncodingFileCommand::new),
      Map.entry(SetModuleJdkCommand.PREFIX, SetModuleJdkCommand::new),
      Map.entry(ReplaceBrowser.PREFIX, ReplaceBrowser::new),
      Map.entry(AssertModuleJdkVersionCommand.PREFIX, AssertModuleJdkVersionCommand::new),
      Map.entry(WaitForEDTQueueUnstuckCommand.PREFIX, WaitForEDTQueueUnstuckCommand::new),
      Map.entry(CreateScratchFile.PREFIX, CreateScratchFile::new),
      Map.entry(StoreHighlightingResultsCommand.PREFIX, StoreHighlightingResultsCommand::new),
      Map.entry(AddContentRootToModule.PREFIX, AddContentRootToModule::new),
      Map.entry(DisableKotlinNotificationCommand.PREFIX, DisableKotlinNotificationCommand::new),
      Map.entry(RequestHeavyScanningOnNextStartCommand.PREFIX, RequestHeavyScanningOnNextStartCommand::new),
      Map.entry(AssertCaretPositionCommand.PREFIX, AssertCaretPositionCommand::new),
      Map.entry(AssertCurrentFileCommand.PREFIX, AssertCurrentFileCommand::new),
      Map.entry(AwaitCompleteProjectConfigurationCommand.PREFIX, AwaitCompleteProjectConfigurationCommand::new),
      Map.entry(RenameModuleCommand.PREFIX, RenameModuleCommand::new),
      Map.entry(WaitForProjectViewCommand.PREFIX, WaitForProjectViewCommand::new),
      Map.entry(ExpandProjectViewCommand.PREFIX, ExpandProjectViewCommand::new),
      Map.entry(DebugToggleBreakpointCommand.PREFIX, DebugToggleBreakpointCommand::new),
      Map.entry(MoveFilesCommand.PREFIX, MoveFilesCommand::new),
      Map.entry(SystemGCCommand.PREFIX, SystemGCCommand::new),
      Map.entry(JBRFullGCCommand.PREFIX, JBRFullGCCommand::new),
      Map.entry(SetupInlineCompletionListenerCommand.PREFIX, SetupInlineCompletionListenerCommand::new),
      Map.entry(CallInlineCompletionCommand.PREFIX, CallInlineCompletionCommand::new),
      Map.entry(HandleSpanCommand.PREFIX, HandleSpanCommand::new),
      Map.entry(MeasureVfsMassUpdateCommand.PREFIX, MeasureVfsMassUpdateCommand::new),
      Map.entry(FindInFilesCommand.PREFIX, FindInFilesCommand::new),
      Map.entry(WaitForVfsRefreshSelectedEditorCommand.PREFIX, WaitForVfsRefreshSelectedEditorCommand::new),
      Map.entry(CloseLookupCommand.PREFIX, CloseLookupCommand::new),
      Map.entry(OpenProblemViewPanelCommand.PREFIX, OpenProblemViewPanelCommand::new),
      Map.entry(AssertProblemsViewCountCommand.PREFIX, AssertProblemsViewCountCommand::new),
      Map.entry(DetectProjectLeaksCommand.PREFIX, DetectProjectLeaksCommand::new),
      Map.entry(WaitForReOpenedFileCommand.PREFIX, WaitForReOpenedFileCommand::new),
      Map.entry(WaitForCodeVisionCommand.PREFIX, WaitForCodeVisionCommand::new)
    );
  }
}
