/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.execution.DefaultExecutionTarget;
import com.intellij.execution.ExecutionListener;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.ExecutionTargetManager;
import com.intellij.execution.Executor;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.impl.RunnerAndConfigurationSettingsImpl;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Ref;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.jetbrains.performancePlugin.PerformanceTestSpan;
import com.jetbrains.performancePlugin.Timer;
import com.jetbrains.performancePlugin.utils.ActionCallbackProfilerStopper;
import com.sampullara.cli.Args;
import com.sampullara.cli.Argument;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.ImplicitContextKeyed;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public final class RunConfigurationCommand
extends AbstractCommand {
    public static final String PREFIX = "%runConfiguration";
    private static final String MAIN_SPAN_NAME = "runRunConfiguration";
    private static final String DURATION_SPAN_NAME = "runConfiguration#ProcessDuration";
    private ExecutionEnvironment myExecutionEnvironment;
    private static final Logger LOG = Logger.getInstance(RunConfigurationCommand.class);

    public RunConfigurationCommand(@NotNull String text, int line) {
        if (text == null) {
            RunConfigurationCommand.$$$reportNull$$$0(0);
        }
        super(text, line);
        this.myExecutionEnvironment = new ExecutionEnvironment();
    }

    @NotNull
    protected Promise<Object> _execute(final @NotNull PlaybackContext context) {
        if (context == null) {
            RunConfigurationCommand.$$$reportNull$$$0(1);
        }
        final RunConfigurationOptions options = new RunConfigurationOptions();
        Args.parse((Object)options, (String[])((String[])Arrays.stream(this.extractCommandArgument(PREFIX).split("\\|")).flatMap(item -> Arrays.stream(item.split("="))).toArray(String[]::new)), (boolean)false);
        final Ref mainSpan = new Ref();
        final Ref processSpan = new Ref();
        final Timer timer = new Timer();
        final ActionCallbackProfilerStopper actionCallback = new ActionCallbackProfilerStopper();
        Project project = context.getProject();
        final MessageBusConnection connection = project.getMessageBus().connect();
        connection.subscribe(ExecutionManager.EXECUTION_TOPIC, (Object)new ExecutionListener(){

            public void processStarting(@NotNull String executorId, @NotNull ExecutionEnvironment env, @NotNull ProcessHandler handler) {
                if (executorId == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (env == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (handler == null) {
                    1.$$$reportNull$$$0(2);
                }
                mainSpan.set((Object)PerformanceTestSpan.TRACER.spanBuilder(RunConfigurationCommand.MAIN_SPAN_NAME).setParent(PerformanceTestSpan.getContext()).startSpan());
                timer.start();
                RunConfigurationCommand.this.myExecutionEnvironment = env;
                context.message("processStarting: " + String.valueOf(env), RunConfigurationCommand.this.getLine());
            }

            public void processStarted(@NotNull String executorId, @NotNull ExecutionEnvironment env, @NotNull ProcessHandler handler) {
                if (executorId == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (env == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (handler == null) {
                    1.$$$reportNull$$$0(5);
                }
                RunConfigurationCommand.this.myExecutionEnvironment = env;
                if (options.mode == Mode.TILL_STARTED) {
                    ((Span)mainSpan.get()).end();
                    timer.stop();
                    long executionTime = timer.getTotalTime();
                    context.message("processStarted in: " + String.valueOf(env) + ": " + executionTime, RunConfigurationCommand.this.getLine());
                    actionCallback.setDone();
                } else {
                    processSpan.set((Object)PerformanceTestSpan.TRACER.spanBuilder(RunConfigurationCommand.DURATION_SPAN_NAME).setParent(PerformanceTestSpan.getContext().with((ImplicitContextKeyed)mainSpan.get())).startSpan());
                }
            }

            public void processTerminated(@NotNull String executorId, @NotNull ExecutionEnvironment env, @NotNull ProcessHandler handler, int exitCode) {
                if (executorId == null) {
                    1.$$$reportNull$$$0(6);
                }
                if (env == null) {
                    1.$$$reportNull$$$0(7);
                }
                if (handler == null) {
                    1.$$$reportNull$$$0(8);
                }
                if (options.mode == Mode.TILL_TERMINATED) {
                    ((Span)processSpan.get()).end();
                    ((Span)mainSpan.get()).end();
                    timer.stop();
                    long executionTime = timer.getTotalTime();
                    context.message("processTerminated in: " + String.valueOf(env) + ": " + executionTime, RunConfigurationCommand.this.getLine());
                    if (env.equals(RunConfigurationCommand.this.myExecutionEnvironment)) {
                        if (exitCode == 0 && !options.failureExpected || exitCode != 0 && options.failureExpected) {
                            actionCallback.setDone();
                        } else {
                            actionCallback.reject("Run configuration is finished with exitCode: " + exitCode);
                        }
                        connection.disconnect();
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "executorId";
                        break;
                    }
                    case 1: 
                    case 4: 
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "env";
                        break;
                    }
                    case 2: 
                    case 5: 
                    case 8: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "handler";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/performancePlugin/commands/RunConfigurationCommand$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processStarting";
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processStarted";
                        break;
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processTerminated";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        RunManagerImpl runManager = RunManagerImpl.getInstanceImpl((Project)project);
        ApplicationManager.getApplication().invokeLater(() -> {
            DefaultDebugExecutor executor = options.debug ? new DefaultDebugExecutor() : new DefaultRunExecutor();
            RunConfiguration configurationToRun = RunConfigurationCommand.getConfigurationByName((RunManager)runManager, options.configurationName);
            if (configurationToRun == null) {
                actionCallback.reject("Specified configuration is not found: " + options.configurationName);
                RunConfigurationCommand.printAllConfigurationsNames((RunManager)runManager);
            } else {
                ExecutionTargetManager targetManager = ExecutionTargetManager.getInstance((Project)project);
                ExecutionTarget target = targetManager.findTarget(configurationToRun);
                if (target == null) {
                    target = DefaultExecutionTarget.INSTANCE;
                }
                RunnerAndConfigurationSettingsImpl runnerAndConfigurationSettings = new RunnerAndConfigurationSettingsImpl(runManager, configurationToRun);
                ExecutionManager.getInstance((Project)project).restartRunProfile(project, (Executor)executor, target, (RunnerAndConfigurationSettings)runnerAndConfigurationSettings, null);
            }
        });
        Promise promise = Promises.toPromise((ActionCallback)actionCallback);
        if (promise == null) {
            RunConfigurationCommand.$$$reportNull$$$0(2);
        }
        return promise;
    }

    public static RunConfiguration getConfigurationByName(RunManager runManager, String configurationName) {
        return (RunConfiguration)ContainerUtil.find((Iterable)runManager.getAllConfigurationsList(), configuration -> configurationName.equals(configuration.getName()));
    }

    private static void printAllConfigurationsNames(RunManager runManager) {
        LOG.info("*****************************");
        LOG.info("Available configurations are:");
        runManager.getAllConfigurationsList().stream().map(RunProfile::getName).forEach(arg_0 -> ((Logger)LOG).info(arg_0));
        LOG.info("*****************************");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/performancePlugin/commands/RunConfigurationCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/performancePlugin/commands/RunConfigurationCommand";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "_execute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "_execute";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    private static class RunConfigurationOptions {
        @Argument
        Mode mode;
        @Argument
        String configurationName;
        @Argument
        boolean failureExpected;
        @Argument
        boolean debug;

        private RunConfigurationOptions() {
        }
    }

    static enum Mode {
        TILL_STARTED,
        TILL_TERMINATED;

    }
}

