/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.utils;

import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationsConfiguration;
import com.intellij.notification.impl.NotificationSettings;
import com.intellij.notification.impl.NotificationsConfigurationImpl;
import com.intellij.openapi.diagnostic.Logger;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0007H\u0007J\b\u0010\b\u001a\u00020\u0007H\u0007J\u001c\u0010\t\u001a\u00020\u00072\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bH\u0002J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0010H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/performancePlugin/utils/NotificationUtils;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "disableAllBalloonNotifications", "", "enableAllBalloonNotifications", "disableBalloonNotifications", "condition", "Lkotlin/Function1;", "Lcom/intellij/notification/impl/NotificationSettings;", "", "disableBalloonNotificationsByGroupIdPattern", "groupIdsPattern", "", "disableAllBalloonNotificationsWithExcludesPattern", "excludesPattern", "intellij.performanceTesting"})
public final class NotificationUtils {
    @NotNull
    public static final NotificationUtils INSTANCE = new NotificationUtils();
    @NotNull
    private static final Logger LOG;

    private NotificationUtils() {
    }

    @JvmStatic
    public static final void disableAllBalloonNotifications() {
        NotificationsConfigurationImpl.getInstanceImpl().SHOW_BALLOONS = false;
    }

    @JvmStatic
    public static final void enableAllBalloonNotifications() {
        NotificationsConfigurationImpl.getInstanceImpl().SHOW_BALLOONS = true;
    }

    private final void disableBalloonNotifications(Function1<? super NotificationSettings, Boolean> condition) {
        NotificationsConfiguration conf = NotificationsConfiguration.getNotificationsConfiguration();
        if (conf instanceof NotificationsConfigurationImpl) {
            NotificationSettings[] allSettings = ((NotificationsConfigurationImpl)conf).getAllSettings();
            Intrinsics.checkNotNull((Object)allSettings);
            for (NotificationSettings setting : allSettings) {
                Intrinsics.checkNotNull((Object)setting);
                if (!((Boolean)condition.invoke((Object)setting)).booleanValue()) continue;
                LOG.info("Disable notification group " + setting.getGroupId());
                ((NotificationsConfigurationImpl)conf).changeSettings(NotificationSettings.copy$default((NotificationSettings)setting, null, (NotificationDisplayType)NotificationDisplayType.NONE, (boolean)false, (boolean)false, (boolean)false, (int)29, null));
            }
        }
    }

    @JvmStatic
    public static final void disableBalloonNotificationsByGroupIdPattern(@NotNull String groupIdsPattern) {
        Intrinsics.checkNotNullParameter((Object)groupIdsPattern, (String)"groupIdsPattern");
        INSTANCE.disableBalloonNotifications((Function1<? super NotificationSettings, Boolean>)((Function1)arg_0 -> NotificationUtils.disableBalloonNotificationsByGroupIdPattern$lambda$0(groupIdsPattern, arg_0)));
    }

    @JvmStatic
    public static final void disableAllBalloonNotificationsWithExcludesPattern(@NotNull String excludesPattern) {
        Intrinsics.checkNotNullParameter((Object)excludesPattern, (String)"excludesPattern");
        INSTANCE.disableBalloonNotifications((Function1<? super NotificationSettings, Boolean>)((Function1)arg_0 -> NotificationUtils.disableAllBalloonNotificationsWithExcludesPattern$lambda$0(excludesPattern, arg_0)));
    }

    private static final boolean disableBalloonNotificationsByGroupIdPattern$lambda$0(String $groupIdsPattern, NotificationSettings it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        CharSequence charSequence = it.getGroupId();
        return new Regex($groupIdsPattern).matches(charSequence);
    }

    private static final boolean disableAllBalloonNotificationsWithExcludesPattern$lambda$0(String $excludesPattern, NotificationSettings it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        CharSequence charSequence = it.getGroupId();
        return !new Regex($excludesPattern).matches(charSequence);
    }

    static {
        Logger logger = Logger.getInstance(NotificationUtils.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

