/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.profilers;

import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aJ\u001e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007H&J$\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007H\u0096@\u00a2\u0006\u0002\u0010\tJ\u0016\u0010\n\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007H&J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005H&J\u0018\u0010\r\u001a\u0004\u0018\u00010\u00052\u0006\u0010\f\u001a\u00020\u0005H\u0096@\u00a2\u0006\u0002\u0010\u000eJ\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0005H&J\u0012\u0010\u0016\u001a\u00020\u00142\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H&R\u0012\u0010\u0013\u001a\u00020\u0014X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0015R\u0012\u0010\u0019\u001a\u00020\u0014X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0015\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u001b\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/performancePlugin/profilers/Profiler;", "", "startProfiling", "", "activityName", "", "options", "", "startProfilingAsync", "(Ljava/lang/String;Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "stopProfiling", "stopProfileWithNotification", "arguments", "stopProfileAsyncWithNotification", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "compressResults", "Ljava/io/File;", "pathToResult", "archiveName", "isEnabled", "", "()Z", "isEnabledInProject", "project", "Lcom/intellij/openapi/project/Project;", "isProfilingStarted", "Companion", "intellij.performanceTesting"})
public interface Profiler {
    @NotNull
    public static final Companion Companion = com.jetbrains.performancePlugin.profilers.Profiler$Companion.$$INSTANCE;
    @NotNull
    public static final String PROFILER_PROPERTY = "integrationTests.profiler";

    public void startProfiling(@NotNull String var1, @NotNull List<String> var2);

    @Nullable
    default public Object startProfilingAsync(@NotNull String activityName, @NotNull List<String> options, @NotNull Continuation<? super Unit> $completion) {
        return Profiler.startProfilingAsync$suspendImpl(this, activityName, options, $completion);
    }

    public static /* synthetic */ Object startProfilingAsync$suspendImpl(Profiler $this, String activityName, List<String> options, Continuation<? super Unit> $completion) {
        $this.startProfiling(activityName, options);
        return Unit.INSTANCE;
    }

    @NotNull
    public String stopProfiling(@NotNull List<String> var1) throws Exception;

    @NotNull
    public String stopProfileWithNotification(@NotNull String var1);

    @Nullable
    default public Object stopProfileAsyncWithNotification(@NotNull String arguments, @NotNull Continuation<? super String> $completion) {
        return this.stopProfileWithNotification(arguments);
    }

    @Nullable
    public File compressResults(@NotNull String var1, @NotNull String var2) throws IOException;

    public boolean isEnabled();

    public boolean isEnabledInProject(@Nullable Project var1);

    public boolean isProfilingStarted();

    @JvmStatic
    public static boolean isAnyProfilingStarted() {
        return Companion.isAnyProfilingStarted();
    }

    @JvmStatic
    @NotNull
    public static Profiler getCurrentProfilerHandler() {
        return Companion.getCurrentProfilerHandler();
    }

    @JvmStatic
    @NotNull
    public static Profiler getCurrentProfilerHandler(@Nullable Project project) {
        return Companion.getCurrentProfilerHandler(project);
    }

    @JvmStatic
    @NotNull
    public static String formatSnapshotName(boolean isMemorySnapshot) {
        return Companion.formatSnapshotName(isMemorySnapshot);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u000b\u001a\u00020\fH\u0007J\b\u0010\r\u001a\u00020\bH\u0007J\u0012\u0010\r\u001a\u00020\b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0007J\u0010\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\fH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/performancePlugin/profilers/Profiler$Companion;", "", "<init>", "()V", "PROFILER_PROPERTY", "", "EP_NAME", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/jetbrains/performancePlugin/profilers/Profiler;", "getEP_NAME", "()Lcom/intellij/openapi/extensions/ExtensionPointName;", "isAnyProfilingStarted", "", "getCurrentProfilerHandler", "project", "Lcom/intellij/openapi/project/Project;", "formatSnapshotName", "isMemorySnapshot", "intellij.performanceTesting"})
    @SourceDebugExtension(value={"SMAP\nProfiler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Profiler.kt\ncom/jetbrains/performancePlugin/profilers/Profiler$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,67:1\n1761#2,3:68\n774#2:71\n865#2,2:72\n*S KotlinDebug\n*F\n+ 1 Profiler.kt\ncom/jetbrains/performancePlugin/profilers/Profiler$Companion\n*L\n19#1:68,3\n30#1:71\n30#1:72,2\n*E\n"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @NotNull
        public static final String PROFILER_PROPERTY = "integrationTests.profiler";
        @NotNull
        private static final ExtensionPointName<Profiler> EP_NAME;

        private Companion() {
        }

        @NotNull
        public final ExtensionPointName<Profiler> getEP_NAME() {
            return EP_NAME;
        }

        @JvmStatic
        public final boolean isAnyProfilingStarted() {
            boolean bl;
            block3: {
                Iterable $this$any$iv = EP_NAME.getExtensionList();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Profiler it = (Profiler)element$iv;
                        boolean bl2 = false;
                        if (!it.isProfilingStarted()) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        @JvmStatic
        @NotNull
        public final Profiler getCurrentProfilerHandler() {
            Sequence sequence = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)EP_NAME.getExtensionList()), Companion::getCurrentProfilerHandler$lambda$0);
            Comparator<Object> comparator = Comparator.comparing(arg_0 -> Companion.getCurrentProfilerHandler$lambda$2(Companion::getCurrentProfilerHandler$lambda$1, arg_0));
            Intrinsics.checkNotNullExpressionValue(comparator, (String)"comparing(...)");
            Sequence all = SequencesKt.sortedWith((Sequence)sequence, comparator);
            Profiler profiler = (Profiler)SequencesKt.firstOrNull((Sequence)all);
            if (profiler == null) {
                throw new RuntimeException("There are no installed profilers");
            }
            return profiler;
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final Profiler getCurrentProfilerHandler(@Nullable Project project) {
            boolean bl;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = EP_NAME.getExtensionList();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Profiler it = (Profiler)element$iv$iv;
                boolean bl2 = false;
                if (!it.isEnabledInProject(project)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List all = (List)destination$iv$iv;
            boolean bl3 = bl = all.size() == 1;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            return (Profiler)CollectionsKt.first((List)all);
        }

        @JvmStatic
        @NotNull
        public final String formatSnapshotName(boolean isMemorySnapshot) {
            String string = ApplicationInfo.getInstance().getBuild().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
            String buildNumber = string;
            String snapshotDate = new SimpleDateFormat("dd.MM.yyyy_HH.mm.ss").format(new Date());
            return buildNumber + "_" + (isMemorySnapshot ? "memory_" : "") + snapshotDate;
        }

        private static final boolean getCurrentProfilerHandler$lambda$0(Profiler it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.isEnabled();
        }

        private static final String getCurrentProfilerHandler$lambda$1(Profiler p) {
            return p.getClass().getSimpleName();
        }

        private static final String getCurrentProfilerHandler$lambda$2(Function1 $tmp0, Object p0) {
            return (String)$tmp0.invoke(p0);
        }

        static {
            $$INSTANCE = new Companion();
            EP_NAME = new ExtensionPointName("com.jetbrains.performancePlugin.profiler");
        }
    }
}

