/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.joomla.references;

import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ProcessingContext;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.joomla.settings.JoomlaDataService;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.PhpLanguage;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import ini4idea.lang.IniPropertyReference;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public final class JoomlaReferenceContributor
extends PsiReferenceContributor {
    public static final String JHTML = "JHTML";
    public static final String HTML_HELPER = "HTMLHELPER";
    public static final String JTEXT = "JTEXT";
    public static final String TEXT = "TEXT";
    public static final String CALL_ = "_";
    public static final String CALL_SPRINTF = "sprintf";
    public static final String CALL_SCRIPT = "script";

    private static boolean checkMethodReference(PsiElement element, String className, String call) {
        MethodReference methodReference = (MethodReference)PhpPsiUtil.getParentOfClass((PsiElement)element, MethodReference.class);
        if (methodReference != null) {
            String functionName = methodReference.getName();
            PsiElement firstParameter = methodReference.getParameter(0);
            if (element.equals(firstParameter)) {
                PhpExpression classReference = methodReference.getClassReference();
                if (functionName != null && functionName.equals(call) && classReference != null && className.equalsIgnoreCase(classReference.getName())) {
                    return true;
                }
            }
        }
        return false;
    }

    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            JoomlaReferenceContributor.$$$reportNull$$$0(0);
        }
        registrar.registerReferenceProvider((ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withLanguage((Language)PhpLanguage.INSTANCE)).inside((ElementPattern)PlatformPatterns.psiElement().withElementType(PhpElementTypes.PARAMETER_LIST)), (PsiReferenceProvider)new JoomlaReferenceProvider(), 0.0);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/jetbrains/php/joomla/references/JoomlaReferenceContributor", "registerReferenceProviders"));
    }

    private static class JoomlaReferenceProvider
    extends PsiReferenceProvider {
        private JoomlaReferenceProvider() {
        }

        private static PsiReference[] processJTEXT(@NotNull StringLiteralExpression element) {
            String iniId;
            if (element == null) {
                JoomlaReferenceProvider.$$$reportNull$$$0(0);
            }
            if ((iniId = PhpCodeInsightUtil.toString((StringLiteralExpression)element)) != null) {
                return new IniPropertyReference[]{new IniPropertyReference(iniId, false, (PsiElement)element)};
            }
            return PsiReference.EMPTY_ARRAY;
        }

        private static boolean isNoReferences(@NotNull PsiElement element, JoomlaDataService service) {
            if (element == null) {
                JoomlaReferenceProvider.$$$reportNull$$$0(1);
            }
            if (!service.isEnabled()) {
                return true;
            }
            return !(element instanceof StringLiteralExpression);
        }

        private static PsiReference @NotNull [] processJHTML(StringLiteralExpression literal, PhpIndex index) {
            String[] strings;
            String functionFQN = PhpCodeInsightUtil.toString((StringLiteralExpression)literal);
            if (functionFQN != null && (strings = functionFQN.split("\\.")).length > 0) {
                int pointer = 0;
                String prefix = strings.length == 3 ? strings[pointer++] : JoomlaReferenceContributor.JHTML;
                String file = strings.length - pointer == 2 ? strings[pointer++] : "";
                String func = strings[pointer];
                String className = prefix + JoomlaReferenceProvider.firstChToUpperCase(file);
                Collection classes = index.getAnyByFQN(PhpLangUtil.toFQN((String)className));
                if (!classes.isEmpty()) {
                    PhpClass phpClass = (PhpClass)classes.iterator().next();
                    Method methodByName = phpClass.findMethodByName((CharSequence)func);
                    PsiReference[] psiReferenceArray = new PsiReference[]{new PhpCallbackReference((PsiElement)literal, (PsiElement)methodByName)};
                    if (psiReferenceArray == null) {
                        JoomlaReferenceProvider.$$$reportNull$$$0(2);
                    }
                    return psiReferenceArray;
                }
            }
            PsiReference[] psiReferenceArray = new PsiReference[]{new PhpCallbackReference((PsiElement)literal, null)};
            if (psiReferenceArray == null) {
                JoomlaReferenceProvider.$$$reportNull$$$0(3);
            }
            return psiReferenceArray;
        }

        private static boolean isJTEXT(@NotNull PsiElement element) {
            if (element == null) {
                JoomlaReferenceProvider.$$$reportNull$$$0(4);
            }
            return JoomlaReferenceContributor.checkMethodReference(element, JoomlaReferenceContributor.JTEXT, JoomlaReferenceContributor.CALL_) || JoomlaReferenceContributor.checkMethodReference(element, JoomlaReferenceContributor.JTEXT, JoomlaReferenceContributor.CALL_SPRINTF) || JoomlaReferenceContributor.checkMethodReference(element, JoomlaReferenceContributor.JTEXT, JoomlaReferenceContributor.CALL_SCRIPT);
        }

        private static boolean isTEXT(@NotNull PsiElement element) {
            if (element == null) {
                JoomlaReferenceProvider.$$$reportNull$$$0(5);
            }
            return JoomlaReferenceContributor.checkMethodReference(element, JoomlaReferenceContributor.TEXT, JoomlaReferenceContributor.CALL_) || JoomlaReferenceContributor.checkMethodReference(element, JoomlaReferenceContributor.TEXT, JoomlaReferenceContributor.CALL_SPRINTF) || JoomlaReferenceContributor.checkMethodReference(element, JoomlaReferenceContributor.TEXT, JoomlaReferenceContributor.CALL_SCRIPT);
        }

        private static boolean isJHTML(@NotNull PsiElement element) {
            if (element == null) {
                JoomlaReferenceProvider.$$$reportNull$$$0(6);
            }
            return JoomlaReferenceContributor.checkMethodReference(element, JoomlaReferenceContributor.JHTML, JoomlaReferenceContributor.CALL_);
        }

        private static boolean isHTML_HELPER(PsiElement element) {
            return JoomlaReferenceContributor.checkMethodReference(element, JoomlaReferenceContributor.HTML_HELPER, JoomlaReferenceContributor.CALL_);
        }

        private static String firstChToUpperCase(String arg) {
            if (arg.length() > 0) {
                char firstChar = arg.charAt(0);
                char upperCase = Character.toUpperCase(firstChar);
                return upperCase + arg.substring(1);
            }
            return arg;
        }

        public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
            JoomlaDataService service;
            if (element == null) {
                JoomlaReferenceProvider.$$$reportNull$$$0(7);
            }
            if (context == null) {
                JoomlaReferenceProvider.$$$reportNull$$$0(8);
            }
            if (JoomlaReferenceProvider.isNoReferences(element, service = JoomlaDataService.getInstance(element.getProject()))) {
                if (PsiReference.EMPTY_ARRAY == null) {
                    JoomlaReferenceProvider.$$$reportNull$$$0(9);
                }
                return PsiReference.EMPTY_ARRAY;
            }
            StringLiteralExpression literal = (StringLiteralExpression)element;
            PhpIndex index = PhpIndex.getInstance((Project)element.getProject());
            if (JoomlaReferenceProvider.isJHTML(element)) {
                return JoomlaReferenceProvider.processJHTML(literal, index);
            }
            if (JoomlaReferenceProvider.isJTEXT(element)) {
                PsiReference[] psiReferenceArray = JoomlaReferenceProvider.processJTEXT(literal);
                if (psiReferenceArray == null) {
                    JoomlaReferenceProvider.$$$reportNull$$$0(10);
                }
                return psiReferenceArray;
            }
            if (JoomlaReferenceProvider.isTEXT(element)) {
                PsiReference[] psiReferenceArray = JoomlaReferenceProvider.processJTEXT(literal);
                if (psiReferenceArray == null) {
                    JoomlaReferenceProvider.$$$reportNull$$$0(11);
                }
                return psiReferenceArray;
            }
            if (JoomlaReferenceProvider.isHTML_HELPER(element)) {
                return JoomlaReferenceProvider.processJHTML(literal, index);
            }
            if (PsiReference.EMPTY_ARRAY == null) {
                JoomlaReferenceProvider.$$$reportNull$$$0(12);
            }
            return PsiReference.EMPTY_ARRAY;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 9, 10, 11, 12 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: 
                case 3: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/joomla/references/JoomlaReferenceContributor$JoomlaReferenceProvider";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/joomla/references/JoomlaReferenceContributor$JoomlaReferenceProvider";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "processJHTML";
                    break;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReferencesByElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "processJTEXT";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "isNoReferences";
                    break;
                }
                case 2: 
                case 3: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "isJTEXT";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "isTEXT";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "isJHTML";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "getReferencesByElement";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 9, 10, 11, 12 -> new IllegalStateException(string);
            };
        }
    }

    public static class PhpCallbackReference
    extends PsiReferenceBase<PsiElement> {
        private final PsiElement originalElement;

        public PhpCallbackReference(PsiElement element, PsiElement originalElement) {
            super(element);
            this.originalElement = originalElement;
        }

        public PsiElement resolve() {
            return this.originalElement;
        }

        public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
            if (newElementName == null) {
                PhpCallbackReference.$$$reportNull$$$0(0);
            }
            if (this.getElement() instanceof StringLiteralExpression) {
                String text = ElementManipulators.getValueText((PsiElement)this.getElement());
                newElementName = text.substring(0, text.lastIndexOf(92) + 1) + (String)newElementName;
            }
            return super.handleElementRename((String)newElementName);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElementName", "com/jetbrains/php/joomla/references/JoomlaReferenceContributor$PhpCallbackReference", "handleElementRename"));
        }
    }
}

