/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.twig;

import com.intellij.codeInsight.editorActions.BackspaceHandlerDelegate;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiUtilCore;
import com.jetbrains.twig.TwigConfiguration;
import com.jetbrains.twig.TwigFileViewProvider;
import com.jetbrains.twig.TwigSmartKeysConfiguration;
import com.jetbrains.twig.TwigTokenTypes;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TwigBackspaceHandler
extends BackspaceHandlerDelegate {
    public static final Map<Character, Character> MIRROR_CHARS = Map.of(Character.valueOf('%'), Character.valueOf('%'), Character.valueOf('#'), Character.valueOf('#'), Character.valueOf('{'), Character.valueOf('}'), Character.valueOf('}'), Character.valueOf('{'));
    private int myEndDelimiterOffset = -1;
    private int myStartDelimiterOffset = -1;

    public void beforeCharDeleted(char c, @NotNull PsiFile file, @NotNull Editor editor) {
        if (file == null) {
            TwigBackspaceHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            TwigBackspaceHandler.$$$reportNull$$$0(1);
        }
        if (!(file.getViewProvider() instanceof TwigFileViewProvider) || !TwigSmartKeysConfiguration.getInstance().isSyncDelimiterEditing()) {
            return;
        }
        if (TwigConfiguration.getInstance(editor.getProject()).getState().equals(TwigConfiguration.TwigLexerProperties.DEFAULT) && MIRROR_CHARS.containsKey(Character.valueOf(c))) {
            int offset = editor.getCaretModel().getOffset();
            this.myStartDelimiterOffset = TwigBackspaceHandler.isOfType(file.findElementAt(offset), TwigTokenTypes.END_DELIMITERS) ? TwigBackspaceHandler.getStartDelimiterOffset(editor, c, offset) : -1;
            this.myEndDelimiterOffset = TwigBackspaceHandler.isOfType(file.findElementAt(offset - 1), TwigTokenTypes.START_DELIMITERS) ? TwigBackspaceHandler.getEndDelimiterOffset(editor, c, offset) : -1;
        }
    }

    public static int getEndDelimiterOffset(@NotNull Editor editor, char c, int offset) {
        if (editor == null) {
            TwigBackspaceHandler.$$$reportNull$$$0(2);
        }
        String text = editor.getDocument().getText();
        if (offset > 1 && text.charAt(offset - 2) == '{') {
            int endDelimiterOffset = text.indexOf(MIRROR_CHARS.get(Character.valueOf(c)) + "}", offset - 1);
            int startDelimiterOffset = text.indexOf("{" + c, offset - 1);
            if (endDelimiterOffset > 0 && (startDelimiterOffset < 0 || startDelimiterOffset > endDelimiterOffset)) {
                return endDelimiterOffset;
            }
        }
        return -1;
    }

    public static int getStartDelimiterOffset(@NotNull Editor editor, char c, int offset) {
        String text;
        if (editor == null) {
            TwigBackspaceHandler.$$$reportNull$$$0(3);
        }
        if ((text = editor.getDocument().getText()).length() > offset && text.charAt(offset) == '}') {
            int endDelimiterOffset = text.substring(0, offset).lastIndexOf(c + "}");
            int startDelimiterOffset = text.substring(0, offset).lastIndexOf("{" + MIRROR_CHARS.get(Character.valueOf(c)));
            if (startDelimiterOffset >= 0 && endDelimiterOffset < startDelimiterOffset) {
                return startDelimiterOffset;
            }
        }
        return -1;
    }

    public static boolean isOfType(@Nullable PsiElement element, @NotNull TokenSet types) {
        if (types == null) {
            TwigBackspaceHandler.$$$reportNull$$$0(4);
        }
        return types.contains(PsiUtilCore.getElementType((PsiElement)element));
    }

    public boolean charDeleted(char c, @NotNull PsiFile file, @NotNull Editor editor) {
        if (file == null) {
            TwigBackspaceHandler.$$$reportNull$$$0(5);
        }
        if (editor == null) {
            TwigBackspaceHandler.$$$reportNull$$$0(6);
        }
        if (TwigBackspaceHandler.isOfType(file.findElementAt(this.myEndDelimiterOffset), TwigTokenTypes.END_DELIMITERS)) {
            editor.getDocument().deleteString(this.myEndDelimiterOffset - 1, this.myEndDelimiterOffset);
            this.myEndDelimiterOffset = -1;
            return true;
        }
        if (this.myStartDelimiterOffset >= 0 && TwigBackspaceHandler.isOfType(file.findElementAt(this.myStartDelimiterOffset), TwigTokenTypes.START_DELIMITERS)) {
            editor.getDocument().deleteString(this.myStartDelimiterOffset + 1, this.myStartDelimiterOffset + 2);
            this.myStartDelimiterOffset = -1;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/twig/TwigBackspaceHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeCharDeleted";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getEndDelimiterOffset";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getStartDelimiterOffset";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isOfType";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "charDeleted";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

