/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.php.frontend.documentation.phpdoc;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiBuilderFactory;
import com.intellij.lang.PsiParser;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.LazyParseableElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.ILazyParseableElementType;
import com.intellij.util.CharTable;
import com.jetbrains.php.lang.PhpLanguage;
import com.jetbrains.php.lang.documentation.phpdoc.BasicPhpDocStubElementTypesSupplierService;
import com.jetbrains.php.lang.documentation.phpdoc.lexer.PhpDocLexer;
import com.jetbrains.php.lang.documentation.phpdoc.parser.PhpDocParser;
import com.jetbrains.php.lang.documentation.phpdoc.psi.stubs.BasicPhpDocMethodTagElementType;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class FrontendPhpDocStubElementTypesSupplierService
implements BasicPhpDocStubElementTypesSupplierService {
    public Function<String, IElementType> getDocElementTypes() {
        return name -> {
            if (name.equals("DOC_COMMENT")) {
                return new FrontendPhpDocCommentElementType();
            }
            if (name.equals("phpDocSpecialTag")) {
                return new FrontendPhpDocMethodTagElementType();
            }
            return new IElementType(name, (Language)PhpLanguage.INSTANCE);
        };
    }

    private static class FrontendPhpDocCommentElementType
    extends ILazyParseableElementType {
        FrontendPhpDocCommentElementType() {
            super("DOC_COMMENT", (Language)PhpLanguage.INSTANCE);
        }

        public ASTNode parseContents(@NotNull ASTNode chameleon) {
            if (chameleon == null) {
                FrontendPhpDocCommentElementType.$$$reportNull$$$0(0);
            }
            PsiBuilderFactory factory = PsiBuilderFactory.getInstance();
            PsiElement parentElement = chameleon.getTreeParent().getPsi();
            Project project = parentElement.getProject();
            PsiBuilder builder = factory.createBuilder(project, chameleon, (Lexer)new PhpDocLexer(), this.getLanguage(), (CharSequence)chameleon.getText());
            PhpDocParser parser = new PhpDocParser(project);
            return parser.parse((IElementType)this, builder).getFirstChildNode();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chameleon", "com/intellij/php/frontend/documentation/phpdoc/FrontendPhpDocStubElementTypesSupplierService$FrontendPhpDocCommentElementType", "parseContents"));
        }
    }

    private static class FrontendPhpDocMethodTagElementType
    extends IElementType
    implements BasicPhpDocMethodTagElementType {
        private FrontendPhpDocMethodTagElementType() {
            super("phpDocSpecialTag", (Language)PhpLanguage.INSTANCE);
        }

        @NotNull
        public ASTNode parse(@NotNull CharSequence text, @NotNull CharTable table) {
            if (text == null) {
                FrontendPhpDocMethodTagElementType.$$$reportNull$$$0(0);
            }
            if (table == null) {
                FrontendPhpDocMethodTagElementType.$$$reportNull$$$0(1);
            }
            return new LazyParseableElement((IElementType)this, text);
        }

        public ASTNode parse(PsiParser parser, PsiBuilder builder) {
            return parser.parse((IElementType)this, builder).getFirstChildNode();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "text";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "table";
                    break;
                }
            }
            objectArray[1] = "com/intellij/php/frontend/documentation/phpdoc/FrontendPhpDocStubElementTypesSupplierService$FrontendPhpDocMethodTagElementType";
            objectArray[2] = "parse";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

