/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.php.frontend.editor;

import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtilEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.php.lang.documentation.phpdoc.parser.BasicPhpDocStubElementTypes;
import com.jetbrains.php.lang.editor.BasicPhpTypedHandler;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.BasicPhpPsiUtil;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FrontendPhpTypedHandler
extends BasicPhpTypedHandler {
    private static final Set<String> EMPTY_TAGS_MAP = Set.of("area", "base", "basefont", "br", "col", "embed", "frame", "hr", "meta", "img", "input", "isindex", "link", "param", "source", "track", "wbr");

    protected void showMemberLookUp(@NotNull Project project, @NotNull Editor editor) {
        if (project == null) {
            FrontendPhpTypedHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            FrontendPhpTypedHandler.$$$reportNull$$$0(1);
        }
    }

    protected boolean isOpenTagStringInsideXmlTag(char c, @NotNull Editor editor, @NotNull PsiFile file, int offset) {
        if (editor == null) {
            FrontendPhpTypedHandler.$$$reportNull$$$0(2);
        }
        if (file == null) {
            FrontendPhpTypedHandler.$$$reportNull$$$0(3);
        }
        return false;
    }

    protected void tryToMoveSemicolon(PsiFile file, Editor editor) {
    }

    protected boolean isAutoInsertFullPhpOpenTag() {
        return true;
    }

    protected boolean isInsertClosingHtmlTagInPhpDoc() {
        return true;
    }

    public boolean isSingleHtmlTag(@NotNull String tagName) {
        if (tagName == null) {
            FrontendPhpTypedHandler.$$$reportNull$$$0(4);
        }
        return EMPTY_TAGS_MAP.contains(StringUtil.toLowerCase((String)tagName));
    }

    protected void showCompletion(Editor editor) {
    }

    protected TypedHandlerDelegate.Result tryToAddOneLineDocComment(Editor editor, int offset, PsiFile file, Project project) {
        if (offset > 4 && "/** ".equals(editor.getDocument().getCharsSequence().subSequence(offset - 4, offset).toString())) {
            PsiElement element = file.findElementAt(offset - 1);
            PsiElement parent = BasicPhpPsiUtil.getParentByElementTypeCondition((PsiElement)element, (IElementType)BasicPhpDocStubElementTypes.DOC_COMMENT);
            if (parent != null && FrontendPhpTypedHandler.isCompleteDocComment((PsiElement)parent)) {
                return TypedHandlerDelegate.Result.STOP;
            }
            PsiElement comment = BasicPhpPsiUtil.getParentByElementTypeCondition((PsiElement)file.findElementAt(offset - 1), (TokenSet)PhpTokenTypes.COMMENTS);
            if (comment == null || !BasicPhpPsiUtil.isOfType((PsiElement)comment, (IElementType)PhpTokenTypes.C_STYLE_COMMENT)) {
                EditorModificationUtilEx.insertStringAtCaret((Editor)editor, (String)" */");
                editor.getCaretModel().moveCaretRelatively(-3, 0, false, false, false);
                PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
            }
        }
        return TypedHandlerDelegate.Result.STOP;
    }

    protected boolean isDocComment(PsiElement element) {
        return BasicPhpPsiUtil.isOfType((ASTNode)element.getNode(), (IElementType)BasicPhpDocStubElementTypes.DOC_COMMENT);
    }

    protected boolean isGroupStatement(@Nullable PsiElement parent) {
        return BasicPhpPsiUtil.isOfType((PsiElement)parent, (IElementType)PhpElementTypes.GROUP_STATEMENT) || BasicPhpPsiUtil.isOfType((PsiElement)parent, (IElementType)PhpElementTypes.NON_LAZY_GROUP_STATEMENT);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagName";
                break;
            }
        }
        objectArray2[1] = "com/intellij/php/frontend/editor/FrontendPhpTypedHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "showMemberLookUp";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isOpenTagStringInsideXmlTag";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isSingleHtmlTag";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

