/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.blade.debug;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.CharFilter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.impl.source.tree.PsiWhiteSpaceImpl;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IntPair;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.blade.BladeFileType;
import com.jetbrains.php.blade.debug.BladeDebugStateService;
import com.jetbrains.php.blade.parser.BladeElementTypes;
import com.jetbrains.php.blade.psi.BladeDirectivePsiImpl;
import com.jetbrains.php.blade.psi.BladeTokenTypes;
import com.jetbrains.php.debug.template.PhpTemplateDebugStateService;
import com.jetbrains.php.debug.template.PhpTemplateLanguagePathMapper;
import com.jetbrains.php.util.pathmapper.PhpPathMapper;
import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BladeDebugPathMapper
extends PhpTemplateLanguagePathMapper {
    private static final Logger LOG = Logger.getInstance(BladeDebugPathMapper.class);
    public static final String BLADE = "Blade ";
    private boolean pathLineShift = false;

    public boolean isTemplateFileType(@NotNull FileType fileType) {
        if (fileType == null) {
            BladeDebugPathMapper.$$$reportNull$$$0(0);
        }
        return fileType.equals((Object)BladeFileType.INSTANCE);
    }

    public boolean isGeneratedFile(@NotNull VirtualFile file, @NotNull Project project) {
        BladeDebugStateService stateService;
        if (file == null) {
            BladeDebugPathMapper.$$$reportNull$$$0(1);
        }
        if (project == null) {
            BladeDebugPathMapper.$$$reportNull$$$0(2);
        }
        if ((stateService = BladeDebugStateService.getInstance(project)) == null || !stateService.isWellConfigured()) {
            return false;
        }
        String cachePath = stateService.getCachePath();
        VirtualFile cacheDir = cachePath != null ? VfsUtil.findFile((Path)Paths.get(cachePath, new String[0]), (boolean)true) : null;
        return VfsUtilCore.isUnder((VirtualFile)file, Collections.singleton(cacheDir));
    }

    public XSourcePosition mapToTemplate(@Nullable XSourcePosition phpPosition, @NotNull Project project, @NotNull PhpPathMapper remotePathMapper) {
        if (project == null) {
            BladeDebugPathMapper.$$$reportNull$$$0(3);
        }
        if (remotePathMapper == null) {
            BladeDebugPathMapper.$$$reportNull$$$0(4);
        }
        if (phpPosition == null) {
            return null;
        }
        BladeDebugStateService stateService = BladeDebugStateService.getInstance(project);
        if (stateService == null || !stateService.isWellConfigured()) {
            LOG.warn(BLADE + PhpBundle.message((String)"template.debug.cache.dir.is.not.specified", (Object[])new Object[0]));
            return phpPosition;
        }
        VirtualFile generatedFile = phpPosition.getFile();
        String path = this.getTemplatePath(generatedFile);
        if (path != null) {
            VirtualFile templateFile;
            VirtualFile virtualFile = templateFile = ApplicationManager.getApplication().isUnitTestMode() ? generatedFile.getParent().findChild(path) : remotePathMapper.getLocalFile(path);
            if (templateFile != null) {
                int line = this.shiftLineBack(phpPosition.getLine(), FileDocumentManager.getInstance().getDocument(templateFile), project);
                return XDebuggerUtil.getInstance().createPosition(templateFile, line);
            }
        }
        return phpPosition;
    }

    private int shiftLineBack(int initialLine, @Nullable Document templateDocument, @NotNull Project project) {
        if (project == null) {
            BladeDebugPathMapper.$$$reportNull$$$0(5);
        }
        int line = initialLine - this.getPathLineShift(false);
        if (templateDocument != null) {
            line += BladeDebugPathMapper.getExtendsShift(templateDocument, project, false);
            line += BladeDebugPathMapper.getCommentsShift(line, false, templateDocument, project);
            line -= BladeDebugPathMapper.getTextBlocksShift(initialLine, templateDocument, project);
        }
        return line;
    }

    @Nullable
    private String getTemplatePath(VirtualFile file) {
        try {
            String[] lines = StringUtil.splitByLines((String)VfsUtilCore.loadText((VirtualFile)file));
            if (lines.length > 0) {
                String firstLine = StringUtil.strip((String)lines[0], (CharFilter)CharFilter.NOT_WHITESPACE_FILTER);
                String lastLine = StringUtil.strip((String)lines[lines.length - 1], (CharFilter)CharFilter.NOT_WHITESPACE_FILTER);
                if (BladeDebugPathMapper.matchTemplatePathLine(firstLine)) {
                    this.pathLineShift = true;
                    return BladeDebugPathMapper.retrieveTemplatePath(firstLine);
                }
                if (BladeDebugPathMapper.matchTemplatePathLine(lastLine)) {
                    return BladeDebugPathMapper.retrieveTemplatePath(lastLine);
                }
                LOG.warn("Blade debug is not supported for Laravel versions less than 5.8");
            }
        }
        catch (IOException e) {
            LOG.warn(e.getMessage());
        }
        return null;
    }

    @NotNull
    private static String retrieveTemplatePath(@NotNull String firstLine) {
        String s;
        if (firstLine == null) {
            BladeDebugPathMapper.$$$reportNull$$$0(6);
        }
        String string = (s = StringUtil.trimEnd((String)StringUtil.trimStart((String)firstLine, (String)"<?php/*"), (String)"*/?>")).contains("*PATH") ? StringUtil.trimEnd((String)StringUtil.notNullize((String)StringUtil.substringAfter((String)s, (String)"*PATH")), (String)"ENDPATH*") : s;
        if (string == null) {
            BladeDebugPathMapper.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static boolean matchTemplatePathLine(@NotNull String lastLine) {
        if (lastLine == null) {
            BladeDebugPathMapper.$$$reportNull$$$0(8);
        }
        return lastLine.startsWith("<?php/*") && lastLine.endsWith("*/?>") || lastLine.contains("<?php/**PATH") && lastLine.endsWith("ENDPATH**/?>");
    }

    public XSourcePosition mapToPhp(@NotNull XSourcePosition templatePosition, @NotNull Project project, @NotNull PhpPathMapper remotePathMapper) {
        int templateLinesCount;
        Path path;
        BladeDebugStateService stateService;
        if (templatePosition == null) {
            BladeDebugPathMapper.$$$reportNull$$$0(9);
        }
        if (project == null) {
            BladeDebugPathMapper.$$$reportNull$$$0(10);
        }
        if (remotePathMapper == null) {
            BladeDebugPathMapper.$$$reportNull$$$0(11);
        }
        if ((stateService = BladeDebugStateService.getInstance(project)) == null || !stateService.isWellConfigured()) {
            LOG.warn(BLADE + PhpBundle.message((String)"template.debug.cache.dir.is.not.specified", (Object[])new Object[0]));
            return templatePosition;
        }
        String cachePath = stateService.getCachePath();
        try {
            path = Paths.get(cachePath, new String[0]);
        }
        catch (InvalidPathException ipe) {
            LOG.warn(BLADE + PhpBundle.message((String)"template.debug.cache.dir.is.incorrect", (Object[])new Object[0]));
            return templatePosition;
        }
        VirtualFile cacheDir = VfsUtil.findFile((Path)path, (boolean)true);
        if (cacheDir == null) {
            return templatePosition;
        }
        VirtualFile file = templatePosition.getFile();
        Document document = (Document)ReadAction.compute(() -> FileDocumentManager.getInstance().getDocument(file));
        int n = templateLinesCount = document != null ? document.getLineCount() : 0;
        if (!BladeDebugPathMapper.isTemplateFile((VirtualFile)file)) {
            return templatePosition;
        }
        String remoteFilePath = ApplicationManager.getApplication().isUnitTestMode() ? PathUtil.getFileName((String)file.getPath()) : remotePathMapper.getRemoteFilePath(file);
        AtomicReference<VirtualFile> newPath = new AtomicReference<VirtualFile>(file);
        ReadAction.run(() -> VfsUtilCore.processFilesRecursively((VirtualFile)cacheDir, generatedFile -> {
            if (generatedFile.isDirectory()) {
                return true;
            }
            if (remoteFilePath != null && FileUtil.pathsEqual((String)PathUtil.toSystemIndependentName((String)this.getTemplatePath((VirtualFile)generatedFile)), (String)PathUtil.toSystemIndependentName((String)remoteFilePath))) {
                this.checkNotIdentityMappings(project, file, document, templateLinesCount, (VirtualFile)generatedFile);
                newPath.set((VirtualFile)generatedFile);
                return false;
            }
            return true;
        }));
        if (templatePosition.getFile().equals(newPath.get())) {
            LOG.warn(BLADE + PhpBundle.message((String)"template.debug.php.file.not.found", (Object[])new Object[]{file.getPath()}));
        }
        int line = this.shiftLine(templatePosition.getLine(), document, project, false);
        return XDebuggerUtil.getInstance().createPosition(newPath.get(), line);
    }

    private void checkNotIdentityMappings(@NotNull Project project, VirtualFile file, Document document, int templateLinesCount, VirtualFile generatedFile) {
        int predictedLineCount;
        Document genDocument;
        int genLinesCount;
        if (project == null) {
            BladeDebugPathMapper.$$$reportNull$$$0(12);
        }
        int n = genLinesCount = (genDocument = FileDocumentManager.getInstance().getDocument(generatedFile)) != null ? genDocument.getLineCount() : 0;
        if (genLinesCount - templateLinesCount != 1 && (predictedLineCount = this.shiftLine(templateLinesCount, document, project, true)) != genLinesCount) {
            LOG.warn("Blade Not-identity line mappings are found. Debug lines shift may happen in: " + file);
        }
    }

    private int shiftLine(int initialLine, @Nullable Document document, @NotNull Project project, boolean lineCount) {
        if (project == null) {
            BladeDebugPathMapper.$$$reportNull$$$0(13);
        }
        int line = initialLine + this.getPathLineShift(lineCount);
        if (document != null) {
            line -= BladeDebugPathMapper.getExtendsShift(document, project, lineCount);
            line -= BladeDebugPathMapper.getCommentsShift(initialLine, true, document, project);
            line += BladeDebugPathMapper.getTextBlocksShift(initialLine, document, project);
        }
        return line;
    }

    private static int getCommentsShift(int line, boolean forward, @NotNull Document templateDocument, @NotNull Project project) {
        if (templateDocument == null) {
            BladeDebugPathMapper.$$$reportNull$$$0(14);
        }
        if (project == null) {
            BladeDebugPathMapper.$$$reportNull$$$0(15);
        }
        HashSet comments = new HashSet();
        PsiFile templatePsiFile = (PsiFile)ReadAction.compute(() -> PsiDocumentManager.getInstance((Project)project).getPsiFile(templateDocument));
        SyntaxTraverser.psiTraverser((PsiElement)templatePsiFile).filter(PsiComment.class).forEach(comment -> comments.add(new IntPair(templateDocument.getLineNumber(comment.getTextRange().getStartOffset()) + 1, templateDocument.getLineNumber(comment.getTextRange().getEndOffset()) + 1)));
        List sorted = ContainerUtil.sorted(comments, Comparator.comparingInt(pair -> pair.first));
        int shift = 0;
        for (IntPair comment2 : sorted) {
            int commentLength = comment2.second - comment2.first;
            if (forward) {
                if (line >= comment2.second) {
                    shift += commentLength;
                    continue;
                }
                if (line < comment2.first) continue;
                shift += line - comment2.first;
                continue;
            }
            if (line + shift + commentLength > comment2.second) {
                shift += commentLength;
                continue;
            }
            if (line + shift < comment2.first) continue;
            shift += line + shift - comment2.first;
        }
        return shift;
    }

    private static int getTextBlocksShift(int line, @NotNull Document templateDocument, @NotNull Project project) {
        if (templateDocument == null) {
            BladeDebugPathMapper.$$$reportNull$$$0(16);
        }
        if (project == null) {
            BladeDebugPathMapper.$$$reportNull$$$0(17);
        }
        Set<IElementType> textBlockTypes = Set.of(BladeElementTypes.ESCAPED_TEXT_BLOCK, BladeElementTypes.TEXT_BLOCK, BladeElementTypes.RAW_TEXT_BLOCK);
        PsiFile file = (PsiFile)ReadAction.compute(() -> PsiDocumentManager.getInstance((Project)project).getPsiFile(templateDocument));
        Set textBlocks = ((SyntaxTraverser)SyntaxTraverser.psiTraverser((PsiElement)file).filter(i -> textBlockTypes.contains(i.getNode().getElementType()) && i.getNextSibling() instanceof PsiWhiteSpaceImpl && StringUtil.containsChar((String)i.getNextSibling().getText(), (char)'\n'))).toSet();
        return ContainerUtil.count((Iterable)textBlocks, element -> templateDocument.getLineNumber(element.getTextRange().getStartOffset()) + 1 < line);
    }

    private static int getExtendsShift(@NotNull Document templateDocument, @NotNull Project project, boolean lineCount) {
        PsiFile file;
        List elements;
        List sorted;
        if (templateDocument == null) {
            BladeDebugPathMapper.$$$reportNull$$$0(18);
        }
        if (project == null) {
            BladeDebugPathMapper.$$$reportNull$$$0(19);
        }
        if (!(sorted = ContainerUtil.sorted((Collection)(elements = ((SyntaxTraverser)SyntaxTraverser.psiTraverser((PsiElement)(file = (PsiFile)ReadAction.compute(() -> PsiDocumentManager.getInstance((Project)project).getPsiFile(templateDocument)))).filter(i -> i instanceof BladeDirectivePsiImpl && ((BladeDirectivePsiImpl)i).getDirectiveElementType() == BladeTokenTypes.EXTENDS_DIRECTIVE)).toList()), Comparator.comparingInt(i -> i.getTextRange().getStartOffset()))).isEmpty()) {
            int n;
            PsiElement psiElement = ((PsiElement)ContainerUtil.getLastItem((List)sorted)).getNextSibling();
            if (psiElement instanceof PsiWhiteSpaceImpl) {
                PsiWhiteSpaceImpl o = (PsiWhiteSpaceImpl)psiElement;
                n = StringUtil.countNewLines((CharSequence)o.getText());
            } else {
                n = 0;
            }
            int emptyLines = n;
            return (!lineCount ? elements.size() : 0) + emptyLines - 1;
        }
        return !lineCount ? elements.size() : 0;
    }

    private int getPathLineShift(boolean lineCount) {
        return !lineCount ? (this.pathLineShift ? 1 : 0) : 1;
    }

    protected PhpTemplateDebugStateService getTemplateDebugInstance(@NotNull Project project) {
        if (project == null) {
            BladeDebugPathMapper.$$$reportNull$$$0(20);
        }
        return BladeDebugStateService.getInstance(project);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remotePathMapper";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstLine";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/blade/debug/BladeDebugPathMapper";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lastLine";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templatePosition";
                break;
            }
            case 14: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateDocument";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/blade/debug/BladeDebugPathMapper";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "retrieveTemplatePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isTemplateFileType";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isGeneratedFile";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "mapToTemplate";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "shiftLineBack";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "retrieveTemplatePath";
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "matchTemplatePathLine";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "mapToPhp";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "checkNotIdentityMappings";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "shiftLine";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getCommentsShift";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getTextBlocksShift";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getExtendsShift";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getTemplateDebugInstance";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7 -> new IllegalStateException(string);
        };
    }
}

