/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.blade.injection;

import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.jetbrains.php.blade.injection.BladeInjectionInfo;
import com.jetbrains.php.blade.psi.BladePsiLanguageInjectionHost;
import com.jetbrains.php.blade.psi.BladeTokenTypes;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BladeArrayVarsInjectionInfo
extends BladeInjectionInfo {
    private static final Pattern KEY_VALUE_REGEXP = Pattern.compile("(?<quote1>[\"'])(?<key>[\\w\\d]+)(?<quote2>[\"'])\\s*(?<delimiter>=>)?\\s*(?<quote3>[\"'])?(?<value>.*?)(?<quote4>[\"'])?(\\s*,|$)");

    public BladeArrayVarsInjectionInfo(@NotNull String phpPrefix, @NotNull String phpSuffix) {
        if (phpPrefix == null) {
            BladeArrayVarsInjectionInfo.$$$reportNull$$$0(0);
        }
        if (phpSuffix == null) {
            BladeArrayVarsInjectionInfo.$$$reportNull$$$0(1);
        }
        super(phpPrefix, phpSuffix, BladeTokenTypes.DIRECTIVE_PARAMETER_CONTENT);
    }

    @Override
    public int getBladePrefixLength() {
        return 1;
    }

    @Override
    public int getBladeSuffixLength() {
        return 1;
    }

    @Override
    public void register(MultiHostRegistrar registrar, BladePsiLanguageInjectionHost host, PsiElement child, @NotNull String prefix) {
        String parametersText;
        String variables;
        if (prefix == null) {
            BladeArrayVarsInjectionInfo.$$$reportNull$$$0(2);
        }
        Object additionalSuffix = (variables = BladeArrayVarsInjectionInfo.extractVariablesFromArray(parametersText = child.getText())) != null ? "<?php " + variables + " ?>" : "";
        int startOffset = child.getTextOffset() + this.getBladePrefixLength();
        int endOffset = child.getTextOffset() + child.getTextLength() - this.getBladeSuffixLength();
        endOffset = Math.max(startOffset, endOffset);
        TextRange rangeInsideHost = new TextRange(startOffset, endOffset).shiftLeft(host.getTextRange().getStartOffset());
        registrar.addPlace(prefix + this.getPhpPrefix(), this.getPhpSuffix() + (String)additionalSuffix, (PsiLanguageInjectionHost)host, rangeInsideHost);
    }

    @Nullable
    private static String extractVariablesFromArray(String value) {
        String arrayText = BladeArrayVarsInjectionInfo.extractArrayValue(value);
        if (arrayText == null) {
            return null;
        }
        Matcher matcher = KEY_VALUE_REGEXP.matcher(arrayText);
        StringBuilder result = new StringBuilder();
        while (matcher.find()) {
            String key;
            if (matcher.groupCount() < 3) {
                return null;
            }
            if (!Objects.equals(matcher.group("quote1"), matcher.group("quote2"))) {
                return null;
            }
            String string = key = "=>".equals(matcher.group("delimiter")) ? BladeArrayVarsInjectionInfo.extractKeyFromKeyValue(matcher) : BladeArrayVarsInjectionInfo.extractKeyFromValue(matcher);
            if (key == null) {
                return null;
            }
            result.append("/** @var $");
            result.append(matcher.group("key"));
            result.append(" mixed **/");
        }
        return result.length() > 0 ? result.toString() : null;
    }

    @Nullable
    private static String extractArrayValue(String value) {
        if (value.startsWith("([") && value.endsWith("])")) {
            return value.substring(2, value.length() - 2);
        }
        if (value.startsWith("(array(") && value.endsWith("))")) {
            return value.substring(7, value.length() - 2);
        }
        return null;
    }

    @Nullable
    private static String extractKeyFromKeyValue(Matcher matcher) {
        if (!Objects.equals(matcher.group("quote3"), matcher.group("quote4"))) {
            return null;
        }
        if (matcher.group("value") == null) {
            return null;
        }
        if (StringUtil.isNotEmpty((String)matcher.group("value"))) {
            return matcher.group("key");
        }
        if ("'".equals(matcher.group("quote3")) || "\"".equals(matcher.group("quote3"))) {
            return matcher.group("key");
        }
        return null;
    }

    @Nullable
    private static String extractKeyFromValue(Matcher matcher) {
        if (StringUtil.isNotEmpty((String)matcher.group("value")) || StringUtil.isNotEmpty((String)matcher.group("delimiter"))) {
            return null;
        }
        return matcher.group("key");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpPrefix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpSuffix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/blade/injection/BladeArrayVarsInjectionInfo";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "register";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

