/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.blade.injection;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.ui.AppUIUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.SortedList;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.XCollection;
import com.jetbrains.php.blade.BladeBundle;
import com.jetbrains.php.blade.BladeFileType;
import com.jetbrains.php.blade.injection.BladeArrayVarsInjectionInfo;
import com.jetbrains.php.blade.injection.BladeIncludeIfInjectionInfo;
import com.jetbrains.php.blade.injection.BladeInjectInjectionInfo;
import com.jetbrains.php.blade.injection.BladeInjectionInfo;
import com.jetbrains.php.blade.injection.BladeUseInjectionInfo;
import com.jetbrains.php.blade.lang.BladeDirectiveContributor;
import com.jetbrains.php.blade.parser.BladeElementTypes;
import com.jetbrains.php.blade.psi.BladeDirectiveElementType;
import com.jetbrains.php.blade.psi.BladePsiDirective;
import com.jetbrains.php.blade.psi.BladeTokenSets;
import com.jetbrains.php.blade.psi.BladeTokenTypes;
import com.jetbrains.php.blade.psi.BladeTranslatableElement;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="BladeInjectionConfiguration", storages={@Storage(value="blade.xml")})
public class BladeInjectionMappingService
implements PersistentStateComponent<BladeState> {
    private static final BladeInjectionMappingService DEFAULT_INSTANCE = new BladeInjectionMappingService(null){

        @Override
        public void loadState(@NotNull BladeState state) {
            if (state == null) {
                1.$$$reportNull$$$0(0);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/jetbrains/php/blade/injection/BladeInjectionMappingService$1", "loadState"));
        }
    };
    @Nullable
    private final Project myProject;
    private boolean isDefault = true;
    private final Map<String, BladeInjectionInfo> myInfos;
    private final Map<IElementType, BladeInjectionInfo> myNonDirectiveInfos = new HashMap<IElementType, BladeInjectionInfo>();
    private final Map<IElementType, BladeInjectionInfo> myClosingDirectiveInfos;
    private String myTextBlockStart = "{{";
    private String myTextBlockEnd = "}}";
    private String myRawTextBlockStart = "{!!";
    private String myRawTextBlockEnd = "!!}";
    private String myEscapedTextBlockStart = "{{{";
    private String myEscapedTextBlockEnd = "}}}";

    public static BladeInjectionMappingService getInstance(@Nullable Project project) {
        if (project == null) {
            return DEFAULT_INSTANCE;
        }
        return (BladeInjectionMappingService)project.getService(BladeInjectionMappingService.class);
    }

    public BladeInjectionMappingService(@Nullable Project project) {
        this.myNonDirectiveInfos.put(BladeElementTypes.TEXT_BLOCK, new BladeInjectionInfo("<?php\necho e(", "); ?>", BladeTokenTypes.TEXT_BLOCK_CONTENT){

            @Override
            public int getBladePrefixLength() {
                String delimiter = BladeInjectionMappingService.this.myTextBlockStart;
                return delimiter == null ? 0 : delimiter.length();
            }

            @Override
            public int getBladeSuffixLength() {
                String delimiter = BladeInjectionMappingService.this.myTextBlockEnd;
                return delimiter == null ? 0 : delimiter.length();
            }
        });
        this.myNonDirectiveInfos.put(BladeElementTypes.ESCAPED_TEXT_BLOCK, new BladeInjectionInfo("<?php\necho e(", "); ?>", BladeTokenTypes.ESCAPED_TEXT_BLOCK_CONTENT){

            @Override
            public int getBladePrefixLength() {
                String delimiter = BladeInjectionMappingService.this.myEscapedTextBlockStart;
                return delimiter == null ? 0 : delimiter.length();
            }

            @Override
            public int getBladeSuffixLength() {
                String delimiter = BladeInjectionMappingService.this.myEscapedTextBlockEnd;
                return delimiter == null ? 0 : delimiter.length();
            }
        });
        this.myNonDirectiveInfos.put(BladeElementTypes.RAW_TEXT_BLOCK, new BladeInjectionInfo("<?php\necho ", "; ?>", BladeTokenTypes.RAW_TEXT_BLOCK_CONTENT){

            @Override
            public int getBladePrefixLength() {
                String delimiter = BladeInjectionMappingService.this.myRawTextBlockStart;
                return delimiter == null ? 0 : delimiter.length();
            }

            @Override
            public int getBladeSuffixLength() {
                String delimiter = BladeInjectionMappingService.this.myRawTextBlockEnd;
                return delimiter == null ? 0 : delimiter.length();
            }
        });
        this.myNonDirectiveInfos.put(BladeElementTypes.PHP_DIRECTIVE_BLOCK, new BladeInjectionInfo("<?php\n", "; ?>", BladeTokenTypes.PHP_DIRECTIVE_CONTENT){

            @Override
            public int getBladePrefixLength() {
                return "@php".length();
            }

            @Override
            public int getBladeSuffixLength() {
                return "@endphp".length();
            }
        });
        this.myClosingDirectiveInfos = new HashMap<IElementType, BladeInjectionInfo>();
        this.myNonDirectiveInfos.put(BladeElementTypes.PHP_FRAGMENT, new BladeInjectionInfo("", "", BladeElementTypes.PHP_FRAGMENT){

            @Override
            public int getBladePrefixLength() {
                return 0;
            }

            @Override
            public int getBladeSuffixLength() {
                return 0;
            }
        });
        this.myInfos = new HashMap<String, BladeInjectionInfo>();
        this.put(BladeTokenTypes.EXTENDS_DIRECTIVE, BladeInjectionInfo.createForDirective("<?php\necho $__env->make(", ", \\Illuminate\\Support\\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>"));
        this.put(BladeTokenTypes.EXTENDS_FIRST_DIRECTIVE, BladeInjectionInfo.createForDirective("<?php\necho $__env->first(", ", \\Illuminate\\Support\\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>"));
        this.put(BladeTokenTypes.INCLUDE_DIRECTIVE, BladeInjectionInfo.createForDirective("<?php\necho $__env->make(", ", \\Illuminate\\Support\\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>"));
        this.put(BladeTokenTypes.INCLUDE_WHEN_DIRECTIVE, BladeInjectionInfo.createForDirective("<?php\necho $__env->renderWhen(", ", \\Illuminate\\Support\\Arr::except(get_defined_vars(), ['__data', '__path'])); ?>"));
        this.put(BladeTokenTypes.INCLUDE_UNLESS_DIRECTIVE, BladeInjectionInfo.createForDirective("<?php\necho $__env->renderUnless(", ", \\Illuminate\\Support\\Arr::except(get_defined_vars(), ['__data', '__path'])); ?>"));
        this.put(BladeTokenTypes.INCLUDE_FIRST_DIRECTIVE, BladeInjectionInfo.createForDirective("<?php\necho $__env->first(", ", \\Illuminate\\Support\\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>"));
        this.put(BladeTokenTypes.FOREACH_DIRECTIVE, BladeInjectionInfo.createForDirective("<?php\nforeach(", "): ?>"));
        this.myClosingDirectiveInfos.put(BladeTokenTypes.ENDFOREACH_DIRECTIVE, BladeInjectionInfo.createForClosingDirective("<?php\nendforeach", "; ?>"));
        this.put(BladeTokenTypes.FRAGMENT_DIRECTIVE, BladeInjectionInfo.createForDirective("<?php\n$__env->startFragment(", "); ?>"));
        this.myClosingDirectiveInfos.put(BladeTokenTypes.ENDFRAGMENT_DIRECTIVE, BladeInjectionInfo.createForClosingDirective("<?php\necho $__env->stopFragment()", "; ?>"));
        this.put(BladeTokenTypes.IF_DIRECTIVE, BladeInjectionInfo.createForDirective("<?php\nif(", "): ?>"));
        this.myClosingDirectiveInfos.put(BladeTokenTypes.ENDIF_DIRECTIVE, BladeInjectionInfo.createForClosingDirective("<?php\nendif", "; ?>"));
        this.put(BladeTokenTypes.ELSEIF_DIRECTIVE, BladeInjectionInfo.createForDirective("<?php\nelseif(", "): ?>"));
        this.put(BladeTokenTypes.WHILE_DIRECTIVE, BladeInjectionInfo.createForDirective("<?php\nwhile(", "): ?>"));
        this.myClosingDirectiveInfos.put(BladeTokenTypes.ENDWHILE_DIRECTIVE, BladeInjectionInfo.createForClosingDirective("<?php\nendwhile", "; ?>"));
        this.put(BladeTokenTypes.SECTION_DIRECTIVE, BladeInjectionInfo.createForDirective("<?php\n$__env->startSection(", "); ?>"));
        this.put(BladeTokenTypes.SECTION_MISSING_DIRECTIVE, BladeInjectionInfo.createForDirective("<?php\nif (empty(trim($__env->yieldContent(", ")))): ?>"));
        this.put(BladeTokenTypes.YIELD_DIRECTIVE, BladeInjectionInfo.createForDirective("<?php\necho $__env->yieldContent(", "); ?>"));
        this.put(BladeTokenTypes.UNLESS_DIRECTIVE, BladeInjectionInfo.createForDirective("<?php\nif (! (", ")): ?>"));
        this.put(BladeTokenTypes.FOR_DIRECTIVE, BladeInjectionInfo.createForDirective("<?php\nfor(", "): ?>"));
        this.myClosingDirectiveInfos.put(BladeTokenTypes.ENDFOR_DIRECTIVE, BladeInjectionInfo.createForClosingDirective("<?php\nendfor", "; ?>"));
        this.put(BladeTokenTypes.LANG_DIRECTIVE, BladeInjectionInfo.createForDirective("<?php\necho app('translator')->get(", "); ?>"));
        this.put(BladeTokenTypes.CHOICE_DIRECTIVE, BladeInjectionInfo.createForDirective("<?php\necho app('translator')->choice(", "); ?>"));
        this.put(BladeTokenTypes.EACH_DIRECTIVE, BladeInjectionInfo.createForDirective("<?php\necho $__env->renderEach(", "); ?>"));
        this.put(BladeTokenTypes.FORELSE_DIRECTIVE, BladeInjectionInfo.createForDirective("<?php\nforeach(", "): ?>"));
        this.myClosingDirectiveInfos.put(BladeTokenTypes.ENDFORELSE_DIRECTIVE, BladeInjectionInfo.createForClosingDirective("<?php\nendif; endforeach", "; ?>"));
        this.put(BladeTokenTypes.STACK_DIRECTIVE, BladeInjectionInfo.createForDirective("<?php\necho $__env->yieldPushContent(", "); ?>"));
        this.put(BladeTokenTypes.PUSH_DIRECTIVE, BladeInjectionInfo.createForDirective("<?php\n$__env->startPush(", "); ?>"));
        this.put(BladeTokenTypes.PUSHIF_DIRECTIVE, BladeInjectionInfo.createForDirective("<?php\n$__pushif_args = explode(',',", ", 2); if({$__pushif_args[0]}): $__env->startPush({$__pushif_args[1]}); ?>"));
        this.myClosingDirectiveInfos.put(BladeTokenTypes.ENDPUSHIF_DIRECTIVE, BladeInjectionInfo.createForClosingDirective("<?php\n$__env->stopPush(); endif", "; ?>"));
        this.put(BladeTokenTypes.PREPEND_DIRECTIVE, BladeInjectionInfo.createForDirective("<?php\n$__env->startPrepend(", "); ?>"));
        this.put(BladeTokenTypes.PUSHONCE_DIRECTIVE, BladeInjectionInfo.createForDirective("<?php\n$__php_storm_push_once_params = [", "]; if (!$__env->hasRenderedOnce($__php_storm_push_once_params[1])): $__env->markAsRenderedOnce($__php_storm_push_once_params[1]); $__env->startPush($__php_storm_push_once_params[0]); ?>"));
        this.myClosingDirectiveInfos.put(BladeTokenTypes.ENDPUSHONCE_DIRECTIVE, BladeInjectionInfo.createForClosingDirective("<?php\nendif", "; ?>"));
        this.put(BladeTokenTypes.PREPENDONCE_DIRECTIVE, BladeInjectionInfo.createForDirective("<?php\n$___phpstorm_prepend_once_params = [", "]; if (! $__env->hasRenderedOnce($___phpstorm_prepend_once_params[1])): $__env->markAsRenderedOnce($___phpstorm_prepend_once_params); $__env->startPrepend($___phpstorm_prepend_once_params[0]); ?>"));
        this.myClosingDirectiveInfos.put(BladeTokenTypes.ENDPREPENDONCE_DIRECTIVE, BladeInjectionInfo.createForClosingDirective("<?php\nendif", "; ?>"));
        this.put(BladeTokenTypes.UNSET_DIRECTIVE, BladeInjectionInfo.createForDirective("<?php\nunset(", "); ?>"));
        this.put(BladeTokenTypes.PHP_DIRECTIVE, BladeInjectionInfo.createForDirective("<?php\n(", "); ?>"));
        this.put(BladeTokenTypes.BREAK_DIRECTIVE, BladeInjectionInfo.createForDirective("<?php\nif(", ") break; ?>"));
        this.put(BladeTokenTypes.CONTINUE_DIRECTIVE, BladeInjectionInfo.createForDirective("<?php\nif(", ") continue; ?>"));
        this.put(BladeTokenTypes.CAN_DIRECTIVE, BladeInjectionInfo.createForDirective("<?php\nif (app(\\Illuminate\\Contracts\\Auth\\Access\\Gate::class)->check(", ")): ?>"));
        this.put(BladeTokenTypes.CANNOT_DIRECTIVE, BladeInjectionInfo.createForDirective("<?php\nif (app(\\Illuminate\\Contracts\\Auth\\Access\\Gate::class)->denies(", ")): ?>"));
        this.put(BladeTokenTypes.ELSECAN_DIRECTIVE, BladeInjectionInfo.createForDirective("<?php\nelseif (app(\\Illuminate\\Contracts\\Auth\\Access\\Gate::class)->check(", ")): ?>"));
        this.put(BladeTokenTypes.ELSECANNOT_DIRECTIVE, BladeInjectionInfo.createForDirective("<?php\nelseif (app(\\Illuminate\\Contracts\\Auth\\Access\\Gate::class)->denies(", ")): ?>"));
        this.put(BladeTokenTypes.ELSECANANY_DIRECTIVE, BladeInjectionInfo.createForDirective("<?php\nelseif (app(\\Illuminate\\Contracts\\Auth\\Access\\Gate::class)->any(", ")): ?>"));
        this.put(BladeTokenTypes.HASSECTION_DIRECTIVE, BladeInjectionInfo.createForDirective("<?php\nif (! empty(trim($__env->yieldContent(", ")))): ?>"));
        this.put(BladeTokenTypes.COMPONENT_DIRECTIVE, BladeInjectionInfo.createForDirective("<?php\n$__env->startComponent(", "); ?>"));
        this.put(BladeTokenTypes.COMPONENT_FIRST_DIRECTIVE, BladeInjectionInfo.createForDirective("<?php\n$__env->startComponentFirst(", "); ?>"));
        this.put(BladeTokenTypes.ENV_DIRECTIVE, BladeInjectionInfo.createForDirective("<?php\nif(app()->environment(", ")): ?>"));
        this.myClosingDirectiveInfos.put(BladeTokenTypes.ENDENV_DIRECTIVE, BladeInjectionInfo.createForClosingDirective("<?php\nendif", "; ?>"));
        this.put(BladeTokenTypes.SLOT_DIRECTIVE, BladeInjectionInfo.createForDirective("<?php\n$__env->slot(", "); ?>"));
        this.put(BladeTokenTypes.ISSET_DIRECTIVE, BladeInjectionInfo.createForDirective("<?php\nif(isset(", ")): ?>"));
        this.myClosingDirectiveInfos.put(BladeTokenTypes.ENDISSET_DIRECTIVE, BladeInjectionInfo.createForClosingDirective("<?php\nendif", "; ?>"));
        this.put(BladeTokenTypes.EMPTY_DIRECTIVE, BladeInjectionInfo.createForDirective("<?php\nif(empty(", ")): ?>"));
        this.put(BladeTokenTypes.SWITCH_DIRECTIVE, BladeInjectionInfo.createForDirective("<?php\nswitch(", "): ?>"));
        this.myClosingDirectiveInfos.put(BladeTokenTypes.ENDSWITCH_DIRECTIVE, BladeInjectionInfo.createForClosingDirective("<?php\nendswitch", "; ?>"));
        this.put(BladeTokenTypes.CASE_DIRECTIVE, BladeInjectionInfo.createForDirective("<?php\ncase (", "): ?>"));
        this.put(BladeTokenTypes.AUTH_DIRECTIVE, BladeInjectionInfo.createForDirective("<?php\nif(auth()->guard(", ")->check()): ?>"));
        this.put(BladeTokenTypes.ELSE_AUTH_DIRECTIVE, BladeInjectionInfo.createForDirective("<?php\nelseif(auth()->guard(", ")->check()): ?>"));
        this.put(BladeTokenTypes.GUEST_DIRECTIVE, BladeInjectionInfo.createForDirective("<?php\nif(auth()->guard(", ")->guest()): ?>"));
        this.put(BladeTokenTypes.ELSE_GUEST_DIRECTIVE, BladeInjectionInfo.createForDirective("<?php\nelseif(auth()->guard(", ")->guest()): ?>"));
        this.put(BladeTokenTypes.JSON_DIRECTIVE, BladeInjectionInfo.createForDirective("<?php\necho json_encode(", ") ?>"));
        this.put(BladeTokenTypes.JS_DIRECTIVE, BladeInjectionInfo.createForDirective("<?php\necho \\Illuminate\\Support\\Js::from(", ")->toHtml() ?>"));
        this.put(BladeTokenTypes.CHECKED_DIRECTIVE, BladeInjectionInfo.createForDirective("<?php\nif(", "): echo 'checked'; endif; ?>"));
        this.put(BladeTokenTypes.SELECTED_DIRECTIVE, BladeInjectionInfo.createForDirective("<?php\nif(", "): echo 'selected'; endif; ?>"));
        this.put(BladeTokenTypes.DISABLED_DIRECTIVE, BladeInjectionInfo.createForDirective("<?php\nif(", "): echo 'disabled'; endif; ?>"));
        this.put(BladeTokenTypes.REQUIRED_DIRECTIVE, BladeInjectionInfo.createForDirective("<?php\nif(", "): echo 'required'; endif; ?>"));
        this.put(BladeTokenTypes.READONLY_DIRECTIVE, BladeInjectionInfo.createForDirective("<?php\nif(", "): echo 'readonly'; endif; ?>"));
        this.put(BladeTokenTypes.DD_DIRECTIVE, BladeInjectionInfo.createForDirective("<?php\ndd(", "); ?>"));
        this.put(BladeTokenTypes.DUMP_DIRECTIVE, BladeInjectionInfo.createForDirective("<?php\ndump(", "); ?>"));
        this.put(BladeTokenTypes.METHOD_DIRECTIVE, BladeInjectionInfo.createForDirective("<?php\necho method_field(", "); ?>"));
        this.put(BladeTokenTypes.CANANY_DIRECTIVE, BladeInjectionInfo.createForDirective("<?php\nif (app(\\Illuminate\\Contracts\\Auth\\Access\\Gate::class)->any(", ")): ?>"));
        this.put(BladeTokenTypes.CLASS_DIRECTIVE, BladeInjectionInfo.createForDirective("class=\"<?php\necho \\Illuminate\\Support\\Arr::toCssClasses(", ") ?>\""));
        this.put(BladeTokenTypes.STYLE_DIRECTIVE, BladeInjectionInfo.createForDirective("style=\"<?php\necho \\Illuminate\\Support\\Arr::toCssStyles(", ") ?>\""));
        this.put(BladeTokenTypes.ERROR_DIRECTIVE, BladeInjectionInfo.createForDirective("<?php\n$__errorArgs = [", "];\n$__bag = $errors->getBag($__errorArgs[1] ?? 'default');\nif ($__bag->has($__errorArgs[0])) :\nif (isset($message)) { $__messageOriginal = $message; }\n$message = $__bag->first($__errorArgs[0]); ?>"));
        this.put(BladeTokenTypes.AWARE_DIRECTIVE, new BladeArrayVarsInjectionInfo("<?php\n$__aware_exp = ", "?>"));
        this.put(BladeTokenTypes.PROPS_DIRECTIVE, new BladeArrayVarsInjectionInfo("<?php\n$__props_exp = ", "?>"));
        this.put(BladeTokenTypes.VITE_DIRECTIVE, BladeInjectionInfo.createForDirective("<?php\n$__vite_arguments = ", " ?? '()'; echo app(Illuminate\\Foundation\\Vite::class){$__vite_arguments}; ?>"));
        this.addNonconfigurableData();
        for (BladeDirectiveElementType type : BladeTokenSets.getDirectiveTypes()) {
            if (this.getDirectiveInfos().containsKey(type.getText())) continue;
            this.put(type, null);
        }
        this.myProject = project;
    }

    private void put(@NotNull BladeDirectiveElementType directiveType, @Nullable BladeInjectionInfo info) {
        if (directiveType == null) {
            BladeInjectionMappingService.$$$reportNull$$$0(0);
        }
        this.myInfos.put(directiveType.getText(), info);
    }

    @Nullable
    public BladeInjectionInfo getInfo(IElementType bladeElementType, @Nullable String latestBladeText) {
        if (BladeElementTypes.DIRECTIVE_PARAMETER != bladeElementType) {
            return BladeInjectionMappingService.getNonDirectiveInfo(bladeElementType);
        }
        return this.getDirectiveInfos().get(latestBladeText);
    }

    @Nullable
    public BladeInjectionInfo getInfo(BladeTranslatableElement element) {
        BladePsiDirective directive = (BladePsiDirective)ObjectUtils.tryCast((Object)((Object)element), BladePsiDirective.class);
        BladePsiDirective bladePsiDirective = directive = directive == null ? (BladePsiDirective)ObjectUtils.tryCast((Object)element.getParent(), BladePsiDirective.class) : directive;
        if (directive == null) {
            return BladeInjectionMappingService.getNonDirectiveInfo(element.getNode().getElementType());
        }
        if (directive.isClosing()) {
            return this.myClosingDirectiveInfos.get(directive.getDirectiveElementType());
        }
        return this.getDirectiveInfos().get(directive.getName());
    }

    @NotNull
    public Map<String, BladeInjectionInfo> getDirectiveInfos() {
        HashMap<String, BladeInjectionInfo> allDirectives = new HashMap<String, BladeInjectionInfo>(this.myInfos);
        for (BladeDirectiveContributor contributor : BladeDirectiveContributor.getEP_NAME().getExtensionList()) {
            contributor.getDirectives(this.myProject).forEach(d -> allDirectives.put(d.getName(), d.getInjectionInfo()));
        }
        HashMap<String, BladeInjectionInfo> hashMap = allDirectives;
        if (hashMap == null) {
            BladeInjectionMappingService.$$$reportNull$$$0(1);
        }
        return hashMap;
    }

    @NotNull
    public BladeState getState() {
        return this.isDefault ? new BladeState() : new BladeState(false, this.myInfos, this.myTextBlockStart, this.myTextBlockEnd, this.myRawTextBlockStart, this.myRawTextBlockEnd, this.myEscapedTextBlockStart, this.myEscapedTextBlockEnd);
    }

    public void loadState(@NotNull BladeState state) {
        if (state == null) {
            BladeInjectionMappingService.$$$reportNull$$$0(2);
        }
        this.doApplyState(state, false);
    }

    public void resetFormState(BladeState state) {
        this.doApplyState(state, true);
    }

    private void doApplyState(BladeState state, boolean reloadFilesIfChanged) {
        if (state.isDefault()) {
            state = new BladeState();
        }
        boolean changed = this.isDefault != state.isDefault();
        this.isDefault = state.isDefault();
        changed |= !StringUtil.equals((CharSequence)this.myTextBlockStart, (CharSequence)state.getTextBlockStart()) || !StringUtil.equals((CharSequence)this.myTextBlockEnd, (CharSequence)state.getTextBlockEnd()) || !StringUtil.equals((CharSequence)this.myRawTextBlockStart, (CharSequence)state.getRawTextBlockStart()) || !StringUtil.equals((CharSequence)this.myRawTextBlockEnd, (CharSequence)state.getRawTextBlockEnd()) || !StringUtil.equals((CharSequence)this.myEscapedTextBlockStart, (CharSequence)state.getEscapedTextBlockStart()) || !StringUtil.equals((CharSequence)this.myEscapedTextBlockEnd, (CharSequence)state.getEscapedTextBlockEnd());
        this.myTextBlockStart = state.getTextBlockStart();
        this.myTextBlockEnd = state.getTextBlockEnd();
        this.myRawTextBlockStart = state.getRawTextBlockStart();
        this.myRawTextBlockEnd = state.getRawTextBlockEnd();
        this.myEscapedTextBlockStart = state.getEscapedTextBlockStart();
        this.myEscapedTextBlockEnd = state.getEscapedTextBlockEnd();
        if (!changed && reloadFilesIfChanged) {
            for (InjectionData data : state.myDataList) {
                String directive = data.getDirective();
                boolean containsKey = this.myInfos.containsKey(directive);
                if (!containsKey) {
                    changed = true;
                    break;
                }
                BladeInjectionInfo info = this.myInfos.remove(directive);
                if (data.isParametrized == (info == null)) {
                    changed = true;
                    break;
                }
                if (!data.isParametrized || StringUtil.equals((CharSequence)data.getPrefix(), (CharSequence)info.getPhpPrefix()) && StringUtil.equals((CharSequence)data.getSuffix(), (CharSequence)info.getPhpSuffix())) continue;
                changed = true;
                break;
            }
            if (!changed) {
                for (BladeInjectionInfo info : this.myInfos.values()) {
                    if (info != null && !info.isConfigurable()) continue;
                    changed = true;
                    break;
                }
            }
        }
        this.myInfos.clear();
        for (InjectionData data : state.getDataList()) {
            this.myInfos.put(data.getDirective(), data.toInjectionInfo());
        }
        this.addNonconfigurableData();
        if (changed && reloadFilesIfChanged) {
            this.reparseBladeFiles();
        }
    }

    private void addNonconfigurableData() {
        this.myInfos.put(BladeTokenTypes.INJECT_DIRECTIVE.getText(), new BladeInjectInjectionInfo());
        this.myInfos.put(BladeTokenTypes.USE_DIRECTIVE.getText(), new BladeUseInjectionInfo());
        this.myInfos.put(BladeTokenTypes.INCLUDE_IF_DIRECTIVE.getText(), new BladeIncludeIfInjectionInfo());
    }

    private void reparseBladeFiles() {
        if (this.myProject != null) {
            Task.Backgroundable task = new Task.Backgroundable(this.myProject, BladeBundle.message("settings.blocks.progress.reparsing.blade.files", new Object[0]), true){

                public void run(@NotNull ProgressIndicator indicator) {
                    int index;
                    int partCapacity;
                    if (indicator == null) {
                        7.$$$reportNull$$$0(0);
                    }
                    indicator.setIndeterminate(false);
                    Collection bladeFiles = (Collection)ReadAction.compute(() -> FileTypeIndex.getFiles((FileType)BladeFileType.INSTANCE, (GlobalSearchScope)GlobalSearchScope.allScope((Project)this.getProject())));
                    VirtualFile[] filesArray = bladeFiles.toArray(VirtualFile.EMPTY_ARRAY);
                    int capacity = 20;
                    for (index = 0; index < filesArray.length && !indicator.isCanceled() && !this.getProject().isDisposed(); index += partCapacity) {
                        indicator.setFraction((double)index / (double)filesArray.length);
                        partCapacity = Math.min(20, filesArray.length - index);
                        VirtualFile[] part = new VirtualFile[partCapacity];
                        System.arraycopy(filesArray, index, part, 0, partCapacity);
                        ApplicationManager.getApplication().invokeAndWait(() -> PsiDocumentManager.getInstance((Project)this.getProject()).reparseFiles(Arrays.asList(part), true));
                    }
                    assert (indicator.isCanceled() || index == filesArray.length);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/php/blade/injection/BladeInjectionMappingService$7", "run"));
                }
            };
            AppUIUtil.invokeLaterIfProjectAlive((Project)this.myProject, () -> BladeInjectionMappingService.lambda$reparseBladeFiles$1((Task)task));
        }
    }

    public void resetToDefaults() {
        this.resetFormState(new BladeState());
    }

    public static BladeInjectionInfo getNonDirectiveInfo(@NotNull IElementType type) {
        if (type == null) {
            BladeInjectionMappingService.$$$reportNull$$$0(3);
        }
        return BladeInjectionMappingService.getInstance(null).myNonDirectiveInfos.get(type);
    }

    private static /* synthetic */ void lambda$reparseBladeFiles$1(Task task) {
        task.queue();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directiveType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/blade/injection/BladeInjectionMappingService";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/blade/injection/BladeInjectionMappingService";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectiveInfos";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "put";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getNonDirectiveInfo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    public static class BladeState {
        private boolean myDefault;
        private List<InjectionData> myDataList = new SortedList(Comparator.comparing(InjectionData::getDirective));
        private String myTextBlockStart;
        private String myTextBlockEnd;
        private String myRawTextBlockStart;
        private String myRawTextBlockEnd;
        private String myEscapedTextBlockStart;
        private String myEscapedTextBlockEnd;

        public BladeState() {
            this(true, BladeInjectionMappingService.DEFAULT_INSTANCE.myInfos, BladeInjectionMappingService.DEFAULT_INSTANCE.myTextBlockStart, BladeInjectionMappingService.DEFAULT_INSTANCE.myTextBlockEnd, BladeInjectionMappingService.DEFAULT_INSTANCE.myRawTextBlockStart, BladeInjectionMappingService.DEFAULT_INSTANCE.myRawTextBlockEnd, BladeInjectionMappingService.DEFAULT_INSTANCE.myEscapedTextBlockStart, BladeInjectionMappingService.DEFAULT_INSTANCE.myEscapedTextBlockEnd);
        }

        private BladeState(boolean isDefault, Map<String, BladeInjectionInfo> infos, String textBlockStartDelimiter, String textBlockEndDelimiter, String rawTextBlockStartDelimiter, String rawTextBlockEndDelimiter, String escapedTextBlockStartDelimiter, String escapedTextBlockEndDelimiter) {
            this.myDefault = isDefault;
            this.setDataMap(infos);
            this.myTextBlockStart = textBlockStartDelimiter;
            this.myTextBlockEnd = textBlockEndDelimiter;
            this.myRawTextBlockStart = rawTextBlockStartDelimiter;
            this.myRawTextBlockEnd = rawTextBlockEndDelimiter;
            this.myEscapedTextBlockStart = escapedTextBlockStartDelimiter;
            this.myEscapedTextBlockEnd = escapedTextBlockEndDelimiter;
        }

        @Deprecated
        @XCollection(elementTypes={InjectionData.class}, propertyElementName="customDirectives")
        public List<InjectionData> getOldDataList() {
            return null;
        }

        @Deprecated
        public void setOldDataList(List<InjectionData> oldDataList) {
            this.myDefault = false;
            this.myDataList = oldDataList;
        }

        @Deprecated
        @Attribute(value="textStart")
        public String getOldTextBlockStart() {
            return null;
        }

        @Deprecated
        public void setOldTextBlockStart(@NonNls String oldTextBlockStart) {
            this.myDefault = false;
            this.myTextBlockStart = oldTextBlockStart;
        }

        @Deprecated
        @Attribute(value="textEnd")
        public String getOldTextBlockEnd() {
            return null;
        }

        @Deprecated
        public void setOldTextBlockEnd(@NonNls String oldTextBlockEnd) {
            this.myDefault = false;
            this.myTextBlockEnd = oldTextBlockEnd;
        }

        @Deprecated
        @Attribute(value="rawTextStart")
        public String getOldRawTextBlockStart() {
            return null;
        }

        @Deprecated
        public void setOldRawTextBlockStart(@NonNls String oldRawTextBlockStart) {
            this.myDefault = false;
            this.myRawTextBlockStart = oldRawTextBlockStart;
        }

        @Deprecated
        @Attribute(value="rawTextEnd")
        public String getOldRawTextBlockEnd() {
            return null;
        }

        @Deprecated
        public void setOldRawTextBlockEnd(@NonNls String oldRawTextBlockEnd) {
            this.myDefault = false;
            this.myRawTextBlockEnd = oldRawTextBlockEnd;
        }

        @Deprecated
        @Attribute(value="escapedTextStart")
        public String getOldEscapedTextBlockStart() {
            return null;
        }

        @Deprecated
        public void setOldEscapedTextBlockStart(@NonNls String oldEscapedTextBlockStart) {
            if ("{{{".equals(oldEscapedTextBlockStart) || "{!!".equals(oldEscapedTextBlockStart)) {
                return;
            }
            this.myDefault = false;
            this.myEscapedTextBlockStart = oldEscapedTextBlockStart;
        }

        @Deprecated
        @Attribute(value="escapedTextEnd")
        public String getOldEscapedTextBlockEnd() {
            return null;
        }

        @Deprecated
        public void setOldEscapedTextBlockEnd(@NonNls String oldEscapedTextBlockEnd) {
            if ("}}}".equals(oldEscapedTextBlockEnd) || "!!}".equals(oldEscapedTextBlockEnd)) {
                return;
            }
            this.myDefault = false;
            this.myEscapedTextBlockEnd = oldEscapedTextBlockEnd;
        }

        public void setDataMap(Map<String, BladeInjectionInfo> result) {
            this.myDataList.clear();
            if (result == null) {
                return;
            }
            for (Map.Entry<String, BladeInjectionInfo> entry : result.entrySet()) {
                if (entry.getValue() != null && !entry.getValue().isConfigurable()) continue;
                this.myDataList.add(new InjectionData(entry.getKey(), entry.getValue()));
            }
        }

        @XCollection(propertyElementName="directives")
        public List<InjectionData> getDataList() {
            return this.myDataList;
        }

        public void setDataList(List<InjectionData> dataList) {
            this.myDataList = dataList;
        }

        @Attribute(value="default")
        public boolean isDefault() {
            return this.myDefault;
        }

        public void setDefault(boolean aDefault) {
            this.myDefault = aDefault;
        }

        @Attribute(value="contentPrefix")
        public String getTextBlockStart() {
            return this.myTextBlockStart;
        }

        public void setTextBlockStart(String textBlockStart) {
            this.myTextBlockStart = textBlockStart;
        }

        @Attribute(value="contentSuffix")
        public String getTextBlockEnd() {
            return this.myTextBlockEnd;
        }

        public void setTextBlockEnd(String textBlockEnd) {
            this.myTextBlockEnd = textBlockEnd;
        }

        @Attribute(value="rawPrefix")
        public String getRawTextBlockStart() {
            return this.myRawTextBlockStart;
        }

        public void setRawTextBlockStart(String rawTextBlockStart) {
            this.myRawTextBlockStart = rawTextBlockStart;
        }

        @Attribute(value="rawSuffix")
        public String getRawTextBlockEnd() {
            return this.myRawTextBlockEnd;
        }

        public void setRawTextBlockEnd(String rawTextBlockEnd) {
            this.myRawTextBlockEnd = rawTextBlockEnd;
        }

        @Attribute(value="escapedPrefix")
        public String getEscapedTextBlockStart() {
            return this.myEscapedTextBlockStart;
        }

        public void setEscapedTextBlockStart(String escapedTextBlockStart) {
            this.myEscapedTextBlockStart = escapedTextBlockStart;
        }

        @Attribute(value="escapedSuffix")
        public String getEscapedTextBlockEnd() {
            return this.myEscapedTextBlockEnd;
        }

        public void setEscapedTextBlockEnd(String escapedTextBlockEnd) {
            this.myEscapedTextBlockEnd = escapedTextBlockEnd;
        }
    }

    @Tag(value="data")
    public static class InjectionData
    implements Cloneable {
        private String directive;
        private boolean isParametrized;
        private String prefix;
        private String suffix;

        public InjectionData() {
            this("", false, "", "");
        }

        public InjectionData(@NotNull String directive, @Nullable BladeInjectionInfo info) {
            if (directive == null) {
                InjectionData.$$$reportNull$$$0(0);
            }
            this(directive, info != null, info == null ? "" : info.getPhpPrefix(), info == null ? "" : info.getPhpSuffix());
        }

        public InjectionData(@NotNull String directive, boolean isParametrized, @NotNull String prefix, @NotNull String suffix) {
            if (directive == null) {
                InjectionData.$$$reportNull$$$0(1);
            }
            if (prefix == null) {
                InjectionData.$$$reportNull$$$0(2);
            }
            if (suffix == null) {
                InjectionData.$$$reportNull$$$0(3);
            }
            this.directive = directive;
            this.isParametrized = isParametrized;
            this.prefix = prefix;
            this.suffix = suffix;
        }

        @Attribute(value="directive")
        public String getDirective() {
            return this.directive;
        }

        public void setDirective(String directive) {
            this.directive = directive;
        }

        @Attribute(value="injection")
        public boolean isParametrized() {
            return this.isParametrized;
        }

        public void setParametrized(boolean parametrized) {
            this.isParametrized = parametrized;
        }

        @Attribute(value="prefix")
        public String getPrefix() {
            return this.prefix;
        }

        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        @Attribute(value="suffix")
        public String getSuffix() {
            return this.suffix;
        }

        public void setSuffix(String suffix) {
            this.suffix = suffix;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof InjectionData)) {
                return false;
            }
            InjectionData data = (InjectionData)o;
            if (this.isParametrized != data.isParametrized) {
                return false;
            }
            if (!this.directive.equals(data.directive)) {
                return false;
            }
            if (!this.prefix.equals(data.prefix)) {
                return false;
            }
            return this.suffix.equals(data.suffix);
        }

        public int hashCode() {
            int result = this.directive.hashCode();
            result = 31 * result + (this.isParametrized ? 1 : 0);
            result = 31 * result + this.prefix.hashCode();
            result = 31 * result + this.suffix.hashCode();
            return result;
        }

        public String toString() {
            return "InjectionData{directive='" + this.directive + "', isParametrized=" + this.isParametrized + ", prefix='" + this.prefix + "', suffix='" + this.suffix + "'}";
        }

        public InjectionData clone() {
            try {
                return (InjectionData)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new IllegalStateException(e);
            }
        }

        @Nullable
        public BladeInjectionInfo toInjectionInfo() {
            if (BladeTokenTypes.AWARE_DIRECTIVE.getText().equals(this.getDirective()) || BladeTokenTypes.PROPS_DIRECTIVE.getText().equals(this.getDirective())) {
                return new BladeArrayVarsInjectionInfo(this.getPrefix(), this.getSuffix());
            }
            return this.isParametrized ? BladeInjectionInfo.createForDirective(this.getPrefix(), this.getSuffix()) : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "directive";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "prefix";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "suffix";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/blade/injection/BladeInjectionMappingService$InjectionData";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

