/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.blade.injection;

import com.intellij.codeInsight.daemon.impl.CollectHighlightsUtil;
import com.intellij.lang.Language;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.blade.html.BladeHTMLLanguage;
import com.jetbrains.php.blade.injection.BladeInjectionInfo;
import com.jetbrains.php.blade.parser.BladeElementTypes;
import com.jetbrains.php.blade.psi.BladeFileImpl;
import com.jetbrains.php.blade.psi.BladePsiLanguageInjectionHost;
import com.jetbrains.php.blade.psi.BladeTranslatableElement;
import com.jetbrains.php.lang.PhpLanguage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BladeInjector
implements MultiHostInjector,
DumbAware {
    private static final List<? extends Class<? extends PsiElement>> ELEMENTS_TO_INJECT = List.of(BladePsiLanguageInjectionHost.class);

    public void getLanguagesToInject(final @NotNull MultiHostRegistrar registrar, @NotNull PsiElement context) {
        BladePsiLanguageInjectionHost bladeInjectionHost;
        if (registrar == null) {
            BladeInjector.$$$reportNull$$$0(0);
        }
        if (context == null) {
            BladeInjector.$$$reportNull$$$0(1);
        }
        if ((bladeInjectionHost = (BladePsiLanguageInjectionHost)((Object)ObjectUtils.tryCast((Object)context, BladePsiLanguageInjectionHost.class))) == null) {
            return;
        }
        final Ref injection = new Ref();
        if (!bladeInjectionHost.isPhysical() && !(bladeInjectionHost.getContainingFile() instanceof BladeFileImpl)) {
            return;
        }
        final PsiFile htmlFile = (PsiFile)ContainerUtil.find((Iterable)context.getContainingFile().getViewProvider().getAllFiles(), f -> BladeHTMLLanguage.INSTANCE.getID().equals(f.getLanguage().getID()));
        bladeInjectionHost.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                List<BladeInjectionInfo> injectionInfos;
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((injectionInfos = BladeInjector.getInjectionInfos(element, htmlFile)).isEmpty()) {
                    super.visitElement(element);
                    return;
                }
                if (injection.isNull()) {
                    injection.set((Object)registrar.startInjecting((Language)PhpLanguage.INSTANCE));
                }
                for (BladeInjectionInfo injectionInfo : injectionInfos) {
                    injectionInfo.register((MultiHostRegistrar)injection.get(), bladeInjectionHost, element, "");
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/php/blade/injection/BladeInjector$1", "visitElement"));
            }
        });
        MultiHostRegistrar startedInjection = (MultiHostRegistrar)injection.get();
        if (startedInjection != null) {
            startedInjection.doneInjecting();
        }
    }

    private static List<BladeInjectionInfo> getInjectionInfos(@NotNull PsiElement element, @Nullable PsiFile htmlFile) {
        BladeInjectionInfo injectionInfo;
        List<BladeInjectionInfo> elements;
        if (element == null) {
            BladeInjector.$$$reportNull$$$0(2);
        }
        if (!(elements = BladeInjector.getAttributeInjections(element, htmlFile)).isEmpty()) {
            return elements;
        }
        BladeTranslatableElement translatableElement = (BladeTranslatableElement)((Object)ObjectUtils.tryCast((Object)element, BladeTranslatableElement.class));
        BladeInjectionInfo bladeInjectionInfo = injectionInfo = translatableElement != null ? translatableElement.getInfo() : null;
        if (injectionInfo != null) {
            return List.of(injectionInfo);
        }
        return ContainerUtil.emptyList();
    }

    @NotNull
    private static List<BladeInjectionInfo> getAttributeInjections(final @NotNull PsiElement element, @Nullable PsiFile htmlFile) {
        int endBladeElement;
        if (element == null) {
            BladeInjector.$$$reportNull$$$0(3);
        }
        if (htmlFile == null || element.getNode().getElementType() != BladeElementTypes.INJECTABLE_TEMPLATE_HTML) {
            List<BladeInjectionInfo> list = Collections.emptyList();
            if (list == null) {
                BladeInjector.$$$reportNull$$$0(4);
            }
            return list;
        }
        final int startBladeElement = element.getTextRange().getStartOffset();
        PsiElement parent = CollectHighlightsUtil.findCommonParent((PsiElement)htmlFile, (int)startBladeElement, (int)(endBladeElement = element.getTextRange().getEndOffset()));
        if (parent == null) {
            List<BladeInjectionInfo> list = Collections.emptyList();
            if (list == null) {
                BladeInjector.$$$reportNull$$$0(5);
            }
            return list;
        }
        final ArrayList<BladeInjectionInfo> injections = new ArrayList<BladeInjectionInfo>();
        parent.accept((PsiElementVisitor)new XmlRecursiveElementVisitor(){

            public void visitXmlTag(@NotNull XmlTag tag) {
                if (tag == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (tag.getName().startsWith("x-")) {
                    Arrays.stream(tag.getAttributes()).filter(a -> a.getName().startsWith(":")).map(a -> a.getValueElement()).filter(Objects::nonNull).filter(v -> element.getTextRange().contains(v.getTextRange())).map(v -> new BladeInjectionInfo("<?php\n__phpstorm_set_attr(", "); ?>", BladeElementTypes.INJECTABLE_TEMPLATE_HTML, (XmlAttributeValue)v, startBladeElement, endBladeElement){
                        final /* synthetic */ XmlAttributeValue val$v;
                        final /* synthetic */ int val$startBladeElement;
                        final /* synthetic */ int val$endBladeElement;
                        {
                            this.val$v = xmlAttributeValue;
                            this.val$startBladeElement = n;
                            this.val$endBladeElement = n2;
                            super(phpPrefix, phpSuffix, contentType);
                        }

                        @Override
                        public int getBladePrefixLength() {
                            return this.val$v.getTextRange().getStartOffset() - this.val$startBladeElement + 1;
                        }

                        @Override
                        public int getBladeSuffixLength() {
                            return this.val$endBladeElement - this.val$v.getTextRange().getEndOffset() + 1;
                        }
                    }).forEach(injections::add);
                }
                super.visitXmlTag(tag);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/jetbrains/php/blade/injection/BladeInjector$2", "visitXmlTag"));
            }
        });
        ArrayList<BladeInjectionInfo> arrayList = injections;
        if (arrayList == null) {
            BladeInjector.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @NotNull
    public List<? extends Class<? extends PsiElement>> elementsToInjectIn() {
        List<? extends Class<? extends PsiElement>> list = ELEMENTS_TO_INJECT;
        if (list == null) {
            BladeInjector.$$$reportNull$$$0(7);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/blade/injection/BladeInjector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/blade/injection/BladeInjector";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributeInjections";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "elementsToInjectIn";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLanguagesToInject";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getInjectionInfos";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getAttributeInjections";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7 -> new IllegalStateException(string);
        };
    }
}

