/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.blade.inspections.filter;

import com.intellij.codeInsight.daemon.impl.IntentionActionFilter;
import com.intellij.codeInsight.intention.CommonIntentionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.impl.config.IntentionActionWrapper;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.actions.CleanupAllIntention;
import com.intellij.codeInspection.ex.QuickFixWrapper;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.diagnostic.ReportingClassSubstitutor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.blade.BladeLanguage;
import com.jetbrains.php.blade.parser.BladeElementTypes;
import com.jetbrains.php.blade.psi.BladeTokenTypes;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BladePhpQuickFixesFilter
implements IntentionActionFilter {
    private static final Set<String> ALLOW_LIST = Set.of("PhpImportQualifierQuickFix", "PhpRemoveRedundantQualifierQuickFix");

    public boolean accept(@NotNull IntentionAction intentionAction, @Nullable PsiFile file, int offset) {
        if (intentionAction == null) {
            BladePhpQuickFixesFilter.$$$reportNull$$$0(0);
        }
        if (file == null || file.getLanguage() != BladeLanguage.INSTANCE) {
            return true;
        }
        LocalQuickFix quickFix = QuickFixWrapper.unwrap((CommonIntentionAction)intentionAction);
        if (quickFix != null) {
            Class fixClass = ReportingClassSubstitutor.getClassToReport((Object)intentionAction);
            if (ALLOW_LIST.contains(fixClass.getSimpleName())) {
                return true;
            }
            if (!fixClass.getPackageName().startsWith("com.jetbrains.php.lang")) {
                return true;
            }
            return BladePhpQuickFixesFilter.isInsidePhpDirectiveOrFragment(file.findElementAt(offset));
        }
        if (intentionAction instanceof CleanupAllIntention) {
            return false;
        }
        IntentionActionWrapper intentionWrapper = (IntentionActionWrapper)ObjectUtils.tryCast((Object)intentionAction, IntentionActionWrapper.class);
        if (intentionWrapper != null) {
            return !intentionWrapper.getImplementationClassName().startsWith("com.jetbrains.php.lang");
        }
        return true;
    }

    private static boolean isInsidePhpDirectiveOrFragment(@Nullable PsiElement startElement) {
        if (startElement == null) {
            return false;
        }
        PsiElement bladeElement = BladePhpQuickFixesFilter.getBladeElement(startElement);
        if (bladeElement == null) {
            return false;
        }
        return BladeTokenTypes.PHP_DIRECTIVE_CONTENT == PsiUtilCore.getElementType((PsiElement)bladeElement) || BladeElementTypes.PHP_FRAGMENT == PsiUtilCore.getElementType((PsiElement)bladeElement.getParent());
    }

    @Nullable
    static PsiElement getBladeElement(@NotNull PsiElement startElement) {
        if (startElement == null) {
            BladePhpQuickFixesFilter.$$$reportNull$$$0(1);
        }
        InjectedLanguageManager injectionManager = InjectedLanguageManager.getInstance((Project)startElement.getProject());
        TextRange hostRange = injectionManager.injectedToHost(startElement, startElement.getTextRange());
        PsiFile topLevelFile = injectionManager.getTopLevelFile(startElement);
        return topLevelFile.getViewProvider().findElementAt(hostRange.getStartOffset(), BladeLanguage.INSTANCE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "intentionAction";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/blade/inspections/filter/BladePhpQuickFixesFilter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "accept";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getBladeElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

