/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.blade.lang;

import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegateAdapter;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.php.blade.parser.BladeDirectiveStructureData;
import com.jetbrains.php.blade.psi.BladeDirectiveElementType;
import com.jetbrains.php.blade.psi.BladeFileImpl;
import com.jetbrains.php.blade.psi.BladeTokenTypes;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public final class BladeEnterBetweenDirectives
extends EnterHandlerDelegateAdapter {
    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file, @NotNull Editor editor, @NotNull Ref<Integer> caretOffset, @NotNull Ref<Integer> caretAdvance, @NotNull DataContext dataContext, EditorActionHandler originalHandler) {
        if (file == null) {
            BladeEnterBetweenDirectives.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            BladeEnterBetweenDirectives.$$$reportNull$$$0(1);
        }
        if (caretOffset == null) {
            BladeEnterBetweenDirectives.$$$reportNull$$$0(2);
        }
        if (caretAdvance == null) {
            BladeEnterBetweenDirectives.$$$reportNull$$$0(3);
        }
        if (dataContext == null) {
            BladeEnterBetweenDirectives.$$$reportNull$$$0(4);
        }
        if (BladeEnterBetweenDirectives.isBladeFile(file) && BladeEnterBetweenDirectives.isBetweenDirectiveTags(editor, (Integer)caretOffset.get())) {
            Editor hostEditor = editor instanceof EditorWindow ? ((EditorWindow)editor).getDelegate() : editor;
            originalHandler.execute(hostEditor, hostEditor.getCaretModel().getCurrentCaret(), dataContext);
            return EnterHandlerDelegate.Result.DefaultForceIndent;
        }
        return EnterHandlerDelegate.Result.Continue;
    }

    private static boolean isBladeFile(@NotNull PsiFile file) {
        if (file == null) {
            BladeEnterBetweenDirectives.$$$reportNull$$$0(5);
        }
        return file instanceof BladeFileImpl || InjectedLanguageManager.getInstance((Project)file.getProject()).getTopLevelFile((PsiElement)file) instanceof BladeFileImpl;
    }

    private static boolean isBetweenDirectiveTags(Editor editor, int offset) {
        CharSequence content;
        EditorHighlighter highlighter;
        HighlighterIterator iterator;
        int retrieveCount;
        if (offset == 0) {
            return false;
        }
        Project project = editor.getProject();
        if (project == null) {
            return false;
        }
        if (editor instanceof EditorWindow) {
            editor = ((EditorWindow)editor).getDelegate();
            offset = editor.getCaretModel().getOffset();
        }
        if ((retrieveCount = BladeEnterBetweenDirectives.retreatToBladeDirective(iterator = (highlighter = editor.getHighlighter()).createIterator(offset))) == -1 || iterator.atEnd()) {
            return false;
        }
        BladeDirectiveElementType directive = (BladeDirectiveElementType)iterator.getTokenType();
        Collection closingDirectives = BladeDirectiveStructureData.CLOSING_DIRECTIVES.get((Object)directive);
        if (closingDirectives.isEmpty()) {
            return false;
        }
        for (int i = 0; i < retrieveCount; ++i) {
            iterator.advance();
        }
        int whitespaceStart = offset;
        int whitespaceEnd = -1;
        while (!iterator.atEnd() && !closingDirectives.contains(iterator.getTokenType())) {
            if (BladeEnterBetweenDirectives.isMultiline(iterator)) {
                return false;
            }
            if (!TokenSet.WHITE_SPACE.contains(iterator.getTokenType())) {
                return false;
            }
            whitespaceEnd = iterator.getEnd();
            iterator.advance();
        }
        if (iterator.atEnd()) {
            return false;
        }
        if (offset < iterator.getStart() && BladeEnterBetweenDirectives.isMultiline(content = editor.getDocument().getCharsSequence().subSequence(offset, iterator.getStart()))) {
            return false;
        }
        if (whitespaceEnd > whitespaceStart) {
            editor.getDocument().deleteString(whitespaceStart, whitespaceEnd);
        }
        return true;
    }

    private static boolean isMultiline(CharSequence chars) {
        return chars.chars().anyMatch(c -> c == 10);
    }

    private static int retreatToBladeDirective(HighlighterIterator iterator) {
        iterator.retreat();
        int retrieveCount = 1;
        boolean isParametrized = false;
        while (!iterator.atEnd() && !(iterator.getTokenType() instanceof BladeDirectiveElementType)) {
            if (BladeTokenTypes.DIRECTIVE_RBRACE.equals(iterator.getTokenType())) {
                isParametrized = true;
            }
            if (!isParametrized && BladeEnterBetweenDirectives.isMultiline(iterator)) {
                return -1;
            }
            if (isParametrized || TokenSet.WHITE_SPACE.contains(iterator.getTokenType()) || BladeTokenTypes.DIRECTIVE_LBRACE.equals(iterator.getTokenType()) || BladeTokenTypes.DIRECTIVE_PARAMETER_CONTENT.equals(iterator.getTokenType())) {
                iterator.retreat();
                ++retrieveCount;
                continue;
            }
            return -1;
        }
        return retrieveCount;
    }

    private static boolean isMultiline(HighlighterIterator iterator) {
        return BladeEnterBetweenDirectives.isMultiline(iterator.getDocument().getCharsSequence().subSequence(iterator.getStart(), iterator.getEnd()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caretOffset";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caretAdvance";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/blade/lang/BladeEnterBetweenDirectives";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "preprocessEnter";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isBladeFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

