/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.blade.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.php.blade.injection.BladeInjectionInfo;
import com.jetbrains.php.blade.injection.BladeInjectionMappingService;
import com.jetbrains.php.blade.parser.BladeCompositeElement;
import com.jetbrains.php.blade.parser.BladeDirectiveStructureData;
import com.jetbrains.php.blade.parser.BladeElementTypes;
import com.jetbrains.php.blade.psi.BladeClosingDirectivePsiImpl;
import com.jetbrains.php.blade.psi.BladeDirectiveParameterPsiImpl;
import com.jetbrains.php.blade.psi.BladeDirectivePsiImpl;
import com.jetbrains.php.blade.psi.BladeInjectableTextImpl;
import com.jetbrains.php.blade.psi.BladePhpBlockPsiImpl;
import com.jetbrains.php.blade.psi.BladePsiLanguageInjectionHost;
import com.jetbrains.php.blade.psi.BladeTranslatableElement;

public final class BladePsiElementCreator {
    public static PsiElement create(ASTNode node) {
        IElementType type = node.getElementType();
        if (BladeElementTypes.DIRECTIVE == type) {
            if (BladeDirectiveStructureData.CLOSING_DIRECTIVES.values().contains(node.getFirstChildNode().getElementType())) {
                return new BladeClosingDirectivePsiImpl(node);
            }
            return new BladeDirectivePsiImpl(node);
        }
        if (BladeElementTypes.DIRECTIVE_PARAMETER == type) {
            return new BladeDirectiveParameterPsiImpl(node);
        }
        if (BladeElementTypes.PHP_DIRECTIVE_BLOCK == type) {
            return new BladePhpBlockPsiImpl(node);
        }
        if (BladeElementTypes.INJECTABLE_TEMPLATE_HTML == type) {
            return new BladeInjectableTextImpl(node);
        }
        if (BladeElementTypes.INJECTION_HOST == type) {
            return new BladePsiLanguageInjectionHost(node);
        }
        BladeInjectionInfo info = BladeInjectionMappingService.getNonDirectiveInfo(type);
        if (info != null) {
            return new BladeTranslatableElement(node);
        }
        return new BladeCompositeElement(node);
    }
}

