/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.symfony.asset.mapper;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.symfony.asset.mapper.SymfonyAssetMapperManager;
import com.intellij.symfony.liveTemplates.SymfonyLiveTemplateComposerConfigClientKt;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0002\u001a\u0016\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0001\u001a\u0018\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0001\u001a\u001a\u0010\u000b\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0001H\u0002\u001a\u001a\u0010\f\u001a\u0004\u0018\u00010\b2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u0001H\u0002\u001a.\u0010\u000e\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00012\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00110\u0010H\u0002\u001a\u000e\u0010\u0012\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"SYMFONY_WITH_ASSERT_MAPPER_VERSION", "", "isModuleResolved", "", "project", "Lcom/intellij/openapi/project/Project;", "moduleName", "resolveModule", "Lcom/intellij/openapi/vfs/VirtualFile;", "host", "Lcom/intellij/psi/PsiElement;", "tryToResolveInVendorDir", "tryToResolveByExtension", "dir", "tryToResolveByPath", "moduleInfo", "", "", "isSymfonyAssetMapperUsed", "intellij.symfony"})
@SourceDebugExtension(value={"SMAP\nSymfonyAssetMapperReferenceContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SymfonyAssetMapperReferenceContributor.kt\ncom/intellij/symfony/asset/mapper/SymfonyAssetMapperReferenceContributorKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,81:1\n1#2:82\n*E\n"})
public final class SymfonyAssetMapperReferenceContributorKt {
    @NotNull
    public static final String SYMFONY_WITH_ASSERT_MAPPER_VERSION = "6.2.9";

    public static final boolean isModuleResolved(@NotNull Project project, @NotNull String moduleName) {
        VirtualFile module;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        Map<String, Map<String, Object>> modules = SymfonyAssetMapperManager.Companion.getInstance(project).getModules();
        Map<String, Object> map = modules.get(moduleName);
        if (map == null) {
            return false;
        }
        Map<String, Object> moduleInfo = map;
        if (moduleInfo.get("url") != null) {
            return true;
        }
        VirtualFile virtualFile = SymfonyAssetMapperReferenceContributorKt.tryToResolveByPath(project, moduleName, moduleInfo);
        if (virtualFile == null) {
            virtualFile = SymfonyAssetMapperReferenceContributorKt.tryToResolveInVendorDir(project, moduleName);
        }
        return (module = virtualFile) != null;
    }

    @Nullable
    public static final VirtualFile resolveModule(@NotNull PsiElement host, @NotNull String moduleName) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        Project project = host.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        Map<String, Map<String, Object>> modules = SymfonyAssetMapperManager.Companion.getInstance(project2).getModules();
        Map<String, Object> map = modules.get(moduleName);
        if (map == null) {
            return null;
        }
        Map<String, Object> moduleInfo = map;
        VirtualFile virtualFile = SymfonyAssetMapperReferenceContributorKt.tryToResolveByPath(project2, moduleName, moduleInfo);
        if (virtualFile == null && (virtualFile = SymfonyAssetMapperReferenceContributorKt.tryToResolveInVendorDir(project2, moduleName)) == null) {
            virtualFile = SymfonyAssetMapperManager.Companion.tryToResolveByExternalUrl((String)moduleInfo.get("url"));
        }
        return virtualFile;
    }

    private static final VirtualFile tryToResolveInVendorDir(Project project, String moduleName) {
        VirtualFile virtualFile = SymfonyAssetMapperManager.Companion.getInstance(project).getAssetsVendorDir();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile assetsVendorDir = virtualFile;
        VirtualFile virtualFile2 = assetsVendorDir.findFileByRelativePath(moduleName);
        if (virtualFile2 == null && (virtualFile2 = SymfonyAssetMapperReferenceContributorKt.tryToResolveByExtension(assetsVendorDir, moduleName)) == null) {
            return null;
        }
        VirtualFile file = virtualFile2;
        if (!file.isDirectory()) {
            return file;
        }
        return SymfonyAssetMapperReferenceContributorKt.tryToResolveByExtension(file, StringsKt.substringAfterLast$default((String)moduleName, (char)'/', null, (int)2, null));
    }

    private static final VirtualFile tryToResolveByExtension(VirtualFile dir, String moduleName) {
        Object[] objectArray = new String[]{".index.js", ".js", ".css"};
        for (String ext : CollectionsKt.listOf((Object[])objectArray)) {
            VirtualFile virtualFile = dir.findFileByRelativePath(moduleName + ext);
            if (virtualFile == null) continue;
            VirtualFile it = virtualFile;
            boolean bl = false;
            return it;
        }
        return null;
    }

    private static final VirtualFile tryToResolveByPath(Project project, String moduleName, Map<String, ? extends Object> moduleInfo) {
        VirtualFile virtualFile = SymfonyAssetMapperManager.Companion.getInstance(project).getRoot();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile root = virtualFile;
        String string = (String)moduleInfo.get("path");
        if (string == null && (string = (String)moduleInfo.get("downloaded_to")) == null && (string = (String)moduleInfo.get("package_specifier")) == null) {
            return null;
        }
        String path = string;
        VirtualFile virtualFile2 = root.findFileByRelativePath(path);
        if (virtualFile2 == null && (virtualFile2 = root.findFileByRelativePath("assets/" + path)) == null && (virtualFile2 = root.findFileByRelativePath("assets/vendor/" + path)) == null) {
            char[] cArray = new char[]{'@'};
            virtualFile2 = root.findFileByRelativePath("vendor/" + StringsKt.trimStart((String)moduleName, (char[])cArray) + "/assets/dist/" + StringsKt.substringAfterLast$default((String)path, (char)'/', null, (int)2, null));
        }
        return virtualFile2;
    }

    public static final boolean isSymfonyAssetMapperUsed(@NotNull PsiElement host) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Project project = host.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        return SymfonyAssetMapperManager.Companion.getInstance(project2).getImportMap() != null && SymfonyLiveTemplateComposerConfigClientKt.isSymfonyInstalled(project2, SYMFONY_WITH_ASSERT_MAPPER_VERSION);
    }
}

