/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.symfony.inspections;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.inspections.PhpAnnotationToAttributeInspection;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0006H\u0014J\b\u0010\u000f\u001a\u00020\u0006H\u0014J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u0006H\u0016J\u0010\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0006H\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/symfony/inspections/PhpSymfonyAnnotationToAttributeInspection;", "Lcom/jetbrains/php/lang/inspections/PhpAnnotationToAttributeInspection;", "<init>", "()V", "SYMFONY_CONSTRAINTS_ATTRIBUTES", "", "", "SYMFONY_SERIALIZER_ATTRIBUTES", "SYMFONY_ATTRIBUTES", "checkToolVersion", "", "project", "Lcom/intellij/openapi/project/Project;", "getAttributeFqn", "attributeName", "getFrameworkName", "getHighlightedRange", "Lcom/intellij/openapi/util/TextRange;", "tag", "Lcom/jetbrains/php/lang/documentation/phpdoc/psi/tags/PhpDocTag;", "createAttributeText", "getAlias", "intellij.symfony"})
public final class PhpSymfonyAnnotationToAttributeInspection
extends PhpAnnotationToAttributeInspection {
    @NotNull
    private final Set<String> SYMFONY_CONSTRAINTS_ATTRIBUTES;
    @NotNull
    private final Set<String> SYMFONY_SERIALIZER_ATTRIBUTES;
    @NotNull
    private final Set<String> SYMFONY_ATTRIBUTES;

    /*
     * WARNING - void declaration
     */
    public PhpSymfonyAnnotationToAttributeInspection() {
        void $this$SYMFONY_ATTRIBUTES_u24lambda_u240;
        Object object = new String[]{"Bic", "Blank", "Callback", "CardScheme", "Cascade", "Choice", "Count", "Country", "Currency", "Date", "DateTime", "DisableAutoMapping", "DivisibleBy", "Email", "EnableAutoMapping", "EqualTo", "Expression", "ExpressionLanguageSyntax", "File", "GreaterThan", "GreaterThanOrEqual", "GroupSequence", "GroupSequenceProvider", "Hostname", "Iban", "IdenticalTo", "Image", "Ip", "Isbn", "IsFalse", "Isin", "IsNull", "Issn", "IsTrue", "Json", "Language", "Length", "LessThan", "LessThanOrEqual", "Locale", "Luhn", "Negative", "NegativeOrZero", "NotBlank", "NotCompromisedPassword", "NotEqualTo", "NotIdenticalTo", "NotNull", "Positive", "PositiveOrZero", "Range", "Regex", "Time", "Timezone", "Traverse", "Type", "Ulid", "Unique", "Url", "Uuid", "Valid"};
        this.SYMFONY_CONSTRAINTS_ATTRIBUTES = SetsKt.setOf((Object[])object);
        object = new String[]{"DiscriminatorMap", "Groups", "Ignore", "MaxDepth", "SerializedName"};
        this.SYMFONY_SERIALIZER_ATTRIBUTES = SetsKt.setOf((Object[])object);
        Object object2 = object = SetsKt.createSetBuilder();
        PhpSymfonyAnnotationToAttributeInspection phpSymfonyAnnotationToAttributeInspection = this;
        boolean bl = false;
        $this$SYMFONY_ATTRIBUTES_u24lambda_u240.addAll((Collection)this.SYMFONY_CONSTRAINTS_ATTRIBUTES);
        $this$SYMFONY_ATTRIBUTES_u24lambda_u240.addAll((Collection)this.SYMFONY_SERIALIZER_ATTRIBUTES);
        $this$SYMFONY_ATTRIBUTES_u24lambda_u240.add("Required");
        $this$SYMFONY_ATTRIBUTES_u24lambda_u240.add("Route");
        $this$SYMFONY_ATTRIBUTES_u24lambda_u240.add("UniqueEntity");
        phpSymfonyAnnotationToAttributeInspection.SYMFONY_ATTRIBUTES = SetsKt.build((Set)object);
    }

    @Override
    protected boolean checkToolVersion(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return !PhpIndex.getInstance(project).getAnyByFQN("Symfony\\Contracts\\Service\\Attribute\\Required").isEmpty();
    }

    @Override
    @NotNull
    protected String getAttributeFqn(@NotNull String attributeName) {
        Intrinsics.checkNotNullParameter((Object)attributeName, (String)"attributeName");
        if (this.SYMFONY_CONSTRAINTS_ATTRIBUTES.contains(attributeName)) {
            return "Symfony\\Component\\Validator\\Constraints\\";
        }
        if (this.SYMFONY_SERIALIZER_ATTRIBUTES.contains(attributeName)) {
            return "Symfony\\Component\\Serializer\\Annotation\\";
        }
        if (Intrinsics.areEqual((Object)attributeName, (Object)"Required")) {
            return "Symfony\\Contracts\\Service\\Attribute\\";
        }
        if (Intrinsics.areEqual((Object)attributeName, (Object)"Route")) {
            return "Symfony\\Component\\Routing\\Annotation\\";
        }
        if (Intrinsics.areEqual((Object)attributeName, (Object)"UniqueEntity")) {
            return "Symfony\\Bridge\\Doctrine\\Validator\\Constraints\\";
        }
        return "Symfony\\Component\\Validator\\Constraints\\";
    }

    @Override
    @NotNull
    protected String getFrameworkName() {
        return "Symfony";
    }

    @Override
    @NotNull
    public TextRange getHighlightedRange(@NotNull PhpDocTag tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        TextRange textRange = tag.getFirstChild().getTextRangeInParent();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRangeInParent(...)");
        return textRange;
    }

    @Override
    @Nullable
    public String createAttributeText(@NotNull PhpDocTag tag, @NotNull String attributeName) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)attributeName, (String)"attributeName");
        if (!this.SYMFONY_ATTRIBUTES.contains(attributeName)) {
            return null;
        }
        return super.createAttributeText(tag, attributeName);
    }

    @Override
    @NotNull
    public String getAlias(@NotNull String attributeName) {
        Intrinsics.checkNotNullParameter((Object)attributeName, (String)"attributeName");
        if (this.SYMFONY_CONSTRAINTS_ATTRIBUTES.contains(attributeName)) {
            return "Assert";
        }
        return super.getAlias(attributeName);
    }
}

