/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.clones.languagescope;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.LighterASTTokenNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.clones.languagescope.PhpExtractDuplicatedMethodQuickFix;
import com.jetbrains.clones.languagescope.common.CommonDuplicateScope;
import com.jetbrains.clones.structures.TextClone;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.parser.PhpStubElementTypes;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0018\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001fH\u0016J\u0018\u0010 \u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\u001dH\u0016J\u0018\u0010\"\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0018\u0010#\u001a\u00020$2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u001e\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0016J\u001a\u0010,\u001a\u00070\t\u00a2\u0006\u0002\b\n*\u00020\t2\u0006\u0010-\u001a\u00020\tH\u0082\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R \u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR \u0010\u000f\u001a\u00070\t\u00a2\u0006\u0002\b\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u000e\u001a\u0004\b\u0010\u0010\fR \u0010\u0012\u001a\u00070\t\u00a2\u0006\u0002\b\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u000e\u001a\u0004\b\u0013\u0010\fR \u0010\u0015\u001a\u00070\t\u00a2\u0006\u0002\b\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u000e\u001a\u0004\b\u0016\u0010\f\u00a8\u0006."}, d2={"Lcom/jetbrains/clones/languagescope/PhpDuplicateScope;", "Lcom/jetbrains/clones/languagescope/common/CommonDuplicateScope;", "<init>", "()V", "languageName", "", "getLanguageName", "()Ljava/lang/String;", "noiseNodes", "Lcom/intellij/psi/tree/TokenSet;", "Lorg/jetbrains/annotations/NotNull;", "getNoiseNodes", "()Lcom/intellij/psi/tree/TokenSet;", "noiseNodes$delegate", "Lkotlin/Lazy;", "ignoredNodes", "getIgnoredNodes", "ignoredNodes$delegate", "literals", "getLiterals", "literals$delegate", "methodsAndFields", "getMethodsAndFields", "methodsAndFields$delegate", "isNoise", "", "ast", "Lcom/intellij/lang/LighterAST;", "node", "Lcom/intellij/lang/LighterASTNode;", "isAnonymized", "Lcom/intellij/lang/LighterASTTokenNode;", "shouldAnalyzeChildSubsequences", "parent", "isIgnoredAsDuplicate", "weightOf", "", "createQuickFixes", "", "Lcom/intellij/codeInspection/LocalQuickFix;", "project", "Lcom/intellij/openapi/project/Project;", "textClone", "Lcom/jetbrains/clones/structures/TextClone;", "plus", "other", "intellij.php.duplicatesDetection"})
public final class PhpDuplicateScope
extends CommonDuplicateScope {
    @NotNull
    private final String languageName;
    @NotNull
    private final Lazy noiseNodes$delegate = LazyKt.lazy(() -> PhpDuplicateScope.noiseNodes_delegate$lambda$0(this));
    @NotNull
    private final Lazy ignoredNodes$delegate = LazyKt.lazy(() -> PhpDuplicateScope.ignoredNodes_delegate$lambda$1(this));
    @NotNull
    private final Lazy literals$delegate = LazyKt.lazy(() -> PhpDuplicateScope.literals_delegate$lambda$2(this));
    @NotNull
    private final Lazy methodsAndFields$delegate = LazyKt.lazy(PhpDuplicateScope::methodsAndFields_delegate$lambda$3);

    public PhpDuplicateScope() {
        this.languageName = "PHP";
    }

    @NotNull
    public String getLanguageName() {
        return this.languageName;
    }

    private final TokenSet getNoiseNodes() {
        Lazy lazy = this.noiseNodes$delegate;
        return (TokenSet)lazy.getValue();
    }

    private final TokenSet getIgnoredNodes() {
        Lazy lazy = this.ignoredNodes$delegate;
        return (TokenSet)lazy.getValue();
    }

    private final TokenSet getLiterals() {
        Lazy lazy = this.literals$delegate;
        return (TokenSet)lazy.getValue();
    }

    private final TokenSet getMethodsAndFields() {
        Lazy lazy = this.methodsAndFields$delegate;
        return (TokenSet)lazy.getValue();
    }

    public boolean isNoise(@NotNull LighterAST ast, @NotNull LighterASTNode node) {
        Intrinsics.checkNotNullParameter((Object)ast, (String)"ast");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return this.getNoiseNodes().contains(node.getTokenType());
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean isAnonymized(@NotNull LighterAST ast, @NotNull LighterASTTokenNode node) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)ast, (String)"ast");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        LighterASTNode parent = ast.getParent((LighterASTNode)node);
        if (this.getLiterals().contains(node.getTokenType())) {
            bl = this.getIndexConfiguration().getAnonymizeLiterals();
            return bl;
        }
        if (Intrinsics.areEqual((Object)node.getTokenType(), (Object)PhpTokenTypes.VARIABLE)) {
            bl = this.getIndexConfiguration().getAnonymizeIdentifiers();
            return bl;
        }
        if (Intrinsics.areEqual((Object)node.getTokenType(), (Object)PhpTokenTypes.IDENTIFIER)) {
            LighterASTNode lighterASTNode = parent;
            if (this.getMethodsAndFields().contains((IElementType)(lighterASTNode != null ? lighterASTNode.getTokenType() : null))) {
                bl = this.getIndexConfiguration().getAnonymizeFunctions();
                return bl;
            }
        }
        if (!Intrinsics.areEqual((Object)node.getTokenType(), (Object)PhpTokenTypes.IDENTIFIER)) return true;
        LighterASTNode lighterASTNode = parent;
        if (!Intrinsics.areEqual((Object)(lighterASTNode != null ? lighterASTNode.getTokenType() : null), (Object)PhpElementTypes.CLASS_REFERENCE)) return true;
        return false;
    }

    public boolean shouldAnalyzeChildSubsequences(@NotNull LighterAST ast, @NotNull LighterASTNode parent) {
        Intrinsics.checkNotNullParameter((Object)ast, (String)"ast");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        return PhpElementTypes.ANY_GROUP_STATEMENT.contains(parent.getTokenType());
    }

    public boolean isIgnoredAsDuplicate(@NotNull LighterAST ast, @NotNull LighterASTNode node) {
        Intrinsics.checkNotNullParameter((Object)ast, (String)"ast");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return this.getIgnoredNodes().contains(node.getTokenType());
    }

    public int weightOf(@NotNull LighterAST ast, @NotNull LighterASTNode node) {
        Intrinsics.checkNotNullParameter((Object)ast, (String)"ast");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        IElementType iElementType = node.getTokenType();
        return PhpElementTypes.STATEMENTS.contains(iElementType) ? 2 : (PhpElementTypes.tsEXPRESSIONS.contains(iElementType) ? 1 : 0);
    }

    @NotNull
    public List<LocalQuickFix> createQuickFixes(@NotNull Project project, @NotNull TextClone textClone) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)textClone, (String)"textClone");
        return CollectionsKt.plus((Collection)super.createQuickFixes(project, textClone), (Iterable)CollectionsKt.listOfNotNull((Object)PhpExtractDuplicatedMethodQuickFix.Companion.createFix(project, textClone)));
    }

    private final TokenSet plus(TokenSet $this$plus, TokenSet other) {
        Intrinsics.checkNotNullParameter((Object)$this$plus, (String)"<this>");
        TokenSet[] tokenSetArray = new TokenSet[]{$this$plus, other};
        TokenSet tokenSet = TokenSet.orSet((TokenSet[])tokenSetArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"orSet(...)");
        return tokenSet;
    }

    private static final TokenSet noiseNodes_delegate$lambda$0(PhpDuplicateScope this$0) {
        IElementType[] iElementTypeArray = new IElementType[]{PhpTokenTypes.WHITE_SPACE, PhpTokenTypes.PHP_CLOSING_TAG};
        TokenSet tokenSet = TokenSet.create((IElementType[])iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"create(...)");
        TokenSet tokenSet2 = PhpElementTypes.tsCOMMENTS;
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet2, (String)"tsCOMMENTS");
        TokenSet tokenSet3 = this$0.plus(tokenSet, tokenSet2);
        TokenSet tokenSet4 = TokenSet.WHITE_SPACE;
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet4, (String)"WHITE_SPACE");
        TokenSet tokenSet5 = this$0.plus(tokenSet3, tokenSet4);
        TokenSet tokenSet6 = PhpTokenTypes.tsBRACES;
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet6, (String)"tsBRACES");
        TokenSet tokenSet7 = this$0.plus(tokenSet5, tokenSet6);
        TokenSet tokenSet8 = PhpTokenTypes.tsPHP_OPENING_TAGS;
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet8, (String)"tsPHP_OPENING_TAGS");
        return this$0.plus(tokenSet7, tokenSet8);
    }

    private static final TokenSet ignoredNodes_delegate$lambda$1(PhpDuplicateScope this$0) {
        IElementType[] iElementTypeArray = new IElementType[]{PhpElementTypes.CASE, PhpElementTypes.CASE_DEFAULT, PhpElementTypes.CATCH, PhpElementTypes.ELSE, PhpElementTypes.FINALLY, PhpStubElementTypes.CLASS, PhpStubElementTypes.CLASS_METHOD};
        TokenSet tokenSet = TokenSet.create((IElementType[])iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"create(...)");
        TokenSet tokenSet2 = PhpElementTypes.ANY_GROUP_STATEMENT;
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet2, (String)"ANY_GROUP_STATEMENT");
        return this$0.plus(tokenSet, tokenSet2);
    }

    private static final TokenSet literals_delegate$lambda$2(PhpDuplicateScope this$0) {
        TokenSet tokenSet = PhpTokenTypes.tsSTRINGS;
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"tsSTRINGS");
        TokenSet tokenSet2 = PhpTokenTypes.tsNUMBERS;
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet2, (String)"tsNUMBERS");
        return this$0.plus(tokenSet, tokenSet2);
    }

    private static final TokenSet methodsAndFields_delegate$lambda$3() {
        IElementType[] iElementTypeArray = new IElementType[]{PhpElementTypes.METHOD_REFERENCE, PhpElementTypes.FIELD_REFERENCE, PhpElementTypes.FUNCTION_CALL};
        return TokenSet.create((IElementType[])iElementTypeArray);
    }
}

