/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIcons;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.PhpParameterInfoHandler;
import com.jetbrains.php.lang.documentation.phpdoc.PhpDocUtil;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpPresentationUtil {
    @NotNull
    public static final String FILE_SEPARATOR = "/";
    public static final char FILE_SEPARATOR_CHAR = '/';

    private PhpPresentationUtil() {
    }

    public static ItemPresentation getPresentation(@NotNull PhpNamedElement element) {
        if (element == null) {
            PhpPresentationUtil.$$$reportNull$$$0(0);
        }
        String location = PhpPresentationUtil.getPresentablePathForFile(element.getContainingFile().getVirtualFile(), element.getProject());
        return new PresentationData(element.getName(), location, element.getIcon(), null);
    }

    private static String getPresentablePathForClass(@Nullable PhpClass klass) {
        String[] fileNames;
        if (klass == null) {
            return "?";
        }
        PsiFile psiFile = klass.getContainingFile();
        if (psiFile == null) {
            return "?";
        }
        VirtualFile classRoot = psiFile.getVirtualFile();
        for (String fileName : fileNames = (String[])ArrayUtil.reverseArray((Object[])klass.getName().split("_"))) {
            if (!fileName.equals(classRoot.getNameWithoutExtension()) || (classRoot = classRoot.getParent()) == null) break;
        }
        return PhpPresentationUtil.getPresentablePathForFile(classRoot, klass.getProject());
    }

    public static String getPresentablePathForFile(@Nullable VirtualFile file, Project project) {
        if (file == null) {
            return "";
        }
        ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)project);
        ProjectFileIndex fileIndex = projectRootManager.getFileIndex();
        VirtualFile contentRoot = fileIndex.getContentRootForFile(file);
        if (contentRoot != null) {
            String relativePath = VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)contentRoot, (char)'/');
            StringBuilder pathPresentationBuilder = new StringBuilder();
            pathPresentationBuilder.append("...").append(FILE_SEPARATOR);
            if (projectRootManager.getContentRoots().length > 1) {
                pathPresentationBuilder.append(contentRoot.getName()).append(FILE_SEPARATOR);
            }
            pathPresentationBuilder.append(relativePath);
            return pathPresentationBuilder.toString();
        }
        VirtualFile[] roots = projectRootManager.getContentRoots();
        String location = "";
        for (VirtualFile root : roots) {
            if (!file.getUrl().startsWith(root.getUrl())) continue;
            location = VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)root, (char)File.separatorChar);
        }
        if (location != null && location.isEmpty()) {
            location = file.getCanonicalPath();
        }
        return location == null ? ".../" : location;
    }

    public static ItemPresentation getClassPresentation(@NotNull PhpClass klass) {
        if (klass == null) {
            PhpPresentationUtil.$$$reportNull$$$0(1);
        }
        String location = PhpPresentationUtil.getPresentablePathForClass(klass);
        return new PresentationData(klass.getName() + "   " + StringUtil.trimEnd((String)klass.getNamespaceName(), (String)"\\"), location, klass.getIcon(), null);
    }

    public static ItemPresentation getDirectoryPresentation(PsiDirectory directory) {
        String pathForFile = PhpPresentationUtil.getPresentablePathForFile(directory.getVirtualFile(), directory.getProject());
        return new PresentationData(directory.getName(), pathForFile, PlatformIcons.FOLDER_ICON, null);
    }

    public static ItemPresentation getVarPresentation(@NotNull Variable variable) {
        if (variable == null) {
            PhpPresentationUtil.$$$reportNull$$$0(2);
        }
        return PhpPresentationUtil.getPresentation(variable);
    }

    public static ItemPresentation getMethodPresentation(@NotNull Method method) {
        PhpClass parent;
        if (method == null) {
            PhpPresentationUtil.$$$reportNull$$$0(3);
        }
        String location = ((parent = method.getContainingClass()) != null ? parent.getName() : "?") + " " + PhpPresentationUtil.getPresentablePathForClass(parent);
        return new PresentationData(method.getName(), location, method.getIcon(), null);
    }

    public static ItemPresentation getFieldPresentation(@NotNull Field field) {
        PhpClass parent;
        if (field == null) {
            PhpPresentationUtil.$$$reportNull$$$0(4);
        }
        String location = ((parent = field.getContainingClass()) != null ? parent.getName() : "?") + " " + PhpPresentationUtil.getPresentablePathForClass(parent);
        return new PresentationData(field.getName(), location, field.getIcon(), null);
    }

    public static ItemPresentation getFunctionPresentation(@NotNull Function function) {
        if (function == null) {
            PhpPresentationUtil.$$$reportNull$$$0(5);
        }
        return PhpPresentationUtil.getPresentation(function);
    }

    public static ItemPresentation getConstantPresentation(@NotNull Constant constant) {
        if (constant == null) {
            PhpPresentationUtil.$$$reportNull$$$0(6);
        }
        return PhpPresentationUtil.getPresentation(constant);
    }

    public static PresentationData getFilePresentation(@NotNull PhpFile phpFile) {
        if (phpFile == null) {
            PhpPresentationUtil.$$$reportNull$$$0(7);
        }
        VirtualFile virtualFile = phpFile.getVirtualFile();
        assert (virtualFile != null);
        String location = PhpPresentationUtil.getPresentablePathForFile(virtualFile, phpFile.getProject());
        return new PresentationData(phpFile.getName(), location, phpFile.getIcon(0), null);
    }

    public static PresentationData getNamespacePresentation(@NotNull PhpNamespace phpNamespace) {
        if (phpNamespace == null) {
            PhpPresentationUtil.$$$reportNull$$$0(8);
        }
        String location = PhpPresentationUtil.getPresentablePathForFile(phpNamespace.getContainingFile().getVirtualFile(), phpNamespace.getProject());
        String fqn = phpNamespace.getFQN();
        String presentableText = "\\".equals(fqn) ? fqn : PhpLangUtil.toPresentableFQN(fqn);
        return new PresentationData(presentableText, location, phpNamespace.getIcon(), null);
    }

    public static Icon getAccessIcon(PhpModifier.Access modifier) {
        if (modifier == PhpModifier.Access.PRIVATE) {
            return PhpIcons.PRIVATE;
        }
        if (modifier == PhpModifier.Access.PROTECTED) {
            return PhpIcons.PROTECTED;
        }
        return PhpIcons.PUBLIC;
    }

    @NotNull
    public static String getParameterPresentation(@NotNull Parameter p, @NotNull Collection<String> parameterTypes) {
        String attributes;
        if (p == null) {
            PhpPresentationUtil.$$$reportNull$$$0(9);
        }
        if (parameterTypes == null) {
            PhpPresentationUtil.$$$reportNull$$$0(10);
        }
        StringBuilder s = new StringBuilder();
        if (p.isOptional()) {
            s.append('[');
        }
        if (!(attributes = p.getAttributes().stream().filter(Predicate.not(PhpDocUtil::isInternalAtribute)).map(a -> a.getFQN()).filter(Objects::nonNull).map(fqn -> "#[" + PhpLangUtil.toShortName(fqn) + "]").distinct().collect(Collectors.joining(" "))).isEmpty()) {
            s.append(attributes);
            s.append(" ");
        }
        if (p.isPassByRef()) {
            s.append('&');
        }
        if (p.isVariadic()) {
            s.append("...");
        }
        s.append(p.getName());
        if (!parameterTypes.isEmpty()) {
            s.append(": ").append(String.join((CharSequence)"|", parameterTypes));
        }
        if (p.isOptional()) {
            String def = p.getDefaultValuePresentation();
            PhpPresentationUtil.appendDefaultValue(s, def);
            s.append(']');
        }
        String string = s.toString();
        if (string == null) {
            PhpPresentationUtil.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    public static Collection<String> getParameterTypesStrings(@NotNull Parameter p) {
        if (p == null) {
            PhpPresentationUtil.$$$reportNull$$$0(12);
        }
        if (DumbService.getInstance((Project)p.getProject()).isDumb()) {
            Collection<String> collection = p.getType().getSortedTypesStrings(null);
            if (collection == null) {
                PhpPresentationUtil.$$$reportNull$$$0(13);
            }
            return collection;
        }
        PhpType type = (PhpType)p.getUserData(PhpParameterInfoHandler.PARAM_TYPE_FROM_GIST);
        if (type == null) {
            type = p.getGlobalType();
        }
        if (type.isEmpty() || PhpType.NULL.equals(type) && !p.getDeclaredType().equals(PhpType.NULL)) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                PhpPresentationUtil.$$$reportNull$$$0(14);
            }
            return list;
        }
        Collection<String> collection = type.global(p.getProject()).getSortedTypesStrings(null);
        if (collection == null) {
            PhpPresentationUtil.$$$reportNull$$$0(15);
        }
        return collection;
    }

    public static void appendDefaultValue(@NotNull StringBuilder s, @Nullable String defaultValue) {
        if (s == null) {
            PhpPresentationUtil.$$$reportNull$$$0(16);
        }
        if (defaultValue != null) {
            s.append(" = ");
            s.append(defaultValue);
        }
    }

    public static String formatFunction(@NotNull Function function) {
        PhpType phpType;
        if (function == null) {
            PhpPresentationUtil.$$$reportNull$$$0(17);
        }
        StringBuilder b = new StringBuilder().append(function.isClosure() ? PhpBundle.message("lambda", new Object[0]) : function.getName());
        Parameter[] parameters = function.getParameters();
        PhpPresentationUtil.formatParameters(b, parameters, PhpPresentationUtil.parameterTypesWithShortenUniqueFqns(parameters));
        if (!(DumbService.isDumb((Project)function.getProject()) || (phpType = function.getLocalType(false).global(function.getProject())).isEmpty() || function instanceof Method && ((Method)function).getMethodType(true) == Method.MethodType.CONSTRUCTOR)) {
            b.append(": ");
            b.append(PhpPresentationUtil.joinShortenTypes(phpType, function.getNamespaceName()));
        }
        return b.toString();
    }

    @NotNull
    private static String joinShortenTypes(@NotNull PhpType phpType, String namespaceName) {
        if (phpType == null) {
            PhpPresentationUtil.$$$reportNull$$$0(18);
        }
        SmartList types = new SmartList(phpType.getSortedTypesStrings(namespaceName));
        Map<String, Long> frequency = PhpPresentationUtil.getShortNamesFrequency(Collections.singletonList(types));
        String string = String.join((CharSequence)"|", PhpPresentationUtil.shortenUniqueFqns(frequency, (Collection<String>)types));
        if (string == null) {
            PhpPresentationUtil.$$$reportNull$$$0(19);
        }
        return string;
    }

    public static void formatType(@NotNull StringBuilder builder2, @NotNull PhpNamedElement e) {
        PhpType phpType;
        if (builder2 == null) {
            PhpPresentationUtil.$$$reportNull$$$0(20);
        }
        if (e == null) {
            PhpPresentationUtil.$$$reportNull$$$0(21);
        }
        if (!(phpType = e.getType().filterUnknown()).isEmpty()) {
            builder2.append(": ");
            builder2.append(PhpPresentationUtil.joinShortenTypes(phpType, "\\"));
        }
    }

    @NotNull
    public static StringBuilder formatParameters(@Nullable StringBuilder b, Parameter @NotNull [] parameters) {
        if (parameters == null) {
            PhpPresentationUtil.$$$reportNull$$$0(22);
        }
        return PhpPresentationUtil.formatParameters(b, parameters, ContainerUtil.map((Object[])parameters, PhpPresentationUtil::getParameterTypesStrings));
    }

    @NotNull
    private static StringBuilder formatParameters(@Nullable StringBuilder b, Parameter @NotNull [] parameters, List<Collection<String>> parametersTypes) {
        if (parameters == null) {
            PhpPresentationUtil.$$$reportNull$$$0(23);
        }
        if (b == null) {
            b = new StringBuilder();
        }
        b.append('(');
        for (int i = 0; i < parameters.length; ++i) {
            b.append(PhpPresentationUtil.getParameterPresentation(parameters[i], parametersTypes.get(i)));
            if (parameters.length - i <= 1) continue;
            b.append(", ");
        }
        b.append(')');
        StringBuilder stringBuilder = b;
        if (stringBuilder == null) {
            PhpPresentationUtil.$$$reportNull$$$0(24);
        }
        return stringBuilder;
    }

    @NotNull
    public static List<Collection<String>> parameterTypesWithShortenUniqueFqns(Parameter @NotNull [] parameters) {
        if (parameters == null) {
            PhpPresentationUtil.$$$reportNull$$$0(25);
        }
        List parameterTypes = ContainerUtil.map((Object[])parameters, PhpPresentationUtil::getParameterTypesStrings);
        Map<String, Long> shortNamesFrequency = PhpPresentationUtil.getShortNamesFrequency(parameterTypes);
        List list = ContainerUtil.map((Collection)parameterTypes, types -> PhpPresentationUtil.shortenUniqueFqns(shortNamesFrequency, types));
        if (list == null) {
            PhpPresentationUtil.$$$reportNull$$$0(26);
        }
        return list;
    }

    private static Map<String, Long> getShortNamesFrequency(List<Collection<String>> parameterTypes) {
        return parameterTypes.stream().flatMap(Collection::stream).map(PhpLangUtil::toShortName).collect(Collectors.groupingBy(java.util.function.Function.identity(), Collectors.counting()));
    }

    @NotNull
    private static List<String> shortenUniqueFqns(Map<String, Long> shortNamesFrequencies, Collection<String> fqns) {
        List list = ContainerUtil.map(fqns, fqn -> shortNamesFrequencies.getOrDefault(PhpLangUtil.toShortName(fqn), 1L) > 1L ? fqn : PhpLangUtil.toShortName(fqn));
        if (list == null) {
            PhpPresentationUtil.$$$reportNull$$$0(27);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11, 13, 14, 15, 19, 24, 26, 27 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "klass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 5: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constant";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpFile";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpNamespace";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterTypes";
                break;
            }
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 19: 
            case 24: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/PhpPresentationUtil";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpType";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 22: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/PhpPresentationUtil";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterPresentation";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterTypesStrings";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "joinShortenTypes";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "formatParameters";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "parameterTypesWithShortenUniqueFqns";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "shortenUniqueFqns";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPresentation";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getClassPresentation";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getVarPresentation";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getMethodPresentation";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getFieldPresentation";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionPresentation";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getConstantPresentation";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getFilePresentation";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getNamespacePresentation";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getParameterPresentation";
                break;
            }
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 19: 
            case 24: 
            case 26: 
            case 27: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getParameterTypesStrings";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "appendDefaultValue";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "formatFunction";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "joinShortenTypes";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "formatType";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "formatParameters";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "parameterTypesWithShortenUniqueFqns";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 11, 13, 14, 15, 19, 24, 26, 27 -> new IllegalStateException(string);
        };
    }
}

