/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php;

import com.google.common.collect.Sets;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.annotator.PhpAnnotatorVisitor;
import com.jetbrains.php.lang.documentation.phpdoc.lexer.PhpDocTokenTypes;
import com.jetbrains.php.lang.documentation.phpdoc.parser.PhpDocElementTypes;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocType;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpExpressionCodeFragment;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.ForeachStatement;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.ParameterListOwner;
import com.jetbrains.php.lang.psi.elements.PhpAttribute;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PhpUnset;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.ParameterListImpl;
import com.jetbrains.php.lang.psi.resolve.types.shapes.PhpDocArrayShapeProvider;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpWorkaroundUtil {
    private static final Set<String> SPECIAL_GENERIC_ARRAYS_NAMES = Set.of("non-empty-array", "non-empty-list");
    private static final Collection<String> GENERIC_ARRAYS_NAMES = Sets.union(Set.of("array", "list", "iterable"), SPECIAL_GENERIC_ARRAYS_NAMES);

    private PhpWorkaroundUtil() {
    }

    public static boolean isAssignByReference(@NotNull AssignmentExpression assignmentExpression) {
        PsiElement opBitAnd;
        if (assignmentExpression == null) {
            PhpWorkaroundUtil.$$$reportNull$$$0(0);
        }
        if ((opBitAnd = PhpPsiUtil.getChildOfType((PsiElement)assignmentExpression, PhpTokenTypes.opBIT_AND)) == null) {
            PsiElement opAssgn = PhpPsiUtil.getChildOfType((PsiElement)assignmentExpression, PhpTokenTypes.opASGN);
            if (opAssgn != null) {
                return opAssgn.getText().contains("&");
            }
            return false;
        }
        return true;
    }

    public static PhpAccessInstruction.Access getArrayAccess(@NotNull PhpAccessVariableInstruction instruction) {
        ArrayAccessExpression arrayExpression;
        PsiElement anchorParent;
        PhpPsiElement anchor;
        if (instruction == null) {
            PhpWorkaroundUtil.$$$reportNull$$$0(1);
        }
        if ((anchor = instruction.getAnchor()) instanceof Variable && (anchorParent = anchor.getParent()) instanceof ArrayAccessExpression && (arrayExpression = (ArrayAccessExpression)anchorParent).getValue() == anchor) {
            ArrayAccessExpression outerArray = PhpPsiUtil.getOuterParentOfType(arrayExpression, ArrayAccessExpression.class);
            PhpAccessInstruction.Access outerArrayAccess = PhpCodeInsightUtil.getAccess(outerArray);
            if (outerArray.getParent() instanceof PhpUnset) {
                return PhpAccessInstruction.Access.UNSET_ACCESS;
            }
            if (!outerArrayAccess.isRead()) {
                return PhpAccessInstruction.Access.WRITE_ACCESS;
            }
        }
        return PhpAccessInstruction.Access.READ_ACCESS;
    }

    public static boolean isReadReference(@NotNull PsiElement anchor) {
        if (anchor == null) {
            PhpWorkaroundUtil.$$$reportNull$$$0(2);
        }
        return PhpPsiUtil.isOfType(PhpPsiUtil.getPrevSiblingIgnoreWhitespace(anchor, true), PhpTokenTypes.opBIT_AND);
    }

    @Nullable
    public static PhpPsiElement getForeachArray(@NotNull ForeachStatement foreachStatement) {
        if (foreachStatement == null) {
            PhpWorkaroundUtil.$$$reportNull$$$0(3);
        }
        return PhpWorkaroundUtil.findNextPhpPsiElement(foreachStatement.getFirstChild());
    }

    @Nullable
    public static Variable getForeachKey(@NotNull ForeachStatement foreachStatement) {
        PhpPsiElement array;
        if (foreachStatement == null) {
            PhpWorkaroundUtil.$$$reportNull$$$0(4);
        }
        if ((array = PhpWorkaroundUtil.getForeachArray(foreachStatement)) != null) {
            PhpPsiElement v2;
            PhpPsiElement v1 = PhpWorkaroundUtil.getNextPsiSibling(array);
            PhpPsiElement phpPsiElement = v2 = v1 != null ? PhpWorkaroundUtil.getNextPsiSibling(v1) : null;
            if (v2 instanceof Variable && v1 instanceof Variable) {
                return (Variable)v1;
            }
        }
        return null;
    }

    @Nullable
    public static PhpReference getForeachValue(@NotNull ForeachStatement foreachStatement) {
        if (foreachStatement == null) {
            PhpWorkaroundUtil.$$$reportNull$$$0(5);
        }
        for (PsiElement lastChild = foreachStatement.getLastChild(); lastChild != null; lastChild = lastChild.getPrevSibling()) {
            if (!(lastChild instanceof PhpReference)) continue;
            return (PhpReference)lastChild;
        }
        return null;
    }

    @Nullable
    public static PhpPsiElement getNextPsiSibling(@NotNull PhpPsiElement psiElement) {
        if (psiElement == null) {
            PhpWorkaroundUtil.$$$reportNull$$$0(6);
        }
        return PhpWorkaroundUtil.findNextPhpPsiElement(psiElement.getNextSibling());
    }

    @Nullable
    public static PhpPsiElement findNextPhpPsiElement(@Nullable PsiElement element) {
        for (PsiElement currElement = element; currElement != null; currElement = currElement.getNextSibling()) {
            if (!(currElement.getNode() instanceof CompositeElement)) continue;
            if (currElement instanceof PhpPsiElement) {
                PhpPsiElement phpPsiElement = (PhpPsiElement)currElement;
                if (phpPsiElement instanceof PhpDocComment || PhpPsiUtil.isOfType((PsiElement)phpPsiElement, PhpElementTypes.HTML)) continue;
                return phpPsiElement;
            }
            return null;
        }
        return null;
    }

    public static boolean isIntentionAvailable(@NotNull PsiElement element) {
        if (element == null) {
            PhpWorkaroundUtil.$$$reportNull$$$0(7);
        }
        return !(element.getContainingFile() instanceof PhpExpressionCodeFragment) && element.getContainingFile() instanceof PhpFile;
    }

    @Nullable
    public static Parameter getFunctionParameter(@NotNull PsiElement position) {
        ParameterList parameterList;
        if (position == null) {
            PhpWorkaroundUtil.$$$reportNull$$$0(8);
        }
        if ((parameterList = (ParameterList)PhpPsiUtil.getParentByCondition(position, false, ParameterList.INSTANCEOF, Statement.INSTANCEOF)) != null) {
            PsiElement parent = parameterList.getParent();
            int index = PhpWorkaroundUtil.getArgumentIndex(position, parameterList);
            if (index != -1) {
                Collection<Function> elements = PhpWorkaroundUtil.resolveTargetFunctions(parent);
                for (Function element : elements) {
                    Parameter lastParameter;
                    Parameter[] funcParameters = element.getParameters();
                    if (index < funcParameters.length) {
                        return funcParameters[index];
                    }
                    if (funcParameters.length <= 0 || !(lastParameter = funcParameters[funcParameters.length - 1]).isVariadic()) continue;
                    return lastParameter;
                }
            }
        }
        return null;
    }

    @NotNull
    public static Collection<Function> resolveTargetFunctions(@Nullable PsiElement element) {
        return PhpWorkaroundUtil.resolveTargetFunctions(PhpWorkaroundUtil.getFunctionReferenceToResolve(element));
    }

    @NotNull
    public static List<Function> resolveTargetFunctions(@Nullable PhpReference ref) {
        List list = ref != null ? ContainerUtil.filterIsInstance(ref.resolveGlobal(true), Function.class) : Collections.emptyList();
        if (list == null) {
            PhpWorkaroundUtil.$$$reportNull$$$0(9);
        }
        return list;
    }

    @Nullable
    public static PhpReference getFunctionReferenceToResolve(@Nullable PsiElement element) {
        if (element instanceof FunctionReference) {
            return (FunctionReference)element;
        }
        if (element instanceof NewExpression) {
            return ((NewExpression)element).getClassReference();
        }
        if (element instanceof PhpAttribute) {
            return ((PhpAttribute)element).getClassReference();
        }
        return null;
    }

    public static int getArgumentIndex(@NotNull PsiElement position, @Nullable ParameterList parameterList) {
        if (position == null) {
            PhpWorkaroundUtil.$$$reportNull$$$0(10);
        }
        int index = -1;
        if (parameterList != null) {
            PsiElement[] refParameters = parameterList.getParameters();
            for (int i = 0; i < refParameters.length; ++i) {
                if (!PsiTreeUtil.isAncestor((PsiElement)refParameters[i], (PsiElement)position, (boolean)false)) continue;
                index = i;
                break;
            }
        }
        return index;
    }

    public static int resolveMappedParameterIndex(@Nullable PsiElement argument) {
        int[] indexes;
        ParameterListOwner parameterListOwner;
        if (argument == null) {
            return -1;
        }
        PsiElement nameIdentifier = ParameterListImpl.getNameIdentifier(argument);
        if (nameIdentifier != null && (parameterListOwner = PhpPsiUtil.getParentOfClass(argument, ParameterListOwner.class)) != null && (indexes = PhpAnnotatorVisitor.resolveFunctions(parameterListOwner).stream().mapToInt(f -> PhpWorkaroundUtil.getMappedParameterIndex(nameIdentifier, f)).distinct().toArray()).length == 1 && indexes[0] >= 0) {
            return indexes[0];
        }
        return PhpCodeInsightUtil.getParameterIndex(argument);
    }

    public static Collection<Parameter> multiResolveMappedParameters(@Nullable PsiElement argument) {
        ParameterListOwner parameterListOwner = PhpPsiUtil.getParentOfClass(argument, ParameterListOwner.class);
        if (parameterListOwner == null) {
            return Collections.emptySet();
        }
        return PhpAnnotatorVisitor.resolveFunctions(parameterListOwner).stream().map(f -> PhpWorkaroundUtil.resolveArgument(argument, parameterListOwner, f)).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    @Nullable
    private static Parameter resolveArgument(@NotNull PsiElement argument, ParameterListOwner parameterListOwner, Function function) {
        if (argument == null) {
            PhpWorkaroundUtil.$$$reportNull$$$0(11);
        }
        PsiElement nameIdentifier = ParameterListImpl.getNameIdentifier(argument);
        Parameter[] parameters = function.getParameters();
        Object[] arguments = parameterListOwner.getParameters();
        int positionalIndex = ArrayUtil.indexOf((Object[])arguments, (Object)argument);
        if (nameIdentifier == null && positionalIndex >= 0) {
            return parameters[Math.min(parameters.length, positionalIndex)];
        }
        int index = PhpWorkaroundUtil.getMappedParameterIndex(nameIdentifier, function);
        return index >= 0 && index < parameters.length ? parameters[index] : null;
    }

    private static int getMappedParameterIndex(PsiElement nameIdentifier, Function resolvedFunction) {
        if (resolvedFunction != null) {
            String name = nameIdentifier.getText();
            List<Parameter> parameters = Arrays.asList(resolvedFunction.getParameters());
            return PhpWorkaroundUtil.resolveMappedParameterIndex(name, parameters);
        }
        return -1;
    }

    public static int resolveMappedParameterIndex(String argumentName, List<Parameter> parameters) {
        int i = ContainerUtil.indexOf(parameters, p -> PhpLangUtil.equalsParameterNames(p.getName(), argumentName));
        if (i >= 0) {
            return i;
        }
        Parameter lastParameter = (Parameter)ContainerUtil.getLastItem(parameters);
        if (lastParameter != null && lastParameter.isVariadic()) {
            return parameters.size() - 1;
        }
        return -1;
    }

    public static Collection<String> getGenericArraysNames() {
        return GENERIC_ARRAYS_NAMES;
    }

    public static boolean isGenericArray(@NotNull PhpDocType docType) {
        if (docType == null) {
            PhpWorkaroundUtil.$$$reportNull$$$0(12);
        }
        return PhpWorkaroundUtil.isGenericArray((PsiElement)docType, docType.getName());
    }

    public static boolean isGenericArray(@NotNull PsiElement element, @Nullable String name) {
        String res;
        if (element == null) {
            PhpWorkaroundUtil.$$$reportNull$$$0(13);
        }
        return (res = PhpWorkaroundUtil.getGenericDocTypeName(element, name)) != null && PhpWorkaroundUtil.getGenericArraysNames().contains(res);
    }

    public static boolean isSpecialArray(@Nullable String name) {
        String typeName = StringUtil.toLowerCase((String)StringUtil.notNullize((String)name));
        return SPECIAL_GENERIC_ARRAYS_NAMES.contains(typeName);
    }

    @Nullable
    public static String getGenericDocTypeName(@NotNull PhpDocType docType) {
        if (docType == null) {
            PhpWorkaroundUtil.$$$reportNull$$$0(14);
        }
        return PhpWorkaroundUtil.getGenericDocTypeName((PsiElement)docType, docType.getName());
    }

    @Nullable
    public static String getGenericDocTypeName(@NotNull PsiElement element, @Nullable String name) {
        PsiElement attributes;
        if (element == null) {
            PhpWorkaroundUtil.$$$reportNull$$$0(15);
        }
        return (attributes = PhpPsiUtil.getChildOfType(element, (IElementType)PhpDocElementTypes.phpDocAttributeList)) != null ? StringUtil.toLowerCase((String)StringUtil.notNullize((String)name)) : null;
    }

    @NotNull
    public static JBIterable<PhpDocType> valueDocTypes(@NotNull PsiElement docType) {
        if (docType == null) {
            PhpWorkaroundUtil.$$$reportNull$$$0(16);
        }
        JBIterable jBIterable = PhpWorkaroundUtil.valueDocTypes(docType, PhpDocTokenTypes.DOC_LAB, PhpDocTokenTypes.DOC_RAB, PhpDocTokenTypes.DOC_COMMA).filter(PhpDocType.class);
        if (jBIterable == null) {
            PhpWorkaroundUtil.$$$reportNull$$$0(17);
        }
        return jBIterable;
    }

    @NotNull
    public static JBIterable<? extends PsiElement> valueDocTypes(@NotNull PsiElement docType, IElementType lBrace, IElementType rBrace, IElementType comma) {
        PsiElement elementToFindCommentsAfter;
        if (docType == null) {
            PhpWorkaroundUtil.$$$reportNull$$$0(18);
        }
        if ((elementToFindCommentsAfter = PhpWorkaroundUtil.getTypesSeparatorElement(docType, lBrace, rBrace, comma)) == null) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                PhpWorkaroundUtil.$$$reportNull$$$0(19);
            }
            return jBIterable;
        }
        JBIterable jBIterable = SyntaxTraverser.psiApi().siblings((Object)elementToFindCommentsAfter);
        if (jBIterable == null) {
            PhpWorkaroundUtil.$$$reportNull$$$0(20);
        }
        return jBIterable;
    }

    @Nullable
    public static PsiElement getTypesSeparatorElement(@NotNull PsiElement docType) {
        if (docType == null) {
            PhpWorkaroundUtil.$$$reportNull$$$0(21);
        }
        return PhpWorkaroundUtil.getTypesSeparatorElement(docType, PhpDocTokenTypes.DOC_LAB, PhpDocTokenTypes.DOC_RAB, PhpDocTokenTypes.DOC_COMMA);
    }

    @Nullable
    public static PsiElement getTypesSeparatorElement(@NotNull PsiElement docType, IElementType lBrace, IElementType rBrace, IElementType comma) {
        PsiElement attributes;
        if (docType == null) {
            PhpWorkaroundUtil.$$$reportNull$$$0(22);
        }
        if ((attributes = PhpPsiUtil.getChildOfType(docType, (IElementType)PhpDocElementTypes.phpDocAttributeList)) == null) {
            return null;
        }
        PsiElement attributesFirstChild = attributes.getFirstChild();
        PsiElement lastChild = attributes.getLastChild();
        while (PhpDocArrayShapeProvider.isIgnoredElementInMultilineDocType(lastChild)) {
            lastChild = lastChild.getPrevSibling();
        }
        if (!PhpPsiUtil.isOfType(attributesFirstChild, lBrace) || !PhpPsiUtil.isOfType(lastChild, rBrace)) {
            return null;
        }
        return (PsiElement)ObjectUtils.notNull((Object)PhpPsiUtil.getChildOfType(attributes, comma), (Object)attributesFirstChild);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9, 17, 19, 20 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignmentExpression";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instruction";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "foreachStatement";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 7: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 9: 
            case 17: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/PhpWorkaroundUtil";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/PhpWorkaroundUtil";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveTargetFunctions";
                break;
            }
            case 17: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "valueDocTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAssignByReference";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getArrayAccess";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isReadReference";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getForeachArray";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getForeachKey";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getForeachValue";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getNextPsiSibling";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isIntentionAvailable";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionParameter";
                break;
            }
            case 9: 
            case 17: 
            case 19: 
            case 20: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getArgumentIndex";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "resolveArgument";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isGenericArray";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getGenericDocTypeName";
                break;
            }
            case 16: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "valueDocTypes";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getTypesSeparatorElement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9, 17, 19, 20 -> new IllegalStateException(string);
        };
    }
}

