/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.actions;

import com.intellij.lang.ExpressionTypeProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpCaches;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.elements.ArrayIndex;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public final class PhpExpressionTypeProvider
extends ExpressionTypeProvider<PhpTypedElement> {
    @NotNull
    public String getInformationHint(@NotNull PhpTypedElement element) {
        String typePresentation;
        if (element == null) {
            PhpExpressionTypeProvider.$$$reportNull$$$0(0);
        }
        String string = StringUtil.isEmpty((String)(typePresentation = PhpExpressionTypeProvider.computeTypeWithoutCaches(element).toStringResolved())) ? PhpBundle.message("empty.type", new Object[0]) : StringUtil.escapeXmlEntities((String)typePresentation);
        if (string == null) {
            PhpExpressionTypeProvider.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    private static PhpType computeTypeWithoutCaches(@NotNull PhpTypedElement element) {
        if (element == null) {
            PhpExpressionTypeProvider.$$$reportNull$$$0(2);
        }
        PhpType phpType = PhpExpressionTypeProvider.computeLocalTypeWithoutCaches(element).global(element.getProject());
        if (phpType == null) {
            PhpExpressionTypeProvider.$$$reportNull$$$0(3);
        }
        return phpType;
    }

    @NotNull
    private static PhpType computeLocalTypeWithoutCaches(@NotNull PhpTypedElement element) {
        if (element == null) {
            PhpExpressionTypeProvider.$$$reportNull$$$0(4);
        }
        if (ApplicationManager.getApplication().isInternal()) {
            PhpCaches.getInstance(element.getProject()).clearCaches(false);
        }
        PhpType phpType = element.getType();
        if (phpType == null) {
            PhpExpressionTypeProvider.$$$reportNull$$$0(5);
        }
        return phpType;
    }

    @NotNull
    public List<PhpTypedElement> getExpressionsAt(@NotNull PsiElement elementAt) {
        if (elementAt == null) {
            PhpExpressionTypeProvider.$$$reportNull$$$0(6);
        }
        List list = SyntaxTraverser.psiApi().parents((Object)elementAt).filter(PhpExpression.class).filter(Conditions.not(PhpExpressionTypeProvider::isTrivialExpression)).map(PhpTypedElement.class::cast).toList();
        if (list == null) {
            PhpExpressionTypeProvider.$$$reportNull$$$0(7);
        }
        return list;
    }

    public boolean hasAdvancedInformation() {
        return true;
    }

    @NotNull
    public String getAdvancedInformationHint(@NotNull PhpTypedElement element) {
        if (element == null) {
            PhpExpressionTypeProvider.$$$reportNull$$$0(8);
        }
        return PhpExpressionTypeProvider.getPresentation(ContainerUtil.map2Set(PhpExpressionTypeProvider.computeLocalTypeWithoutCaches(element).getTypesWithParametrisedParts(), t -> t + " -> " + PhpType.global(element.getProject(), t).toStringResolved()));
    }

    @NotNull
    @NlsSafe
    private static String getPresentation(Set<@NlsSafe String> types) {
        String string = StringUtil.join(types, (String)"\n");
        if (string == null) {
            PhpExpressionTypeProvider.$$$reportNull$$$0(9);
        }
        return string;
    }

    private static boolean isTrivialExpression(@NotNull PhpTypedElement e) {
        IElementType operationType;
        if (e == null) {
            PhpExpressionTypeProvider.$$$reportNull$$$0(10);
        }
        if (e instanceof ArrayIndex || e instanceof AssignmentExpression) {
            return true;
        }
        return e instanceof BinaryExpression && (PhpTokenTypes.tsLOGICAL_OPS.contains(operationType = ((BinaryExpression)e).getOperationType()) || PhpTokenTypes.tsCOMPARE_OPS.contains(operationType));
    }

    @NotNull
    @Nls(capitalization=Nls.Capitalization.Sentence)
    public String getErrorHint() {
        String string = PhpBundle.message("no.expression.found", new Object[0]);
        if (string == null) {
            PhpExpressionTypeProvider.$$$reportNull$$$0(11);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 5, 7, 9, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/actions/PhpExpressionTypeProvider";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementAt";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/actions/PhpExpressionTypeProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInformationHint";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "computeTypeWithoutCaches";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "computeLocalTypeWithoutCaches";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpressionsAt";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentation";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorHint";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInformationHint";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "computeTypeWithoutCaches";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "computeLocalTypeWithoutCaches";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getExpressionsAt";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getAdvancedInformationHint";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isTrivialExpression";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 5, 7, 9, 11 -> new IllegalStateException(string);
        };
    }
}

