/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.actions;

import com.intellij.ide.IdeView;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.actions.CreateFromTemplateActionBase;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.PathUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIcons;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.inspections.phpdoc.PhpDocCommentGenerator;
import com.jetbrains.php.lang.inspections.quickfix.createClass.PhpCreateClassQuickFix;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.refactoring.PhpNameUtil;
import com.jetbrains.php.roots.PhpPsrNamespaceRootDetector;
import com.jetbrains.php.templates.PhpCreateFileFromTemplateDataProvider;
import java.io.File;
import java.util.List;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpNewBaseAction
extends AnAction {
    private static final Logger LOG = Logger.getInstance(PhpNewBaseAction.class);
    private static final String SEPARATOR = "/";

    protected PhpNewBaseAction() {
    }

    protected PhpNewBaseAction(@NotNull @NlsActions.ActionText String actionName, @NotNull @NlsActions.ActionDescription String description, @NotNull Icon icon) {
        if (actionName == null) {
            PhpNewBaseAction.$$$reportNull$$$0(0);
        }
        if (description == null) {
            PhpNewBaseAction.$$$reportNull$$$0(1);
        }
        if (icon == null) {
            PhpNewBaseAction.$$$reportNull$$$0(2);
        }
        super(actionName, description, icon);
    }

    protected PhpNewBaseAction(@NotNull Supplier<String> actionName, @NotNull Supplier<String> description, @NotNull Icon icon) {
        if (actionName == null) {
            PhpNewBaseAction.$$$reportNull$$$0(3);
        }
        if (description == null) {
            PhpNewBaseAction.$$$reportNull$$$0(4);
        }
        if (icon == null) {
            PhpNewBaseAction.$$$reportNull$$$0(5);
        }
        super(actionName, description, icon);
    }

    protected PhpNewBaseAction(@NotNull @NlsActions.ActionText String actionName, @NotNull @NlsActions.ActionDescription String description) {
        if (actionName == null) {
            PhpNewBaseAction.$$$reportNull$$$0(6);
        }
        if (description == null) {
            PhpNewBaseAction.$$$reportNull$$$0(7);
        }
        this(actionName, description, PhpIcons.PHP_FILE);
    }

    protected PhpNewBaseAction(@NotNull Supplier<String> actionName, @NotNull Supplier<String> description) {
        if (actionName == null) {
            PhpNewBaseAction.$$$reportNull$$$0(8);
        }
        if (description == null) {
            PhpNewBaseAction.$$$reportNull$$$0(9);
        }
        this(actionName, description, PhpIcons.PHP_FILE);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        DataContext dataContext;
        IdeView view;
        if (e == null) {
            PhpNewBaseAction.$$$reportNull$$$0(10);
        }
        if ((view = (IdeView)LangDataKeys.IDE_VIEW.getData(dataContext = e.getDataContext())) == null) {
            return;
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return;
        }
        PsiDirectory initialBaseDir = view.getOrChooseDirectory();
        if (initialBaseDir == null) {
            return;
        }
        this.invoke(project, initialBaseDir, this.getFile(dataContext), view, (Editor)CommonDataKeys.EDITOR.getData(dataContext));
    }

    public PsiFile getFile(DataContext dataContext) {
        return (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
    }

    @Deprecated(forRemoval=true)
    public void invoke(@NotNull Project project, @NotNull PsiDirectory initialBaseDir, @Nullable PsiFile file, @Nullable IdeView view) {
        if (project == null) {
            PhpNewBaseAction.$$$reportNull$$$0(11);
        }
        if (initialBaseDir == null) {
            PhpNewBaseAction.$$$reportNull$$$0(12);
        }
        this.invoke(project, initialBaseDir, file, view, null);
    }

    public void invoke(@NotNull Project project, @NotNull PsiDirectory initialBaseDir, @Nullable PsiFile file, @Nullable IdeView view, @Nullable Editor editor) {
        PhpCreateFileFromTemplateDataProvider providerByEditor;
        PhpCreateFileFromTemplateDataProvider dataProvider;
        if (project == null) {
            PhpNewBaseAction.$$$reportNull$$$0(13);
        }
        if (initialBaseDir == null) {
            PhpNewBaseAction.$$$reportNull$$$0(14);
        }
        PhpCreateFileFromTemplateDataProvider phpCreateFileFromTemplateDataProvider = dataProvider = (providerByEditor = this.getDataProvider(project, initialBaseDir, file, editor)) != null ? providerByEditor : this.getDataProvider(project, initialBaseDir, file);
        if (dataProvider == null) {
            return;
        }
        PsiFile createdFile = this.createFile(project, dataProvider);
        if (createdFile == null) {
            return;
        }
        PhpNewBaseAction.navigateToCreatedFile(project, view, dataProvider.getFilePath(), createdFile, this.requestFocus(), this.getOffset(createdFile));
        PhpNewBaseAction.startLiveTemplate(project, dataProvider.getTemplateName(), createdFile);
    }

    @Nullable
    protected PsiFile createFile(@NotNull Project project, @NotNull PhpCreateFileFromTemplateDataProvider dataProvider) {
        if (project == null) {
            PhpNewBaseAction.$$$reportNull$$$0(15);
        }
        if (dataProvider == null) {
            PhpNewBaseAction.$$$reportNull$$$0(16);
        }
        return PhpNewBaseAction.createFile(project, dataProvider, __ -> {}, this.getActionName());
    }

    @Nullable
    public static PsiFile createFile(@NotNull Project project, @NotNull PhpCreateFileFromTemplateDataProvider dataProvider, @NotNull Consumer<? super PsiFile> postActionsOnCreatedFileMaker, @NotNull @NlsContexts.Command String actionName) {
        if (project == null) {
            PhpNewBaseAction.$$$reportNull$$$0(17);
        }
        if (dataProvider == null) {
            PhpNewBaseAction.$$$reportNull$$$0(18);
        }
        if (postActionsOnCreatedFileMaker == null) {
            PhpNewBaseAction.$$$reportNull$$$0(19);
        }
        if (actionName == null) {
            PhpNewBaseAction.$$$reportNull$$$0(20);
        }
        PsiDirectory baseDir = dataProvider.getBaseDirectory();
        String templateName = dataProvider.getTemplateName();
        String filePath = dataProvider.getFilePath();
        Properties properties = dataProvider.getProperties(baseDir);
        properties.setProperty("FILE_NAME", PathUtil.getFileName((String)filePath));
        PsiFile createdFile = PhpCreateClassQuickFix.createClassInSeparateFile(project, properties, filePath, baseDir, actionName, templateName, postActionsOnCreatedFileMaker);
        if (createdFile == null) {
            return null;
        }
        if (createdFile instanceof PhpFile) {
            PhpPsrNamespaceRootDetector.detectNewRootDirectory(project, (PhpFile)createdFile, properties.getProperty("NAMESPACE"));
        }
        return createdFile;
    }

    protected static void navigateToCreatedFile(@NotNull Project project, @Nullable IdeView view, @NotNull String filePath, @NotNull PsiFile createdFile, boolean requestFocus, int offset) {
        if (project == null) {
            PhpNewBaseAction.$$$reportNull$$$0(21);
        }
        if (filePath == null) {
            PhpNewBaseAction.$$$reportNull$$$0(22);
        }
        if (createdFile == null) {
            PhpNewBaseAction.$$$reportNull$$$0(23);
        }
        if (view != null) {
            view.selectElement((PsiElement)createdFile);
        } else if (createdFile instanceof PhpFile) {
            VirtualFile virtualFile = createdFile.getVirtualFile();
            if (virtualFile == null) {
                LOG.warn("Can not open created file: '" + filePath + "'");
            } else {
                PsiNavigationSupport.getInstance().createNavigatable(project, virtualFile, offset).navigate(requestFocus);
            }
        }
    }

    protected int getOffset(@Nullable PsiFile psiFile) {
        return -1;
    }

    protected boolean requestFocus() {
        return false;
    }

    protected static void startLiveTemplate(@NotNull Project project, @NotNull String templateName, @NotNull PsiFile createdFile) {
        FileTemplate template;
        if (project == null) {
            PhpNewBaseAction.$$$reportNull$$$0(24);
        }
        if (templateName == null) {
            PhpNewBaseAction.$$$reportNull$$$0(25);
        }
        if (createdFile == null) {
            PhpNewBaseAction.$$$reportNull$$$0(26);
        }
        if ((template = FileTemplateManager.getInstance((Project)project).findInternalTemplate(templateName)) != null && template.isLiveTemplateEnabled()) {
            CreateFromTemplateActionBase.startLiveTemplate((PsiFile)createdFile);
        } else {
            Editor editor;
            PhpDocComment docComment;
            PhpClass clazz = (PhpClass)PsiTreeUtil.findChildOfType((PsiElement)createdFile, PhpClass.class, (boolean)false);
            PhpDocComment phpDocComment = docComment = clazz != null ? clazz.getDocComment() : null;
            if (docComment != null && (editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor()) != null) {
                WriteCommandAction.runWriteCommandAction((Project)project, () -> PhpDocCommentGenerator.tryMoveCaretOnMarker(editor, docComment.getTextRange()));
            }
        }
    }

    @Nullable
    protected abstract PhpCreateFileFromTemplateDataProvider getDataProvider(@NotNull Project var1, @NotNull PsiDirectory var2, @Nullable PsiFile var3);

    @Nullable
    protected PhpCreateFileFromTemplateDataProvider getDataProvider(@NotNull Project project, @NotNull PsiDirectory directory, @Nullable PsiFile file, @Nullable Editor editor) {
        if (project == null) {
            PhpNewBaseAction.$$$reportNull$$$0(27);
        }
        if (directory == null) {
            PhpNewBaseAction.$$$reportNull$$$0(28);
        }
        return null;
    }

    @NotNull
    @Nls
    protected String getActionName() {
        String string = this.getTemplatePresentation().getText();
        if (string == null) {
            PhpNewBaseAction.$$$reportNull$$$0(29);
        }
        return string;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            PhpNewBaseAction.$$$reportNull$$$0(30);
        }
        boolean enabled = PhpNewBaseAction.isAvailable(e.getDataContext());
        Presentation presentation = e.getPresentation();
        presentation.setEnabledAndVisible(enabled);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            PhpNewBaseAction.$$$reportNull$$$0(31);
        }
        return actionUpdateThread;
    }

    public static boolean isAvailable(DataContext dataContext) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return false;
        }
        IdeView view = (IdeView)LangDataKeys.IDE_VIEW.getData(dataContext);
        return view != null && view.getDirectories().length != 0;
    }

    @Nullable
    @NlsContexts.DialogMessage
    protected static String isValidFilePath(@NotNull String fullFilePath, @NotNull PsiDirectory baseDirectory) {
        String filePath;
        if (fullFilePath == null) {
            PhpNewBaseAction.$$$reportNull$$$0(32);
        }
        if (baseDirectory == null) {
            PhpNewBaseAction.$$$reportNull$$$0(33);
        }
        if ((filePath = StringUtil.replace((String)fullFilePath, (String)File.separator, (String)SEPARATOR)).isEmpty()) {
            return PhpBundle.message("validation.file.not.valid.name", fullFilePath);
        }
        List split = StringUtil.split((String)filePath, (String)SEPARATOR);
        if (split.isEmpty()) {
            return PhpBundle.message("validation.file.not.valid.name", fullFilePath);
        }
        for (int i = 0; i < split.size(); ++i) {
            String path = (String)split.get(i);
            if (PhpNameUtil.isValidFileName(path)) continue;
            return PhpBundle.message("validation.file.not.valid.name", fullFilePath);
        }
        VirtualFile baseDirectoryFile = baseDirectory.getVirtualFile();
        VirtualFile fileByRelativePath = baseDirectoryFile.findFileByRelativePath(PhpNameUtil.trimStart(filePath, '/'));
        if (fileByRelativePath != null) {
            return PhpBundle.message("validation.file.already.exists", fullFilePath);
        }
        return null;
    }

    public boolean isDumbAware() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 29, 31 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionName";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 10: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 21: 
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialBaseDir";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataProvider";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "postActionsOnCreatedFileMaker";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "createdFile";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateName";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/actions/PhpNewBaseAction";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullFilePath";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDirectory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/actions/PhpNewBaseAction";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionName";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createFile";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "navigateToCreatedFile";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "startLiveTemplate";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getDataProvider";
                break;
            }
            case 29: 
            case 31: {
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "isValidFilePath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 29, 31 -> new IllegalStateException(string);
        };
    }
}

