/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.actions;

import com.intellij.ide.browsers.WebBrowserManager;
import com.intellij.ide.browsers.WebBrowserXmlService;
import com.intellij.ide.browsers.actions.OpenInBrowserBaseGroupAction;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.diff.impl.DiffUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.php.refactoring.move.dnd.PhpMoveClassesDragAndDropHandlerDelegate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001a\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\"\u0010\u000e\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/php/actions/PhpOpenInBrowserEditorContextBarGroupAction;", "Lcom/intellij/ide/browsers/actions/OpenInBrowserBaseGroupAction$OpenInBrowserEditorContextBarGroupAction;", "<init>", "()V", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "needShowOnHover", "", "psiFile", "Lcom/intellij/psi/PsiFile;", "browserManager", "Lcom/intellij/ide/browsers/WebBrowserManager;", "isEnabled", "editor", "Lcom/intellij/openapi/editor/Editor;", "intellij.php.impl"})
public final class PhpOpenInBrowserEditorContextBarGroupAction
extends OpenInBrowserBaseGroupAction.OpenInBrowserEditorContextBarGroupAction {
    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        WebBrowserManager browserManager = WebBrowserManager.getInstance();
        PsiFile psiFile = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        Intrinsics.checkNotNull((Object)browserManager);
        boolean needShowOnHover = this.needShowOnHover(psiFile, browserManager);
        boolean enabled = this.isEnabled(needShowOnHover, browserManager, editor);
        e.getPresentation().setEnabledAndVisible(enabled);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final boolean needShowOnHover(PsiFile psiFile, WebBrowserManager browserManager) {
        boolean bl;
        if (psiFile != null) {
            WebBrowserXmlService webBrowserXmlService = WebBrowserXmlService.Companion.getInstance();
            Language language = psiFile.getViewProvider().getBaseLanguage();
            Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getBaseLanguage(...)");
            if (webBrowserXmlService.isXmlLanguage(language)) {
                bl = browserManager.isShowBrowserHoverXml();
                return bl;
            }
        }
        if (psiFile != null && PhpMoveClassesDragAndDropHandlerDelegate.isValidSingleClassFile((PsiElement)psiFile)) {
            return false;
        }
        bl = browserManager.isShowBrowserHover();
        return bl;
    }

    private final boolean isEnabled(boolean needShowOnHover, WebBrowserManager browserManager, Editor editor) {
        return needShowOnHover && (!browserManager.getActiveBrowsers().isEmpty() || OpenInBrowserBaseGroupAction.OpenInBrowserEditorContextBarGroupAction.hasLocalBrowser()) && editor != null && !DiffUtil.isDiffEditor((Editor)editor);
    }
}

