/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.actions.statistics;

import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.eventLog.events.EventId3;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.jetbrains.php.actions.PhpNewClassDialog;
import com.jetbrains.php.actions.newClassDataProvider.ClassCreationType;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.phpunit.codeGeneration.PhpNewTestDialog;
import com.jetbrains.php.templates.PhpFileTemplateUtil;
import com.jetbrains.php.testFramework.PhpTestCreateInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpNewClassUsageLogger
extends CounterUsagesCollector {
    private static final EventLogGroup GROUP = new EventLogGroup("php.new.action", 4);
    static final EventField<String> TARGET = EventFields.String((String)"target", List.of("class", "method", "none"));
    static final EventField<String> SOURCE = EventFields.String((String)"source", List.of("empty", "interface", "trait", "class"));
    static final EventField<Integer> METHOD_COUNT = EventFields.Int((String)"method_count");
    static final EventField<Boolean> WITH_INHERIT_MEMBER = EventFields.Boolean((String)"with_inherit_member");
    static final EventField<String> FRAMEWORK = EventFields.String((String)"framework", Arrays.asList("PHPUnit", "PHPUnit_6", "PHPSpec", "Codeception_Unit", "Codeception_Functional", "third.party"));
    static final EventField<String> ACTION_ID = new StringEventField("action_id"){

        @NotNull
        public List<String> getValidationRule() {
            List<String> newTestActions = Arrays.asList("PHPUnit_Test", "Test", "PhpUnitNewTestFromClass", "PhpNewTest", "CodeceptionNewUnitTestFromClass", "third.party");
            List<String> list = Arrays.asList("{util#class_name}", String.format("{enum:%s}", StringUtil.join(newTestActions, (String)"|")));
            if (list == null) {
                1.$$$reportNull$$$0(0);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/actions/statistics/PhpNewClassUsageLogger$1", "getValidationRule"));
        }
    };
    static final VarargEventId ADD_NEW_TEST = GROUP.registerVarargEvent("add.new.test", new EventField[]{TARGET, SOURCE, METHOD_COUNT, FRAMEWORK, ACTION_ID, WITH_INHERIT_MEMBER});
    static final EventField<Boolean> LIBRARY_WAS_CHANGED = EventFields.Boolean((String)"library_was_changed");
    static final EventField<Boolean> DIRECTORY_WAS_CHANGED = EventFields.Boolean((String)"directory_was_changed");
    static final EventField<Boolean> NAMESPACE_WAS_CHANGED = EventFields.Boolean((String)"namespace_was_changed");
    static final EventField<Boolean> SHOW_INHERITED_MEMBERS_WAS_CHANGED = EventFields.Boolean((String)"show_inherited_members_was_changed");
    static final EventField<Boolean> TEST_TARGET_TEXT_WAS_CHANGED = EventFields.Boolean((String)"test_target_text_was_changed");
    static final EventField<Boolean> METHODS_TABLE_WAS_CHANGED = EventFields.Boolean((String)"methods_table_was_changed");
    static final VarargEventId ADD_NEW_TEST_FIELDS_USAGE = GROUP.registerVarargEvent("add.new.test.fields.usage", new EventField[]{LIBRARY_WAS_CHANGED, DIRECTORY_WAS_CHANGED, NAMESPACE_WAS_CHANGED, SHOW_INHERITED_MEMBERS_WAS_CHANGED, TEST_TARGET_TEXT_WAS_CHANGED, METHODS_TABLE_WAS_CHANGED});
    static final EventField<Boolean> NEW_CLASS_WITH_CUSTOM_VARS = EventFields.Boolean((String)"with_custom_vars");
    static final EventField<String> NEW_CLASS_TYPE = EventFields.String((String)"type", Arrays.asList("PHP Trait", "PHP Interface", "PHP Class", "PHP Enum", "custom"));
    static final EventField<String> NEW_EXTENSION = EventFields.String((String)"extension", Arrays.asList(PhpFileTemplateUtil.getRegisteredPhpFileExtensions()));
    static final EventId3<String, Boolean, String> ADD_NEW_CLASS = GROUP.registerEvent("add.new.class", NEW_CLASS_TYPE, NEW_CLASS_WITH_CUSTOM_VARS, NEW_EXTENSION);
    static final EventField<Boolean> NEW_CLASS_FILE_NAME_WAS_CHANGED = EventFields.Boolean((String)"file_name_was_changed");
    static final EventField<Boolean> NEW_CLASS_NAMESPACE_WAS_CHANGED = EventFields.Boolean((String)"namespace_was_changed");
    static final EventField<Boolean> NEW_CLASS_DIRECTORY_WAS_CHANGED = EventFields.Boolean((String)"directory_was_changed");
    static final EventField<Boolean> NEW_CLASS_TEMPLATE_WAS_CHANGED = EventFields.Boolean((String)"template_was_changed");
    static final EventField<Boolean> NEW_CLASS_EXTENSION_WAS_CHANGED = EventFields.Boolean((String)"extension_was_changed");
    static final EventField<Boolean> NEW_CLASS_SUPER_FQN_WAS_CHANGED = EventFields.Boolean((String)"super_fqn_was_changed");
    static final EventField<Boolean> NEW_CLASS_IMPLEMENTS_TABLE_WAS_CHANGED = EventFields.Boolean((String)"implements_table_was_changed");
    static final VarargEventId ADD_NEW_CLASS_FIELDS_USAGE = GROUP.registerVarargEvent("add.new.class.fields.usage", new EventField[]{NEW_CLASS_FILE_NAME_WAS_CHANGED, NEW_CLASS_NAMESPACE_WAS_CHANGED, NEW_CLASS_DIRECTORY_WAS_CHANGED, NEW_CLASS_TEMPLATE_WAS_CHANGED, NEW_CLASS_EXTENSION_WAS_CHANGED, NEW_CLASS_SUPER_FQN_WAS_CHANGED, NEW_CLASS_IMPLEMENTS_TABLE_WAS_CHANGED});
    static final EventId1<String> ADD_NEW_FILE = GROUP.registerEvent("add.new.file", NEW_EXTENSION);

    public static void logNewTest(@NotNull Project project, @NotNull AnAction action, @NotNull PhpNewTestDialog dataProvider, @Nullable PhpNamedElement targetElement) {
        if (project == null) {
            PhpNewClassUsageLogger.$$$reportNull$$$0(0);
        }
        if (action == null) {
            PhpNewClassUsageLogger.$$$reportNull$$$0(1);
        }
        if (dataProvider == null) {
            PhpNewClassUsageLogger.$$$reportNull$$$0(2);
        }
        ADD_NEW_TEST.log(project, PhpNewClassUsageLogger.getNewTestData(project, action, dataProvider, targetElement));
        ADD_NEW_TEST_FIELDS_USAGE.log(project, PhpNewClassUsageLogger.getFieldsUsageData(dataProvider));
    }

    @NotNull
    private static List<EventPair<?>> getNewTestData(@NotNull Project project, @NotNull AnAction action, @NotNull PhpNewTestDialog dataProvider, @Nullable PhpNamedElement targetElement) {
        String actionId;
        if (project == null) {
            PhpNewClassUsageLogger.$$$reportNull$$$0(3);
        }
        if (action == null) {
            PhpNewClassUsageLogger.$$$reportNull$$$0(4);
        }
        if (dataProvider == null) {
            PhpNewClassUsageLogger.$$$reportNull$$$0(5);
        }
        PhpTestCreateInfo info = dataProvider.getSelectedTestCreateInfo();
        ArrayList data = new ArrayList();
        data.add(TARGET.with((Object)PhpNewClassUsageLogger.getTargetElementStatus(targetElement)));
        data.add(SOURCE.with((Object)PhpNewClassUsageLogger.getSourceElementStatus(targetElement)));
        data.add(METHOD_COUNT.with((Object)dataProvider.getSelectedClassMembers().size()));
        data.add(FRAMEWORK.with((Object)(PluginInfoDetectorKt.getPluginInfo(info.getClass()).isDevelopedByJetBrains() ? info.getName() : "third.party")));
        PluginInfo actionInfo = PluginInfoDetectorKt.getPluginInfo(action.getClass());
        String string = actionId = actionInfo.isSafeToReport() ? ActionManager.getInstance().getId(action) : "third.party";
        if (actionId == null) {
            actionId = action.getClass().getName();
        }
        data.add(ACTION_ID.with((Object)actionId));
        PhpClass targetClass = dataProvider.getSelectedTargetClass(project);
        boolean isInheritMemberSelected = targetClass != null && dataProvider.isInheritedMembersOptionSelected() && dataProvider.getSelectedClassMembers().stream().anyMatch(m -> PhpNewClassUsageLogger.getContainingClass(m) != targetClass);
        data.add(WITH_INHERIT_MEMBER.with((Object)isInheritMemberSelected));
        ArrayList arrayList = data;
        if (arrayList == null) {
            PhpNewClassUsageLogger.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @NotNull
    private static List<EventPair<?>> getFieldsUsageData(@NotNull PhpNewTestDialog dataProvider) {
        if (dataProvider == null) {
            PhpNewClassUsageLogger.$$$reportNull$$$0(7);
        }
        ArrayList data = new ArrayList();
        data.add(LIBRARY_WAS_CHANGED.with((Object)dataProvider.isLibraryChanged()));
        data.add(DIRECTORY_WAS_CHANGED.with((Object)dataProvider.myDirectoryTextChangedUnderFocus));
        data.add(NAMESPACE_WAS_CHANGED.with((Object)dataProvider.myNamespaceTextChangedUnderFocus));
        data.add(SHOW_INHERITED_MEMBERS_WAS_CHANGED.with((Object)dataProvider.myShowInheritedMembersChangedUnderFocus));
        data.add(TEST_TARGET_TEXT_WAS_CHANGED.with((Object)dataProvider.myTestTargetTextChangedUnderFocus));
        data.add(METHODS_TABLE_WAS_CHANGED.with((Object)dataProvider.myMethodsTableWasChangedUnderFocus));
        ArrayList arrayList = data;
        if (arrayList == null) {
            PhpNewClassUsageLogger.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    @NotNull
    private static String getSourceElementStatus(@Nullable PhpNamedElement element) {
        PhpClass containingClass = PhpNewClassUsageLogger.getContainingClass(element);
        if (containingClass == null) {
            return "empty";
        }
        if (containingClass.isInterface()) {
            return "interface";
        }
        if (containingClass.isTrait()) {
            return "trait";
        }
        return "class";
    }

    @Nullable
    private static PhpClass getContainingClass(@Nullable PhpNamedElement element) {
        return element != null ? PhpPsiUtil.getParentOfClass((PsiElement)element, false, PhpClass.class) : null;
    }

    @NotNull
    private static String getTargetElementStatus(@Nullable PhpNamedElement element) {
        if (element instanceof PhpClass) {
            return "class";
        }
        if (element instanceof Method) {
            return "method";
        }
        return "none";
    }

    public static void logNewClass(@NotNull Project project, @NotNull PhpNewClassDialog dataProvider) {
        ClassCreationType type;
        if (project == null) {
            PhpNewClassUsageLogger.$$$reportNull$$$0(9);
        }
        if (dataProvider == null) {
            PhpNewClassUsageLogger.$$$reportNull$$$0(10);
        }
        ADD_NEW_CLASS.log(project, (Object)(ClassCreationType.BUNDLED.contains((Object)(type = dataProvider.getSelectedClassCreationType())) ? type.getTemplateName() : "custom"), (Object)dataProvider.hasCustomProperties(), (Object)dataProvider.getExtension());
        ADD_NEW_CLASS_FIELDS_USAGE.log(project, PhpNewClassUsageLogger.getFieldsUsageData(dataProvider));
    }

    @NotNull
    private static List<EventPair<?>> getFieldsUsageData(@NotNull PhpNewClassDialog dataProvider) {
        if (dataProvider == null) {
            PhpNewClassUsageLogger.$$$reportNull$$$0(11);
        }
        ArrayList data = new ArrayList();
        data.add(NEW_CLASS_FILE_NAME_WAS_CHANGED.with((Object)dataProvider.myFileNameTextChangedUnderFocus));
        data.add(NEW_CLASS_NAMESPACE_WAS_CHANGED.with((Object)dataProvider.myNamespaceTextChangedUnderFocus));
        data.add(NEW_CLASS_DIRECTORY_WAS_CHANGED.with((Object)dataProvider.myDirectoryTextChangedUnderFocus));
        data.add(NEW_CLASS_TEMPLATE_WAS_CHANGED.with((Object)dataProvider.myTemplateTypeChangedUnderFocus));
        data.add(NEW_CLASS_EXTENSION_WAS_CHANGED.with((Object)dataProvider.myExtensionTypeChangedUnderFocus));
        data.add(NEW_CLASS_SUPER_FQN_WAS_CHANGED.with((Object)dataProvider.mySuperFqnTextChangedUnderFocus));
        data.add(NEW_CLASS_IMPLEMENTS_TABLE_WAS_CHANGED.with((Object)dataProvider.myInterfaceFqnsToImplementTableChangedUnderFocus));
        ArrayList arrayList = data;
        if (arrayList == null) {
            PhpNewClassUsageLogger.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    public static void logNewFile(@NotNull Project project, @NotNull String extension) {
        if (project == null) {
            PhpNewClassUsageLogger.$$$reportNull$$$0(13);
        }
        if (extension == null) {
            PhpNewClassUsageLogger.$$$reportNull$$$0(14);
        }
        ADD_NEW_FILE.log(project, (Object)extension);
    }

    public EventLogGroup getGroup() {
        return GROUP;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 8, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataProvider";
                break;
            }
            case 6: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/actions/statistics/PhpNewClassUsageLogger";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/actions/statistics/PhpNewClassUsageLogger";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewTestData";
                break;
            }
            case 8: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getFieldsUsageData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "logNewTest";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getNewTestData";
                break;
            }
            case 6: 
            case 8: 
            case 12: {
                break;
            }
            case 7: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getFieldsUsageData";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "logNewClass";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "logNewFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 8, 12 -> new IllegalStateException(string);
        };
    }
}

