/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.codeInsight;

import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProviderDescriptor;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.controlFlow.PhpExitPointNoReturnProvider;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocMethod;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.resolve.types.PhpParameterBasedTypeProvider;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeSignatureKey;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpExitPointFunctionData;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpExitPointFunctionIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpMetaTypeInferenceMappingIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpExpectedFunctionArgumentsIndex;
import icons.PhpIcons;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpMetaDeclarationLineMarkerProvider
extends LineMarkerProviderDescriptor {
    @Nls(capitalization=Nls.Capitalization.Sentence)
    @Nullable(value="null means disabled")
    public @Nls(capitalization=Nls.Capitalization.Sentence) @Nullable(value="null means disabled") String getName() {
        return PhpBundle.message("meta.declaration.line.marker.name", new Object[0]);
    }

    public LineMarkerInfo<?> getLineMarkerInfo(@NotNull PsiElement element) {
        if (element == null) {
            PhpMetaDeclarationLineMarkerProvider.$$$reportNull$$$0(0);
        }
        return null;
    }

    public void collectSlowLineMarkers(@NotNull List<? extends PsiElement> elements, @NotNull Collection<? super LineMarkerInfo<?>> result) {
        if (elements == null) {
            PhpMetaDeclarationLineMarkerProvider.$$$reportNull$$$0(1);
        }
        if (result == null) {
            PhpMetaDeclarationLineMarkerProvider.$$$reportNull$$$0(2);
        }
        for (PsiElement psiElement : elements) {
            Collection<MetaDeclarationInfoType> metaDeclarationInfoTypes;
            PhpClass aClass;
            Function function;
            if (!PhpPsiUtil.isOfType(psiElement, PhpTokenTypes.IDENTIFIER) || (function = (Function)ObjectUtils.tryCast((Object)psiElement.getParent(), Function.class)) == null || function.getNameIdentifier() != psiElement || function instanceof PhpDocMethod || function.isClosure() || function instanceof Method && (aClass = ((Method)function).getContainingClass()) != null && aClass.isAnonymous() || (metaDeclarationInfoTypes = PhpMetaDeclarationLineMarkerProvider.getMetaDeclarationInfoTypes(function)).isEmpty()) continue;
            LineMarkerInfo info = new LineMarkerInfo(psiElement, psiElement.getTextRange(), PhpIcons.Metadata, PhpMetaDeclarationLineMarkerProvider.createTypeHintRenderer(function, metaDeclarationInfoTypes), (GutterIconNavigationHandler)new NavigateToMetaDeclarationAction(metaDeclarationInfoTypes), GutterIconRenderer.Alignment.RIGHT);
            result.add(info);
        }
    }

    @NotNull
    private static com.intellij.util.Function<PsiElement, String> createTypeHintRenderer(Function function, Collection<MetaDeclarationInfoType> metaDeclarationInfoTypes) {
        com.intellij.util.Function function2 = e -> {
            MetaDeclarationInfoType onlyDeclarationInfo = (MetaDeclarationInfoType)ContainerUtil.getOnlyItem((Collection)metaDeclarationInfoTypes);
            return onlyDeclarationInfo != null ? PhpBundle.message("meta.declaration.exists", onlyDeclarationInfo.getName(), function.getName()) : PhpBundle.message("meta.multiple.declaration.exists", function.getName());
        };
        if (function2 == null) {
            PhpMetaDeclarationLineMarkerProvider.$$$reportNull$$$0(3);
        }
        return function2;
    }

    private static Collection<MetaDeclarationInfoType> getMetaDeclarationInfoTypes(Function function) {
        LinkedHashSet<MetaDeclarationInfoType> result = new LinkedHashSet<MetaDeclarationInfoType>();
        PhpMetaDeclarationLineMarkerProvider.addFromTypeOverrides(function, result);
        PhpMetaDeclarationLineMarkerProvider.addFromExpectedArguments(function, result);
        PhpMetaDeclarationLineMarkerProvider.addFromExitPoints(function, result);
        return result;
    }

    private static void addFromExitPoints(Function function, Collection<MetaDeclarationInfoType> result) {
        for (String s : FileBasedIndex.getInstance().getAllKeys(PhpExitPointFunctionIndex.KEY, function.getProject())) {
            FileBasedIndex.getInstance().processValues(PhpExitPointFunctionIndex.KEY, (Object)s, null, (file, value) -> {
                for (PhpExitPointFunctionData data : value) {
                    if (data.fromAttribute() || !PhpExitPointNoReturnProvider.matchesFunction(function, data)) continue;
                    result.add(new MetaDeclarationInfoType("exitPoint", function, file));
                }
                return true;
            }, GlobalSearchScope.allScope((Project)function.getProject()));
        }
    }

    private static void addFromExpectedArguments(Function function, Collection<MetaDeclarationInfoType> result) {
        FileBasedIndex.getInstance().processValues(PhpExpectedFunctionArgumentsIndex.KEY, (Object)function.getFQN(), null, (file, value) -> {
            if (!PhpParameterBasedTypeProvider.isMeta(file)) {
                return true;
            }
            result.add(new MetaDeclarationInfoType("expectedArguments", function, file));
            return true;
        }, PhpMetaDeclarationLineMarkerProvider.createScope(function));
    }

    private static void addFromTypeOverrides(Function function, Collection<MetaDeclarationInfoType> result) {
        String signature = PhpTypeSignatureKey.getSignature(function);
        FileBasedIndex.getInstance().processValues(PhpMetaTypeInferenceMappingIndex.KEY, (Object)signature, null, (file, value) -> {
            for (String typeMapping : value.getKeys()) {
                final String instructionName = PhpMetaDeclarationLineMarkerProvider.getInstructionName(typeMapping);
                result.add(new MetaDeclarationInfoType("override", function, file){

                    @Override
                    @NotNull
                    protected Stream<FunctionReference> metaReferencedDirectives(PsiFile file) {
                        Stream<FunctionReference> stream = super.metaReferencedDirectives(file).filter(f -> {
                            FunctionReference instruction = (FunctionReference)ObjectUtils.tryCast((Object)f.getParameter(1), FunctionReference.class);
                            return instruction != null && instructionName.equals(instruction.getName());
                        });
                        if (stream == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return stream;
                    }

                    @Override
                    public String getName() {
                        return instructionName;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/codeInsight/PhpMetaDeclarationLineMarkerProvider$1", "metaReferencedDirectives"));
                    }
                });
            }
            return true;
        }, PhpMetaDeclarationLineMarkerProvider.createScope(function));
    }

    @NotNull
    private static GlobalSearchScope createScope(Function function) {
        GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)function.getProject());
        if (globalSearchScope == null) {
            PhpMetaDeclarationLineMarkerProvider.$$$reportNull$$$0(4);
        }
        return globalSearchScope;
    }

    @NotNull
    private static String getInstructionName(String key) {
        return switch (key) {
            case "\u03c0\u2020" -> "type";
            case "\u03c0e\u2020" -> "elementType";
            default -> "map";
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/codeInsight/PhpMetaDeclarationLineMarkerProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/codeInsight/PhpMetaDeclarationLineMarkerProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createTypeHintRenderer";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLineMarkerInfo";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "collectSlowLineMarkers";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4 -> new IllegalStateException(string);
        };
    }

    private static final class NavigateToMetaDeclarationAction
    implements GutterIconNavigationHandler<PsiElement> {
        private final Collection<MetaDeclarationInfoType> myMetaDeclarationsInfos;

        private NavigateToMetaDeclarationAction(Collection<MetaDeclarationInfoType> metaDeclarationsInfos) {
            this.myMetaDeclarationsInfos = metaDeclarationsInfos;
        }

        public void navigate(MouseEvent e, final PsiElement elt) {
            MetaDeclarationInfoType onlyDeclarationType = (MetaDeclarationInfoType)ContainerUtil.getOnlyItem(this.myMetaDeclarationsInfos);
            if (onlyDeclarationType != null) {
                NavigateToMetaDeclarationAction.navigate(elt.getProject(), onlyDeclarationType);
                return;
            }
            List actions = ContainerUtil.map(this.myMetaDeclarationsInfos, type -> new AnAction(PhpBundle.message("navigate.to.meta.declaration", type.getName()), (MetaDeclarationInfoType)type){
                final /* synthetic */ MetaDeclarationInfoType val$type;
                {
                    this.val$type = metaDeclarationInfoType;
                    super(arg0);
                }

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    NavigateToMetaDeclarationAction.navigate(elt.getProject(), this.val$type);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/codeInsight/PhpMetaDeclarationLineMarkerProvider$NavigateToMetaDeclarationAction$1", "actionPerformed"));
                }
            });
            JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)new DefaultActionGroup(actions), DataContext.EMPTY_CONTEXT, JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, true).show(new RelativePoint(e));
        }

        private static void navigate(Project project, MetaDeclarationInfoType type) {
            PsiFile file = PsiManager.getInstance((Project)project).findFile(type.myFile);
            int offset = file != null ? type.computeOffset(file) : -1;
            FileEditorManager.getInstance((Project)project).openEditor(new OpenFileDescriptor(project, type.myFile, offset), true);
        }
    }

    private static class MetaDeclarationInfoType {
        private final String myDeclarationName;
        private final String myReferencedFunctionSignature;
        private final VirtualFile myFile;

        private MetaDeclarationInfoType(String declarationName, Function referencedFunctionSignature, VirtualFile file) {
            this.myDeclarationName = declarationName;
            this.myReferencedFunctionSignature = PhpTypeSignatureKey.getSignature(referencedFunctionSignature);
            this.myFile = file;
        }

        protected int computeOffset(PsiFile file) {
            return this.metaReferencedDirectives(file).map(f -> (FunctionReference)ObjectUtils.tryCast((Object)f.getParameter(0), FunctionReference.class)).filter(Objects::nonNull).filter(e -> PhpLangUtil.equalsClassNames(e.getSignature(), this.myReferencedFunctionSignature)).mapToInt(e -> e.getTextRange().getStartOffset()).findFirst().orElse(-1);
        }

        @NotNull
        protected Stream<FunctionReference> metaReferencedDirectives(PsiFile file) {
            Stream<FunctionReference> stream = PsiTreeUtil.findChildrenOfType((PsiElement)file, FunctionReference.class).stream().filter(f -> this.myDeclarationName.equals(f.getName()));
            if (stream == null) {
                MetaDeclarationInfoType.$$$reportNull$$$0(0);
            }
            return stream;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MetaDeclarationInfoType type = (MetaDeclarationInfoType)o;
            return this.myDeclarationName.equals(type.myDeclarationName) && this.myReferencedFunctionSignature.equals(type.myReferencedFunctionSignature) && this.myFile.equals(type.myFile);
        }

        public int hashCode() {
            return Objects.hash(this.myDeclarationName, this.myReferencedFunctionSignature, this.myFile);
        }

        public String getName() {
            return this.myDeclarationName;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/codeInsight/PhpMetaDeclarationLineMarkerProvider$MetaDeclarationInfoType", "metaReferencedDirectives"));
        }
    }
}

