/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.codeInsight;

import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.PhpMatchArmConditionInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpCaseConditionInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpConditionInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpBaseCaseConditionInstructionImpl;
import com.jetbrains.php.codeInsight.dataFlow.PhpConditionDFAnalyzer;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;

public abstract class PhpSwitchCaseAwareInstructionProcessor<E>
extends PhpInstructionProcessor {
    protected abstract PhpConditionDFAnalyzer<E> getAnalyzer();

    protected boolean processBaseConditionInstruction(PhpConditionInstruction instruction) {
        return this.processInstruction(instruction);
    }

    protected E performDFA(PhpConditionInstruction instruction) {
        return this.performDFA(instruction, this.getAnalyzer());
    }

    protected E performDFA(PhpConditionInstruction instruction, PhpConditionDFAnalyzer<E> analyzer) {
        if (instruction instanceof PhpBaseCaseConditionInstructionImpl) {
            IElementType tokenType = instruction instanceof PhpMatchArmConditionInstruction ? PhpTokenTypes.opIDENTICAL : PhpTokenTypes.opEQUAL;
            E result = analyzer.tryComputeStateFromConditionalGuard(((PhpBaseCaseConditionInstructionImpl)instruction).getSwitchArgument(), ((PhpBaseCaseConditionInstructionImpl)instruction).getCaseArgument(), tokenType, instruction.getResult());
            return result != null ? result : analyzer.getEmpty();
        }
        return analyzer.performDFA(instruction);
    }

    protected E performDFA(PhpInstruction instruction, PsiElement condition, boolean result, PhpConditionDFAnalyzer<E> analyzer) {
        if (instruction instanceof PhpBaseCaseConditionInstructionImpl) {
            IElementType tokenType = instruction instanceof PhpMatchArmConditionInstruction ? PhpTokenTypes.opIDENTICAL : PhpTokenTypes.opEQUAL;
            E r = analyzer.tryComputeStateFromConditionalGuard(((PhpBaseCaseConditionInstructionImpl)instruction).getSwitchArgument(), condition, tokenType, result);
            return r != null ? r : analyzer.getEmpty();
        }
        return analyzer.performDFA(condition, result);
    }

    @Override
    public boolean processConditionInstruction(PhpConditionInstruction instruction) {
        return this.processBaseConditionInstruction(instruction);
    }

    @Override
    public boolean processCaseConditionInstruction(PhpCaseConditionInstruction instruction) {
        return this.processBaseConditionInstruction((PhpBaseCaseConditionInstructionImpl)instruction);
    }
}

