/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.codeInsight.controlFlow;

import com.google.common.collect.ImmutableMultimap;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlow;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpEntryPointInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpExitPointInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpEntryPointInstructionImpl;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpExitPointInstructionImpl;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class PhpControlFlowImpl
implements PhpControlFlow {
    public static final PhpInstruction[] EMPTY = new PhpInstruction[]{new PhpEntryPointInstructionImpl(null), new PhpExitPointInstructionImpl()};
    private final PhpInstruction[] myInstructions;
    private ImmutableMultimap<PsiElement, PhpInstruction> myInstructionMap;

    public PhpControlFlowImpl(PhpInstruction @NotNull [] instructions) {
        if (instructions == null) {
            PhpControlFlowImpl.$$$reportNull$$$0(0);
        }
        this.myInstructions = instructions.length < 100000 ? instructions : EMPTY;
    }

    @Override
    public PhpInstruction @NotNull [] getInstructions() {
        if (this.myInstructions == null) {
            PhpControlFlowImpl.$$$reportNull$$$0(1);
        }
        return this.myInstructions;
    }

    @Override
    @NotNull
    public PhpEntryPointInstruction getEntryPoint() {
        PhpEntryPointInstruction phpEntryPointInstruction = (PhpEntryPointInstruction)this.myInstructions[0];
        if (phpEntryPointInstruction == null) {
            PhpControlFlowImpl.$$$reportNull$$$0(2);
        }
        return phpEntryPointInstruction;
    }

    @Override
    @NotNull
    public PhpExitPointInstruction getExitPoint() {
        PhpExitPointInstruction phpExitPointInstruction = (PhpExitPointInstruction)this.myInstructions[this.myInstructions.length - 1];
        if (phpExitPointInstruction == null) {
            PhpControlFlowImpl.$$$reportNull$$$0(3);
        }
        return phpExitPointInstruction;
    }

    @Override
    public <T extends PhpInstruction> T getInstruction(PsiElement anchor, Class<T> instructionClass) {
        return (T)((PhpInstruction)ContainerUtil.getFirstItem(this.getInstructions(anchor, instructionClass)));
    }

    @Override
    public <T extends PhpInstruction> Collection<T> getInstructions(PsiElement anchor, Class<T> instructionClass) {
        if (this.myInstructionMap == null) {
            ImmutableMultimap.Builder map = ImmutableMultimap.builder();
            for (PhpInstruction i : this.myInstructions) {
                PsiElement curAnchor = i.getAnchor();
                if (curAnchor == null) continue;
                map.put((Object)curAnchor, (Object)i);
            }
            this.myInstructionMap = map.build();
        }
        return ContainerUtil.filterIsInstance((Collection)this.myInstructionMap.get((Object)anchor), instructionClass);
    }

    public String toString() {
        StringBuilder builder2 = new StringBuilder();
        for (PhpInstruction instruction : this.myInstructions) {
            builder2.append(instruction);
            builder2.append("\n");
        }
        return builder2.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instructions";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/codeInsight/controlFlow/PhpControlFlowImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/codeInsight/controlFlow/PhpControlFlowImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstructions";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getEntryPoint";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getExitPoint";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3 -> new IllegalStateException(string);
        };
    }
}

