/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.codeInsight.controlFlow.instructions;

import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.RWAccess;
import org.jetbrains.annotations.NotNull;

public interface PhpAccessInstruction
extends PhpInstruction {
    @NotNull
    public PhpPsiElement getAnchor();

    @NotNull
    public Access getAccess();

    public static class ReadOrReadRefAccess
    extends Access.DefaultAccess {
        private final RWAccess myVariable;

        public ReadOrReadRefAccess(@NotNull RWAccess variable) {
            if (variable == null) {
                ReadOrReadRefAccess.$$$reportNull$$$0(0);
            }
            this.myVariable = variable;
        }

        @Override
        public boolean isReadRef() {
            return this.myVariable.isWriteAccess();
        }

        @Override
        public boolean isRead() {
            return !this.isReadRef();
        }

        public String toString() {
            return "READ_OR_READ_REF";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/jetbrains/php/codeInsight/controlFlow/instructions/PhpAccessInstruction$ReadOrReadRefAccess", "<init>"));
        }
    }

    public static interface Access {
        public static final Access WRITE_ACCESS = new DefaultAccess(){

            @Override
            public boolean isWrite() {
                return true;
            }

            public String toString() {
                return "WRITE";
            }
        };
        public static final Access WRITE_REF_ACCESS = new DefaultAccess(){

            @Override
            public boolean isWriteRef() {
                return true;
            }

            public String toString() {
                return "WRITE_REF";
            }
        };
        public static final Access READ_ACCESS = new DefaultAccess(){

            @Override
            public boolean isRead() {
                return true;
            }

            public String toString() {
                return "READ";
            }
        };
        public static final Access READ_REF_ACCESS = new DefaultAccess(){

            @Override
            public boolean isReadRef() {
                return true;
            }

            public String toString() {
                return "READ_REF";
            }
        };
        public static final Access READ_WRITE_ACCESS = new DefaultAccess(){

            @Override
            public boolean isRead() {
                return true;
            }

            @Override
            public boolean isWrite() {
                return true;
            }

            @Override
            public boolean isReadWrite() {
                return true;
            }

            public String toString() {
                return "READ_WRITE";
            }
        };
        public static final Access COMPACT_READ_ACCESS = new DefaultAccess(){

            @Override
            public boolean isLightRead() {
                return true;
            }

            public String toString() {
                return "COMPACT_STRING_READ";
            }
        };
        public static final Access LIGHT_READ_ACCESS = new DefaultAccess(){

            @Override
            public boolean isLightRead() {
                return true;
            }

            public String toString() {
                return "LIGHT_READ";
            }
        };
        public static final Access UNSET_ACCESS = new DefaultAccess(){

            @Override
            public boolean isUnset() {
                return true;
            }

            @Override
            public boolean isLightRead() {
                return true;
            }

            public String toString() {
                return "UNSET";
            }
        };
        public static final Access ISSET_ACCESS = new DefaultAccess(){

            @Override
            public boolean isLightRead() {
                return true;
            }

            public String toString() {
                return "ISSET";
            }
        };

        public boolean isRead();

        public boolean isWrite();

        public boolean isWriteRef();

        public boolean isReadRef();

        public boolean isReadWrite();

        public boolean isUnset();

        public boolean isLightRead();

        public static class DefaultAccess
        implements Access {
            @Override
            public boolean isRead() {
                return false;
            }

            @Override
            public boolean isWrite() {
                return false;
            }

            @Override
            public boolean isWriteRef() {
                return false;
            }

            @Override
            public boolean isReadRef() {
                return false;
            }

            @Override
            public boolean isReadWrite() {
                return false;
            }

            @Override
            public boolean isUnset() {
                return false;
            }

            @Override
            public boolean isLightRead() {
                return false;
            }
        }
    }
}

