/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.codeInsight.controlFlow.instructions.impl;

import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowBuilder;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpFinallyHostInstruction;
import com.jetbrains.php.lang.psi.elements.Function;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpInstructionImpl
extends UserDataHolderBase
implements PhpInstruction {
    @Nullable
    private Set<PhpInstruction> myAmbiguousConditionsInstructions = null;
    public int myNumber;
    @NotNull
    private final List<PhpInstruction> myPredecessors = new SmartList();
    private ReachabilityStatus myReachabilityStatus = null;
    private boolean myTerminatesAfterFinally;
    private PhpControlFlowBuilder.PhpSkippedLoopInstruction mySkipLoopPredecessor;
    @Nullable
    protected PsiElement myAnchor;
    @Nullable
    private Collection<Function> myClosuresAfter = null;
    private PhpFinallyHostInstruction myFinallyHostInstruction;

    protected PhpInstructionImpl(@Nullable PsiElement anchor) {
        this.myAnchor = anchor;
    }

    @Override
    public abstract void appendSuccessors(@NotNull Collection<PhpInstruction> var1);

    @Override
    @NotNull
    public final Collection<PhpInstruction> getPredecessors() {
        ProgressIndicatorProvider.checkCanceled();
        List<PhpInstruction> list = this.myPredecessors;
        if (list == null) {
            PhpInstructionImpl.$$$reportNull$$$0(0);
        }
        return list;
    }

    @Override
    public final int num() {
        return this.myNumber;
    }

    public void join(@NotNull PhpInstructionImpl instruction) {
        if (instruction == null) {
            PhpInstructionImpl.$$$reportNull$$$0(1);
        }
        if (instruction.myReachabilityStatus != ReachabilityStatus.UNKNOWN) {
            instruction.myReachabilityStatus = this.isUnreachable() ? ReachabilityStatus.UNREACHABLE : ReachabilityStatus.UNKNOWN;
        }
        instruction.getPredecessors().add(this);
    }

    public boolean isUnreachable() {
        return this.myReachabilityStatus == ReachabilityStatus.UNREACHABLE;
    }

    public void setTerminatesAfterFinally() {
        this.myTerminatesAfterFinally = true;
    }

    public boolean isTerminatesAfterFinally() {
        return this.myTerminatesAfterFinally;
    }

    public void setSkipLoopPredecessor(PhpControlFlowBuilder.PhpSkippedLoopInstruction instruction) {
        this.mySkipLoopPredecessor = instruction;
    }

    public PhpControlFlowBuilder.PhpSkippedLoopInstruction getSkipLoopPredecessor() {
        return this.mySkipLoopPredecessor;
    }

    public void addClosureAfter(Function function) {
        if (this.myClosuresAfter == null) {
            this.myClosuresAfter = new HashSet<Function>();
        }
        this.myClosuresAfter.add(function);
    }

    public Iterable<Function> getClosuresAfter() {
        return (Iterable)ObjectUtils.notNull(this.myClosuresAfter, Collections.emptySet());
    }

    public PhpFinallyHostInstruction getContainingBlockFinallyHostInstruction() {
        return this.myFinallyHostInstruction;
    }

    public void setFinallyHostInstruction(PhpFinallyHostInstruction finallyHostInstruction) {
        this.myFinallyHostInstruction = finallyHostInstruction;
    }

    public abstract void replaceSuccessor(@NotNull PhpInstructionImpl var1, @Nullable PhpInstructionImpl var2);

    @Override
    public boolean process(@NotNull PhpInstructionProcessor processor) {
        if (processor == null) {
            PhpInstructionImpl.$$$reportNull$$$0(2);
        }
        return processor.processInstruction(this);
    }

    public String toString() {
        StringBuilder builder2 = new StringBuilder();
        String preds = PhpInstructionImpl.getNumbers(this.getPredecessors(), this.myNumber - 1);
        if (preds == null) {
            preds = "";
        } else if (preds.isEmpty()) {
            preds = "-";
        }
        Collection<PhpInstruction> successors = this.getSuccessors();
        String succs = PhpInstructionImpl.getNumbers(successors, this.myNumber + 1);
        if (succs == null) {
            succs = "";
        } else if (succs.isEmpty()) {
            succs = "-";
        }
        builder2.append(String.format("p:%-5s s:%-5s %2s:", preds, succs, this.num()));
        return builder2.toString();
    }

    @NotNull
    public Collection<PhpInstruction> getSuccessors() {
        ArrayList<PhpInstruction> successors = new ArrayList<PhpInstruction>();
        this.appendSuccessors(successors);
        ArrayList<PhpInstruction> arrayList = successors;
        if (arrayList == null) {
            PhpInstructionImpl.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    private static String getNumbers(@NotNull Collection<PhpInstruction> predecessors, int i) {
        if (predecessors == null) {
            PhpInstructionImpl.$$$reportNull$$$0(4);
        }
        if (predecessors.size() == 1 && predecessors.iterator().next().num() == i) {
            return null;
        }
        StringBuilder builder2 = new StringBuilder();
        int[] predNums = new int[predecessors.size()];
        int curPred = 0;
        for (PhpInstruction predecessor : predecessors) {
            predNums[curPred] = predecessor.num();
            ++curPred;
        }
        Arrays.sort(predNums);
        for (int j = 0; j < predNums.length; ++j) {
            if (j != 0) {
                builder2.append(",");
            }
            builder2.append(predNums[j]);
        }
        return builder2.toString();
    }

    public Set<PhpInstruction> getAmbiguousConditionsInstructions() {
        return (Set)ObjectUtils.notNull(this.myAmbiguousConditionsInstructions, Collections.emptySet());
    }

    public void addAmbiguousInstructions(Collection<PhpInstruction> ambiguousInstructions) {
        if (this.myAmbiguousConditionsInstructions == null && !ambiguousInstructions.isEmpty()) {
            this.myAmbiguousConditionsInstructions = new HashSet<PhpInstruction>();
            this.myAmbiguousConditionsInstructions.addAll(ambiguousInstructions);
        }
    }

    @Override
    @Nullable
    public PsiElement getAnchor() {
        ProgressIndicatorProvider.checkCanceled();
        return this.myAnchor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/codeInsight/controlFlow/instructions/impl/PhpInstructionImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instruction";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predecessors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPredecessors";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/codeInsight/controlFlow/instructions/impl/PhpInstructionImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuccessors";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "join";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getNumbers";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 4 -> new IllegalArgumentException(string);
        };
    }

    private static enum ReachabilityStatus {
        UNREACHABLE,
        UNKNOWN;

    }
}

