/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.codeInsight.highlighting;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Consumer;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.codeInsight.highlighting.PhpHighlightUsagesHandlerBase;
import com.jetbrains.php.lang.inspections.PhpThrownExceptionsAnalyzer;
import com.jetbrains.php.lang.inspections.exception.PhpExceptionAnalysisService;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpHighlightExceptionsHandler
extends PhpHighlightUsagesHandlerBase<PsiElement> {
    private final PsiElement myTarget;
    private final PsiElement myScope;
    private final PhpType myExceptions;
    private final PhpType myExceptionsToFilter;

    public PhpHighlightExceptionsHandler(@NotNull Editor editor, @NotNull PsiFile file, @NotNull PsiElement target, @NotNull PsiElement scope, @NotNull PhpType exceptions, @NotNull PhpType exceptionsToFilter) {
        if (editor == null) {
            PhpHighlightExceptionsHandler.$$$reportNull$$$0(0);
        }
        if (file == null) {
            PhpHighlightExceptionsHandler.$$$reportNull$$$0(1);
        }
        if (target == null) {
            PhpHighlightExceptionsHandler.$$$reportNull$$$0(2);
        }
        if (scope == null) {
            PhpHighlightExceptionsHandler.$$$reportNull$$$0(3);
        }
        if (exceptions == null) {
            PhpHighlightExceptionsHandler.$$$reportNull$$$0(4);
        }
        if (exceptionsToFilter == null) {
            PhpHighlightExceptionsHandler.$$$reportNull$$$0(5);
        }
        super(editor, file);
        this.myTarget = target;
        this.myExceptions = exceptions;
        this.myExceptionsToFilter = exceptionsToFilter;
        this.myScope = scope;
    }

    @NotNull
    public List<PsiElement> getTargets() {
        List<PsiElement> list = Collections.singletonList(this.myTarget);
        if (list == null) {
            PhpHighlightExceptionsHandler.$$$reportNull$$$0(6);
        }
        return list;
    }

    protected void selectTargets(@NotNull List<? extends PsiElement> targets, @NotNull Consumer<? super List<? extends PsiElement>> selectionConsumer) {
        if (targets == null) {
            PhpHighlightExceptionsHandler.$$$reportNull$$$0(7);
        }
        if (selectionConsumer == null) {
            PhpHighlightExceptionsHandler.$$$reportNull$$$0(8);
        }
        selectionConsumer.consume(targets);
    }

    public void computeUsages(@NotNull List<? extends PsiElement> targets) {
        if (targets == null) {
            PhpHighlightExceptionsHandler.$$$reportNull$$$0(9);
        }
        this.addOccurrence(this.myTarget);
        PhpScopeHolder scopeHolder = PhpPsiUtil.getScopeHolder(this.myScope);
        if (scopeHolder != null) {
            Project project = scopeHolder.getProject();
            TextRange thrownRange = this.myScope.getTextRange();
            Set<Pair<TextRange, String>> rangeExceptions = PhpExceptionAnalysisService.getThrownExceptionsWithRanges(scopeHolder, thrownRange, thrownRange, false);
            Set exceptions = StreamEx.of(rangeExceptions).map(pair -> (String)pair.second).nonNull().toSet();
            Collection<String> filtered = PhpThrownExceptionsAnalyzer.filterNonThrowable(exceptions, project);
            PhpIndex index = PhpIndex.getInstance(project);
            for (Pair<TextRange, String> rangException : rangeExceptions) {
                String exception = (String)rangException.second;
                if (!filtered.contains(exception) || !this.shouldHighlight(new PhpType().add(exception), index)) continue;
                this.myReadUsages.add((TextRange)rangException.first);
            }
        }
    }

    private boolean shouldHighlight(@NotNull PhpType type, @NotNull PhpIndex index) {
        if (type == null) {
            PhpHighlightExceptionsHandler.$$$reportNull$$$0(10);
        }
        if (index == null) {
            PhpHighlightExceptionsHandler.$$$reportNull$$$0(11);
        }
        return !(!this.myExceptions.isAmbiguous() && !this.myExceptions.isConvertibleFrom(type, index) || !this.myExceptionsToFilter.isAmbiguous() && this.myExceptionsToFilter.isConvertibleFrom(type, index));
    }

    @Nullable
    public String getFeatureId() {
        return "codeassists.highlight.throws";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptions";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionsToFilter";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/codeInsight/highlighting/PhpHighlightExceptionsHandler";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targets";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectionConsumer";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/codeInsight/highlighting/PhpHighlightExceptionsHandler";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargets";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "selectTargets";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "computeUsages";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "shouldHighlight";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }
}

