/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.codeInsight.typeInference;

import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessFieldByVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpArrayAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpConditionInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpEntryPointInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpAccessInstructionImpl;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpConditionInstructionImpl;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpInstructionWithInversedEx;
import com.jetbrains.php.codeInsight.typeInference.PhpArrayAccessTypeDFAnalyzer;
import com.jetbrains.php.codeInsight.typeInference.PhpTypeAnalyzerProcessor;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.SelfAssignmentExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpArrayAccessTypeAnalyzer
extends PhpTypeAnalyzerProcessor {
    @Nullable
    private final PsiElement myKey;
    private boolean myFoundExactArrayIndexType;
    protected boolean myKeyChanged = false;
    private boolean myWrittenExactArrayIndexType = false;
    private final Collection<PhpInstructionWithInversedEx> myDFAStatesConditionInstructions = new HashSet<PhpInstructionWithInversedEx>();
    private final Collection<PhpInstructionWithInversedEx> myInverseDFAStatesConditionInstructions = new HashSet<PhpInstructionWithInversedEx>();

    public PhpArrayAccessTypeAnalyzer(@Nullable PsiElement key) {
        this.myKey = key;
    }

    @Override
    public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
        PhpAccessInstruction.Access access;
        if (!this.myKeyChanged && this.myKey instanceof Variable && PhpLangUtil.equalsVariableNames(instruction.getVariableName(), ((Variable)this.myKey).getName()) && ((access = instruction.getAccess()).isWrite() || access.isWriteRef() || ((PhpAccessInstructionImpl)((Object)instruction)).isReadOrReadRefAccessLocalAware())) {
            this.myKeyChanged = true;
        }
        return super.processAccessVariableInstruction(instruction);
    }

    @Override
    public boolean processAccessFieldByVariableInstruction(PhpAccessFieldByVariableInstruction instruction) {
        if (!this.myKeyChanged && this.myKey instanceof FieldReference && PhpPsiUtil.areElementsEquivalent((PsiElement)instruction.getAnchor(), this.myKey)) {
            this.myKeyChanged = true;
        }
        return super.processAccessFieldByVariableInstruction(instruction);
    }

    @Override
    public boolean processArrayAccessInstruction(PhpArrayAccessInstruction curInstruction) {
        if (this.isSameValue(curInstruction) && (curInstruction.getAccess().isWrite() || curInstruction.getAccess().isWriteRef())) {
            String literalKey = PhpArrayAccessTypeAnalyzer.getKey(curInstruction.getKey());
            String myLiteralKey = PhpArrayAccessTypeAnalyzer.getKey(this.myKey);
            if (literalKey != null && myLiteralKey != null && !PhpArrayAccessTypeAnalyzer.sameLiteralKeys(literalKey, myLiteralKey)) {
                return true;
            }
            this.processAccessInstruction(curInstruction);
            if (PhpArrayAccessTypeAnalyzer.sameArrayKeys(curInstruction.getKey(), this.myKey)) {
                if (!this.myFoundExactArrayIndexType) {
                    this.resetType();
                }
                this.myFoundExactArrayIndexType = true;
                this.myWrittenExactArrayIndexType = true;
                return this.processAccessInstruction(curInstruction);
            }
        }
        return true;
    }

    public static boolean sameArrayKeys(@Nullable PsiElement key, @Nullable PsiElement key1) {
        if (key == null || key1 == null) {
            return false;
        }
        return PhpArrayAccessTypeAnalyzer.sameLiteralKeys(PhpArrayAccessTypeAnalyzer.getKey(key1), PhpArrayAccessTypeAnalyzer.getKey(key)) || PhpPsiUtil.areElementsEquivalent(key, key1);
    }

    private static boolean sameLiteralKeys(@Nullable String key, @Nullable String key1) {
        return PhpLangUtil.equals(key, key1);
    }

    protected abstract boolean isSameValue(PhpArrayAccessInstruction var1);

    @Override
    public boolean processConditionInstruction(PhpConditionInstruction instruction) {
        PhpArrayAccessTypeDFAnalyzer analyzer = this.createAnalyzer(this.myKeyChanged ? null : this.myKey);
        PhpType type = (PhpType)analyzer.performDFA(instruction.getCondition(), instruction.getResult());
        if (!type.isEmpty()) {
            this.setType(type);
            ContainerUtil.addIfNotNull(this.myDFAStatesConditionInstructions, (Object)((PhpConditionInstructionImpl)instruction).getInverseInstruction());
            if (analyzer.foundExactArrayIndex() && !this.myInverseDFAStatesConditionInstructions.contains(instruction)) {
                this.myFoundExactArrayIndexType = true;
            }
            return !analyzer.completeTypeComputed();
        }
        ContainerUtil.addIfNotNull(this.myInverseDFAStatesConditionInstructions, (Object)((PhpConditionInstructionImpl)instruction).getInverseInstruction());
        if (this.myDFAStatesConditionInstructions.contains(instruction)) {
            this.setType(PhpType.MIXED);
        }
        return true;
    }

    protected boolean elementOverwritten(PhpAccessInstruction.Access access, PsiElement anchor) {
        SelfAssignmentExpression expression;
        return access.isWrite() && ((expression = (SelfAssignmentExpression)ObjectUtils.tryCast((Object)anchor.getParent(), SelfAssignmentExpression.class)) == null || expression.getVariable() != anchor);
    }

    @Override
    public boolean processEntryPointInstruction(PhpEntryPointInstruction instruction) {
        this.handlePreliminaryTraversalEnd();
        return super.processEntryPointInstruction(instruction);
    }

    protected void handlePreliminaryTraversalEnd() {
        if (this.myWrittenExactArrayIndexType) {
            this.myFoundExactArrayIndexType = false;
        }
    }

    @NotNull
    protected abstract PhpArrayAccessTypeDFAnalyzer createAnalyzer(@Nullable PsiElement var1);

    public boolean foundExactArrayIndexType() {
        return this.myFoundExactArrayIndexType;
    }

    @Nullable
    public static String getKey(@Nullable PsiElement value) {
        if (value == null) {
            return null;
        }
        return value instanceof ConstantReference ? ((ConstantReference)value).getName() : PhpCodeInsightUtil.toString(value);
    }
}

