/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.codeInsight.typeInference;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Range;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowBuilder;
import com.jetbrains.php.codeInsight.dataFlow.PhpConditionDFAnalyzer;
import com.jetbrains.php.codeInsight.dataFlow.type.PhpTypeConditionDFAnalyzer;
import com.jetbrains.php.codeInsight.typeInference.PhpAmbiguousCompositeTypeState;
import com.jetbrains.php.codeInsight.typeInference.PhpBitLogicalOpsVariableDfaState;
import com.jetbrains.php.codeInsight.typeInference.PhpCompositeTypeState;
import com.jetbrains.php.codeInsight.typeInference.PhpDfaBasedAnalyzerProcessor;
import com.jetbrains.php.codeInsight.typeInference.PhpDfaBasedTypeState;
import com.jetbrains.php.codeInsight.typeInference.PhpDfaDelegateBasedTypeState;
import com.jetbrains.php.codeInsight.typeInference.PhpDfaStateFromAssertionProvider;
import com.jetbrains.php.codeInsight.typeInference.PhpStrictVariableDfaState;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocMethod;
import com.jetbrains.php.lang.inspections.classes.PhpHierarchyChecksInspection;
import com.jetbrains.php.lang.inspections.controlFlow.constantCondition.PhpPreviousDfaBaseStateConditionDFAnalyzer;
import com.jetbrains.php.lang.inspections.controlFlow.constantCondition.PhpRangeCheckDfaBasedTypeState;
import com.jetbrains.php.lang.inspections.controlFlow.constantCondition.variable.PhpPreviousVariableDfaAnalyzerProcessor;
import com.jetbrains.php.lang.inspections.type.PhpExpressionAlwaysConstantEvaluator;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.ArrayCreationExpression;
import com.jetbrains.php.lang.psi.elements.ArrayHashElement;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.ClassConstantReference;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.ConcatenationExpression;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.MemberReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpDefine;
import com.jetbrains.php.lang.psi.elements.PhpEmpty;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpIsset;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.UnaryExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.ArrayCreationExpressionImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpExcludeTypeTP;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeAnalyserVisitor;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpDfaBaseStateConditionDFAnalyzer
extends PhpConditionDFAnalyzer<PhpVariableDfaState> {
    public static final PhpDfaBasedTypeState NOT_ISSET = new PhpDfaBasedTypeState("NOT_ISSET");
    public static final PhpDfaDelegateBasedTypeState.PhpNotNullByPrimitiveTypeChecker ALWAYS_BOOL = new PhpDfaDelegateBasedTypeState.PhpNotNullByPrimitiveTypeChecker("is_bool");
    public static final PhpDfaDelegateBasedTypeState STRICT_ALWAYS_TRUE = new PhpDfaDelegateBasedTypeState(PhpDfaDelegateBasedTypeState.NOT_FALSE_NOT_NULL.toString(), new PhpStrictVariableDfaState(PhpDfaDelegateBasedTypeState.NOT_FALSE_NOT_NULL), new PhpStrictVariableDfaState(PhpDfaDelegateBasedTypeState.NOT_FALSE_NOT_NULL), ALWAYS_BOOL);
    public static final PhpAmbiguousCompositeTypeState PROBABLY_FALSE = new PhpAmbiguousCompositeTypeState(new PhpDfaBasedTypeState[]{PhpCompositeTypeState.NULL, PhpCompositeTypeState.ALWAYS_FALSE}){

        @Override
        public PhpType applyType(PhpType type) {
            if (type.isEmpty() || type.hasUnresolved() || ContainerUtil.exists(type.getTypes(), t -> PhpType.isNotExtendablePrimitiveType(t) || PhpType.isArray(t) || PhpType.isPluralType(t))) {
                return type;
            }
            return PhpType.NULL;
        }
    };
    private static final PhpDfaBasedTypeState UNKNOWN_RANGE = new PhpDfaBasedTypeState("UNKNOWN RANGE");
    protected final boolean myGlobal;
    private final boolean myStopOnNegations;
    protected boolean myTryToCreateIntRangeState = true;
    private boolean myAmbiguousCompositeState = false;

    public PhpDfaBaseStateConditionDFAnalyzer(boolean global, boolean stopOnNegations) {
        this.myGlobal = global;
        this.myStopOnNegations = stopOnNegations;
    }

    public void setTryToCreateIntRangeState(boolean tryToCreateIntRangeState) {
        this.myTryToCreateIntRangeState = tryToCreateIntRangeState;
    }

    public void setAmbiguousCompositeState() {
        this.myAmbiguousCompositeState = true;
    }

    public static boolean isNotNullByPrimitiveTypeCheckers(@NotNull FunctionReference condition) {
        String name;
        if (condition == null) {
            PhpDfaBaseStateConditionDFAnalyzer.$$$reportNull$$$0(0);
        }
        return StringUtil.equalsIgnoreCase((CharSequence)(name = condition.getName()), (CharSequence)"is_object") || StringUtil.equalsIgnoreCase((CharSequence)name, (CharSequence)"is_countable") || StringUtil.equalsIgnoreCase((CharSequence)name, (CharSequence)"is_iterable") || StringUtil.equalsIgnoreCase((CharSequence)name, (CharSequence)"is_callable") || StringUtil.equalsIgnoreCase((CharSequence)name, (CharSequence)"is_resource") || name != null && PhpTypeConditionDFAnalyzer.getTypeFromPrimitiveTypeChecker(name) != null;
    }

    @Override
    @NotNull
    public PhpVariableDfaState performDFA(@Nullable PsiElement condition, boolean result) {
        PhpVariableDfaState arrayAccessState;
        if (condition instanceof BinaryExpression) {
            BinaryExpression binaryExpression = (BinaryExpression)condition;
            IElementType operationType = binaryExpression.getOperationType();
            if (operationType == PhpTokenTypes.opNOT_EQUAL || operationType == PhpTokenTypes.opNOT_IDENTICAL || operationType == PhpTokenTypes.opEQUAL || operationType == PhpTokenTypes.opIDENTICAL) {
                PsiElement right = binaryExpression.getRightOperand();
                PsiElement left = binaryExpression.getLeftOperand();
                PhpVariableDfaState stateFromNullGuard = this.computeStateFromConditionalGuard(left, right, operationType, result);
                if (stateFromNullGuard != null) {
                    PhpVariableDfaState phpVariableDfaState = stateFromNullGuard;
                    if (phpVariableDfaState == null) {
                        PhpDfaBaseStateConditionDFAnalyzer.$$$reportNull$$$0(1);
                    }
                    return phpVariableDfaState;
                }
                PhpVariableDfaState flippedStateFromNullGuard = this.computeStateFromConditionalGuard(right, left, operationType, result);
                if (flippedStateFromNullGuard != null) {
                    PhpVariableDfaState phpVariableDfaState = flippedStateFromNullGuard;
                    if (phpVariableDfaState == null) {
                        PhpDfaBaseStateConditionDFAnalyzer.$$$reportNull$$$0(2);
                    }
                    return phpVariableDfaState;
                }
            } else if (operationType == PhpTokenTypes.kwINSTANCEOF) {
                PhpDfaBasedTypeState state;
                PsiElement left = binaryExpression.getLeftOperand();
                if (this.needToProcessElement(left) && (state = this.getInstanceofTypeState(binaryExpression, result)) != null) {
                    PhpVariableDfaState phpVariableDfaState = this.createState(left, state);
                    if (phpVariableDfaState == null) {
                        PhpDfaBaseStateConditionDFAnalyzer.$$$reportNull$$$0(3);
                    }
                    return phpVariableDfaState;
                }
            } else if (operationType == PhpTokenTypes.opBIT_AND || operationType == PhpTokenTypes.opBIT_OR) {
                PhpVariableDfaState state = (PhpVariableDfaState)((Object)super.performDFA((PsiElement)condition, result));
                return new PhpVariableDfaState(state.getVariableName(), new PhpBitLogicalOpsVariableDfaState((PhpDfaBasedTypeState)state.getState()));
            }
        } else {
            FunctionReference possibleAssertion;
            if (condition instanceof PhpIsset) {
                PhpVariableDfaState phpVariableDfaState = StreamEx.of((Object[])((PhpIsset)condition).getVariables()).map(e -> this.createIssetDFAState((PsiElement)e, result)).reduce((s, s1) -> this.and((PhpVariableDfaState)((Object)s), (PhpVariableDfaState)((Object)s1), result)).orElseGet(this::getEmpty);
                if (phpVariableDfaState == null) {
                    PhpDfaBaseStateConditionDFAnalyzer.$$$reportNull$$$0(4);
                }
                return phpVariableDfaState;
            }
            if (condition instanceof FunctionReference && StringUtil.equalsIgnoreCase((CharSequence)((FunctionReference)condition).getName(), (CharSequence)"is_null")) {
                PhpVariableDfaState state;
                parameter = ((FunctionReference)condition).getParameter(0);
                if (parameter instanceof PhpTypedElement && (state = this.computeNullabilityState(parameter, !result)) != null) {
                    PhpVariableDfaState phpVariableDfaState = PhpDfaBaseStateConditionDFAnalyzer.updateStrict(state, true);
                    if (phpVariableDfaState == null) {
                        PhpDfaBaseStateConditionDFAnalyzer.$$$reportNull$$$0(5);
                    }
                    return phpVariableDfaState;
                }
            } else if ((result || this.myStopOnNegations) && condition instanceof FunctionReference && PhpLangUtil.equalsFunctionNames("in_array", ((FunctionReference)condition).getName())) {
                state = this.createCompositeStateFromInArrayCall((FunctionReference)condition, result);
                if (state != null) {
                    PhpVariableDfaState phpVariableDfaState = state;
                    if (phpVariableDfaState == null) {
                        PhpDfaBaseStateConditionDFAnalyzer.$$$reportNull$$$0(6);
                    }
                    return phpVariableDfaState;
                }
            } else if (condition instanceof FunctionReference && (result || this.myStopOnNegations && !PhpLangUtil.equalsFunctionNames(((FunctionReference)condition).getName(), "is_numeric")) && PhpDfaBaseStateConditionDFAnalyzer.isNotNullByPrimitiveTypeCheckers((FunctionReference)condition)) {
                PhpDfaBasedTypeState nullabilityState;
                parameter = ((FunctionReference)condition).getParameter(0);
                if (parameter != null && this.needToProcessElement(parameter) && (nullabilityState = PhpDfaBaseStateConditionDFAnalyzer.createNotNullByPrimitiveTypeCheckerState(Objects.requireNonNull(((FunctionReference)condition).getName()), result)) != null) {
                    PhpVariableDfaState phpVariableDfaState = this.createState(parameter, nullabilityState);
                    if (phpVariableDfaState == null) {
                        PhpDfaBaseStateConditionDFAnalyzer.$$$reportNull$$$0(7);
                    }
                    return phpVariableDfaState;
                }
            } else if (condition instanceof PhpEmpty) {
                PhpExpression elementToCheckType = (PhpExpression)ContainerUtil.find((Object[])((PhpEmpty)condition).getVariables(), this::needToProcessElement);
                if (elementToCheckType != null) {
                    if (!result) {
                        PhpVariableDfaState phpVariableDfaState = this.createState((PsiElement)elementToCheckType, PhpCompositeTypeState.NOT_EMPTY_CHECK);
                        if (phpVariableDfaState == null) {
                            PhpDfaBaseStateConditionDFAnalyzer.$$$reportNull$$$0(8);
                        }
                        return phpVariableDfaState;
                    }
                    if (this.myStopOnNegations) {
                        PhpVariableDfaState phpVariableDfaState = this.createState((PsiElement)elementToCheckType, PhpPreviousDfaBaseStateConditionDFAnalyzer.EMPTY_CHECK_STATE);
                        if (phpVariableDfaState == null) {
                            PhpDfaBaseStateConditionDFAnalyzer.$$$reportNull$$$0(9);
                        }
                        return phpVariableDfaState;
                    }
                }
            } else if (condition instanceof FunctionReference && (PhpControlFlowBuilder.isSupportedBuiltInAssertion(possibleAssertion = (FunctionReference)condition) || PhpDfaBaseStateConditionDFAnalyzer.isSupportedThirdPartyAssertion(possibleAssertion))) {
                state = this.computeStateFromAssertion(possibleAssertion, result);
                if (state != null) {
                    PhpVariableDfaState phpVariableDfaState = state;
                    if (phpVariableDfaState == null) {
                        PhpDfaBaseStateConditionDFAnalyzer.$$$reportNull$$$0(10);
                    }
                    return phpVariableDfaState;
                }
            } else if (this.needToProcessElement((PsiElement)condition)) {
                BinaryExpression binary;
                PsiElement state;
                boolean coalesceCondition = condition != null && (state = condition.getParent()) instanceof BinaryExpression && PhpPsiUtil.isOfType((binary = (BinaryExpression)state).getOperation(), PhpTokenTypes.opCOALESCE) && binary.getLeftOperand() == condition;
                PhpDfaBasedTypeState trueVariant = coalesceCondition ? PhpStrictVariableDfaState.ISSET : PhpDfaDelegateBasedTypeState.NOT_FALSE_NOT_NULL;
                PhpDfaBasedTypeState falseVariant = coalesceCondition ? NOT_ISSET : PROBABLY_FALSE;
                PhpVariableDfaState phpVariableDfaState = this.createState((PsiElement)condition, result ? trueVariant : falseVariant);
                if (phpVariableDfaState == null) {
                    PhpDfaBaseStateConditionDFAnalyzer.$$$reportNull$$$0(11);
                }
                return phpVariableDfaState;
            }
        }
        if (result && (arrayAccessState = this.tryCreateArrayAccessExistenceCheck((PsiElement)condition)) != null) {
            PhpVariableDfaState phpVariableDfaState = arrayAccessState;
            if (phpVariableDfaState == null) {
                PhpDfaBaseStateConditionDFAnalyzer.$$$reportNull$$$0(12);
            }
            return phpVariableDfaState;
        }
        while (condition instanceof AssignmentExpression) {
            PhpPsiElement variable = ((AssignmentExpression)condition).getVariable();
            if (this.needToProcessElement((PsiElement)variable)) {
                PhpVariableDfaState phpVariableDfaState = this.createState((PsiElement)variable, result ? PhpDfaDelegateBasedTypeState.NOT_FALSE_NOT_NULL : PROBABLY_FALSE);
                if (phpVariableDfaState == null) {
                    PhpDfaBaseStateConditionDFAnalyzer.$$$reportNull$$$0(13);
                }
                return phpVariableDfaState;
            }
            condition = ((AssignmentExpression)condition).getValue();
        }
        PhpVariableDfaState phpVariableDfaState = (PhpVariableDfaState)((Object)super.performDFA((PsiElement)condition, result));
        if (phpVariableDfaState == null) {
            PhpDfaBaseStateConditionDFAnalyzer.$$$reportNull$$$0(14);
        }
        return phpVariableDfaState;
    }

    public static boolean isSupportedThirdPartyAssertion(@NotNull FunctionReference functionReference) {
        if (functionReference == null) {
            PhpDfaBaseStateConditionDFAnalyzer.$$$reportNull$$$0(15);
        }
        return !PhpDfaStateFromAssertionProvider.getSupportedProviders(functionReference).isEmpty();
    }

    @Nullable
    private PhpVariableDfaState computeStateFromAssertion(@NotNull FunctionReference assertion, boolean result) {
        if (assertion == null) {
            PhpDfaBaseStateConditionDFAnalyzer.$$$reportNull$$$0(16);
        }
        if (PhpControlFlowBuilder.isSupportedBuiltInAssertion(assertion)) {
            PsiElement left = assertion.getParameter(0);
            return this.performDFA(left, result);
        }
        return StreamEx.of(PhpDfaStateFromAssertionProvider.getSupportedProviders(assertion)).map(p -> p.computeState(assertion, this, result)).findFirst(s -> s != null).orElse(null);
    }

    @Nullable
    private PhpVariableDfaState createCompositeStateFromInArrayCall(FunctionReference condition, boolean result) {
        ArrayCreationExpression array;
        PsiElement parameter = condition.getParameter(0);
        if (parameter != null && this.needToProcessElement(parameter) && (array = (ArrayCreationExpression)ObjectUtils.tryCast((Object)condition.getParameter(1), ArrayCreationExpression.class)) != null) {
            boolean strict = PhpLangUtil.isTrue(condition.getParameter(2));
            PhpDfaBasedTypeState[] states = (PhpDfaBasedTypeState[])((StreamEx)StreamEx.of((Stream)ArrayCreationExpressionImpl.children(array).stream()).map(PhpDfaBaseStateConditionDFAnalyzer::getArrayElement).map(e -> this.getPrimitiveTypeCheckState((PsiElement)e, !result, strict)).filter(Objects::nonNull)).toArray(PhpDfaBasedTypeState.class);
            if (states.length > 0) {
                return this.createState(parameter, result ? new PhpAmbiguousCompositeTypeState(states) : new PhpDfaDelegateBasedTypeState("IN_ARRAY", states));
            }
        }
        return null;
    }

    @Nullable
    private static PhpPsiElement getArrayElement(PhpPsiElement c) {
        return c instanceof ArrayHashElement ? ((ArrayHashElement)c).getValue() : c.getFirstPsiChild();
    }

    @Nullable
    public static PhpDfaBasedTypeState createNotNullByPrimitiveTypeCheckerState(@NotNull String name, boolean result) {
        if (name == null) {
            PhpDfaBaseStateConditionDFAnalyzer.$$$reportNull$$$0(17);
        }
        if (!result) {
            PhpTypeConditionDFAnalyzer.PhpTypeContract contract = PhpTypeConditionDFAnalyzer.getTypeFromPrimitiveTypeChecker(name);
            return contract != null ? new PhpPrimitiveTypeExclusionState(contract.getType(), name) : null;
        }
        return PhpDfaBaseStateConditionDFAnalyzer.createNotNullByPrimitiveTypeCheckerState(name);
    }

    @NotNull
    public static PhpDfaBasedTypeState createNotNullByPrimitiveTypeCheckerState(@NotNull String name) {
        if (name == null) {
            PhpDfaBaseStateConditionDFAnalyzer.$$$reportNull$$$0(18);
        }
        if (PhpLangUtil.equalsFunctionNames("is_array", name)) {
            PhpDfaDelegateBasedTypeState.PhpNotNullByPrimitiveTypeChecker phpNotNullByPrimitiveTypeChecker = PhpDfaDelegateBasedTypeState.PhpNotNullByPrimitiveTypeChecker.IS_ARRAY_CHECK;
            if (phpNotNullByPrimitiveTypeChecker == null) {
                PhpDfaBaseStateConditionDFAnalyzer.$$$reportNull$$$0(19);
            }
            return phpNotNullByPrimitiveTypeChecker;
        }
        if (PhpLangUtil.equalsFunctionNames("is_callable", name)) {
            PhpDfaDelegateBasedTypeState.PhpNotNullByPrimitiveTypeChecker phpNotNullByPrimitiveTypeChecker = PhpDfaDelegateBasedTypeState.PhpNotNullByPrimitiveTypeChecker.IS_CALLABLE_CHECK;
            if (phpNotNullByPrimitiveTypeChecker == null) {
                PhpDfaBaseStateConditionDFAnalyzer.$$$reportNull$$$0(20);
            }
            return phpNotNullByPrimitiveTypeChecker;
        }
        if (PhpLangUtil.equalsFunctionNames("is_object", name)) {
            PhpDfaBasedTypeState phpDfaBasedTypeState = PhpDfaDelegateBasedTypeState.NOT_PRIMITIVE;
            if (phpDfaBasedTypeState == null) {
                PhpDfaBaseStateConditionDFAnalyzer.$$$reportNull$$$0(21);
            }
            return phpDfaBasedTypeState;
        }
        if (PhpLangUtil.equalsFunctionNames("is_iterable", name)) {
            PhpDfaBasedTypeState phpDfaBasedTypeState = PhpDfaDelegateBasedTypeState.PhpNotNullByPrimitiveTypeChecker.IS_ITERABLE_CHECK;
            if (phpDfaBasedTypeState == null) {
                PhpDfaBaseStateConditionDFAnalyzer.$$$reportNull$$$0(22);
            }
            return phpDfaBasedTypeState;
        }
        return new PhpDfaDelegateBasedTypeState.PhpNotNullByPrimitiveTypeChecker(name);
    }

    @Nullable
    protected PhpDfaBasedTypeState getInstanceofTypeState(BinaryExpression binaryExpression, boolean result) {
        return result ? PhpDfaBaseStateConditionDFAnalyzer.getInstanceofTypeState(binaryExpression.getProject(), (ClassReference)ObjectUtils.tryCast((Object)binaryExpression.getRightOperand(), ClassReference.class), this.myGlobal) : null;
    }

    public static @NotNull PhpDfaDelegateBasedTypeState.PhpInstanceofTypeState getInstanceofTypeState(Project project, @Nullable ClassReference classReference, boolean global) {
        String fqnToCheck = classReference != null ? classReference.getSignature().substring(2) : null;
        PhpDfaDelegateBasedTypeState.PhpInstanceofTypeState phpInstanceofTypeState = PhpDfaDelegateBasedTypeState.PhpInstanceofTypeState.createInstance(project, fqnToCheck, global);
        if (phpInstanceofTypeState == null) {
            PhpDfaBaseStateConditionDFAnalyzer.$$$reportNull$$$0(23);
        }
        return phpInstanceofTypeState;
    }

    @NotNull
    public PhpVariableDfaState createState(PsiElement element, PhpDfaBasedTypeState state) {
        return new PhpVariableDfaState((CharSequence)((Variable)element).getName(), state);
    }

    @Override
    @Nullable
    protected PhpVariableDfaState performDFAFromBooleanComparison(PsiElement left, PsiElement right, IElementType operationType, boolean result) {
        if (PhpDfaBaseStateConditionDFAnalyzer.strictComparisonWithTrue(right, operationType, result)) {
            return null;
        }
        return (PhpVariableDfaState)((Object)super.performDFAFromBooleanComparison(left, right, operationType, result));
    }

    public static boolean strictComparisonWithTrue(PsiElement right, IElementType operationType, boolean result) {
        return (operationType == PhpTokenTypes.opNOT_IDENTICAL || operationType == PhpTokenTypes.opIDENTICAL) && EQUALITY_TOKENS.contains(operationType) != result && PhpLangUtil.isTrue(right);
    }

    private PhpVariableDfaState createIssetDFAState(PsiElement elementToCheckType, boolean result) {
        PhpVariableDfaState arrayAccessState;
        if (this.needToProcessElement(elementToCheckType)) {
            PhpDfaBasedTypeState nullabilityState = result ? PhpStrictVariableDfaState.ISSET : NOT_ISSET;
            return this.createState(elementToCheckType, nullabilityState);
        }
        if (result && (arrayAccessState = this.tryCreateArrayAccessExistenceCheck(elementToCheckType)) != null) {
            return arrayAccessState;
        }
        return this.getEmpty();
    }

    @Nullable
    protected PhpVariableDfaState tryCreateArrayAccessExistenceCheck(PsiElement elementToCheckType) {
        if (this.myStopOnNegations && this.tryUnwrapArrayAccessExistenceCheck()) {
            while (elementToCheckType instanceof ArrayAccessExpression) {
                elementToCheckType = ((ArrayAccessExpression)elementToCheckType).getValue();
            }
            if (this.needToProcessElement((PsiElement)elementToCheckType)) {
                return this.createState((PsiElement)elementToCheckType, PhpDfaDelegateBasedTypeState.NOT_FALSE_NOT_NULL);
            }
        }
        return null;
    }

    protected boolean tryUnwrapArrayAccessExistenceCheck() {
        return false;
    }

    @Override
    protected PhpVariableDfaState computeStateFromConditionalGuard(PsiElement left, PsiElement right, IElementType operationType, boolean result) {
        Object state;
        boolean strict;
        if ((operationType == PhpTokenTypes.opIDENTICAL || operationType == PhpTokenTypes.opEQUAL) == result) {
            String className;
            PsiElement getClassTarget = PhpTypeConditionDFAnalyzer.getGetClassTarget(left);
            String string = className = this.needToProcessElement(getClassTarget) ? PhpTypeConditionDFAnalyzer.inferClassName(right) : null;
            if (className != null) {
                return this.createState(getClassTarget, PhpClassEqualToState.createClassEqualInstance(right.getProject(), className, this.myGlobal));
            }
        }
        if (!this.needToProcessElement(left)) {
            return (PhpVariableDfaState)((Object)super.computeStateFromConditionalGuard(left, right, operationType, result));
        }
        boolean notEqualCheck = operationType == PhpTokenTypes.opNOT_EQUAL || operationType == PhpTokenTypes.opNOT_IDENTICAL;
        boolean negatedCheck = notEqualCheck == result;
        boolean bl = strict = operationType == PhpTokenTypes.opNOT_IDENTICAL || operationType == PhpTokenTypes.opIDENTICAL;
        if (PhpLangUtil.isNull(right)) {
            PhpDfaBasedTypeState nullabilityState = negatedCheck ? (strict ? PhpCompositeTypeState.NOT_NULL : PhpDfaDelegateBasedTypeState.NOT_FALSE_NOT_NULL) : (strict ? PhpCompositeTypeState.NULL : PROBABLY_FALSE);
            return PhpDfaBaseStateConditionDFAnalyzer.updateStrict(this.createState(left, nullabilityState), strict);
        }
        if (PhpLangUtil.isFalse(right) && (state = this.createFalseComparisonState(left, negatedCheck, strict)) != null) {
            return state;
        }
        if (!negatedCheck || this.myStopOnNegations && this.myGlobal) {
            if (!negatedCheck && PhpLangUtil.isTrue(right)) {
                state = strict ? STRICT_ALWAYS_TRUE : PhpDfaDelegateBasedTypeState.NOT_FALSE_NOT_NULL;
                return this.createState(left, (PhpDfaBasedTypeState)state);
            }
            state = this.getPrimitiveTypeCheckState(right, negatedCheck, strict);
            if (state != null) {
                return this.createState(left, (PhpDfaBasedTypeState)state);
            }
        }
        return (PhpVariableDfaState)((Object)super.computeStateFromConditionalGuard(left, right, operationType, result));
    }

    @Nullable
    protected PhpVariableDfaState createFalseComparisonState(PsiElement left, boolean negatedCheck, boolean strict) {
        if (negatedCheck) {
            PhpDfaBasedTypeState state = strict ? PhpCompositeTypeState.NOT_FALSE : PhpDfaDelegateBasedTypeState.NOT_FALSE_NOT_NULL;
            return PhpDfaBaseStateConditionDFAnalyzer.updateStrict(this.createState(left, state), strict);
        }
        return null;
    }

    @Nullable
    public PhpDfaBasedTypeState getPrimitiveTypeCheckState(PsiElement right, boolean negatedCheck, boolean strict) {
        return this.doGetPrimitiveTypeCheckState(right, negatedCheck, strict);
    }

    @Nullable
    public static PhpDfaBasedTypeState getIntBoundRangesState(@Nullable PsiElement element, boolean global) {
        return global ? PhpDfaBaseStateConditionDFAnalyzer.getIntBoundRangesState(PhpType.global(element)) : null;
    }

    @Nullable
    public static PhpDfaBasedTypeState getIntBoundRangesState(@NotNull PhpType type) {
        Set states;
        if (type == null) {
            PhpDfaBaseStateConditionDFAnalyzer.$$$reportNull$$$0(24);
        }
        if (!(states = StreamEx.of(type.getTypesWithParametrisedParts()).map(PhpType::getIntRangeBounds).map(PhpDfaBaseStateConditionDFAnalyzer::createRangeState).toSet()).isEmpty() && !states.contains(UNKNOWN_RANGE)) {
            PhpDfaBasedTypeState onlyState = (PhpDfaBasedTypeState)ContainerUtil.getOnlyItem((Collection)states);
            return onlyState != null ? onlyState : new PhpAmbiguousCompositeTypeState(states.toArray(PhpCompositeTypeState.EMPTY_ARRAY));
        }
        return null;
    }

    @NotNull
    public static PhpDfaBasedTypeState createRangeState(@Nullable Range<Integer> range) {
        if (range == null) {
            PhpDfaBasedTypeState phpDfaBasedTypeState = UNKNOWN_RANGE;
            if (phpDfaBasedTypeState == null) {
                PhpDfaBaseStateConditionDFAnalyzer.$$$reportNull$$$0(25);
            }
            return phpDfaBasedTypeState;
        }
        PhpRangeCheckDfaBasedTypeState.PhpIntRangeCheckDfaBasedTypeState l = new PhpRangeCheckDfaBasedTypeState.PhpIntRangeCheckDfaBasedTypeState(PhpRangeCheckDfaBasedTypeState.Operand.GREATER_EQ, (Integer)range.getFrom());
        PhpRangeCheckDfaBasedTypeState.PhpIntRangeCheckDfaBasedTypeState r = new PhpRangeCheckDfaBasedTypeState.PhpIntRangeCheckDfaBasedTypeState(PhpRangeCheckDfaBasedTypeState.Operand.LOWER_EQ, (Integer)range.getTo());
        return new PhpDfaDelegateBasedTypeState("Range", l, r);
    }

    @Nullable
    private PhpDfaBasedTypeState doGetPrimitiveTypeCheckState(PsiElement right, boolean negatedCheck, boolean strict) {
        Collection<String> primitiveTypeCheckerTypeFromName;
        boolean isScalar;
        PhpDfaBasedTypeState state;
        if (this.myGlobal && right instanceof FunctionReference && strict && !negatedCheck && (state = PhpDfaBaseStateConditionDFAnalyzer.tryCreateStateFromFunctionCall((FunctionReference)right)) != null) {
            return new PhpFunctionCallDfaState(state, (FunctionReference)right);
        }
        Pair scalar = PhpDfaBaseStateConditionDFAnalyzer.getTypeFromIdentityCheckOnScalar(right, this.myGlobal);
        boolean bl = isScalar = (!(scalar.second instanceof UnaryExpression) || PhpDfaBaseStateConditionDFAnalyzer.isUnaryNumber((PsiElement)scalar.second)) && !(scalar.second instanceof ConcatenationExpression) && !(scalar.second instanceof ConstantReference) && !(scalar.second instanceof ClassConstantReference);
        if (isScalar && ((PhpType)scalar.first).isEmpty() && PhpExpressionAlwaysConstantEvaluator.ConstantValue.fromValue(right, this.myGlobal) != PhpExpressionAlwaysConstantEvaluator.ConstantValue.UNKNOWN) {
            scalar = Pair.create((Object)PhpType.BOOLEAN, (Object)right);
            isScalar = false;
        }
        if (!(primitiveTypeCheckerTypeFromName = PhpTypeConditionDFAnalyzer.getPrimitiveTypeCheckerTypeFromName((PhpType)scalar.first)).isEmpty()) {
            PhpDfaDelegateBasedTypeState.PhpPrimitiveTypeCheckOperandPsiBasedDescriptor operandDescriptor = scalar.second != null ? new PhpDfaDelegateBasedTypeState.PhpPrimitiveTypeCheckOperandPsiBasedDescriptor((PsiElement)scalar.second) : null;
            return strict ? new PhpDfaDelegateBasedTypeState.PhpPrimitiveTypeCheckByStrictComparison(primitiveTypeCheckerTypeFromName, operandDescriptor, negatedCheck, isScalar) : new PhpDfaDelegateBasedTypeState.PhpPrimitiveTypeCheckByComparison(primitiveTypeCheckerTypeFromName, operandDescriptor, negatedCheck, isScalar);
        }
        return null;
    }

    @Nullable
    private static PhpDfaBasedTypeState tryCreateStateFromFunctionCall(@NotNull FunctionReference right) {
        PhpDfaDelegateBasedTypeState state;
        boolean isMaxCall;
        if (right == null) {
            PhpDfaBaseStateConditionDFAnalyzer.$$$reportNull$$$0(26);
        }
        if (((isMaxCall = PhpCodeInsightUtil.isGlobalFunctionCallWithName(right, "max")) || PhpCodeInsightUtil.isGlobalFunctionCallWithName(right, "min")) && (state = PhpDfaBaseStateConditionDFAnalyzer.tryCreateStateFromMinMaxCall(right, isMaxCall)) != null) {
            return state;
        }
        if (right instanceof MemberReference && new PhpType().add((PsiElement)((MemberReference)((Object)right)).getClassReference()).global(right.getProject()).isAmbiguous()) {
            return null;
        }
        Collection functions = right.multiResolveStrict(Function.class);
        if (ContainerUtil.exists((Iterable)functions, f -> f instanceof PhpDocMethod)) {
            return null;
        }
        PhpType type = functions.stream().map(PhpDfaBaseStateConditionDFAnalyzer::getLargestPossibleDeclaredType).reduce(new PhpType(), PhpType::add);
        return PhpDfaBaseStateConditionDFAnalyzer.createCompositeTypeFromReferenceResolvedType(right, type);
    }

    @Nullable
    public static PhpDfaBasedTypeState createCompositeTypeFromReferenceResolvedType(@NotNull PhpReference reference, PhpType type) {
        if (reference == null) {
            PhpDfaBaseStateConditionDFAnalyzer.$$$reportNull$$$0(27);
        }
        if (!type.isEmpty() && reference instanceof MemberReference && ((MemberReference)reference).hasNullSafeDereference()) {
            type.add(PhpType.NULL);
        }
        return PhpPreviousVariableDfaAnalyzerProcessor.creteCompositeState(type.getTypes(), Stream.empty());
    }

    private static PhpType getLargestPossibleDeclaredType(Function f) {
        if (f instanceof Method && PhpHierarchyChecksInspection.hasTentativeReturnTypeAttribute((Method)f) && !PhpLanguageLevel.current((Project)f.getProject()).isAtLeast(PhpLanguageLevel.PHP810)) {
            return PhpType.MIXED;
        }
        if (f instanceof Method && ((Method)f).isAbstract() && f.getDeclaredType().isEmpty()) {
            PhpType type = new PhpType();
            Ref noTypeInOverridingMethodExists = new Ref((Object)false);
            PhpClassHierarchyUtils.processOverridingMethods((Method)f, (method, subClass, baseClass) -> {
                PhpType overridingType = method.getDeclaredType().global(f.getProject());
                if (overridingType.isEmpty() && !method.isAbstract()) {
                    noTypeInOverridingMethodExists.set((Object)true);
                    return false;
                }
                type.add(overridingType);
                return true;
            });
            return (Boolean)noTypeInOverridingMethodExists.get() != false || type.isEmpty() ? PhpType.MIXED : type;
        }
        PhpType type = f.getDeclaredType().global(f.getProject());
        return type.isEmpty() ? PhpType.MIXED : type;
    }

    @Nullable
    private static PhpDfaDelegateBasedTypeState tryCreateStateFromMinMaxCall(@NotNull FunctionReference right, boolean isMaxCall) {
        if (right == null) {
            PhpDfaBaseStateConditionDFAnalyzer.$$$reportNull$$$0(28);
        }
        IElementType token = isMaxCall ? PhpTokenTypes.opGREATER_OR_EQUAL : PhpTokenTypes.opLESS_OR_EQUAL;
        PsiElement[] parameters = right.getParameters();
        Stream<Object> arguments = parameters.length == 1 && parameters[0] instanceof ArrayCreationExpressionImpl ? ((ArrayCreationExpressionImpl)parameters[0]).values() : Stream.of(parameters);
        PhpDfaBasedTypeState[] states = (PhpRangeCheckDfaBasedTypeState[])((StreamEx)StreamEx.of(arguments).map(a -> PhpRangeCheckDfaBasedTypeState.tryToCreate(a, token, true, true)).filter(Objects::nonNull)).toArray(PhpRangeCheckDfaBasedTypeState.class);
        return states.length > 0 ? new PhpDfaDelegateBasedTypeState((isMaxCall ? "max" : "min") + " call", states) : null;
    }

    public static Pair<PhpType, PsiElement> getTypeFromIdentityCheckOnScalar(PsiElement element, boolean global) {
        PhpType type;
        if (element instanceof UnaryExpression && !(type = PhpTypeAnalyserVisitor.getCastOperationType(PsiUtilCore.getElementType((PsiElement)((UnaryExpression)element).getOperation()))).isEmpty()) {
            return Pair.create((Object)type, (Object)element);
        }
        if (element instanceof PhpExpression && (element instanceof ConcatenationExpression || PhpPsiUtil.isOfType(element, PhpElementTypes.SCALARS) || PhpDfaBaseStateConditionDFAnalyzer.isUnaryNumber(element) || PhpLangUtil.isTrue(element) || PhpLangUtil.isFalse(element) || global && PhpDfaBaseStateConditionDFAnalyzer.isStaticConstantReference(element, true))) {
            return Pair.create((Object)((PhpExpression)element).getGlobalType(), (Object)element);
        }
        if (element instanceof ArrayCreationExpression) {
            return Pair.create((Object)PhpType.ARRAY, (Object)element);
        }
        return Pair.create((Object)PhpType.EMPTY, null);
    }

    private static boolean isUnaryNumber(PsiElement element) {
        UnaryExpression unary;
        return element instanceof UnaryExpression && PhpPsiUtil.isOfType((unary = (UnaryExpression)element).getOperation(), PhpTokenTypes.opMINUS) && PhpPsiUtil.isOfType((PsiElement)unary.getValue(), PhpElementTypes.NUMBER);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isStaticConstantReference(PsiElement element, boolean global) {
        if (element instanceof ClassConstantReference && ((ClassConstantReference)element).getClassReference() instanceof ClassReference) {
            return true;
        }
        if (!(element instanceof ConstantReference)) return false;
        if (!global) return true;
        if (ContainerUtil.exists((Iterable)((ConstantReference)element).multiResolveStrict(Constant.class), PhpDefine.class::isInstance)) return false;
        return true;
    }

    public static boolean nonStrictNullValue(@Nullable PsiElement element) {
        if (element instanceof StringLiteralExpression) {
            String contents = ((StringLiteralExpression)element).getContents();
            return contents.isEmpty() || contents.equals("0");
        }
        return PhpDfaBaseStateConditionDFAnalyzer.isZero(element) || PhpLangUtil.isFalse(element);
    }

    public static boolean isZero(@Nullable PsiElement element) {
        if (PhpPsiUtil.isOfType(element, PhpElementTypes.NUMBER)) {
            String text = element.getText();
            return text.equals("0") || text.equals("0.0");
        }
        return false;
    }

    protected static PhpVariableDfaState updateStrict(PhpVariableDfaState state, boolean strict) {
        return strict ? new PhpVariableDfaState(state.getVariableName(), new PhpStrictVariableDfaState((PhpDfaBasedTypeState)state.getState())) : state;
    }

    @Nullable
    private PhpVariableDfaState computeNullabilityState(PsiElement elementToCheck, boolean isNotNullCheck) {
        if (!this.needToProcessElement(elementToCheck)) {
            return null;
        }
        PhpDfaBasedTypeState nullabilityState = isNotNullCheck ? PhpCompositeTypeState.NOT_NULL : PhpCompositeTypeState.NULL;
        return this.createState(elementToCheck, nullabilityState);
    }

    protected boolean needToProcessElement(PsiElement elementToProcess) {
        return elementToProcess instanceof Variable;
    }

    private PhpVariableDfaState merge(@NotNull PhpVariableDfaState leftOperand, @NotNull PhpVariableDfaState rightOperand, boolean ambiguousResult) {
        PhpVariableDfaState merge;
        if (leftOperand == null) {
            PhpDfaBaseStateConditionDFAnalyzer.$$$reportNull$$$0(29);
        }
        if (rightOperand == null) {
            PhpDfaBaseStateConditionDFAnalyzer.$$$reportNull$$$0(30);
        }
        return (merge = this.mergeInner(leftOperand, rightOperand, ambiguousResult)) != null && !StringUtil.isEmpty((CharSequence)merge.getVariableName()) ? merge : PhpVariableDfaState.EMPTY;
    }

    protected PhpVariableDfaState createState(PhpVariableDfaState merge, boolean ambiguousResult) {
        return ambiguousResult ? new PhpVariableDfaState(merge.getVariableName(), PhpCompositeTypeState.AMBIGUOUS) : merge;
    }

    private PhpVariableDfaState mergeInner(@NotNull PhpVariableDfaState leftOperand, @NotNull PhpVariableDfaState rightOperand, boolean ambiguousResult) {
        if (leftOperand == null) {
            PhpDfaBaseStateConditionDFAnalyzer.$$$reportNull$$$0(31);
        }
        if (rightOperand == null) {
            PhpDfaBaseStateConditionDFAnalyzer.$$$reportNull$$$0(32);
        }
        if (leftOperand.getState() == PhpCompositeTypeState.UNKNOWN) {
            return this.createState(rightOperand, ambiguousResult || this.myAmbiguousCompositeState);
        }
        if (rightOperand.getState() == PhpCompositeTypeState.UNKNOWN) {
            return this.createState(leftOperand, ambiguousResult || this.myAmbiguousCompositeState);
        }
        if (rightOperand.equals((Object)leftOperand)) {
            return rightOperand;
        }
        if (PhpLangUtil.equalsVariableNames(leftOperand.getVariableName(), rightOperand.getVariableName())) {
            PhpCompositeTypeState state = ambiguousResult ? new PhpAmbiguousCompositeTypeState((PhpDfaBasedTypeState)leftOperand.getState(), (PhpDfaBasedTypeState)rightOperand.getState()) : new PhpCompositeTypeState((PhpDfaBasedTypeState)leftOperand.getState(), (PhpDfaBasedTypeState)rightOperand.getState());
            return new PhpVariableDfaState(leftOperand.getVariableName(), state);
        }
        return null;
    }

    @Override
    @NotNull
    public PhpVariableDfaState and(@NotNull PhpVariableDfaState leftOperand, @NotNull PhpVariableDfaState rightOperand, boolean conditionResult) {
        if (leftOperand == null) {
            PhpDfaBaseStateConditionDFAnalyzer.$$$reportNull$$$0(33);
        }
        if (rightOperand == null) {
            PhpDfaBaseStateConditionDFAnalyzer.$$$reportNull$$$0(34);
        }
        PhpVariableDfaState phpVariableDfaState = this.merge(leftOperand, rightOperand, !conditionResult);
        if (phpVariableDfaState == null) {
            PhpDfaBaseStateConditionDFAnalyzer.$$$reportNull$$$0(35);
        }
        return phpVariableDfaState;
    }

    @Override
    @NotNull
    public PhpVariableDfaState or(@NotNull PhpVariableDfaState leftOperand, @NotNull PhpVariableDfaState rightOperand, boolean conditionResult) {
        if (leftOperand == null) {
            PhpDfaBaseStateConditionDFAnalyzer.$$$reportNull$$$0(36);
        }
        if (rightOperand == null) {
            PhpDfaBaseStateConditionDFAnalyzer.$$$reportNull$$$0(37);
        }
        PhpVariableDfaState phpVariableDfaState = this.merge(leftOperand, rightOperand, conditionResult);
        if (phpVariableDfaState == null) {
            PhpDfaBaseStateConditionDFAnalyzer.$$$reportNull$$$0(38);
        }
        return phpVariableDfaState;
    }

    @Override
    public PhpVariableDfaState getEmpty() {
        return PhpVariableDfaState.EMPTY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 19, 20, 21, 22, 23, 25, 35, 38 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 35: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/codeInsight/typeInference/PhpDfaBaseStateConditionDFAnalyzer";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionReference";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assertion";
                break;
            }
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "right";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 29: 
            case 31: 
            case 33: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftOperand";
                break;
            }
            case 30: 
            case 32: 
            case 34: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rightOperand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/codeInsight/typeInference/PhpDfaBaseStateConditionDFAnalyzer";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "performDFA";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "createNotNullByPrimitiveTypeCheckerState";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstanceofTypeState";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "createRangeState";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "and";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "or";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isNotNullByPrimitiveTypeCheckers";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 35: 
            case 38: {
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isSupportedThirdPartyAssertion";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "computeStateFromAssertion";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createNotNullByPrimitiveTypeCheckerState";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getIntBoundRangesState";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "tryCreateStateFromFunctionCall";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "createCompositeTypeFromReferenceResolvedType";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "tryCreateStateFromMinMaxCall";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "merge";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "mergeInner";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "and";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "or";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 19, 20, 21, 22, 23, 25, 35, 38 -> new IllegalStateException(string);
        };
    }

    public static class PhpVariableDfaState
    extends PhpDfaBasedAnalyzerProcessor.PhpVariableDfaState<PhpDfaBasedTypeState> {
        public static final PhpVariableDfaState EMPTY = new PhpVariableDfaState((CharSequence)"", PhpCompositeTypeState.UNKNOWN);

        public PhpVariableDfaState(CharSequence variableName, PhpDfaBasedTypeState state) {
            super(variableName, state);
        }

        @Override
        public PhpDfaBasedAnalyzerProcessor.PhpVariableDfaState<PhpDfaBasedTypeState> copy(PhpDfaBasedTypeState state) {
            return new PhpVariableDfaState(this.getVariableName(), state);
        }
    }

    public static class PhpPrimitiveTypeExclusionState
    extends PhpDfaBasedTypeState {
        private final PhpType myExclusionType;
        private final String myPrimitiveTypeCheckerName;

        @Override
        public int getCustomHashCode() {
            return Objects.hash(this.myExclusionType, this.myPrimitiveTypeCheckerName);
        }

        private PhpPrimitiveTypeExclusionState(PhpType type, @NotNull String primitiveTypeCheckerName) {
            if (primitiveTypeCheckerName == null) {
                PhpPrimitiveTypeExclusionState.$$$reportNull$$$0(0);
            }
            super("PRIMITIVE TYPE EXCLUSION");
            this.myExclusionType = type;
            this.myPrimitiveTypeCheckerName = primitiveTypeCheckerName;
        }

        @Override
        public PhpType applyType(PhpType type) {
            PhpType tmp = new PhpType().add(type);
            if (this.myPrimitiveTypeCheckerName.equals("is_array") && PhpType.intersects(tmp, PhpType.ITERABLE)) {
                tmp = tmp.filter(PhpType.ITERABLE).add(PhpType.TRAVERSABLE);
            }
            for (String t : this.myExclusionType.getTypes()) {
                tmp = tmp.filterOutIncompleteTypesAware(new PhpExcludeTypeTP.PhpPrimitiveTypeExclusion(t));
            }
            return tmp;
        }

        public String getPrimitiveTypeCheckerName() {
            return this.myPrimitiveTypeCheckerName;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "primitiveTypeCheckerName", "com/jetbrains/php/codeInsight/typeInference/PhpDfaBaseStateConditionDFAnalyzer$PhpPrimitiveTypeExclusionState", "<init>"));
        }
    }

    public static class PhpClassEqualToState
    extends PhpDfaDelegateBasedTypeState.PhpInstanceofTypeState {
        protected PhpClassEqualToState(@Nullable String fqn, PhpDfaBasedTypeState ... states) {
            super(fqn, states);
        }

        private boolean iDifferentFQN(@NotNull PhpDfaBasedTypeState state) {
            if (state == null) {
                PhpClassEqualToState.$$$reportNull$$$0(0);
            }
            return this.myClassFqn != null && state instanceof PhpClassEqualToState && !Objects.equals(((PhpClassEqualToState)state).myClassFqn, this.myClassFqn);
        }

        @Override
        public boolean coveredBy(Project project, @NotNull PhpDfaBasedTypeState state, boolean global, MultiMap<PhpDfaBasedTypeState, PhpDfaBasedTypeState> skippedStates) {
            if (state == null) {
                PhpClassEqualToState.$$$reportNull$$$0(1);
            }
            if (this.myClassFqn != null && state instanceof PhpClassEqualToState) {
                return Objects.equals(((PhpClassEqualToState)state).myClassFqn, this.myClassFqn);
            }
            return super.coveredBy(project, state, global, skippedStates);
        }

        @Override
        public boolean excludedBy(Project project, @NotNull PhpDfaBasedTypeState state, boolean global, MultiMap<PhpDfaBasedTypeState, PhpDfaBasedTypeState> skippedStates) {
            if (state == null) {
                PhpClassEqualToState.$$$reportNull$$$0(2);
            }
            if (this.iDifferentFQN(state)) {
                return true;
            }
            return super.excludedBy(project, state, global, skippedStates);
        }

        public static PhpClassEqualToState createClassEqualInstance(Project project, String fqn, boolean global) {
            return new PhpClassEqualToState(fqn, PhpClassEqualToState.getDelegates(project, fqn, global));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "state";
            objectArray2[1] = "com/jetbrains/php/codeInsight/typeInference/PhpDfaBaseStateConditionDFAnalyzer$PhpClassEqualToState";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "iDifferentFQN";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "coveredBy";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "excludedBy";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class PhpFunctionCallDfaState
    extends PhpDfaBasedTypeState {
        @NotNull
        private final PhpDfaBasedTypeState myState;
        private final FunctionReference myCall;

        private PhpFunctionCallDfaState(@NotNull PhpDfaBasedTypeState state, @NotNull FunctionReference call) {
            if (state == null) {
                PhpFunctionCallDfaState.$$$reportNull$$$0(0);
            }
            if (call == null) {
                PhpFunctionCallDfaState.$$$reportNull$$$0(1);
            }
            super("function call " + call.getName());
            this.myState = state;
            this.myCall = call;
        }

        public FunctionReference getCall() {
            return this.myCall;
        }

        @Override
        public boolean coveredBy(Project project, @NotNull PhpDfaBasedTypeState state, boolean global, MultiMap<PhpDfaBasedTypeState, PhpDfaBasedTypeState> skippedStates) {
            if (state == null) {
                PhpFunctionCallDfaState.$$$reportNull$$$0(2);
            }
            if (state instanceof PhpFunctionCallDfaState) {
                return false;
            }
            return this.myState.coveredBy(project, state, global, skippedStates);
        }

        @Override
        public boolean excludedBy(Project project, @NotNull PhpDfaBasedTypeState state, boolean global, MultiMap<PhpDfaBasedTypeState, PhpDfaBasedTypeState> skippedStates) {
            if (state == null) {
                PhpFunctionCallDfaState.$$$reportNull$$$0(3);
            }
            if (state instanceof PhpFunctionCallDfaState) {
                return false;
            }
            return this.myState.excludedBy(project, state, global, skippedStates);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "call";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/codeInsight/typeInference/PhpDfaBaseStateConditionDFAnalyzer$PhpFunctionCallDfaState";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "coveredBy";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "excludedBy";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

