/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.codeInsight.typeInference;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.php.codeInsight.PhpSwitchCaseAwareInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpArrayAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpCallInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpConditionInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpEntryPointInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpIncludeInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpEvalInstructionImpl;
import com.jetbrains.php.codeInsight.dataFlow.PhpConditionDFAnalyzer;
import com.jetbrains.php.codeInsight.typeInference.PhpVariableInferredTypeAnalyzerProcessor;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.controlFlow.constantCondition.PhpStateArgumentInfo;
import com.jetbrains.php.lang.inspections.controlFlow.constantCondition.PhpVariableDfaStateWithInfo;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpDfaBasedAnalyzerProcessor<E, S extends PhpVariableDfaState<E>>
extends PhpSwitchCaseAwareInstructionProcessor<S> {
    @Nullable
    protected final CharSequence myVariableName;
    @Nullable
    protected final PsiElement myAnchor;
    protected final MultiMap<TextRange, PhpVariableDfaState<E>> myProcessedRanges = MultiMap.create();
    protected boolean myAmbiguous;
    @Nullable
    protected PhpVariableDfaState<E> myInjectedState = null;
    protected PhpInstruction myLastDfaInstruction;
    protected int myProcessedRangesMinStartOffset = Integer.MAX_VALUE;

    public PhpDfaBasedAnalyzerProcessor(@Nullable CharSequence name, @Nullable PsiElement anchor) {
        this.myVariableName = name;
        this.myAnchor = anchor;
    }

    @Override
    public boolean processInstruction(PhpInstruction instruction) {
        if (instruction instanceof PhpEvalInstructionImpl) {
            this.myAmbiguous = true;
            this.haltTraversal();
            return false;
        }
        return super.processInstruction(instruction);
    }

    @Override
    protected boolean processBaseConditionInstruction(PhpConditionInstruction instruction) {
        super.processBaseConditionInstruction(instruction);
        return this.processCondition(instruction, instruction.getCondition(), instruction.getResult());
    }

    public boolean processCondition(PhpInstruction instruction, @Nullable PsiElement condition, boolean result) {
        if (condition == null || this.myAnchor != null && condition == this.myAnchor) {
            return true;
        }
        TextRange outerRange = condition.getTextRange();
        if (outerRange.getEndOffset() >= this.myProcessedRangesMinStartOffset) {
            if (this.myProcessedRanges.keySet().stream().anyMatch(arg_0 -> ((TextRange)outerRange).intersects(arg_0))) {
                PhpVariableDfaState alreadyComputedState = (PhpVariableDfaState)((Object)ContainerUtil.getFirstItem((Collection)this.myProcessedRanges.get((Object)outerRange)));
                if (alreadyComputedState != null) {
                    this.putValue(outerRange, new PhpVariableDfaStateWithInstruction<E>(alreadyComputedState.getVariableName(), this.getUnknown(), instruction));
                    if (this.myVariableName == null || alreadyComputedState.getVariableName().equals(this.myVariableName)) {
                        return false;
                    }
                }
                return true;
            }
        }
        @NotNull PhpVariableDfaState state = (PhpVariableDfaState)((Object)this.performDFA(instruction, condition, result, this.getAnalyzer()));
        return this.registerState(instruction, outerRange, state);
    }

    private void putValue(TextRange outerRange, PhpVariableDfaStateWithInstruction<E> value) {
        this.myProcessedRanges.putValue((Object)outerRange, value);
        this.myProcessedRangesMinStartOffset = Math.min(outerRange.getStartOffset(), this.myProcessedRangesMinStartOffset);
    }

    protected void put(TextRange range, List<PhpVariableDfaState<E>> amendedStates) {
        this.myProcessedRanges.put((Object)range, amendedStates);
        this.myProcessedRangesMinStartOffset = Math.min(range.getStartOffset(), this.myProcessedRangesMinStartOffset);
    }

    @Override
    protected PhpConditionDFAnalyzer<S> getAnalyzer() {
        return this.createAnalyzer();
    }

    protected boolean registerState(PhpInstruction instruction, TextRange outerRange, @NotNull PhpVariableDfaState<E> state) {
        if (state == null) {
            PhpDfaBasedAnalyzerProcessor.$$$reportNull$$$0(0);
        }
        PhpVariableDfaStateWithInstruction<E> value = PhpDfaBasedAnalyzerProcessor.wrapWithInstruction(instruction, state);
        this.putValue(outerRange, value);
        if (!this.isUnknown(state) && this.sameVariableName(state.getVariableName())) {
            this.myLastDfaInstruction = instruction;
            return false;
        }
        return true;
    }

    @NotNull
    public static <E> PhpVariableDfaStateWithInstruction<E> wrapWithInstruction(@Nullable PhpInstruction instruction, @NotNull PhpVariableDfaState<E> state) {
        if (state == null) {
            PhpDfaBasedAnalyzerProcessor.$$$reportNull$$$0(1);
        }
        PhpStateArgumentInfo info = state instanceof PhpVariableDfaStateWithInfo ? ((PhpVariableDfaStateWithInfo)((Object)state)).getInfo() : null;
        return new PhpVariableDfaStateWithInstruction<E>(state.getVariableName(), state.getState(), instruction, info);
    }

    @NotNull
    protected abstract E getUnknown();

    public abstract boolean isUnknown(@NotNull PhpVariableDfaState<E> var1);

    @NotNull
    public abstract PhpConditionDFAnalyzer<S> createAnalyzer();

    protected boolean sameVariableName(CharSequence name) {
        return this.myVariableName == null || PhpLangUtil.equalsVariableNames(name, this.myVariableName);
    }

    @Override
    public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
        PhpAccessInstruction.Access access;
        super.processAccessVariableInstruction(instruction);
        if (this.sameVariableName(instruction.getVariableName()) && ((access = instruction.getAccess()).isWriteRef() || access.isUnset() || access.isWrite())) {
            return false;
        }
        return super.processAccessVariableInstruction(instruction);
    }

    @Override
    public boolean processArrayAccessInstruction(PhpArrayAccessInstruction instruction) {
        super.processArrayAccessInstruction(instruction);
        CharSequence name = PhpVariableInferredTypeAnalyzerProcessor.getBaseVariableName(instruction);
        PhpAccessInstruction.Access access = instruction.getAccess();
        if (this.sameVariableName(name) && (access.isWrite() || access.isWriteRef()) || this.sameVariableName(instruction.getVariableName()) && access.isUnset()) {
            return false;
        }
        return super.processArrayAccessInstruction(instruction);
    }

    protected void setState(PhpVariableDfaStateWithInstruction<E> value) {
        this.putValue(TextRange.EMPTY_RANGE, value);
    }

    @Override
    public boolean processEntryPointInstruction(PhpEntryPointInstruction instruction) {
        super.processEntryPointInstruction(instruction);
        this.myAmbiguous = this.myInjectedState == null;
        this.haltTraversal();
        return super.processEntryPointInstruction(instruction);
    }

    @Override
    public boolean processIncludeInstruction(PhpIncludeInstruction instruction) {
        this.myAmbiguous = true;
        this.haltTraversal();
        return false;
    }

    @Override
    public boolean processPhpCallInstruction(PhpCallInstruction instruction) {
        if (PhpDfaBasedAnalyzerProcessor.isDynamicCall(instruction)) {
            this.myAmbiguous = true;
            this.haltTraversal();
            return false;
        }
        return super.processPhpCallInstruction(instruction);
    }

    public static boolean isDynamicCall(@NotNull PhpCallInstruction instruction) {
        PsiElement functionArgument;
        FunctionReference functionReference;
        if (instruction == null) {
            PhpDfaBasedAnalyzerProcessor.$$$reportNull$$$0(2);
        }
        return (functionReference = instruction.getFunctionReference()).getNameNode() == null && (functionArgument = PhpPsiUtil.unparenthesize((PsiElement)functionReference.getFirstPsiChild())) != null && !PhpPsiUtil.isOfType(functionArgument, PhpElementTypes.CLOSURE);
    }

    @Nullable
    public PhpVariableDfaStateWithInstruction<E> getState() {
        if (this.myAmbiguous) {
            return null;
        }
        List<PhpVariableDfaState> states = this.myProcessedRanges.values().stream().filter(s -> s != this.getEmpty()).filter(s -> this.sameVariableName(s.getVariableName())).toList();
        if (ContainerUtil.exists(states, s -> this.isUnknown((PhpVariableDfaState<E>)((Object)s)))) {
            return new PhpVariableDfaStateWithInstruction<E>(this.myVariableName, this.getUnknown(), this.myLastDfaInstruction);
        }
        PhpVariableDfaState firstState = (PhpVariableDfaState)((Object)ContainerUtil.getFirstItem(states));
        if (firstState == null) {
            return null;
        }
        E composedState = states.stream().map(PhpVariableDfaState::getState).reduce((delegates, delegates2) -> this.createAmbiguousState(delegates, delegates2)).orElse(null);
        if (composedState == null) {
            return null;
        }
        PhpStateArgumentInfo info = firstState instanceof PhpVariableDfaStateWithInstruction ? ((PhpVariableDfaStateWithInstruction)firstState).getInfo() : null;
        return new PhpVariableDfaStateWithInstruction<Object>(firstState.getVariableName(), this.composeStrictState(composedState), this.myLastDfaInstruction, info);
    }

    protected E composeStrictState(E state) {
        return state;
    }

    protected abstract E createAmbiguousState(E var1, E var2);

    @NotNull
    protected abstract PhpVariableDfaState<E> getEmpty();

    public void setInjectedState(PhpVariableDfaState<E> injectedState) {
        this.myInjectedState = injectedState;
    }

    @Override
    public boolean shouldSkipAmbiguousPredecessors() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instruction";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/codeInsight/typeInference/PhpDfaBasedAnalyzerProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "registerState";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "wrapWithInstruction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isDynamicCall";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class PhpVariableDfaState<E>
    extends Pair<CharSequence, E> {
        public PhpVariableDfaState(CharSequence variableName, E state) {
            super((Object)variableName, state);
        }

        public CharSequence getVariableName() {
            return (CharSequence)this.first;
        }

        public E getState() {
            return (E)this.second;
        }

        public PhpVariableDfaState<E> copy(E state) {
            return new PhpVariableDfaState<E>((CharSequence)this.first, state);
        }
    }

    public static class PhpVariableDfaStateWithInstruction<E>
    extends PhpVariableDfaState<E> {
        private final PhpInstruction myInstruction;
        @Nullable
        private final PhpStateArgumentInfo myInfo;

        public PhpVariableDfaStateWithInstruction(CharSequence variableName, E state, PhpInstruction instruction, @Nullable PhpStateArgumentInfo info) {
            super(variableName, state);
            this.myInstruction = instruction;
            this.myInfo = info;
        }

        public PhpVariableDfaStateWithInstruction(CharSequence variableName, E state, PhpInstruction instruction) {
            this(variableName, state, instruction, null);
        }

        public PhpInstruction getInstruction() {
            return this.myInstruction;
        }

        public PhpStateArgumentInfo getInfo() {
            return this.myInfo;
        }

        @Override
        public PhpVariableDfaStateWithInstruction<E> copy(E state) {
            return new PhpVariableDfaStateWithInstruction<E>(this.getVariableName(), state, this.getInstruction(), this.getInfo());
        }
    }
}

