/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.codeInsight.typeInference;

import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlow;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpVariableDocDeclarationInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpAccessVariableInstructionImpl;
import com.jetbrains.php.codeInsight.typeInference.PhpTypeAnalyzerProcessor;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.Variable;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class PhpVariableDocDeclaredTypeAnalyzerProcessor
extends PhpTypeAnalyzerProcessor {
    private static final Key<CachedValue<Set<CharSequence>>> KEY = Key.create((String)"php.doc.variable.declaration");
    @NotNull
    private final String myVariableName;
    @NotNull
    private final Variable myVariable;
    private final boolean myIsWriteAccess;

    public PhpVariableDocDeclaredTypeAnalyzerProcessor(@NotNull Variable variable) {
        if (variable == null) {
            PhpVariableDocDeclaredTypeAnalyzerProcessor.$$$reportNull$$$0(0);
        }
        this.myVariableName = variable.getName();
        this.myVariable = variable;
        this.myIsWriteAccess = this.myVariable.isWriteAccess(false);
    }

    @Override
    public boolean processVariableDocDeclarationInstruction(PhpVariableDocDeclarationInstruction instruction) {
        if (this.myVariableName.contentEquals(instruction.getVariableName())) {
            this.setType(instruction.getPhpDocVariable().getType());
            return false;
        }
        return true;
    }

    @Override
    public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
        if (this.myVariableName.contentEquals(instruction.getVariableName()) && ((PhpAccessVariableInstructionImpl)instruction).getAssignedValue() != null) {
            PhpPsiElement anchor = instruction.getAnchor();
            if (this.myIsWriteAccess) {
                return anchor == this.myVariable;
            }
            if (anchor instanceof PhpNamedElement) {
                this.setType(((PhpNamedElement)anchor).getDocType());
            }
            return false;
        }
        return super.processAccessVariableInstruction(instruction);
    }

    public boolean scopeContainsDocType(@NotNull PhpPsiElement anchor, @NotNull CharSequence name) {
        PhpScopeHolder holder;
        if (anchor == null) {
            PhpVariableDocDeclaredTypeAnalyzerProcessor.$$$reportNull$$$0(1);
        }
        if (name == null) {
            PhpVariableDocDeclaredTypeAnalyzerProcessor.$$$reportNull$$$0(2);
        }
        if ((holder = PhpPsiUtil.getScopeHolder((PsiElement)anchor)) == null) {
            return false;
        }
        Set variableNamesWithDocDeclarations = (Set)CachedValuesManager.getCachedValue((PsiElement)holder, KEY, () -> CachedValueProvider.Result.create(PhpVariableDocDeclaredTypeAnalyzerProcessor.getVariableNamesWithDocDeclaration(holder), (Object[])new Object[]{holder}));
        return variableNamesWithDocDeclarations.contains(name);
    }

    @NotNull
    private static Set<CharSequence> getVariableNamesWithDocDeclaration(PhpScopeHolder holder) {
        PhpControlFlow flow = holder.getControlFlow();
        final HashSet<CharSequence> variableNamesWithDocDeclarations = new HashSet<CharSequence>();
        PhpControlFlowUtil.processFlow(flow, new PhpInstructionProcessor(){

            @Override
            public boolean processVariableDocDeclarationInstruction(PhpVariableDocDeclarationInstruction instruction) {
                variableNamesWithDocDeclarations.add(instruction.getVariableName());
                return super.processVariableDocDeclarationInstruction(instruction);
            }

            @Override
            public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                PhpNamedElement variable;
                PhpPsiElement phpPsiElement;
                if (((PhpAccessVariableInstructionImpl)instruction).getAssignedValue() != null && (phpPsiElement = instruction.getAnchor()) instanceof PhpNamedElement && !(variable = (PhpNamedElement)phpPsiElement).getDocType().isEmpty()) {
                    variableNamesWithDocDeclarations.add(variable.getNameCS());
                }
                return super.processAccessVariableInstruction(instruction);
            }
        });
        HashSet<CharSequence> hashSet = variableNamesWithDocDeclarations;
        if (hashSet == null) {
            PhpVariableDocDeclaredTypeAnalyzerProcessor.$$$reportNull$$$0(3);
        }
        return hashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/codeInsight/typeInference/PhpVariableDocDeclaredTypeAnalyzerProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/codeInsight/typeInference/PhpVariableDocDeclaredTypeAnalyzerProcessor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariableNamesWithDocDeclaration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "scopeContainsDocType";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

