/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.completion.PhpAnyExpressionArgument;
import com.jetbrains.php.completion.PhpCompletionContributor;
import com.jetbrains.php.completion.PhpObjectShapeCompletionProvider;
import com.jetbrains.php.lang.inspections.attributes.PhpArrayKeyDoesNotMatchArrayShapeInspection;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.ArrayCreationExpression;
import com.jetbrains.php.lang.psi.elements.ArrayHashElement;
import com.jetbrains.php.lang.psi.elements.ArrayIndex;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.ForeachStatement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.ArrayCreationExpressionImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpArrayShapeIndexTP;
import com.jetbrains.php.lang.psi.resolve.types.shapes.PhpArrayShapeBasedOnUsageProvider;
import com.jetbrains.php.lang.psi.resolve.types.shapes.PhpArrayShapeOfArrayCreationProvider;
import com.jetbrains.php.lang.psi.resolve.types.shapes.PhpArrayShapesProvider;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpExpectedFunctionArgument;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpExpectedFunctionArgumentsIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpShapeEntriesIndex;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpArrayShapeIndexCompletionProvider
extends CompletionProvider<CompletionParameters> {
    protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
        ArrayAccessExpression arrayAccess;
        if (parameters == null) {
            PhpArrayShapeIndexCompletionProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            PhpArrayShapeIndexCompletionProvider.$$$reportNull$$$0(1);
        }
        if (result == null) {
            PhpArrayShapeIndexCompletionProvider.$$$reportNull$$$0(2);
        }
        if ((arrayAccess = PhpPsiUtil.getParentOfClass(parameters.getPosition(), true, ArrayAccessExpression.class)) == null) {
            return;
        }
        ArrayIndex index = arrayAccess.getIndex();
        if (index == null) {
            return;
        }
        PhpPsiElement parent = index.getValue();
        PhpPsiElement value = arrayAccess.getValue();
        PhpArrayShapeIndexCompletionProvider.addValues(result, parent, (PsiElement)value);
    }

    private static void addValues(@NotNull CompletionResultSet result, PhpPsiElement parent, PsiElement value) {
        if (result == null) {
            PhpArrayShapeIndexCompletionProvider.$$$reportNull$$$0(3);
        }
        if (value == null) {
            return;
        }
        StreamEx keys = StreamEx.of(PhpArrayShapeIndexCompletionProvider.getArrayShapes(value)).map(PhpShapeEntriesIndex.PhpShapeEntry::getKey);
        PhpCompletionContributor.addExpectedValues(result, (PsiElement)parent, (Stream<PhpExpectedFunctionArgument>)keys);
    }

    public static Collection<PhpShapeEntriesIndex.PhpShapeEntry> getArrayShapes(PsiElement value) {
        ArrayDeque<PhpExpectedFunctionArgument> parentAccesses = new ArrayDeque<PhpExpectedFunctionArgument>();
        value = PhpArrayShapeIndexCompletionProvider.findTargetValue(value, parentAccesses);
        ArrayList<PhpShapeEntriesIndex.PhpShapeEntry> shapes = new ArrayList<PhpShapeEntriesIndex.PhpShapeEntry>(PhpArrayShapeIndexCompletionProvider.getArrayShapes(value, parentAccesses));
        if (value instanceof FieldReference) {
            FieldReference fieldReference = (FieldReference)value;
            String key = fieldReference.getName();
            shapes.addAll(((StreamEx)((StreamEx)StreamEx.of(PhpObjectShapeCompletionProvider.getObjectShapes(fieldReference)).filter(s -> StringUtil.unquoteString((String)s.getKey().getValue()).equals(key))).flatMap(s -> s.getChildren().stream()).filter(s -> !s.isObjectShape())).toList());
        }
        return shapes;
    }

    private static Collection<PhpShapeEntriesIndex.PhpShapeEntry> getArrayShapes(PsiElement value, ArrayDeque<PhpExpectedFunctionArgument> parentAccesses) {
        List arrayShapes = ((StreamEx)StreamEx.of(PhpArrayShapesProvider.EP_NAME.getExtensionList().stream()).append((Object)PhpArrayShapeBasedOnUsageProvider.INSTANCE).append((Object)PhpArrayShapeOfArrayCreationProvider.INSTANCE).flatMap(r -> r.getValues(value, true).stream()).append(PhpArrayShapeIndexCompletionProvider.arrayShapesFromTypes(value))).toList();
        return PhpArrayShapeIndexCompletionProvider.collectShapesByParentAccesses(parentAccesses, arrayShapes);
    }

    public static <T> Collection<PhpShapeEntriesIndex.PhpShapeEntry> collectShapesByParentAccesses(ArrayDeque<T> parentAccesses, BiFunction<? super PhpExpectedFunctionArgument, ? super T, Boolean> accessPredicate, Collection<PhpShapeEntriesIndex.PhpShapeEntry> arrayShapes) {
        for (Object access : parentAccesses) {
            arrayShapes = arrayShapes.stream().filter(shape -> (Boolean)accessPredicate.apply(shape.getKey(), (Object)access) != false || shape.getKey() instanceof PhpAnyExpressionArgument).flatMap(shape -> shape.getChildren().stream()).collect(Collectors.toList());
        }
        return arrayShapes;
    }

    public static Collection<PhpShapeEntriesIndex.PhpShapeEntry> collectShapesByParentAccesses(ArrayDeque<PhpExpectedFunctionArgument> parentAccesses, Collection<PhpShapeEntriesIndex.PhpShapeEntry> arrayShapes) {
        return PhpArrayShapeIndexCompletionProvider.collectShapesByParentAccesses(parentAccesses, (key, access) -> key.getValue().equals(access.getValue()) || key.equals(access) || access instanceof PhpAnyExpressionArgument, arrayShapes);
    }

    @Nullable
    public static PsiElement findTargetValue(PsiElement value, ArrayDeque<PhpExpectedFunctionArgument> parentAccessesToFill) {
        PsiElement item;
        if ((value = PhpArrayShapeIndexCompletionProvider.fillParentAccesses(value, parentAccessesToFill)) instanceof Variable && (item = (PsiElement)ContainerUtil.getOnlyItem((Collection)((Variable)value).resolveLocal())) instanceof Variable) {
            PsiElement psiElement;
            PsiElement array = value;
            while ((psiElement = item.getParent()) instanceof ForeachStatement) {
                ForeachStatement foreach = (ForeachStatement)psiElement;
                parentAccessesToFill.addFirst(PhpAnyExpressionArgument.INSTANCE);
                array = PhpArrayShapeIndexCompletionProvider.fillParentAccesses(foreach.getArray(), parentAccessesToFill);
                item = foreach.getParent();
            }
            return PhpArrayShapeIndexCompletionProvider.fillParentAccesses(array, parentAccessesToFill);
        }
        return value;
    }

    @Nullable
    private static PsiElement fillParentAccesses(@Nullable PsiElement value, ArrayDeque<PhpExpectedFunctionArgument> parentAccessesToFill) {
        while (value instanceof ArrayAccessExpression) {
            ArrayIndex index = ((ArrayAccessExpression)value).getIndex();
            PhpPsiElement indexValue = index != null ? index.getValue() : null;
            PhpExpectedFunctionArgument parentAccess = PhpArrayShapeIndexCompletionProvider.getParentAccesses(indexValue);
            value = ((ArrayAccessExpression)value).getValue();
            parentAccessesToFill.addFirst(parentAccess);
        }
        return value;
    }

    @NotNull
    public static PhpExpectedFunctionArgument getParentAccesses(PhpPsiElement indexValue) {
        PhpExpectedFunctionArgument phpExpectedFunctionArgument = PhpArrayKeyDoesNotMatchArrayShapeInspection.isPossibleArrayShapeIndex(indexValue) ? PhpExpectedFunctionArgumentsIndex.getExpectedArgument((PsiElement)indexValue, 0, 0, null, false) : PhpAnyExpressionArgument.INSTANCE;
        if (phpExpectedFunctionArgument == null) {
            PhpArrayShapeIndexCompletionProvider.$$$reportNull$$$0(4);
        }
        return phpExpectedFunctionArgument;
    }

    @NotNull
    private static Stream<PhpShapeEntriesIndex.PhpShapeEntry> arrayShapesFromTypes(PsiElement value) {
        Stream<PhpShapeEntriesIndex.PhpShapeEntry> stream = value instanceof PhpReference ? ((PhpReference)value).getSignatureParts().stream().flatMap(s -> PhpArrayShapeIndexTP.fetchArrayShapeEntries(value.getProject(), s)) : Stream.empty();
        if (stream == null) {
            PhpArrayShapeIndexCompletionProvider.$$$reportNull$$$0(5);
        }
        return stream;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/completion/PhpArrayShapeIndexCompletionProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/completion/PhpArrayShapeIndexCompletionProvider";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getParentAccesses";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "arrayShapesFromTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addCompletions";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addValues";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5 -> new IllegalStateException(string);
        };
    }

    public static class PhpArrayShapeInLiteralCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            ArrayCreationExpression arrayCreationLiteral;
            if (parameters == null) {
                PhpArrayShapeInLiteralCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PhpArrayShapeInLiteralCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                PhpArrayShapeInLiteralCompletionProvider.$$$reportNull$$$0(2);
            }
            if ((arrayCreationLiteral = PhpPsiUtil.getParentOfClass(parameters.getPosition(), true, ArrayCreationExpression.class)) == null) {
                return;
            }
            PhpPsiElement parent = ArrayCreationExpressionImpl.children(arrayCreationLiteral).stream().filter(child -> PsiTreeUtil.isAncestor((PsiElement)child, (PsiElement)parameters.getPosition(), (boolean)false)).map(element -> element instanceof ArrayHashElement ? ((ArrayHashElement)element).getKey() : element.getFirstPsiChild()).filter(Objects::nonNull).findFirst().orElse(null);
            PhpArrayShapeIndexCompletionProvider.addValues(result, parent, (PsiElement)arrayCreationLiteral);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/completion/PhpArrayShapeIndexCompletionProvider$PhpArrayShapeInLiteralCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

