/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.completion;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class PhpBaseKeywordInsertHandler
implements InsertHandler<LookupElement> {
    private static final String DUMMY_NAME_MARKER = "a";
    private static final String DUMMY_INDENT_MARKER = "const;";
    public static final PhpBaseKeywordInsertHandler WITH_PARAMETERS_BODY = new PhpBaseKeywordInsertHandler(){

        @Override
        protected void insert(Project project, Document document, int offset, PsiFile file) {
            PsiElement element = file.findElementAt(offset);
            if (element != null && PhpPsiUtil.getNextSiblingByCondition(element, GroupStatement.INSTANCEOF) != null) {
                return;
            }
            PhpBaseKeywordInsertHandler.insertString(project, file, document, offset, true);
        }
    };
    public static final PhpBaseKeywordInsertHandler WITH_PARAMETERS = new PhpBaseKeywordInsertHandler(){

        @Override
        protected void insert(Project project, Document document, int offset, PsiFile file) {
            PsiElement element = file.findElementAt(offset);
            if (element != null && PhpPsiUtil.getNextSiblingByCondition(element, GroupStatement.INSTANCEOF) != null) {
                return;
            }
            document.insertString(offset, (CharSequence)" ();");
        }
    };
    public static final PhpBaseKeywordInsertHandler WITH_BODY = new PhpBaseKeywordInsertHandler(){

        @Override
        protected void insert(Project project, Document document, int offset, PsiFile file) {
            PsiElement element = file.findElementAt(offset);
            if (element != null && PhpPsiUtil.getNextSiblingByCondition(element, (Condition<? super PsiElement>)((Condition)e -> PhpPsiUtil.isOfType(e, PhpTokenTypes.chLBRACE))) != null) {
                return;
            }
            PhpBaseKeywordInsertHandler.insertString(project, file, document, offset, false);
        }
    };

    public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
        if (context == null) {
            PhpBaseKeywordInsertHandler.$$$reportNull$$$0(0);
        }
        if (item == null) {
            PhpBaseKeywordInsertHandler.$$$reportNull$$$0(1);
        }
        Editor editor = context.getEditor();
        CaretModel caretModel = editor.getCaretModel();
        int offset = caretModel.getOffset();
        this.insert(context.getProject(), editor.getDocument(), offset, context.getFile());
        caretModel.moveToOffset(offset + 1);
    }

    private static void insertString(Project project, PsiFile file, Document document, int offset, boolean insertParameters) {
        String indent = " ".repeat(CommonCodeStyleSettings.IndentOptions.DEFAULT_INDENT_OPTIONS.INDENT_SIZE);
        String beforeIndent = " %s%s {\n%s".formatted(DUMMY_NAME_MARKER, insertParameters ? "()" : "", indent);
        String afterIndent = "%s\n}".formatted(DUMMY_INDENT_MARKER);
        String body = beforeIndent + afterIndent;
        document.insertString(offset, (CharSequence)body);
        RangeMarker nameMarker = document.createRangeMarker(offset + 1, offset + 1 + DUMMY_NAME_MARKER.length());
        RangeMarker indentMarker = document.createRangeMarker(offset + beforeIndent.length(), offset + beforeIndent.length() + DUMMY_INDENT_MARKER.length());
        PhpBaseKeywordInsertHandler.reformatInsertedString(project, file, document, offset, offset + body.length(), List.of(nameMarker, indentMarker));
    }

    private static void reformatInsertedString(Project project, PsiFile file, Document document, int startOffset, int endOffset, Collection<RangeMarker> rangeMarkersToDelete) {
        if (startOffset < 0 || endOffset < 0 || endOffset > document.getTextLength() || endOffset < startOffset) {
            return;
        }
        PsiDocumentManager psiDocManager = PsiDocumentManager.getInstance((Project)project);
        psiDocManager.commitDocument(document);
        CodeStyleManager.getInstance((Project)project).reformatRange((PsiElement)file, startOffset, endOffset);
        for (RangeMarker rangeMarker : rangeMarkersToDelete) {
            int start = rangeMarker.getStartOffset();
            int end = rangeMarker.getEndOffset();
            if (start < 0 || end < 0 || end > document.getTextLength() || end < start) continue;
            document.deleteString(rangeMarker.getStartOffset(), rangeMarker.getEndOffset());
            rangeMarker.dispose();
        }
        psiDocManager.commitDocument(document);
        psiDocManager.doPostponedOperationsAndUnblockDocument(document);
    }

    protected abstract void insert(Project var1, Document var2, int var3, PsiFile var4);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "item";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/php/completion/PhpBaseKeywordInsertHandler";
        objectArray[2] = "handleInsert";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

