/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupElementRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpIcons;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.completion.PhpCompletionContributor;
import com.jetbrains.php.completion.PhpLookupElement;
import com.jetbrains.php.completion.PhpUsageContextArrayIndexCompletionProviderBase;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.ArrayIndex;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpGlobalArrayAccessAssignmentIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpExpectedFunctionArgument;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Collection;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpGlobalsArrayIndexCompletionProvider
extends CompletionProvider<CompletionParameters> {
    protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
        Variable variable;
        PhpPsiElement phpPsiElement;
        ArrayAccessExpression arrayAccess;
        if (parameters == null) {
            PhpGlobalsArrayIndexCompletionProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            PhpGlobalsArrayIndexCompletionProvider.$$$reportNull$$$0(1);
        }
        if (result == null) {
            PhpGlobalsArrayIndexCompletionProvider.$$$reportNull$$$0(2);
        }
        if ((arrayAccess = PhpPsiUtil.getParentOfClass(parameters.getPosition(), true, ArrayAccessExpression.class)) != null && (phpPsiElement = arrayAccess.getValue()) instanceof Variable && PhpLangUtil.equalsVariableNames((variable = (Variable)phpPsiElement).getName(), "GLOBALS")) {
            ArrayIndex arrayIndex = arrayAccess.getIndex();
            if (arrayIndex == null) {
                return;
            }
            PhpGlobalsArrayIndexCompletionProvider.addGlobalVariables(variable.getProject(), (PsiElement)arrayIndex.getValue(), result);
        }
    }

    public static void addGlobalVariables(final @NotNull Project project, @Nullable PsiElement value, @NotNull CompletionResultSet result) {
        if (project == null) {
            PhpGlobalsArrayIndexCompletionProvider.$$$reportNull$$$0(3);
        }
        if (result == null) {
            PhpGlobalsArrayIndexCompletionProvider.$$$reportNull$$$0(4);
        }
        PhpIndex index = PhpIndex.getInstance(project);
        Collection<String> variableNames = index.getAllVariableNames(result.getPrefixMatcher().cloneWithPrefix(StringUtil.unquoteString((String)result.getPrefixMatcher().getPrefix())));
        StreamEx arguments = ((StreamEx)StreamEx.of(variableNames).append(PhpGlobalArrayAccessAssignmentIndex.getAllVariableNames(project)).distinct()).map(v -> PhpUsageContextArrayIndexCompletionProviderBase.createArgument(v));
        PhpCompletionContributor.expectedValues(value, (Stream<? extends PhpExpectedFunctionArgument>)arguments).map(e -> new LookupElementDecorator<LookupElement>(e){

            public LookupElementRenderer<? extends LookupElement> getExpensiveRenderer() {
                return PhpGlobalsArrayIndexCompletionProvider.createRenderer(project);
            }
        }).forEach(arg_0 -> ((CompletionResultSet)result).addElement(arg_0));
    }

    @NotNull
    private static LookupElementRenderer<LookupElement> createRenderer(final Project project) {
        return new LookupElementRenderer<LookupElement>(){

            public void renderElement(LookupElement element, LookupElementPresentation presentation) {
                PhpLookupElement lookupElement;
                PhpNamedElement namedElement;
                String name = StringUtil.unquoteString((String)element.getLookupString());
                Variable variable = (Variable)ContainerUtil.getFirstItem(PhpIndex.getInstance(project).getVariablesByName(name));
                if (variable != null && (namedElement = (lookupElement = new PhpLookupElement(variable)).getNamedElement()) != null) {
                    lookupElement.doRender(presentation, namedElement);
                    return;
                }
                presentation.setItemText(element.getLookupString());
                PhpGlobalsArrayIndexCompletionProvider.renderGlobalVariableFromGlobalsArray(project, presentation, name);
            }
        };
    }

    public static void renderGlobalVariableFromGlobalsArray(Project project, LookupElementPresentation presentation, String name) {
        PhpType type;
        presentation.setIcon(PhpIcons.VARIABLE);
        Int2ObjectMap assignmentsInAnyFile = (Int2ObjectMap)ContainerUtil.getFirstItem(PhpGlobalArrayAccessAssignmentIndex.findAssignments(project, name).values());
        if (assignmentsInAnyFile != null && !assignmentsInAnyFile.isEmpty() && (type = (PhpType)assignmentsInAnyFile.get(assignmentsInAnyFile.keySet().iterator().nextInt())) != null) {
            presentation.setTypeText(type.toStringRelativized("\\"));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/completion/PhpGlobalsArrayIndexCompletionProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addCompletions";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "addGlobalVariables";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

