/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.completion;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.util.ParenthesesInsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.completion.PhpBaseKeywordInsertHandler;
import com.jetbrains.php.completion.PhpCompletionContributor;
import com.jetbrains.php.completion.PhpCompletionSorting;
import com.jetbrains.php.completion.PhpGroupStatementBodyInsertHandler;
import com.jetbrains.php.completion.insert.PhpKeywordInsertHandler;
import com.jetbrains.php.completion.insert.PhpReturnKeywordInsertHandler;
import com.jetbrains.php.completion.insert.PhpSymbolInsertHandler;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.annotator.PhpAnnotatorVisitor;
import com.jetbrains.php.lang.formatter.PhpCodeStyleSettings;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.Declare;
import com.jetbrains.php.lang.psi.elements.DoWhile;
import com.jetbrains.php.lang.psi.elements.Else;
import com.jetbrains.php.lang.psi.elements.ElseIf;
import com.jetbrains.php.lang.psi.elements.ExtendsList;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.For;
import com.jetbrains.php.lang.psi.elements.ForeachStatement;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.If;
import com.jetbrains.php.lang.psi.elements.ImplementsList;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MultiassignmentExpression;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.PhpBreak;
import com.jetbrains.php.lang.psi.elements.PhpCase;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassFieldsList;
import com.jetbrains.php.lang.psi.elements.PhpContinue;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpMatchArm;
import com.jetbrains.php.lang.psi.elements.PhpMatchExpression;
import com.jetbrains.php.lang.psi.elements.PhpModifierList;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.lang.psi.elements.PhpNamespaceReference;
import com.jetbrains.php.lang.psi.elements.PhpParameterType;
import com.jetbrains.php.lang.psi.elements.PhpPropertyHook;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PhpReturn;
import com.jetbrains.php.lang.psi.elements.PhpSwitch;
import com.jetbrains.php.lang.psi.elements.PhpThrowExpression;
import com.jetbrains.php.lang.psi.elements.PhpTraitUseRule;
import com.jetbrains.php.lang.psi.elements.PhpTypeDeclaration;
import com.jetbrains.php.lang.psi.elements.PhpUse;
import com.jetbrains.php.lang.psi.elements.PhpUseList;
import com.jetbrains.php.lang.psi.elements.PhpYield;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.Try;
import com.jetbrains.php.lang.psi.elements.While;
import com.jetbrains.php.lang.psi.elements.impl.FieldImpl;
import com.jetbrains.php.lang.psi.elements.impl.FunctionImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpModifierListImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpPromotedFieldParameterImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeSignatureKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpKeywordsCompletionContributor
extends CompletionContributor
implements DumbAware {
    public static final ElementPattern<PsiElement> IN_FIELD_TYPE = PlatformPatterns.psiElement().withParent((ElementPattern)PlatformPatterns.psiElement(ClassReference.class).withParent((ElementPattern)PlatformPatterns.psiElement(PhpTypeDeclaration.class).afterSibling((ElementPattern)PlatformPatterns.psiElement(PhpModifierList.class))));
    private static final ElementPattern<PsiElement> IN_NS_REF_IN_FIELD_TYPE = PlatformPatterns.psiElement().withParent((ElementPattern)PlatformPatterns.psiElement(PhpNamespaceReference.class).withSuperParent(2, (ElementPattern)PlatformPatterns.psiElement(PhpTypeDeclaration.class)));
    private static final ElementPattern<PsiElement> AFTER_NUMBER_LITERAL = PlatformPatterns.psiElement().afterLeafSkipping(StandardPatterns.alwaysFalse(), (ElementPattern)PlatformPatterns.psiElement().withElementType((ElementPattern)PlatformPatterns.elementType().oneOf((Object[])PhpTokenTypes.tsNUMBERS.getTypes())));
    private static final String KEYWORD_SUFFIX = " keyword";
    private static final TokenSet AS_INSTEADOF = TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.kwAS, PhpTokenTypes.kwINSTEADOF});
    static final TokenSet CONST_FUNCTION = TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.kwCONST, PhpTokenTypes.kwFUNCTION});
    private static final String RETURN_TRUE_ITEM = "return true";
    private static final String RETURN_FALSE_ITEM = "return false";
    private static final String RETURN_NULL_ITEM = "return null";
    public static final List<String> ALL_DIRECTIVES = List.of("ticks", "encoding", "strict_types");
    private static final List<String> DIRECTIVES_WITHOUT_SCALARS = List.of("ticks", "encoding");

    @NotNull
    private static List<LookupElementBuilder> getStatementKeywords(@NotNull Project project) {
        if (project == null) {
            PhpKeywordsCompletionContributor.$$$reportNull$$$0(0);
        }
        ArrayList<LookupElementBuilder> keywords = new ArrayList<LookupElementBuilder>(Arrays.asList(PhpKeywordsCompletionContributor.k(PhpTokenTypes.kwIF), PhpKeywordsCompletionContributor.k(PhpTokenTypes.kwSWITCH), PhpKeywordsCompletionContributor.k(PhpTokenTypes.kwWHILE), PhpKeywordsCompletionContributor.k(PhpTokenTypes.kwFOR), PhpKeywordsCompletionContributor.k(PhpTokenTypes.kwFOREACH), PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwDECLARE, (InsertHandler<LookupElement>)ParenthesesInsertHandler.WITH_PARAMETERS), PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwDO, null), PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwRETURN, (InsertHandler<LookupElement>)PhpReturnKeywordInsertHandler.getInstance()), PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwTRY, PhpGroupStatementBodyInsertHandler.TRY_INSTANCE), PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwFUNCTION, (InsertHandler<LookupElement>)PhpBaseKeywordInsertHandler.WITH_PARAMETERS_BODY), PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwTHROW), PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwCONST), PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwCLASS, (InsertHandler<LookupElement>)PhpBaseKeywordInsertHandler.WITH_BODY), PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwINTERFACE, (InsertHandler<LookupElement>)PhpBaseKeywordInsertHandler.WITH_BODY), PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwTRAIT, (InsertHandler<LookupElement>)PhpBaseKeywordInsertHandler.WITH_BODY), PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwENUM, (InsertHandler<LookupElement>)PhpBaseKeywordInsertHandler.WITH_BODY), PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwGOTO), PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwGLOBAL), PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwABSTRACT), PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwFINAL), PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwECHO)));
        if (PhpLanguageFeature.ARROW_FUNCTION_SYNTAX.isSupported(project)) {
            keywords.add(PhpKeywordsCompletionContributor.k(PhpTokenTypes.kwFN));
        }
        if (PhpLanguageFeature.READONLY_CLASSES.isSupported(project)) {
            keywords.add(PhpKeywordsCompletionContributor.e("readonly"));
        }
        ArrayList<LookupElementBuilder> arrayList = keywords;
        if (arrayList == null) {
            PhpKeywordsCompletionContributor.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @NotNull
    private static List<LookupElementBuilder> getExpressionKeywords(@NotNull Project project) {
        if (project == null) {
            PhpKeywordsCompletionContributor.$$$reportNull$$$0(2);
        }
        ArrayList<LookupElementBuilder> keywords = new ArrayList<LookupElementBuilder>(Arrays.asList(PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwCLONE), PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwNEW), PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwINCLUDE), PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwINCLUDE_ONCE), PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwREQUIRE), PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwREQUIRE_ONCE), PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwPRINT)));
        if (PhpLanguageFeature.MATCH_EXPRESSION.isSupported(project)) {
            keywords.add(PhpKeywordsCompletionContributor.k(PhpTokenTypes.kwMATCH));
        }
        ArrayList<LookupElementBuilder> arrayList = keywords;
        if (arrayList == null) {
            PhpKeywordsCompletionContributor.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @NotNull
    private static List<LookupElementBuilder> getClassKeywords(@NotNull Project project) {
        if (project == null) {
            PhpKeywordsCompletionContributor.$$$reportNull$$$0(4);
        }
        ArrayList<LookupElementBuilder> keywords = new ArrayList<LookupElementBuilder>(Arrays.asList(PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwABSTRACT), PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwFINAL), PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwPRIVATE, (InsertHandler<LookupElement>)PhpSymbolInsertHandler.VISIBILITY), PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwPROTECTED, (InsertHandler<LookupElement>)PhpSymbolInsertHandler.VISIBILITY), PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwUSE), PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwVAR)));
        if (PhpLanguageFeature.READONLY_PROPERTIES.isSupported(project)) {
            keywords.add(PhpKeywordsCompletionContributor.e("readonly"));
        }
        ArrayList<LookupElementBuilder> arrayList = keywords;
        if (arrayList == null) {
            PhpKeywordsCompletionContributor.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @NotNull
    private static List<LookupElementBuilder> getInterfaceKeywords(boolean notInterface, Project project) {
        List<LookupElementBuilder> list = List.of(PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwFUNCTION, (InsertHandler<LookupElement>)(notInterface ? PhpBaseKeywordInsertHandler.WITH_PARAMETERS_BODY : PhpBaseKeywordInsertHandler.WITH_PARAMETERS)), PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwPUBLIC, (InsertHandler<LookupElement>)PhpSymbolInsertHandler.VISIBILITY), PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwSTATIC));
        if (PhpLanguageFeature.ASYMMETRIC_VISIBILITY.isSupported(project)) {
            List<LookupElementBuilder> asymmetricVisibilityKeywords = List.of(PhpKeywordsCompletionContributor.e("public(set)", (InsertHandler<LookupElement>)PhpSymbolInsertHandler.ASYMMETRIC_VISIBILITY), PhpKeywordsCompletionContributor.e("protected(set)", (InsertHandler<LookupElement>)PhpSymbolInsertHandler.ASYMMETRIC_VISIBILITY), PhpKeywordsCompletionContributor.e("private(set)", (InsertHandler<LookupElement>)PhpSymbolInsertHandler.ASYMMETRIC_VISIBILITY));
            List list2 = ContainerUtil.concat(list, asymmetricVisibilityKeywords);
            if (list2 == null) {
                PhpKeywordsCompletionContributor.$$$reportNull$$$0(6);
            }
            return list2;
        }
        List<LookupElementBuilder> list3 = list;
        if (list3 == null) {
            PhpKeywordsCompletionContributor.$$$reportNull$$$0(7);
        }
        return list3;
    }

    public PhpKeywordsCompletionContributor() {
        PhpClassDeclarationCompletionProvider classDeclarationCompletionProvider = new PhpClassDeclarationCompletionProvider();
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withParent((ElementPattern)PlatformPatterns.psiElement(PhpClass.class)), classDeclarationCompletionProvider);
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(2, (ElementPattern)PlatformPatterns.psiElement().afterSibling((ElementPattern)PlatformPatterns.psiElement(PhpClass.class))), classDeclarationCompletionProvider);
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(2, (ElementPattern)PlatformPatterns.psiElement().afterSibling((ElementPattern)PlatformPatterns.psiElement(Statement.class))), classDeclarationCompletionProvider);
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(2, (ElementPattern)PlatformPatterns.psiElement().afterSibling((ElementPattern)PlatformPatterns.psiElement(Try.class))), new PhpCatchFinallyCompletionProvider());
        PhpAnonymousFunctionCompletionProvider anonymousFunctionCompletionProvider = new PhpAnonymousFunctionCompletionProvider();
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(2, ParameterList.class), anonymousFunctionCompletionProvider);
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(2, AssignmentExpression.class), anonymousFunctionCompletionProvider);
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(2, PhpReturn.class), anonymousFunctionCompletionProvider);
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(2, PhpYield.class), anonymousFunctionCompletionProvider);
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(2, (ElementPattern)PlatformPatterns.psiElement().afterSibling((ElementPattern)PlatformPatterns.psiElement(Function.class))), anonymousFunctionCompletionProvider);
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(2, (ElementPattern)PlatformPatterns.psiElement().afterSibling((ElementPattern)PlatformPatterns.psiElement(Statement.class))), anonymousFunctionCompletionProvider);
        this.extend(CompletionType.BASIC, StandardPatterns.or((ElementPattern[])new ElementPattern[]{PlatformPatterns.psiElement().withParent(PhpClass.class), IN_FIELD_TYPE}), new PhpClassLevelCompletionProvider());
        this.extend(CompletionType.BASIC, IN_NS_REF_IN_FIELD_TYPE, new PhpReadonlyBeforeFullyNamespacedPropertyTypeProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(2, DoWhile.class), new PhpDoWhileLevelCompletionProvider());
        PhpForeachLevelCompletionProvider foreachLevelCompletionProvider = new PhpForeachLevelCompletionProvider();
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(3, ForeachStatement.class), foreachLevelCompletionProvider);
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(4, ForeachStatement.class), foreachLevelCompletionProvider);
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(5, ForeachStatement.class), foreachLevelCompletionProvider);
        PhpLogicalOperatorCompletionProvider logicalOperatorCompletionProvider = new PhpLogicalOperatorCompletionProvider();
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(2, For.class), logicalOperatorCompletionProvider);
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(3, For.class), logicalOperatorCompletionProvider);
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(3, If.class), logicalOperatorCompletionProvider);
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(3, ElseIf.class), logicalOperatorCompletionProvider);
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(3, While.class), logicalOperatorCompletionProvider);
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(2, (ElementPattern)PlatformPatterns.psiElement().afterSibling((ElementPattern)PlatformPatterns.psiElement(DoWhile.class))), logicalOperatorCompletionProvider);
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(2, (ElementPattern)PlatformPatterns.psiElement().afterSibling((ElementPattern)PlatformPatterns.psiElement(Statement.class))), logicalOperatorCompletionProvider);
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().inside(true, (ElementPattern)PlatformPatterns.psiElement(PhpCase.class)), logicalOperatorCompletionProvider);
        PhpNamespaceLevelCompletionProvider namespaceLevelCompletionProvider = new PhpNamespaceLevelCompletionProvider();
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(4, PhpNamespace.class), namespaceLevelCompletionProvider);
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(5, PhpNamespace.class), namespaceLevelCompletionProvider);
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(6, PhpNamespace.class), namespaceLevelCompletionProvider);
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(4, PhpFile.class), namespaceLevelCompletionProvider);
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(5, PhpFile.class), namespaceLevelCompletionProvider);
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(6, PhpFile.class), namespaceLevelCompletionProvider);
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withParent(ConstantReference.class), new PhpBasicKeywordsCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(2, NewExpression.class), new PhpAnonymousClassCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withParent(PhpTraitUseRule.class), new PhpUseClauseCompletionProvider());
        PhpIfLevelCompletionProvider ifLevelCompletionProvider = new PhpIfLevelCompletionProvider();
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(2, (ElementPattern)PlatformPatterns.psiElement().afterSibling((ElementPattern)PlatformPatterns.psiElement(If.class))), ifLevelCompletionProvider);
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(3, If.class), ifLevelCompletionProvider);
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(4, If.class), ifLevelCompletionProvider);
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(5, If.class), ifLevelCompletionProvider);
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(6, If.class), ifLevelCompletionProvider);
        PhpSwitchLevelCompletionProvider switchLevelCompletionProvider = new PhpSwitchLevelCompletionProvider();
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withParent(PhpSwitch.class), switchLevelCompletionProvider);
        this.extend(CompletionType.BASIC, (ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withSuperParent(4, PhpSwitch.class)).atStartOf((ElementPattern)PlatformPatterns.psiElement(Statement.class)), switchLevelCompletionProvider);
        this.extend(CompletionType.BASIC, (ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withSuperParent(5, PhpSwitch.class)).atStartOf((ElementPattern)PlatformPatterns.psiElement(Statement.class)), switchLevelCompletionProvider);
        this.extend(CompletionType.BASIC, (ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withSuperParent(6, PhpSwitch.class)).atStartOf((ElementPattern)PlatformPatterns.psiElement(Statement.class)), switchLevelCompletionProvider);
        PhpWhileLevelCompletionProvider whileLevelCompletionProvider = new PhpWhileLevelCompletionProvider();
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(3, While.class), whileLevelCompletionProvider);
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(4, While.class), whileLevelCompletionProvider);
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(5, While.class), whileLevelCompletionProvider);
        PhpForLevelCompletionProvider forLevelCompletionProvider = new PhpForLevelCompletionProvider();
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(3, For.class), forLevelCompletionProvider);
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(4, For.class), forLevelCompletionProvider);
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(5, For.class), forLevelCompletionProvider);
        PhpDeclareLevelCompletionProvider declareLevelCompletionProvider = new PhpDeclareLevelCompletionProvider();
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(2, Declare.class), declareLevelCompletionProvider);
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(3, Declare.class), declareLevelCompletionProvider);
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(4, Declare.class), declareLevelCompletionProvider);
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(5, Declare.class), declareLevelCompletionProvider);
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(2, PhpMatchArm.class), new PhpMatchExpressionLevelCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(2, PhpParameterType.class), new PhpPromotedFieldParametersKeyword());
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withParent(PhpPropertyHook.class), new PhpPropertyHooksKeywordCompletionProvider());
    }

    public void beforeCompletion(@NotNull CompletionInitializationContext context) {
        PsiElement nextElement;
        PsiFile file;
        PsiElement currentElement;
        if (context == null) {
            PhpKeywordsCompletionContributor.$$$reportNull$$$0(8);
        }
        if ((currentElement = (file = context.getFile()).findElementAt(context.getStartOffset())) instanceof PsiWhiteSpace && PhpPsiUtil.isOfType(nextElement = file.findElementAt(currentElement.getTextRange().getEndOffset()), PhpTokenTypes.NAMESPACE_RESOLUTION) && currentElement.getText().contains("\n")) {
            context.setDummyIdentifier(context.getDummyIdentifier() + ";");
        }
    }

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            PhpKeywordsCompletionContributor.$$$reportNull$$$0(9);
        }
        if (result == null) {
            PhpKeywordsCompletionContributor.$$$reportNull$$$0(10);
        }
        if (AFTER_NUMBER_LITERAL.accepts((Object)parameters.getOriginalPosition())) {
            result.stopHere();
            return;
        }
        super.fillCompletionVariants(parameters, PhpCompletionSorting.addPhpSorting(parameters, result));
    }

    public static boolean isReturnCompletionItem(@NotNull String object) {
        if (object == null) {
            PhpKeywordsCompletionContributor.$$$reportNull$$$0(11);
        }
        return object.equals("return") || object.equals(RETURN_TRUE_ITEM) || object.equals(RETURN_FALSE_ITEM) || object.equals(RETURN_NULL_ITEM);
    }

    private static void addKeywordsAsymmetricModifierListAware(@NotNull CompletionResultSet result, @Nullable PhpModifierList list, Project project) {
        if (result == null) {
            PhpKeywordsCompletionContributor.$$$reportNull$$$0(12);
        }
        if (list != null && list.hasStatic()) {
            return;
        }
        if (PhpLanguageFeature.ASYMMETRIC_VISIBILITY.isSupported(project) && PhpModifierListImpl.getSetOperationModifierPsiElement((PsiElement)list) == null) {
            if (list == null || list.hasPublic()) {
                result.addAllElements(Arrays.asList(PhpKeywordsCompletionContributor.e("protected(set)", (InsertHandler<LookupElement>)PhpSymbolInsertHandler.ASYMMETRIC_VISIBILITY), PhpKeywordsCompletionContributor.e("private(set)", (InsertHandler<LookupElement>)PhpSymbolInsertHandler.ASYMMETRIC_VISIBILITY)));
            } else if (list.hasProtected()) {
                result.addElement((LookupElement)PhpKeywordsCompletionContributor.e("private(set)", (InsertHandler<LookupElement>)PhpSymbolInsertHandler.ASYMMETRIC_VISIBILITY));
            }
        }
    }

    private static boolean isPropertyHooks(@Nullable PsiElement sibling) {
        if (sibling == null) {
            return false;
        }
        if (!PhpLanguageFeature.PROPERTY_HOOKS.isSupported(sibling.getProject()) || !(sibling instanceof PhpClassFieldsList)) {
            return false;
        }
        PhpClassFieldsList list = (PhpClassFieldsList)sibling;
        Field field = (Field)ContainerUtil.getOnlyItem(list.getFields());
        if (field == null) {
            return false;
        }
        return field.hasPropertyHooksContainer();
    }

    private static void addKeywordsModifierListAware(@NotNull CompletionResultSet result, @Nullable PhpModifierList modifierList) {
        PhpClass clazz;
        if (result == null) {
            PhpKeywordsCompletionContributor.$$$reportNull$$$0(13);
        }
        if ((clazz = PhpPsiUtil.getParentOfClass((PsiElement)modifierList, PhpClass.class)) == null || PhpPsiUtil.getChildOfType((PsiElement)modifierList, PhpTokenTypes.kwVAR) != null) {
            return;
        }
        if (!modifierList.hasReadonly()) {
            result.addElement((LookupElement)PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwFUNCTION, (InsertHandler<LookupElement>)(clazz.isInterface() || modifierList.hasAbstract() ? PhpBaseKeywordInsertHandler.WITH_PARAMETERS : PhpBaseKeywordInsertHandler.WITH_PARAMETERS_BODY)));
        }
        if (!modifierList.hasStatic() && !modifierList.hasReadonly()) {
            result.addElement((LookupElement)PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwSTATIC));
        }
        if (!(modifierList.hasPublic() || modifierList.hasProtected() || modifierList.hasPrivate())) {
            result.addElement((LookupElement)PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwPUBLIC, (InsertHandler<LookupElement>)PhpSymbolInsertHandler.VISIBILITY));
            if (!clazz.isInterface()) {
                result.addAllElements(Arrays.asList(PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwPROTECTED, (InsertHandler<LookupElement>)PhpSymbolInsertHandler.VISIBILITY), PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwPRIVATE, (InsertHandler<LookupElement>)PhpSymbolInsertHandler.VISIBILITY)));
            }
        }
        if (!(clazz.isInterface() || modifierList.hasAbstract() || modifierList.hasFinal() || modifierList.hasReadonly())) {
            result.addAllElements(Arrays.asList(PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwABSTRACT), PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwFINAL)));
        }
        if (!(!PhpLanguageFeature.CLASS_CONSTANT_VISIBILITY.isSupported(modifierList.getProject()) || clazz.isTrait() && !PhpLanguageFeature.CONSTANTS_IN_TRAITS.isSupported(modifierList.getProject()) || modifierList.hasStatic() || modifierList.hasAbstract() || modifierList.hasReadonly() || modifierList.hasFinal() && !PhpLanguageFeature.FINAL_CLASS_CONSTANTS.isSupported(modifierList.getProject()) || !modifierList.hasFinal() && !modifierList.hasPublic() && (clazz.isInterface() || !modifierList.hasProtected() && !modifierList.hasPrivate()))) {
            result.addElement((LookupElement)PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwCONST));
        }
        if (!(!PhpLanguageFeature.READONLY_PROPERTIES.isSupported(modifierList.getProject()) || modifierList.hasStatic() || modifierList.hasAbstract() || modifierList.hasFinal() || modifierList.hasReadonly())) {
            result.addElement((LookupElement)PhpKeywordsCompletionContributor.e("readonly"));
        }
    }

    private static boolean isInsideBraces(PsiElement parent) {
        PsiElement sibling = PhpPsiUtil.findPrevSiblingOfAnyType(parent, PhpTokenTypes.chLBRACE, PhpTokenTypes.chRBRACE);
        return PhpPsiUtil.isOfType(sibling, PhpTokenTypes.chLBRACE);
    }

    private static boolean isUseList(PsiElement position) {
        return PhpPsiUtil.getParentByCondition(position, PhpUseList.INSTANCEOF, GroupStatement.INSTANCEOF) != null;
    }

    public static Collection<String> getSupportedDeclareDirectives(Project project) {
        if (PhpLanguageFeature.SCALAR_TYPE_HINTS.isSupported(project)) {
            return ALL_DIRECTIVES;
        }
        return DIRECTIVES_WITHOUT_SCALARS;
    }

    private static void addAllElements(@NotNull CompletionResultSet result, @NotNull TokenSet tokenSet) {
        if (result == null) {
            PhpKeywordsCompletionContributor.$$$reportNull$$$0(14);
        }
        if (tokenSet == null) {
            PhpKeywordsCompletionContributor.$$$reportNull$$$0(15);
        }
        for (IElementType type : tokenSet.getTypes()) {
            result.addElement((LookupElement)PhpKeywordsCompletionContributor.e(type));
        }
    }

    private static void addAllElements(@NotNull CompletionResultSet result, @NotNull TokenSet tokenSet, @Nullable InsertHandler<LookupElement> insertHandler) {
        if (result == null) {
            PhpKeywordsCompletionContributor.$$$reportNull$$$0(16);
        }
        if (tokenSet == null) {
            PhpKeywordsCompletionContributor.$$$reportNull$$$0(17);
        }
        for (IElementType type : tokenSet.getTypes()) {
            result.addElement((LookupElement)PhpKeywordsCompletionContributor.e(type, insertHandler));
        }
    }

    @NotNull
    private static LookupElementBuilder e(@NotNull IElementType token) {
        if (token == null) {
            PhpKeywordsCompletionContributor.$$$reportNull$$$0(18);
        }
        return PhpKeywordsCompletionContributor.e(PhpKeywordsCompletionContributor.getString(token));
    }

    @NotNull
    private static LookupElementBuilder k(@NotNull IElementType token) {
        if (token == null) {
            PhpKeywordsCompletionContributor.$$$reportNull$$$0(19);
        }
        return PhpKeywordsCompletionContributor.e(PhpKeywordsCompletionContributor.getString(token), (InsertHandler<LookupElement>)new PhpKeywordInsertHandler(token));
    }

    @NotNull
    private static LookupElementBuilder e(@NotNull IElementType token, @Nullable InsertHandler<LookupElement> insertHandler) {
        if (token == null) {
            PhpKeywordsCompletionContributor.$$$reportNull$$$0(20);
        }
        return PhpKeywordsCompletionContributor.e(PhpKeywordsCompletionContributor.getString(token), insertHandler);
    }

    @NotNull
    private static LookupElementBuilder e(@NotNull String keyword) {
        if (keyword == null) {
            PhpKeywordsCompletionContributor.$$$reportNull$$$0(21);
        }
        return PhpKeywordsCompletionContributor.e(keyword, (InsertHandler<LookupElement>)PhpSymbolInsertHandler.SPACE);
    }

    @NotNull
    private static LookupElementBuilder e(@NotNull String keyword, @Nullable InsertHandler<LookupElement> insertHandler) {
        if (keyword == null) {
            PhpKeywordsCompletionContributor.$$$reportNull$$$0(22);
        }
        LookupElementBuilder lookupElementBuilder = LookupElementBuilder.create((String)keyword).withBoldness(true).withInsertHandler(insertHandler);
        if (lookupElementBuilder == null) {
            PhpKeywordsCompletionContributor.$$$reportNull$$$0(23);
        }
        return lookupElementBuilder;
    }

    @NotNull
    static String getString(@NotNull IElementType token) {
        String s;
        if (token == null) {
            PhpKeywordsCompletionContributor.$$$reportNull$$$0(24);
        }
        String string = (s = token.toString()).endsWith(KEYWORD_SUFFIX) ? s.substring(0, s.length() - KEYWORD_SUFFIX.length()) : s;
        if (string == null) {
            PhpKeywordsCompletionContributor.$$$reportNull$$$0(25);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 5, 6, 7, 23, 25 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/completion/PhpKeywordsCompletionContributor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenSet";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "token";
                break;
            }
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyword";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/completion/PhpKeywordsCompletionContributor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatementKeywords";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpressionKeywords";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassKeywords";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getInterfaceKeywords";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "e";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getStatementKeywords";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 23: 
            case 25: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getExpressionKeywords";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getClassKeywords";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "beforeCompletion";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "fillCompletionVariants";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isReturnCompletionItem";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addKeywordsAsymmetricModifierListAware";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addKeywordsModifierListAware";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addAllElements";
                break;
            }
            case 18: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "e";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "k";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getString";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 5, 6, 7, 23, 25 -> new IllegalStateException(string);
        };
    }

    private static class PhpClassDeclarationCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private PhpClassDeclarationCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            PhpClass phpClass;
            PsiElement position;
            PsiElement parent;
            if (parameters == null) {
                PhpClassDeclarationCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PhpClassDeclarationCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                PhpClassDeclarationCompletionProvider.$$$reportNull$$$0(2);
            }
            if ((parent = (position = parameters.getPosition().getOriginalElement()).getParent()) instanceof StringLiteralExpression) {
                return;
            }
            PsiElement grandParent = parent.getParent();
            if (PhpCompletionContributor.isDefaultValue(grandParent)) {
                return;
            }
            PhpClass phpClass2 = phpClass = parent instanceof PhpClass ? (PhpClass)parent : PhpClassDeclarationCompletionProvider.getPhpClass(grandParent);
            if (phpClass != null && (parent instanceof PhpClass || !PhpPsiUtil.isOfType(phpClass.getLastChild(), PhpTokenTypes.chRBRACE))) {
                PsiElement sibling;
                PsiElement nextBrace = PhpPsiUtil.findNextSiblingOfAnyType(position, PhpTokenTypes.chLBRACE, PhpTokenTypes.chRBRACE);
                PsiElement prevBrace = PhpPsiUtil.findPrevSiblingOfAnyType(position, PhpTokenTypes.chLBRACE, PhpTokenTypes.chRBRACE);
                if (!(parent instanceof PhpClass && nextBrace != PhpPsiUtil.getChildOfType((PsiElement)phpClass, PhpTokenTypes.chLBRACE) && (nextBrace != null || prevBrace != null) || (PhpPsiUtil.isOfType(sibling = PhpPsiUtil.getPrevSibling(position, PhpPsiUtil.PSI_WHITE_SPACE_INSTANCEOF, PhpPsiUtil.PSI_ERROR_ELEMENT_INSTANCEOF), PhpTokenTypes.kwFINAL, PhpTokenTypes.kwABSTRACT, PhpTokenTypes.kwCLASS, PhpTokenTypes.kwINTERFACE, PhpTokenTypes.kwENUM, PhpTokenTypes.kwTRAIT) || sibling != null && FieldImpl.isReadonlyKeyword(sibling.getNode())) && !(grandParent instanceof NewExpression))) {
                    if (!phpClass.isTrait()) {
                        ImplementsList implementsList = phpClass.getImplementsList();
                        ExtendsList extendsList = phpClass.getExtendsList();
                        if (!(PhpPsiUtil.isOfType(implementsList.getFirstChild(), PhpTokenTypes.kwIMPLEMENTS) || phpClass.isInterface() || PhpPsiUtil.isOfType(extendsList.getFirstChild(), PhpTokenTypes.kwEXTENDS) && PhpPsiUtil.getNextSiblingIgnoreWhitespace(position, true) == extendsList)) {
                            result.addElement((LookupElement)PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwIMPLEMENTS));
                        }
                        if (!PhpPsiUtil.isOfType(extendsList.getFirstChild(), PhpTokenTypes.kwEXTENDS) && PhpPsiUtil.getNextSiblingIgnoreWhitespace(position, true) == extendsList) {
                            result.addElement((LookupElement)PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwEXTENDS));
                        }
                    }
                    result.stopHere();
                }
            }
        }

        @Nullable
        private static PhpClass getPhpClass(@NotNull PsiElement statement) {
            if (statement == null) {
                PhpClassDeclarationCompletionProvider.$$$reportNull$$$0(3);
            }
            if (!(statement instanceof Statement)) {
                return null;
            }
            PhpPsiElement sibling = ((Statement)statement).getPrevPsiSibling();
            if (sibling instanceof PhpClass) {
                return (PhpClass)sibling;
            }
            if (sibling instanceof Statement) {
                PhpPsiElement element;
                Object child = sibling.getFirstChild();
                if (child instanceof AssignmentExpression) {
                    child = ((AssignmentExpression)child).getValue();
                }
                if (PhpPsiUtil.isOfType(child, PhpTokenTypes.kwTHROW)) {
                    child = sibling.getFirstPsiChild();
                }
                if (child instanceof NewExpression && (element = ((NewExpression)child).getFirstPsiChild()) instanceof PhpClass) {
                    return (PhpClass)element;
                }
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/completion/PhpKeywordsCompletionContributor$PhpClassDeclarationCompletionProvider";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addCompletions";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getPhpClass";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PhpCatchFinallyCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private PhpCatchFinallyCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            Try tryStatement;
            PsiElement position;
            if (parameters == null) {
                PhpCatchFinallyCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PhpCatchFinallyCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                PhpCatchFinallyCompletionProvider.$$$reportNull$$$0(2);
            }
            if ((position = parameters.getPosition().getOriginalElement()).getParent() instanceof StringLiteralExpression) {
                return;
            }
            PsiElement parent = position.getParent().getParent();
            if (parent instanceof Statement && (tryStatement = (Try)((Statement)parent).getPrevPsiSibling()) != null && tryStatement.getFinallyBlock() == null) {
                result.addAllElements(Arrays.asList(PhpKeywordsCompletionContributor.k(PhpTokenTypes.kwCATCH), PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwFINALLY, PhpGroupStatementBodyInsertHandler.FINALLY_INSTANCE)));
                if (tryStatement.getCatchClauses().length == 0) {
                    result.stopHere();
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/completion/PhpKeywordsCompletionContributor$PhpCatchFinallyCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PhpAnonymousFunctionCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private PhpAnonymousFunctionCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            Function function;
            PsiElement position;
            PsiElement parent;
            PsiElement grandParent;
            if (parameters == null) {
                PhpAnonymousFunctionCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PhpAnonymousFunctionCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                PhpAnonymousFunctionCompletionProvider.$$$reportNull$$$0(2);
            }
            if (PhpCompletionContributor.isDefaultValue(grandParent = (parent = (position = parameters.getPosition().getOriginalElement()).getParent()).getParent())) {
                return;
            }
            if ((grandParent instanceof ParameterList || grandParent instanceof PhpReturn || grandParent instanceof PhpYield) && parent instanceof ConstantReference && parent.getFirstChild() == position) {
                result.addElement((LookupElement)PhpKeywordsCompletionContributor.k(PhpTokenTypes.kwFUNCTION));
                if (PhpLanguageFeature.ARROW_FUNCTION_SYNTAX.isSupported(position.getProject())) {
                    result.addElement((LookupElement)PhpKeywordsCompletionContributor.k(PhpTokenTypes.kwFN));
                }
            } else if (grandParent instanceof AssignmentExpression) {
                PhpPsiElement value = ((AssignmentExpression)grandParent).getValue();
                if (value != null && value.getFirstChild() == position && !PhpPsiUtil.isOfType((PsiElement)value, PhpElementTypes.HEREDOC)) {
                    result.addElement((LookupElement)PhpKeywordsCompletionContributor.k(PhpTokenTypes.kwFUNCTION));
                    if (PhpLanguageFeature.ARROW_FUNCTION_SYNTAX.isSupported(position.getProject())) {
                        result.addElement((LookupElement)PhpKeywordsCompletionContributor.k(PhpTokenTypes.kwFN));
                    }
                }
            } else if (grandParent instanceof Statement && (function = PhpAnonymousFunctionCompletionProvider.getFunction((Statement)grandParent)) != null && function.isClosure() && !FunctionImpl.isShortArrowFunction(function) && !(function.getLastChild() instanceof GroupStatement)) {
                if (PhpPsiUtil.getChildByCondition(function, PhpUseList.INSTANCEOF) == null) {
                    result.addElement((LookupElement)PhpKeywordsCompletionContributor.k(PhpTokenTypes.kwUSE));
                }
                result.stopHere();
            }
        }

        @Nullable
        private static Function getFunction(@NotNull Statement statement) {
            PhpPsiElement sibling;
            if (statement == null) {
                PhpAnonymousFunctionCompletionProvider.$$$reportNull$$$0(3);
            }
            if ((sibling = statement.getPrevPsiSibling()) instanceof Function) {
                return (Function)sibling;
            }
            if (sibling instanceof Statement) {
                PsiElement child;
                Object[] parameters;
                PsiElement lastParameter;
                Object expression = PhpPsiUtil.getChildByCondition((PsiElement)sibling, PhpExpression.INSTANCEOF);
                if (expression instanceof AssignmentExpression) {
                    expression = ((AssignmentExpression)expression).getValue();
                }
                if (expression instanceof FunctionReference && PhpPsiUtil.isOfType(lastParameter = (PsiElement)ArrayUtil.getLastElement((Object[])(parameters = ((FunctionReference)expression).getParameters())), PhpElementTypes.CLOSURE)) {
                    expression = lastParameter;
                }
                if (expression instanceof PhpExpression && (child = expression.getFirstChild()) instanceof Function) {
                    return (Function)child;
                }
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/completion/PhpKeywordsCompletionContributor$PhpAnonymousFunctionCompletionProvider";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addCompletions";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getFunction";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PhpClassLevelCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private PhpClassLevelCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            PsiElement position;
            PsiElement parent;
            if (parameters == null) {
                PhpClassLevelCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PhpClassLevelCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                PhpClassLevelCompletionProvider.$$$reportNull$$$0(2);
            }
            if ((parent = (position = parameters.getPosition().getOriginalElement()).getParent()) instanceof PhpClass) {
                boolean notEnum;
                PhpClass phpClass = (PhpClass)parent;
                boolean notInterface = !phpClass.isInterface();
                boolean notTrait = !phpClass.isTrait();
                boolean bl = notEnum = !phpClass.isEnum();
                if (notInterface && notTrait && notEnum && PhpPsiUtil.getPrevSiblingByCondition(position, (Condition<? super PsiElement>)((Condition)e -> PhpPsiUtil.isOfType(e, PhpTokenTypes.kwCLASS))) == null) {
                    if (!phpClass.isAbstract() && !phpClass.isFinal()) {
                        result.addElement((LookupElement)PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwABSTRACT));
                        result.addElement((LookupElement)PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwFINAL));
                    }
                    if (!phpClass.isReadonly() && PhpLanguageFeature.READONLY_CLASSES.isSupported(phpClass.getProject())) {
                        result.addElement((LookupElement)PhpKeywordsCompletionContributor.e("readonly"));
                    }
                }
                if (notInterface && notTrait && notEnum && PhpPsiUtil.getChildOfType((PsiElement)phpClass, PhpTokenTypes.kwCLASS) == null) {
                    result.addElement((LookupElement)PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwCLASS, (InsertHandler<LookupElement>)PhpBaseKeywordInsertHandler.WITH_BODY));
                    result.stopHere();
                } else if (PhpKeywordsCompletionContributor.isInsideBraces(position)) {
                    PsiElement sibling = PhpPsiUtil.getPrevSibling(position, PhpPsiUtil.PSI_WHITE_SPACE_INSTANCEOF, PhpPsiUtil.PSI_ERROR_ELEMENT_INSTANCEOF);
                    if (sibling instanceof PhpModifierList) {
                        PhpModifierList modifierList = (PhpModifierList)sibling;
                        PhpKeywordsCompletionContributor.addKeywordsModifierListAware(result, modifierList);
                        PhpKeywordsCompletionContributor.addKeywordsAsymmetricModifierListAware(result, modifierList, sibling.getProject());
                    } else if (!PhpPsiUtil.isOfType(sibling, PhpElementTypes.CLASS_FIELDS) || PhpKeywordsCompletionContributor.isPropertyHooks(sibling) || PhpPsiUtil.isOfType(sibling.getLastChild(), PhpTokenTypes.opSEMICOLON)) {
                        result.addAllElements(PhpKeywordsCompletionContributor.getInterfaceKeywords(notInterface, parent.getProject()));
                        if (notInterface) {
                            result.addAllElements(PhpKeywordsCompletionContributor.getClassKeywords(position.getProject()));
                        }
                        if (notTrait || PhpLanguageFeature.CONSTANTS_IN_TRAITS.isSupported(position.getProject())) {
                            result.addElement((LookupElement)PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwCONST));
                        }
                        if (!notEnum) {
                            result.addElement((LookupElement)PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwCASE));
                        }
                    }
                }
            } else if (parent instanceof ClassReference && !PhpCompletionContributor.isNamespace(position.getPrevSibling()) && PhpPsiUtil.getPrevSiblingByCondition(parent, (Condition<? super PsiElement>)((Condition)e -> PhpPsiUtil.isOfType(e, PhpTokenTypes.opQUEST))) == null) {
                if (parent.getParent() instanceof PhpTypeDeclaration) {
                    parent = parent.getParent();
                }
                PhpModifierList modifierList = (PhpModifierList)PhpPsiUtil.getPrevSiblingByCondition(parent, PhpModifierList.INSTANCEOF);
                PhpKeywordsCompletionContributor.addKeywordsModifierListAware(result, modifierList);
                PhpKeywordsCompletionContributor.addKeywordsAsymmetricModifierListAware(result, modifierList, parent.getProject());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/completion/PhpKeywordsCompletionContributor$PhpClassLevelCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class PhpReadonlyBeforeFullyNamespacedPropertyTypeProvider
    extends CompletionProvider<CompletionParameters> {
        private PhpReadonlyBeforeFullyNamespacedPropertyTypeProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            PsiElement element;
            if (parameters == null) {
                PhpReadonlyBeforeFullyNamespacedPropertyTypeProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PhpReadonlyBeforeFullyNamespacedPropertyTypeProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                PhpReadonlyBeforeFullyNamespacedPropertyTypeProvider.$$$reportNull$$$0(2);
            }
            if (PhpLanguageFeature.READONLY_PROPERTIES.isSupported((element = parameters.getPosition().getOriginalElement()).getProject())) {
                Object fieldsList = PhpPsiUtil.getParentByCondition(element, (Condition<? super PsiElement>)((Condition)e -> e instanceof PhpClassFieldsList || e instanceof PhpPromotedFieldParameterImpl), PhpClass.INSTANCEOF);
                if (fieldsList instanceof PhpClassFieldsList) {
                    PhpModifierList modifierList = ((PhpClassFieldsList)fieldsList).getModifierList();
                    if (modifierList != null && !modifierList.hasReadonly() && !modifierList.hasStatic()) {
                        result.addElement((LookupElement)PhpKeywordsCompletionContributor.e("readonly"));
                    }
                } else if (fieldsList instanceof PhpPromotedFieldParameterImpl && !((PhpPromotedFieldParameterImpl)fieldsList).isReadonly()) {
                    result.addElement((LookupElement)PhpKeywordsCompletionContributor.e("readonly"));
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/completion/PhpKeywordsCompletionContributor$PhpReadonlyBeforeFullyNamespacedPropertyTypeProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PhpDoWhileLevelCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private PhpDoWhileLevelCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            PsiElement position;
            PsiElement parent;
            if (parameters == null) {
                PhpDoWhileLevelCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PhpDoWhileLevelCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                PhpDoWhileLevelCompletionProvider.$$$reportNull$$$0(2);
            }
            if (PhpPsiUtil.getChildOfType(parent = (position = parameters.getPosition().getOriginalElement()).getParent().getParent(), PhpTokenTypes.kwWHILE) == null) {
                result.addElement((LookupElement)PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwWHILE, null));
                result.stopHere();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/completion/PhpKeywordsCompletionContributor$PhpDoWhileLevelCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PhpForeachLevelCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private PhpForeachLevelCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            PsiElement position;
            Object parent;
            if (parameters == null) {
                PhpForeachLevelCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PhpForeachLevelCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                PhpForeachLevelCompletionProvider.$$$reportNull$$$0(2);
            }
            if ((parent = PhpPsiUtil.getParentByCondition(position = parameters.getPosition().getOriginalElement(), (Condition<? super PsiElement>)((Condition)e -> e.getParent() instanceof ForeachStatement))) != null) {
                ForeachStatement foreachStatement = (ForeachStatement)parent.getParent();
                if (PhpCompletionContributor.isInsideParentheses(parent) && foreachStatement.getArray() != parent && PhpPsiUtil.getChildOfType((PsiElement)foreachStatement, PhpTokenTypes.kwAS) == null) {
                    result.addElement((LookupElement)PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwAS));
                    result.stopHere();
                } else if (PhpPsiUtil.getChildOfType((PsiElement)foreachStatement, PhpTokenTypes.opCOLON) != null) {
                    result.addElement((LookupElement)PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwENDFOREACH, (InsertHandler<LookupElement>)PhpSymbolInsertHandler.SEMICOLON));
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/completion/PhpKeywordsCompletionContributor$PhpForeachLevelCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PhpLogicalOperatorCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private PhpLogicalOperatorCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            PsiElement position;
            Object parent;
            if (parameters == null) {
                PhpLogicalOperatorCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PhpLogicalOperatorCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                PhpLogicalOperatorCompletionProvider.$$$reportNull$$$0(2);
            }
            if ((parent = (position = parameters.getPosition().getOriginalElement()).getParent().getParent()) instanceof For) {
                parent = position.getParent();
            }
            if (PhpPsiUtil.getParentByCondition(position, false, PhpCase.INSTANCEOF, PhpSwitch.INSTANCEOF) != null) {
                parent = PhpPsiUtil.getParentByCondition(position, false, (Condition<? super PsiElement>)((Condition)element -> element.getPrevSibling() != null), PhpCase.INSTANCEOF);
            }
            if (parent == null) {
                return;
            }
            PsiElement prevSibling = PhpPsiUtil.getPrevSibling(parent, new Condition[]{PhpPsiUtil.PSI_WHITE_SPACE_INSTANCEOF, PhpPsiUtil.PSI_ERROR_ELEMENT_INSTANCEOF});
            if (prevSibling instanceof Statement && !PhpPsiUtil.isOfType(prevSibling.getLastChild(), PhpTokenTypes.opSEMICOLON)) {
                PsiElement cousin = prevSibling.getFirstChild();
                if (prevSibling instanceof DoWhile || cousin instanceof PhpReference || cousin instanceof NewExpression || PhpPsiUtil.isOfType(cousin, PhpElementTypes.LITERAL_LOGICAL_EXPRESSION, PhpElementTypes.INSTANCEOF_EXPRESSION, PhpElementTypes.ASSIGNMENT_EXPRESSION, PhpTokenTypes.kwECHO, PhpTokenTypes.kwRETURN)) {
                    PhpLogicalOperatorCompletionProvider.addKeywords(parameters, result);
                }
            } else if (prevSibling instanceof PhpExpression) {
                boolean isInParenthesisedCondition;
                PsiElement grandParent = parent.getParent();
                boolean bl = isInParenthesisedCondition = (grandParent instanceof If || grandParent instanceof ElseIf || grandParent instanceof While || grandParent instanceof For) && PhpCompletionContributor.isInsideParentheses(parent);
                if (isInParenthesisedCondition || grandParent instanceof PhpCase) {
                    PhpLogicalOperatorCompletionProvider.addKeywords(parameters, result);
                }
            }
        }

        private static void addKeywords(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
            PsiElement prev;
            if (parameters == null) {
                PhpLogicalOperatorCompletionProvider.$$$reportNull$$$0(3);
            }
            if (result == null) {
                PhpLogicalOperatorCompletionProvider.$$$reportNull$$$0(4);
            }
            if ((prev = PhpCompletionContributor.findPrevElement(parameters, result)) instanceof PsiWhiteSpace) {
                result.addAllElements(Arrays.asList(PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwINSTANCEOF), PhpKeywordsCompletionContributor.e(PhpTokenTypes.opLIT_AND), PhpKeywordsCompletionContributor.e(PhpTokenTypes.opLIT_OR), PhpKeywordsCompletionContributor.e(PhpTokenTypes.opLIT_XOR)));
            }
            result.stopHere();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/completion/PhpKeywordsCompletionContributor$PhpLogicalOperatorCompletionProvider";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addCompletions";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addKeywords";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PhpNamespaceLevelCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private PhpNamespaceLevelCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            PsiElement position;
            PsiElement parent;
            PsiElement grandParent;
            if (parameters == null) {
                PhpNamespaceLevelCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PhpNamespaceLevelCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                PhpNamespaceLevelCompletionProvider.$$$reportNull$$$0(2);
            }
            if ((grandParent = (parent = (position = parameters.getPosition().getOriginalElement()).getParent()).getParent()) instanceof PhpTypeDeclaration) {
                grandParent = grandParent.getParent();
            }
            if (parent instanceof ConstantReference && grandParent instanceof Statement && grandParent.getFirstChild() == parent && parent.getFirstChild() == position) {
                PhpPsiElement sibling = ((Statement)grandParent).getPrevPsiSibling();
                if (sibling instanceof PhpUseList && !PhpPsiUtil.isOfType(sibling.getLastChild(), PhpTokenTypes.opSEMICOLON)) {
                    if (PhpPsiUtil.getChildOfType((PsiElement)sibling, PhpTokenTypes.kwAS) == null) {
                        result.addElement((LookupElement)PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwAS));
                    }
                    result.stopHere();
                } else if (grandParent.getParent() instanceof GroupStatement && !PhpCompletionContributor.isGlobal(position)) {
                    result.addElement((LookupElement)PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwUSE));
                }
            } else if (parent instanceof ClassReference && PhpPsiUtil.getChildByCondition(parent, PhpNamespaceReference.INSTANCEOF) == null && grandParent instanceof PhpUse && PhpPsiUtil.getChildOfType(grandParent.getParent(), CONST_FUNCTION) == null && PhpPsiUtil.getParentOfClass(position, PhpClass.class) == null) {
                PhpKeywordsCompletionContributor.addAllElements(result, CONST_FUNCTION);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/completion/PhpKeywordsCompletionContributor$PhpNamespaceLevelCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PhpBasicKeywordsCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private PhpBasicKeywordsCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            PsiElement position;
            PsiElement parent;
            PsiElement grandParent;
            if (parameters == null) {
                PhpBasicKeywordsCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PhpBasicKeywordsCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                PhpBasicKeywordsCompletionProvider.$$$reportNull$$$0(2);
            }
            if (PhpCompletionContributor.isDefaultValue(grandParent = (parent = (position = parameters.getPosition().getOriginalElement()).getParent()).getParent())) {
                if (PhpPsiUtil.getParentByCondition(grandParent, false, (Condition<? super PsiElement>)((Condition)p -> PhpPsiUtil.isOfType(p, PhpElementTypes.PARAMETER_DEFAULT_VALUE)), Statement.INSTANCEOF) != null) {
                    result.addElement((LookupElement)PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwNEW));
                }
                return;
            }
            if (parent instanceof PhpThrowExpression) {
                result.addElement((LookupElement)PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwNEW));
            } else if (!(parent.getFirstChild() != position || PhpBasicKeywordsCompletionProvider.isList(position) || PhpCompletionContributor.isForeachKeyOrValue(position) || PhpKeywordsCompletionContributor.isUseList(position) || PhpCompletionContributor.isIssetOrUnset(position) || PhpCompletionContributor.isGlobal(position) || grandParent instanceof PhpBreak || grandParent instanceof PhpContinue || PhpCompletionContributor.inAttribute(grandParent))) {
                boolean insideParentheses;
                result.addAllElements(PhpKeywordsCompletionContributor.getExpressionKeywords(position.getProject()));
                boolean bl = insideParentheses = PhpCompletionContributor.isInsideParentheses(parent) || PhpCompletionContributor.isInsideParentheses(grandParent);
                if (!(insideParentheses || grandParent instanceof AssignmentExpression || grandParent instanceof PhpReturn || grandParent instanceof PhpYield || grandParent instanceof ParameterList || grandParent instanceof Constant)) {
                    PsiElement ancestor;
                    Function function;
                    result.addAllElements(PhpKeywordsCompletionContributor.getStatementKeywords(position.getProject()));
                    if (PhpLanguageFeature.SCALAR_TYPE_HINTS.isSupported(position.getProject()) && PhpAnnotatorVisitor.allowedPlaceForStrictTypesDeclareStatement(grandParent)) {
                        result.addElement((LookupElement)LookupElementBuilder.create((String)"declare(strict_types=1);"));
                    }
                    if ((function = (Function)PhpPsiUtil.getParentByCondition(position, Function.INSTANCEOF, PhpNamespace.INSTANCEOF)) != null) {
                        PhpType functionType = new PhpType().add(function.getDeclaredType()).add(function.getDocType());
                        if (functionType.filterNull().isBoolean()) {
                            result.addElement((LookupElement)PhpKeywordsCompletionContributor.e(PhpKeywordsCompletionContributor.RETURN_TRUE_ITEM, (InsertHandler<LookupElement>)PhpSymbolInsertHandler.SEMICOLON));
                            result.addElement((LookupElement)PhpKeywordsCompletionContributor.e(PhpKeywordsCompletionContributor.RETURN_FALSE_ITEM, (InsertHandler<LookupElement>)PhpSymbolInsertHandler.SEMICOLON));
                        }
                        if (functionType.isNullable()) {
                            result.addElement((LookupElement)PhpKeywordsCompletionContributor.e(PhpKeywordsCompletionContributor.RETURN_NULL_ITEM, (InsertHandler<LookupElement>)PhpSymbolInsertHandler.SEMICOLON));
                        }
                    }
                    if (grandParent instanceof Statement && grandParent.getParent() != null && ((ancestor = grandParent.getParent().getParent()) instanceof PhpFile || ancestor instanceof PhpNamespace && !((PhpNamespace)ancestor).isBraced())) {
                        result.addElement((LookupElement)PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwNAMESPACE));
                    }
                }
                PhpBasicKeywordsCompletionProvider.addContextSensitiveKeywords(position, result, insideParentheses);
            }
        }

        private static boolean isList(PsiElement position) {
            return PhpPsiUtil.getParentByCondition(position, MultiassignmentExpression.INSTANCEOF, GroupStatement.INSTANCEOF) != null;
        }

        private static void addContextSensitiveKeywords(@NotNull PsiElement position, @NotNull CompletionResultSet result, boolean insideParentheses) {
            if (position == null) {
                PhpBasicKeywordsCompletionProvider.$$$reportNull$$$0(3);
            }
            if (result == null) {
                PhpBasicKeywordsCompletionProvider.$$$reportNull$$$0(4);
            }
            PsiElement child = position;
            for (PsiElement parent = position.getParent(); parent != null; parent = parent.getParent()) {
                if (child instanceof GroupStatement) {
                    if (parent instanceof For || parent instanceof ForeachStatement || parent instanceof While || parent instanceof DoWhile || parent instanceof PhpCase) {
                        if (!insideParentheses) {
                            result.addElement((LookupElement)PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwCONTINUE, null));
                            result.addElement((LookupElement)PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwBREAK, null));
                        }
                    } else if (parent instanceof Function) {
                        if (!insideParentheses) {
                            result.addElement((LookupElement)PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwSTATIC));
                        }
                        result.addElement((LookupElement)PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwYIELD, null));
                    }
                }
                child = parent;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "position";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/completion/PhpKeywordsCompletionContributor$PhpBasicKeywordsCompletionProvider";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addCompletions";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addContextSensitiveKeywords";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PhpAnonymousClassCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private PhpAnonymousClassCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            boolean isReadonly;
            if (parameters == null) {
                PhpAnonymousClassCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PhpAnonymousClassCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                PhpAnonymousClassCompletionProvider.$$$reportNull$$$0(2);
            }
            PsiElement position = parameters.getPosition().getOriginalElement();
            PsiElement parent = position.getParent();
            PsiElement prevSibling = PhpPsiUtil.getPrevSiblingIgnoreWhitespace(parent, true);
            PsiElement prevPrevSibling = PhpPsiUtil.getPrevSiblingIgnoreWhitespace(prevSibling, true);
            boolean bl = isReadonly = prevSibling != null && FieldImpl.isReadonlyKeyword(prevSibling.getNode());
            if (!PhpCompletionContributor.isNamespace(position.getPrevSibling()) && (PhpPsiUtil.isOfType(prevSibling, PhpTokenTypes.kwNEW) || isReadonly && PhpPsiUtil.isOfType(prevPrevSibling, PhpTokenTypes.kwNEW))) {
                if (!isReadonly && PhpLanguageFeature.ANONYMOUS_READONLY_CLASSES.isSupported(position.getProject())) {
                    result.addElement((LookupElement)PhpKeywordsCompletionContributor.e("readonly"));
                }
                result.addElement((LookupElement)PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwCLASS, (InsertHandler<LookupElement>)PhpBaseKeywordInsertHandler.WITH_BODY));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/completion/PhpKeywordsCompletionContributor$PhpAnonymousClassCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PhpUseClauseCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private PhpUseClauseCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            PsiElement parent;
            if (parameters == null) {
                PhpUseClauseCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PhpUseClauseCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                PhpUseClauseCompletionProvider.$$$reportNull$$$0(2);
            }
            if (PhpPsiUtil.getChildOfType(parent = parameters.getPosition().getOriginalElement().getParent(), PhpTokenTypes.kwAS) != null && PhpPsiUtil.getChildOfType(parent, PhpTokenTypes.tsVISIBILITY_MODIFIERS) == null) {
                PhpKeywordsCompletionContributor.addAllElements(result, PhpTokenTypes.tsVISIBILITY_MODIFIERS, null);
            } else if (PhpPsiUtil.getChildOfType(parent, AS_INSTEADOF) == null) {
                result.addElement((LookupElement)PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwAS));
                if (PhpCompletionContributor.getTraitReference((PhpTraitUseRule)parent) != null) {
                    result.addElement((LookupElement)PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwINSTEADOF));
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/completion/PhpKeywordsCompletionContributor$PhpUseClauseCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PhpIfLevelCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private PhpIfLevelCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            PsiElement position;
            if (parameters == null) {
                PhpIfLevelCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PhpIfLevelCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                PhpIfLevelCompletionProvider.$$$reportNull$$$0(2);
            }
            if ((position = parameters.getPosition().getOriginalElement()).getParent() instanceof StringLiteralExpression) {
                return;
            }
            Statement parent = PhpPsiUtil.getParentOfClass(position, Statement.class);
            if (parent != null) {
                boolean positionIsFirstChild;
                PhpPsiElement sibling = parent.getPrevPsiSibling();
                boolean bl = positionIsFirstChild = position.getParent().getFirstChild() == position;
                if (sibling instanceof If && PhpPsiUtil.getChildByCondition((PsiElement)sibling, Else.INSTANCEOF) == null && positionIsFirstChild) {
                    result.addAllElements(Arrays.asList(PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwELSE, null), PhpKeywordsCompletionContributor.k(PhpTokenTypes.kwELSEIF)));
                } else {
                    If ifStatement = PhpPsiUtil.getParentOfClass(position, If.class);
                    if (ifStatement != null && PhpPsiUtil.getChildOfType((PsiElement)ifStatement, PhpTokenTypes.opCOLON) != null && positionIsFirstChild) {
                        if (PhpPsiUtil.getChildByCondition((PsiElement)ifStatement, Else.INSTANCEOF) == null) {
                            result.addAllElements(Arrays.asList(PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwELSE, (InsertHandler<LookupElement>)PhpSymbolInsertHandler.COLON), PhpKeywordsCompletionContributor.k(PhpTokenTypes.kwELSEIF)));
                        }
                        result.addElement((LookupElement)PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwENDIF, (InsertHandler<LookupElement>)PhpSymbolInsertHandler.SEMICOLON));
                    }
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/completion/PhpKeywordsCompletionContributor$PhpIfLevelCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PhpSwitchLevelCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private PhpSwitchLevelCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            PsiElement position;
            PhpSwitch switchStatement;
            if (parameters == null) {
                PhpSwitchLevelCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PhpSwitchLevelCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                PhpSwitchLevelCompletionProvider.$$$reportNull$$$0(2);
            }
            if ((switchStatement = PhpPsiUtil.getParentOfClass(position = parameters.getPosition().getOriginalElement(), PhpSwitch.class)) != null) {
                if (switchStatement.getDefaultCase() == null) {
                    result.addElement((LookupElement)PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwDEFAULT, null));
                }
                if (PhpPsiUtil.getChildOfType((PsiElement)switchStatement, PhpTokenTypes.opCOLON) != null) {
                    result.addElement((LookupElement)PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwENDSWITCH, (InsertHandler<LookupElement>)PhpSymbolInsertHandler.SEMICOLON));
                }
                result.addElement((LookupElement)PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwCASE));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/completion/PhpKeywordsCompletionContributor$PhpSwitchLevelCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PhpWhileLevelCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private PhpWhileLevelCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            PsiElement position;
            While whileStatement;
            if (parameters == null) {
                PhpWhileLevelCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PhpWhileLevelCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                PhpWhileLevelCompletionProvider.$$$reportNull$$$0(2);
            }
            if ((whileStatement = PhpPsiUtil.getParentOfClass(position = parameters.getPosition().getOriginalElement(), While.class)) != null && PhpPsiUtil.getChildOfType((PsiElement)whileStatement, PhpTokenTypes.opCOLON) != null) {
                result.addElement((LookupElement)PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwENDWHILE, (InsertHandler<LookupElement>)PhpSymbolInsertHandler.SEMICOLON));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/completion/PhpKeywordsCompletionContributor$PhpWhileLevelCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PhpForLevelCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private PhpForLevelCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            PsiElement position;
            For forStatement;
            if (parameters == null) {
                PhpForLevelCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PhpForLevelCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                PhpForLevelCompletionProvider.$$$reportNull$$$0(2);
            }
            if ((forStatement = PhpPsiUtil.getParentOfClass(position = parameters.getPosition().getOriginalElement(), For.class)) != null && PhpPsiUtil.getChildOfType((PsiElement)forStatement, PhpTokenTypes.opCOLON) != null) {
                result.addElement((LookupElement)PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwENDFOR, (InsertHandler<LookupElement>)PhpSymbolInsertHandler.SEMICOLON));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/completion/PhpKeywordsCompletionContributor$PhpForLevelCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PhpDeclareLevelCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private PhpDeclareLevelCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            PsiElement position;
            if (parameters == null) {
                PhpDeclareLevelCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PhpDeclareLevelCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                PhpDeclareLevelCompletionProvider.$$$reportNull$$$0(2);
            }
            if (PhpPsiUtil.isOfType((position = parameters.getPosition().getOriginalElement()).getParent(), PhpElementTypes.DECLARE_DIRECTIVE)) {
                Project project = position.getProject();
                PhpCodeStyleSettings settings = (PhpCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)parameters.getOriginalFile(), PhpCodeStyleSettings.class);
                PhpSymbolInsertHandler insertHandler = settings.SPACE_AROUND_ASSIGNMENT_IN_DECLARE ? PhpSymbolInsertHandler.SPACE : null;
                for (String directive : PhpKeywordsCompletionContributor.getSupportedDeclareDirectives(project)) {
                    result.addElement((LookupElement)LookupElementBuilder.create((String)directive).withInsertHandler((InsertHandler)insertHandler));
                }
                return;
            }
            Declare declareStatement = PhpPsiUtil.getParentOfClass(position, Declare.class);
            if (declareStatement != null && PhpPsiUtil.getChildOfType((PsiElement)declareStatement, PhpTokenTypes.opCOLON) != null) {
                result.addElement((LookupElement)PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwENDDECLARE, (InsertHandler<LookupElement>)PhpSymbolInsertHandler.SEMICOLON));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/completion/PhpKeywordsCompletionContributor$PhpDeclareLevelCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PhpMatchExpressionLevelCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private PhpMatchExpressionLevelCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            PhpMatchArm currentArm;
            PsiElement position;
            PhpMatchExpression matchExpression;
            if (parameters == null) {
                PhpMatchExpressionLevelCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PhpMatchExpressionLevelCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                PhpMatchExpressionLevelCompletionProvider.$$$reportNull$$$0(2);
            }
            if ((matchExpression = PhpPsiUtil.getParentOfClass(position = parameters.getPosition().getOriginalElement(), PhpMatchExpression.class)) != null && matchExpression.getDefaultMatchArm() == null && (currentArm = PhpPsiUtil.getParentOfClass(position, PhpMatchArm.class)) != null && currentArm.getConditions().size() == 1 && PhpPsiUtil.getPrevSiblingByCondition(position.getParent(), (Condition<? super PsiElement>)((Condition)e -> PhpPsiUtil.isOfType(e, PhpTokenTypes.opHASH_ARRAY))) == null) {
                result.addElement((LookupElement)PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwDEFAULT, null));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/completion/PhpKeywordsCompletionContributor$PhpMatchExpressionLevelCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PhpPromotedFieldParametersKeyword
    extends CompletionProvider<CompletionParameters> {
        private PhpPromotedFieldParametersKeyword() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            Function function;
            Parameter parameter;
            PsiElement position;
            Project project;
            if (parameters == null) {
                PhpPromotedFieldParametersKeyword.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PhpPromotedFieldParametersKeyword.$$$reportNull$$$0(1);
            }
            if (result == null) {
                PhpPromotedFieldParametersKeyword.$$$reportNull$$$0(2);
            }
            if (PhpLanguageFeature.PROPERTY_PROMOTION.isSupported(project = (position = parameters.getPosition()).getProject()) && (parameter = PhpPsiUtil.getParentOfClass(position, false, Parameter.class)) != null && (function = PhpPsiUtil.getParentOfClass(parameter, Function.class)) instanceof Method && ((Method)function).getMethodType(false) == Method.MethodType.CONSTRUCTOR) {
                PsiElement prev = PhpCompletionContributor.findPrevElement(parameters, result);
                boolean declarationContainsReadonly = PhpPsiUtil.getPrevSiblingByCondition(prev, (Condition<? super PsiElement>)((Condition)e -> PhpLangUtil.equals(e.getText(), "readonly"))) != null;
                Object modifier = PhpPsiUtil.getPrevSiblingByCondition(prev, (Condition<? super PsiElement>)((Condition)e -> PhpPsiUtil.isOfType(e, PhpTokenTypes.tsVISIBILITY_MODIFIERS) && !PhpModifierListImpl.isSetOperationModifier(e)));
                Object setModifier = PhpPsiUtil.getPrevSiblingByCondition(prev, (Condition<? super PsiElement>)((Condition)e -> PhpModifierListImpl.isSetOperationModifier(e)));
                if (modifier == null) {
                    result.addElement((LookupElement)PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwPRIVATE, (InsertHandler<LookupElement>)PhpSymbolInsertHandler.VISIBILITY));
                    result.addElement((LookupElement)PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwPROTECTED, (InsertHandler<LookupElement>)PhpSymbolInsertHandler.VISIBILITY));
                    result.addElement((LookupElement)PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwPUBLIC, (InsertHandler<LookupElement>)PhpSymbolInsertHandler.VISIBILITY));
                }
                if (PhpLanguageFeature.ASYMMETRIC_VISIBILITY.isSupported(project) && setModifier == null) {
                    if (modifier == null) {
                        result.addAllElements(List.of(PhpKeywordsCompletionContributor.e("public(set)", (InsertHandler<LookupElement>)PhpSymbolInsertHandler.ASYMMETRIC_VISIBILITY), PhpKeywordsCompletionContributor.e("protected(set)", (InsertHandler<LookupElement>)PhpSymbolInsertHandler.ASYMMETRIC_VISIBILITY), PhpKeywordsCompletionContributor.e("private(set)", (InsertHandler<LookupElement>)PhpSymbolInsertHandler.ASYMMETRIC_VISIBILITY)));
                    } else if (PhpPsiUtil.isOfType(modifier, PhpTokenTypes.kwPUBLIC)) {
                        result.addAllElements(List.of(PhpKeywordsCompletionContributor.e("protected(set)", (InsertHandler<LookupElement>)PhpSymbolInsertHandler.ASYMMETRIC_VISIBILITY), PhpKeywordsCompletionContributor.e("private(set)", (InsertHandler<LookupElement>)PhpSymbolInsertHandler.ASYMMETRIC_VISIBILITY)));
                    } else if (PhpPsiUtil.isOfType(modifier, PhpTokenTypes.kwPROTECTED)) {
                        result.addElement((LookupElement)PhpKeywordsCompletionContributor.e("private(set)", (InsertHandler<LookupElement>)PhpSymbolInsertHandler.ASYMMETRIC_VISIBILITY));
                    }
                }
                if (PhpLanguageFeature.READONLY_PROPERTIES.isSupported(project) && !declarationContainsReadonly) {
                    result.addElement((LookupElement)PhpKeywordsCompletionContributor.e("readonly"));
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/completion/PhpKeywordsCompletionContributor$PhpPromotedFieldParametersKeyword";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PhpPropertyHooksKeywordCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private PhpPropertyHooksKeywordCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            if (parameters == null) {
                PhpPropertyHooksKeywordCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PhpPropertyHooksKeywordCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                PhpPropertyHooksKeywordCompletionProvider.$$$reportNull$$$0(2);
            }
            PsiElement position = parameters.getPosition().getOriginalElement();
            if (!PhpLanguageFeature.PROPERTY_HOOKS.isSupported(parameters.getPosition().getProject())) {
                return;
            }
            Field field = (Field)PhpPsiUtil.getParentByCondition(position, Field.INSTANCEOF, PhpClass.INSTANCEOF);
            if (field == null) {
                return;
            }
            PsiElement hooks = FieldImpl.getPropertyHooksContainer(field);
            if (hooks == null) {
                return;
            }
            PhpPropertyHooksKeywordCompletionProvider.addAccessorKeywords(result, field);
            PhpPropertyHooksKeywordCompletionProvider.addFinalKeyword(result, position, hooks);
        }

        private static void addAccessorKeywords(@NotNull CompletionResultSet result, @NotNull Field field) {
            if (result == null) {
                PhpPropertyHooksKeywordCompletionProvider.$$$reportNull$$$0(3);
            }
            if (field == null) {
                PhpPropertyHooksKeywordCompletionProvider.$$$reportNull$$$0(4);
            }
            List<PhpPropertyHook> listHooks = field.getPropertyHooksList();
            PhpPropertyHookShortInsertHandler insertHandlerShort = PhpPropertyHookShortInsertHandler.INSTANCE;
            PhpPropertyHookWithBodyInsertHandler insertHandlerWithBody = PhpPropertyHookWithBodyInsertHandler.INSTANCE;
            if (!ContainerUtil.exists(listHooks, PhpPropertyHook.IS_SET_HOOK)) {
                if (field.isAbstract()) {
                    result.addElement((LookupElement)PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwSET, (InsertHandler<LookupElement>)PhpSymbolInsertHandler.SEMICOLON));
                } else {
                    result.addElement((LookupElement)PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwSET));
                    result.addElement((LookupElement)PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwSET, (InsertHandler<LookupElement>)insertHandlerShort).withTailText("($value) => ...", true));
                    result.addElement((LookupElement)PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwSET, (InsertHandler<LookupElement>)insertHandlerWithBody).withTailText("($value) {...}", true));
                }
            }
            if (!ContainerUtil.exists(listHooks, PhpPropertyHook.IS_GET_HOOK)) {
                if (field.isAbstract()) {
                    result.addElement((LookupElement)PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwGET, (InsertHandler<LookupElement>)PhpSymbolInsertHandler.SEMICOLON));
                } else {
                    result.addElement((LookupElement)PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwGET));
                    result.addElement((LookupElement)PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwGET, (InsertHandler<LookupElement>)insertHandlerShort).withTailText(" => ...", true));
                    result.addElement((LookupElement)PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwGET, (InsertHandler<LookupElement>)insertHandlerWithBody).withTailText(" {...}", true));
                }
            }
        }

        private static void addFinalKeyword(@NotNull CompletionResultSet result, PsiElement position, PsiElement hooks) {
            PhpPropertyHook hook;
            if (result == null) {
                PhpPropertyHooksKeywordCompletionProvider.$$$reportNull$$$0(5);
            }
            if (Objects.isNull(hook = (PhpPropertyHook)PhpPsiUtil.getParentByCondition(position, (Condition<? super PsiElement>)((Condition)e -> PhpPsiUtil.isOfType(e, PhpElementTypes.PROPERTY_HOOK)), Field.INSTANCEOF)) || hook.getModifier().isFinal()) {
                return;
            }
            if (PhpPropertyHooksKeywordCompletionProvider.isLastElementInHooksBlock(position, hook) ? PhpPropertyHooksKeywordCompletionProvider.isHooksAlreadyFullyPopulated(hooks) : !PhpPropertyHooksKeywordCompletionProvider.isFollowedByHookType(position)) {
                return;
            }
            result.addElement((LookupElement)PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwFINAL));
        }

        private static boolean isHooksAlreadyFullyPopulated(PsiElement hooks) {
            if (hooks == null) {
                return false;
            }
            return ContainerUtil.exists((Object[])hooks.getChildren(), PhpPropertyHook.IS_SET_HOOK) && ContainerUtil.exists((Object[])hooks.getChildren(), PhpPropertyHook.IS_GET_HOOK);
        }

        private static boolean isFollowedByHookType(PsiElement element) {
            @Nullable PsiElement successorElement = PhpPropertyHooksKeywordCompletionProvider.nextSiblingSkippingWhiteSpacesAndErrors(element);
            return PhpPsiUtil.isOfType(successorElement, PhpTokenTypes.kwGET, PhpTokenTypes.kwSET);
        }

        private static boolean isLastElementInHooksBlock(PsiElement element, PsiElement hook) {
            return Objects.isNull(PhpPropertyHooksKeywordCompletionProvider.nextSiblingSkippingWhiteSpacesAndErrors(element)) && PhpPsiUtil.isOfType(PhpPropertyHooksKeywordCompletionProvider.nextSiblingSkippingWhiteSpacesAndErrors(hook), PhpTokenTypes.chRBRACE);
        }

        @Nullable
        private static PsiElement nextSiblingSkippingWhiteSpacesAndErrors(PsiElement element) {
            return PhpPsiUtil.getNextSiblingByCondition(element, (Condition<? super PsiElement>)((Condition)sibling -> !(sibling instanceof PsiErrorElement) && !(sibling instanceof PsiWhiteSpace)));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: 
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "field";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/completion/PhpKeywordsCompletionContributor$PhpPropertyHooksKeywordCompletionProvider";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addCompletions";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addAccessorKeywords";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addFinalKeyword";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private static class PhpPropertyHookShortInsertHandler
        implements InsertHandler<LookupElement> {
            private static final PhpPropertyHookShortInsertHandler INSTANCE = new PhpPropertyHookShortInsertHandler();

            private PhpPropertyHookShortInsertHandler() {
            }

            public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
                if (context == null) {
                    PhpPropertyHookShortInsertHandler.$$$reportNull$$$0(0);
                }
                if (item == null) {
                    PhpPropertyHookShortInsertHandler.$$$reportNull$$$0(1);
                }
                PhpPropertyHookWithBodyInsertHandler.handleInsert(context, item, " => ;");
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "item";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/php/completion/PhpKeywordsCompletionContributor$PhpPropertyHooksKeywordCompletionProvider$PhpPropertyHookShortInsertHandler";
                objectArray[2] = "handleInsert";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }

        private static class PhpPropertyHookWithBodyInsertHandler
        implements InsertHandler<LookupElement> {
            private static final PhpPropertyHookWithBodyInsertHandler INSTANCE = new PhpPropertyHookWithBodyInsertHandler();

            private PhpPropertyHookWithBodyInsertHandler() {
            }

            public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
                if (context == null) {
                    PhpPropertyHookWithBodyInsertHandler.$$$reportNull$$$0(0);
                }
                if (item == null) {
                    PhpPropertyHookWithBodyInsertHandler.$$$reportNull$$$0(1);
                }
                PhpPropertyHookWithBodyInsertHandler.handleInsert(context, item, " {}");
            }

            private static void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item, String body) {
                if (context == null) {
                    PhpPropertyHookWithBodyInsertHandler.$$$reportNull$$$0(2);
                }
                if (item == null) {
                    PhpPropertyHookWithBodyInsertHandler.$$$reportNull$$$0(3);
                }
                Editor editor = context.getEditor();
                Document document = editor.getDocument();
                int offset = editor.getCaretModel().getOffset();
                PsiElement underCaret = context.getFile().findElementAt(offset);
                Field field = (Field)PhpPsiUtil.getParentByCondition(underCaret, Field.INSTANCEOF, PhpClass.INSTANCEOF);
                String type = field == null || field.getDeclaredType().isEmpty() ? "" : PhpType.fromStrings(ContainerUtil.map(field.getDeclaredType().getTypes(), PhpTypeSignatureKey.SELF_CLASS::unsign)) + " ";
                String kw = PhpPropertyHookWithBodyInsertHandler.getString(item);
                String parameter = kw.equals("get") ? "" : "(%s$value)".formatted(type);
                String toInsert = parameter + body;
                document.insertString(offset, (CharSequence)toInsert);
                editor.getCaretModel().moveToOffset(offset + toInsert.length() - 1);
            }

            @NotNull
            private static String getString(@NotNull LookupElement item) {
                if (item == null) {
                    PhpPropertyHookWithBodyInsertHandler.$$$reportNull$$$0(4);
                }
                String string = item.getLookupString();
                if (string == null) {
                    PhpPropertyHookWithBodyInsertHandler.$$$reportNull$$$0(5);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 5 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "item";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/php/completion/PhpKeywordsCompletionContributor$PhpPropertyHooksKeywordCompletionProvider$PhpPropertyHookWithBodyInsertHandler";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/php/completion/PhpKeywordsCompletionContributor$PhpPropertyHooksKeywordCompletionProvider$PhpPropertyHookWithBodyInsertHandler";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getString";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "handleInsert";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "getString";
                        break;
                    }
                    case 5: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 5 -> new IllegalStateException(string);
                };
            }
        }
    }
}

