/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpIcons;
import com.jetbrains.php.completion.PhpAnyExpressionArgument;
import com.jetbrains.php.completion.PhpArrayShapeIndexCompletionProvider;
import com.jetbrains.php.completion.PhpLookupElement;
import com.jetbrains.php.completion.insert.PhpReferenceInsertHandler;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocProperty;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocVariable;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.ArrayIndex;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.lang.psi.elements.ParenthesizedExpression;
import com.jetbrains.php.lang.psi.elements.PhpAttributesOwner;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.impl.ClassReferenceImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpClassImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpObjectShapeTypeProvider;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.shapes.PhpDocArrayShapeProvider;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpFieldIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpExpectedFunctionArgument;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpShapeEntriesIndex;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpObjectShapeCompletionProvider
extends CompletionProvider<CompletionParameters> {
    protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
        FieldReference fieldReference;
        if (parameters == null) {
            PhpObjectShapeCompletionProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            PhpObjectShapeCompletionProvider.$$$reportNull$$$0(1);
        }
        if (result == null) {
            PhpObjectShapeCompletionProvider.$$$reportNull$$$0(2);
        }
        if ((fieldReference = PhpPsiUtil.getParentOfClass(parameters.getPosition(), true, FieldReference.class)) == null || fieldReference.isStatic()) {
            return;
        }
        result.addAllElements((Iterable)ContainerUtil.map(PhpObjectShapeCompletionProvider.getObjectShapes(fieldReference), s -> PhpObjectShapeCompletionProvider.createLookupElement(s, fieldReference.getProject())));
    }

    @Nullable
    public static PhpPsiElement findParent(@NotNull FieldReference fieldReference, ArrayDeque<PhpExpectedFunctionArgument> parentAccesses) {
        PhpPsiElement value;
        if (fieldReference == null) {
            PhpObjectShapeCompletionProvider.$$$reportNull$$$0(3);
        }
        if ((value = fieldReference.getClassReference()) == null) {
            return null;
        }
        while (value instanceof FieldReference) {
            FieldReference reference;
            fieldReference = reference = (FieldReference)value;
            parentAccesses.addFirst(PhpShapeEntriesIndex.createKeyForObjectShape(fieldReference));
            value = reference.getClassReference();
        }
        if (value instanceof ParenthesizedExpression) {
            value = ((ParenthesizedExpression)value).extract();
        }
        if (PhpLangUtil.isThisReference((PsiElement)value)) {
            parentAccesses.poll();
            return fieldReference;
        }
        if (value instanceof NewExpression) {
            NewExpression expression = (NewExpression)value;
            return expression.getClassReference();
        }
        return value;
    }

    @NotNull
    private static PhpLookupElement createLookupElement(@NotNull PhpShapeEntriesIndex.PhpShapeEntry objectShape, @NotNull Project project) {
        if (objectShape == null) {
            PhpObjectShapeCompletionProvider.$$$reportNull$$$0(4);
        }
        if (project == null) {
            PhpObjectShapeCompletionProvider.$$$reportNull$$$0(5);
        }
        String key = StringUtil.unquoteString((String)objectShape.getKey().getValue());
        PhpType type = objectShape.getType();
        PhpLookupElement phpLookupElement = PhpLookupElement.createKeywordLookupElement(key, PhpFieldIndex.KEY, PhpIcons.FIELD, type, project, PhpReferenceInsertHandler.getInstance());
        if (phpLookupElement == null) {
            PhpObjectShapeCompletionProvider.$$$reportNull$$$0(6);
        }
        return phpLookupElement;
    }

    private static Collection<? extends PhpNamedElement> resolveLocal(@NotNull PsiElement element) {
        PhpReference reference;
        if (element == null) {
            PhpObjectShapeCompletionProvider.$$$reportNull$$$0(7);
        }
        if ((reference = (PhpReference)ObjectUtils.tryCast((Object)element, PhpReference.class)) == null) {
            return Collections.emptyList();
        }
        if (!ClassReferenceImpl.shouldResolveToConstructor(reference)) {
            return reference.resolveLocal();
        }
        return (Collection)StreamEx.of(reference.resolveLocal()).select(PhpClassImpl.class).flatMap(c -> PhpClassImpl.getOwnConstructors(c).getMethods().stream()).collect(Collectors.toList());
    }

    public static Collection<PhpShapeEntriesIndex.PhpShapeEntry> getObjectShapesInner(@NotNull PsiElement element) {
        if (element == null) {
            PhpObjectShapeCompletionProvider.$$$reportNull$$$0(8);
        }
        return ContainerUtil.flatMap(PhpObjectShapeCompletionProvider.resolveLocal(element), e -> PhpObjectShapeCompletionProvider.getObjectShapes(e));
    }

    public static List<PhpShapeEntriesIndex.PhpShapeEntry> getObjectShapes(@NotNull PhpNamedElement value) {
        if (value == null) {
            PhpObjectShapeCompletionProvider.$$$reportNull$$$0(9);
        }
        ArrayList<PhpShapeEntriesIndex.PhpShapeEntry> objectShapes = new ArrayList<PhpShapeEntriesIndex.PhpShapeEntry>();
        if (value instanceof PhpDocProperty || value instanceof PhpDocVariable) {
            PhpDocTag tag2 = (PhpDocTag)PhpPsiUtil.getParentByCondition((PsiElement)value, PhpDocTag.INSTANCEOF, PhpDocComment.INSTANCEOF);
            objectShapes.addAll(PhpDocArrayShapeProvider.getObjectShapesFromDoc(tag2));
        } else {
            objectShapes.addAll(ContainerUtil.flatMap((Iterable)value.getDocTags(), tag -> PhpDocArrayShapeProvider.getObjectShapesFromDoc(tag)));
            if (value instanceof PhpAttributesOwner) {
                PhpAttributesOwner attributesOwner = (PhpAttributesOwner)((Object)value);
                objectShapes.addAll(PhpShapeEntriesIndex.getObjectShapes(attributesOwner));
            }
        }
        return objectShapes;
    }

    public static Collection<PhpShapeEntriesIndex.PhpShapeEntry> getObjectShapes(FieldReference fieldReference) {
        ArrayDeque<PhpExpectedFunctionArgument> parentAccesses = new ArrayDeque<PhpExpectedFunctionArgument>();
        PhpPsiElement parent = PhpObjectShapeCompletionProvider.findParent(fieldReference, parentAccesses);
        if (parent == null || parent == fieldReference) {
            return Collections.emptyList();
        }
        Collection<PhpShapeEntriesIndex.PhpShapeEntry> objectShapes = PhpObjectShapeCompletionProvider.getObjectShapes((PsiElement)parent, parentAccesses);
        if (!objectShapes.isEmpty()) {
            return objectShapes;
        }
        FieldReference firstFieldReference = (FieldReference)PhpPsiUtil.getParentByCondition((PsiElement)parent, FieldReference.INSTANCEOF, Statement.INSTANCEOF);
        if (firstFieldReference == null) {
            return Collections.emptyList();
        }
        parentAccesses.poll();
        objectShapes.addAll(PhpObjectShapeCompletionProvider.getObjectShapes((PsiElement)firstFieldReference, parentAccesses));
        return objectShapes;
    }

    public static Collection<PhpShapeEntriesIndex.PhpShapeEntry> getObjectShapes(@NotNull PsiElement element, ArrayDeque<PhpExpectedFunctionArgument> parentAccesses) {
        if (element == null) {
            PhpObjectShapeCompletionProvider.$$$reportNull$$$0(10);
        }
        ArrayList<PhpShapeEntriesIndex.PhpShapeEntry> objectShapes = new ArrayList<PhpShapeEntriesIndex.PhpShapeEntry>(PhpObjectShapeCompletionProvider.getObjectShapesInner(element));
        objectShapes.addAll(PhpObjectShapeTypeProvider.objectShapesFromTypes(element));
        if (element instanceof ArrayAccessExpression) {
            objectShapes.addAll(PhpObjectShapeCompletionProvider.getShapesFromArrayAccess(element));
        }
        return PhpArrayShapeIndexCompletionProvider.collectShapesByParentAccesses(parentAccesses, objectShapes);
    }

    private static Collection<PhpShapeEntriesIndex.PhpShapeEntry> getShapesFromArrayAccess(PsiElement element) {
        ArrayAccessExpression arrayAccessExpression;
        ArrayIndex index;
        if (element instanceof ArrayAccessExpression && (index = (arrayAccessExpression = (ArrayAccessExpression)element).getIndex()) != null) {
            PhpExpectedFunctionArgument key = PhpArrayShapeIndexCompletionProvider.getParentAccesses(index.getValue());
            return (Collection)((StreamEx)((StreamEx)StreamEx.of(PhpArrayShapeIndexCompletionProvider.getArrayShapes((PsiElement)arrayAccessExpression.getValue())).filter(s -> s.getKey().getValue().equals(key.getValue()) || s.getKey().equals(key) || s.getKey() instanceof PhpAnyExpressionArgument)).flatMap(s -> s.getChildren().stream()).filter(PhpShapeEntriesIndex.PhpShapeEntry::isObjectShape)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldReference";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objectShape";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/completion/PhpObjectShapeCompletionProvider";
                break;
            }
            case 7: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/completion/PhpObjectShapeCompletionProvider";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createLookupElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addCompletions";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findParent";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createLookupElement";
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "resolveLocal";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getObjectShapesInner";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getObjectShapes";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }
}

