/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.completion;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpCallInstruction;
import com.jetbrains.php.completion.PhpUsageContextArrayIndexCompletionProviderBase;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.intellij.lang.regexp.RegExpFile;
import org.intellij.lang.regexp.psi.RegExpGroup;
import org.jetbrains.annotations.NotNull;

public class PhpRegexpCapturedGroupNamesArrayIndexCompletionProvider
extends PhpUsageContextArrayIndexCompletionProviderBase {
    @Override
    protected Collection<String> getArrayIndexKeysFromUsageContext(@NotNull PsiElement variable) {
        PhpAccessVariableInstruction variableInstruction;
        if (variable == null) {
            PhpRegexpCapturedGroupNamesArrayIndexCompletionProvider.$$$reportNull$$$0(0);
        }
        PhpAccessVariableInstruction phpAccessVariableInstruction = variableInstruction = variable instanceof Variable ? PhpControlFlowUtil.getAccessInstruction((Variable)variable, PhpAccessVariableInstruction.class) : null;
        if (variableInstruction == null) {
            return Collections.emptyList();
        }
        final HashSet<String> res = new HashSet<String>();
        PhpControlFlowUtil.processPreviousVariableAccesses(variableInstruction, false, new PhpInstructionProcessor(){

            @Override
            public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                if (instruction.getAccess().isWrite()) {
                    return false;
                }
                return super.processAccessVariableInstruction(instruction);
            }

            @Override
            public boolean processPhpCallInstruction(PhpCallInstruction instruction) {
                FunctionReference reference = instruction.getFunctionReference();
                ParameterList parameterList = reference.getParameterList();
                if (parameterList == null) {
                    return true;
                }
                Variable matchesArgument = (Variable)ObjectUtils.tryCast((Object)parameterList.getParameter("matches", 2), Variable.class);
                if (matchesArgument != null && PhpLangUtil.equalsVariableNames(matchesArgument.getName(), variableInstruction.getVariableName()) && (PhpCodeInsightUtil.isGlobalFunctionCallWithName(reference, "preg_match") || PhpCodeInsightUtil.isGlobalFunctionCallWithName(reference, "preg_match_all"))) {
                    PsiElement patternArgument = parameterList.getParameter("pattern", 0);
                    if (patternArgument == null) {
                        return true;
                    }
                    for (StringLiteralExpression pattern : PhpPsiUtil.findChildrenNonStrict(patternArgument, StringLiteralExpression.class)) {
                        this.addGroupNamesFromInjectedRegExp(pattern);
                    }
                }
                return true;
            }

            private void addGroupNamesFromInjectedRegExp(StringLiteralExpression pattern) {
                List files = (List)ObjectUtils.notNull((Object)InjectedLanguageManager.getInstance((Project)pattern.getProject()).getInjectedPsiFiles((PsiElement)pattern), Collections::emptyList);
                for (Pair pair : files) {
                    PsiElement first = (PsiElement)pair.getFirst();
                    if (!(first instanceof RegExpFile)) continue;
                    PsiTreeUtil.findChildrenOfType((PsiElement)first, RegExpGroup.class).stream().filter(RegExpGroup::isCapturing).filter(e -> PsiTreeUtil.findChildOfType((PsiElement)e, PsiErrorElement.class) == null).map(RegExpGroup::getGroupName).filter(Objects::nonNull).forEach(res::add);
                }
            }
        });
        return res;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/jetbrains/php/completion/PhpRegexpCapturedGroupNamesArrayIndexCompletionProvider", "getArrayIndexKeysFromUsageContext"));
    }
}

