/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.completion.insert;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtil;
import com.jetbrains.php.completion.insert.PhpFunctionInsertHandler;
import com.jetbrains.php.lang.formatter.PhpCodeStyleSettings;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PhpUse;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpClassConstructorInsertHandler
extends PhpFunctionInsertHandler {
    private static final PhpClassConstructorInsertHandler instance = new PhpClassConstructorInsertHandler();

    public static PhpClassConstructorInsertHandler getInstance() {
        return instance;
    }

    @Override
    @Nullable
    protected Function getFunction(Editor editor, PhpNamedElement element) {
        PhpReference reference;
        PhpClass phpClass = null;
        if (element instanceof PhpClass) {
            phpClass = (PhpClass)element;
        } else if (element instanceof PhpUse && (reference = ((PhpUse)element).getTargetReference()) != null) {
            phpClass = StreamEx.of(reference.resolveGlobal(false)).select(PhpClass.class).findAny().orElse(null);
        }
        if (phpClass != null) {
            Method ownConstructor = phpClass.getOwnConstructor();
            return ownConstructor != null ? ownConstructor : phpClass.getConstructor();
        }
        return null;
    }

    @Override
    protected boolean shouldInsertParens(@NotNull PsiFile file, @Nullable Function function) {
        if (file == null) {
            PhpClassConstructorInsertHandler.$$$reportNull$$$0(0);
        }
        PhpCodeStyleSettings settings = (PhpCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)file, PhpCodeStyleSettings.class);
        return settings.PLACE_PARENS_FOR_CONSTRUCTOR != 2 || function != null && !ArrayUtil.isEmpty((Object[])function.getParameters());
    }

    @Override
    public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement lookupElement) {
        if (context == null) {
            PhpClassConstructorInsertHandler.$$$reportNull$$$0(1);
        }
        if (lookupElement == null) {
            PhpClassConstructorInsertHandler.$$$reportNull$$$0(2);
        }
        super.handleInsert(context, lookupElement);
        this.tryToReplaceReferenceWithAlias(context, lookupElement, false);
    }

    @Override
    protected boolean shouldTryToReplaceReferenceWithAliasAfterInsertion() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookupElement";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/completion/insert/PhpClassConstructorInsertHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldInsertParens";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "handleInsert";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

