/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.completion.ml;

import com.intellij.codeInsight.completion.ml.ContextFeatureProvider;
import com.intellij.codeInsight.completion.ml.MLFeatureValue;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.completion.ml.PhpElementScope;
import com.jetbrains.php.lang.psi.PhpExpressionCodeFragment;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0007\u001a\u00020\bH\u0016J\u001c\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0006H\u0002J\u0010\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/php/completion/ml/PhpContextFeatureProvider;", "Lcom/intellij/codeInsight/completion/ml/ContextFeatureProvider;", "<init>", "()V", "PHP_SCOPE_CONDITION", "Lcom/intellij/openapi/util/Condition;", "Lcom/intellij/psi/PsiElement;", "getName", "", "calculateFeatures", "", "Lcom/intellij/codeInsight/completion/ml/MLFeatureValue;", "lookup", "Lcom/intellij/codeInsight/lookup/Lookup;", "findElementScope", "Lcom/jetbrains/php/completion/ml/PhpElementScope;", "element", "findMethodScope", "scope", "Lcom/jetbrains/php/lang/psi/elements/Method;", "intellij.php.impl"})
public final class PhpContextFeatureProvider
implements ContextFeatureProvider {
    @NotNull
    private final Condition<PsiElement> PHP_SCOPE_CONDITION = PhpContextFeatureProvider::PHP_SCOPE_CONDITION$lambda$0;

    @NotNull
    public String getName() {
        return "php_position";
    }

    @NotNull
    public Map<String, MLFeatureValue> calculateFeatures(@NotNull Lookup lookup) {
        Intrinsics.checkNotNullParameter((Object)lookup, (String)"lookup");
        PsiElement psiElement = lookup.getPsiElement();
        if (psiElement == null) {
            return MapsKt.emptyMap();
        }
        PsiElement element = psiElement;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"scope", (Object)MLFeatureValue.Companion.categorical((Enum)this.findElementScope(element)))};
        return MapsKt.hashMapOf((Pair[])pairArray);
    }

    private final PhpElementScope findElementScope(PsiElement element) {
        Object scope = PhpPsiUtil.getParentByCondition(element, this.PHP_SCOPE_CONDITION);
        if (scope instanceof PhpExpressionCodeFragment) {
            return PhpElementScope.CODE_FRAGMENT;
        }
        if (scope instanceof PhpNamespace) {
            return PhpElementScope.NAMESPACE;
        }
        if (scope instanceof PhpClass) {
            return PhpElementScope.CLASS;
        }
        if (scope instanceof Method) {
            return this.findMethodScope((Method)scope);
        }
        if (scope instanceof Function) {
            return PhpElementScope.FUNCTION;
        }
        if (scope instanceof PsiFile) {
            return PhpElementScope.FILE;
        }
        return PhpElementScope.OTHER;
    }

    private final PhpElementScope findMethodScope(Method scope) {
        return scope.isStatic() ? PhpElementScope.STATIC_METHOD : PhpElementScope.METHOD;
    }

    private static final boolean PHP_SCOPE_CONDITION$lambda$0(PsiElement e) {
        return e instanceof PhpClass || e instanceof PhpScopeHolder;
    }
}

