/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.composer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonProperty;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.composer.ComposerDetectionManager;
import com.jetbrains.php.composer.InstalledPackageData;
import com.jetbrains.php.composer.configData.ComposerConfigManager;
import com.jetbrains.php.lang.inspections.stubs.PhpComposerExtensionStubsInspection;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ComposerConfigUtils {
    private static final Logger LOG = Logger.getInstance(ComposerConfigUtils.class);
    @NonNls
    private static final String VENDOR_DIR_ELEMENT_NAME = "vendor-dir";
    @NonNls
    private static final String BIN_DIR_ELEMENT_NAME = "bin-dir";
    @NonNls
    private static final String DEFAULT_BIN_DIR_NAME = "bin";
    public static final String REQUIRE_PROPERTY_NAME = "require";
    public static final String REQUIRE_DEV_PROPERTY_NAME = "require-dev";
    public static final String[] PHP_PROPERTIES_NAMES = new String[]{"php", "PHP"};
    public static final String SCRIPTS_PROPERTY_NAME = "scripts";
    public static final String LICENSE_PROPERTY_NAME = "license";
    public static final String REPO_PROPERTY_NAME = "repositories";
    public static final String EXT_PREFIX = "ext-";
    private static final String VENDOR_BIN = "/vendor/bin/";

    private ComposerConfigUtils() {
    }

    public static JsonElement parseJson(@NotNull VirtualFile config) throws IOException, JsonParseException {
        if (config == null) {
            ComposerConfigUtils.$$$reportNull$$$0(0);
        }
        String text = VfsUtilCore.loadText((VirtualFile)config);
        JsonParser parser = new JsonParser();
        return parser.parse(text);
    }

    @Nullable
    public static VirtualFile findLockFile(@Nullable VirtualFile configFile) {
        if (configFile == null) {
            return null;
        }
        return configFile.getParent().findChild("composer.lock");
    }

    @NotNull
    public static List<InstalledPackageData> getInstalledPackagesFromConfig(@NotNull VirtualFile composerJson) {
        if (composerJson == null) {
            ComposerConfigUtils.$$$reportNull$$$0(1);
        }
        VirtualFile lock = ComposerConfigUtils.findLockFile(composerJson);
        try {
            return ComposerConfigUtils.getInstalledPackagesFromLock(lock);
        }
        catch (JsonParseException e) {
            return new ArrayList<InstalledPackageData>();
        }
    }

    @NotNull
    private static List<InstalledPackageData> getInstalledPackagesFromLock(@Nullable VirtualFile lockFile) throws JsonParseException {
        if (lockFile == null) {
            return new ArrayList<InstalledPackageData>();
        }
        JsonElement element = null;
        try {
            element = ComposerConfigUtils.parseJson(lockFile);
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
        if (element instanceof JsonObject) {
            ArrayList<InstalledPackageData> result = new ArrayList<InstalledPackageData>();
            for (JsonElement packagesElement : new JsonElement[]{((JsonObject)element).get("packages"), ((JsonObject)element).get("packages-dev")}) {
                if (!(packagesElement instanceof JsonArray)) continue;
                for (JsonElement next : (JsonArray)packagesElement) {
                    if (!(next instanceof JsonObject)) continue;
                    JsonElement name = ((JsonObject)next).get("name");
                    JsonElement version = ((JsonObject)next).get("version");
                    if (!(name instanceof JsonPrimitive) || !(version instanceof JsonPrimitive)) continue;
                    result.add(new InstalledPackageData(name.getAsString(), version.getAsString()));
                }
            }
            ArrayList<InstalledPackageData> arrayList = result;
            if (arrayList == null) {
                ComposerConfigUtils.$$$reportNull$$$0(2);
            }
            return arrayList;
        }
        return new ArrayList<InstalledPackageData>();
    }

    @Nullable
    public static Pair<String, String> getVendorAndBinDirs(@NotNull VirtualFile config) {
        if (config == null) {
            ComposerConfigUtils.$$$reportNull$$$0(3);
        }
        JsonElement element = null;
        try {
            element = ComposerConfigUtils.parseJson(config);
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            return null;
        }
        catch (JsonParseException e) {
            // empty catch block
        }
        String vendorDir = "vendor";
        Object binDir = null;
        if (element instanceof JsonObject) {
            try {
                JsonElement configElement = ((JsonObject)element).get("config");
                if (configElement instanceof JsonObject) {
                    JsonElement binDirElement;
                    JsonElement vendorDirElement = ((JsonObject)configElement).get(VENDOR_DIR_ELEMENT_NAME);
                    if (vendorDirElement != null) {
                        vendorDir = vendorDirElement.getAsString();
                    }
                    if ((binDirElement = ((JsonObject)configElement).get(BIN_DIR_ELEMENT_NAME)) instanceof JsonPrimitive) {
                        binDir = binDirElement.getAsString();
                    }
                }
            }
            catch (JsonParseException jsonParseException) {
                // empty catch block
            }
        }
        if (binDir == null) {
            binDir = vendorDir + "/bin";
        }
        return Pair.create((Object)vendorDir, (Object)binDir);
    }

    public static boolean containsSection(@NotNull VirtualFile config, @NotNull String sectionName) {
        if (config == null) {
            ComposerConfigUtils.$$$reportNull$$$0(4);
        }
        if (sectionName == null) {
            ComposerConfigUtils.$$$reportNull$$$0(5);
        }
        JsonElement element = null;
        try {
            element = ComposerConfigUtils.parseJson(config);
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            return false;
        }
        catch (JsonParseException e) {
            // empty catch block
        }
        if (element instanceof JsonObject) {
            try {
                JsonElement configElement = ((JsonObject)element).get(sectionName);
                return configElement != null;
            }
            catch (JsonParseException jsonParseException) {
                // empty catch block
            }
        }
        return false;
    }

    @Nullable
    public static Set<String> getExtensions(@NotNull VirtualFile config, PhpComposerExtensionStubsInspection.DependencyContext context) {
        JsonElement requireElement;
        JsonElement element;
        if (config == null) {
            ComposerConfigUtils.$$$reportNull$$$0(6);
        }
        try {
            element = ComposerConfigUtils.parseJson(config);
        }
        catch (JsonParseException | IOException e) {
            return null;
        }
        HashSet<String> extensions = new HashSet<String>();
        if (element instanceof JsonObject && (requireElement = ((JsonObject)element).get(context.getSectionName())) instanceof JsonObject) {
            requireElement.getAsJsonObject().entrySet().stream().map(Map.Entry::getKey).filter(s -> s.startsWith(EXT_PREFIX)).map(StringUtil::toLowerCase).forEach(extensions::add);
        }
        return extensions;
    }

    public static boolean requiresPhp(@Nullable VirtualFile config) {
        return ComposerConfigUtils.findRequiresDirectiveValue(config, PHP_PROPERTIES_NAMES) != null;
    }

    @Nullable
    public static String findRequiresPhpDirectiveValue(@Nullable VirtualFile config) {
        return ComposerConfigUtils.findRequiresDirectiveValue(config, PHP_PROPERTIES_NAMES);
    }

    @Nullable
    public static String findRequiresDirectiveValue(@Nullable VirtualFile config, String[] requireNames) {
        return ComposerConfigUtils.findRequiresDirectiveValue(config, requireNames, false);
    }

    @Nullable
    public static String findRequiresDirectiveValue(@Nullable VirtualFile config, String[] requireNames, boolean requireDev) {
        JsonElement element;
        if (config == null) {
            return null;
        }
        try {
            element = ComposerConfigUtils.parseJson(config);
        }
        catch (JsonParseException | IOException e) {
            return null;
        }
        if (element instanceof JsonObject) {
            String value = ComposerConfigUtils.getPropertyValue(REQUIRE_PROPERTY_NAME, requireNames, element);
            return value == null && requireDev ? ComposerConfigUtils.getPropertyValue(REQUIRE_DEV_PROPERTY_NAME, requireNames, element) : value;
        }
        return null;
    }

    private static String getPropertyValue(String section, String[] propertyNames, JsonElement root) {
        JsonElement configElement = ((JsonObject)root).get(section);
        if (configElement instanceof JsonObject) {
            return Arrays.stream(propertyNames).map(name -> ((JsonObject)configElement).get(name)).filter(Objects::nonNull).filter(JsonElement::isJsonPrimitive).map(JsonElement::getAsString).findFirst().orElse(null);
        }
        return null;
    }

    @NotNull
    public static List<String> getScripts(@NotNull VirtualFile config) {
        block9: {
            JsonElement scriptsElement;
            Document document;
            block8: {
                List<String> list;
                if (config == null) {
                    ComposerConfigUtils.$$$reportNull$$$0(7);
                }
                try {
                    document = FileDocumentManager.getInstance().getDocument(config);
                    if (document != null) break block8;
                    list = Collections.emptyList();
                }
                catch (JsonParseException e) {
                    List<String> list2 = Collections.emptyList();
                    if (list2 == null) {
                        ComposerConfigUtils.$$$reportNull$$$0(10);
                    }
                    return list2;
                }
                if (list == null) {
                    ComposerConfigUtils.$$$reportNull$$$0(8);
                }
                return list;
            }
            JsonElement element = new JsonParser().parse(document.getText());
            if (!(element instanceof JsonObject) || !((scriptsElement = ((JsonObject)element).get(SCRIPTS_PROPERTY_NAME)) instanceof JsonObject)) break block9;
            List list = ContainerUtil.mapNotNull((Collection)scriptsElement.getAsJsonObject().entrySet(), entry -> StringUtil.isEmpty((String)((String)entry.getKey())) ? null : (String)entry.getKey());
            if (list == null) {
                ComposerConfigUtils.$$$reportNull$$$0(9);
            }
            return list;
        }
        List<String> list = Collections.emptyList();
        if (list == null) {
            ComposerConfigUtils.$$$reportNull$$$0(11);
        }
        return list;
    }

    public static boolean customRepos(@Nullable VirtualFile config) {
        if (config == null) {
            return false;
        }
        try {
            JsonElement scriptsElement;
            Document document = FileDocumentManager.getInstance().getDocument(config);
            if (document == null) {
                return false;
            }
            JsonElement element = new JsonParser().parse(document.getText());
            if (element instanceof JsonObject && (scriptsElement = ((JsonObject)element).get(REPO_PROPERTY_NAME)) instanceof JsonArray) {
                return scriptsElement.getAsJsonArray().size() != 0;
            }
        }
        catch (JsonParseException e) {
            return false;
        }
        return false;
    }

    @Contract(value="null -> null")
    @Nullable
    public static String getScriptName(@Nullable JsonProperty property) {
        if (property == null || !ComposerConfigUtils.isScriptProperty(property)) {
            return null;
        }
        String propertyName = property.getName();
        return StringUtil.isEmpty((String)propertyName) ? null : propertyName;
    }

    public static boolean isScriptProperty(@NotNull JsonProperty property) {
        JsonProperty scriptsProperty;
        if (property == null) {
            ComposerConfigUtils.$$$reportNull$$$0(12);
        }
        return (scriptsProperty = PhpPsiUtil.getParentOfClass((PsiElement)property, true, JsonProperty.class)) != null && SCRIPTS_PROPERTY_NAME.equals(scriptsProperty.getName()) && ComposerConfigUtils.isTopLevelProperty(scriptsProperty);
    }

    public static boolean isTopLevelProperty(@NotNull JsonProperty property) {
        PsiElement parent;
        if (property == null) {
            ComposerConfigUtils.$$$reportNull$$$0(13);
        }
        return (parent = property.getParent()) != null && parent.getParent() instanceof JsonFile;
    }

    @Nullable
    public static VirtualFile getContainingComposerJsonFile(@NotNull PsiElement element) {
        PsiFile file;
        if (element == null) {
            ComposerConfigUtils.$$$reportNull$$$0(14);
        }
        if ((file = element.getContainingFile()) == null || !"composer.json".equals(file.getName())) {
            return null;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        return virtualFile;
    }

    @Contract(value="_, null -> false")
    public static boolean isPropertyKey(@NotNull PsiElement element, @Nullable JsonProperty property) {
        if (element == null) {
            ComposerConfigUtils.$$$reportNull$$$0(15);
        }
        return property != null && property.getNameElement() == element.getParent();
    }

    public static boolean isPackageProperty(@NotNull JsonProperty property) {
        JsonProperty parent;
        if (property == null) {
            ComposerConfigUtils.$$$reportNull$$$0(16);
        }
        if ((parent = PhpPsiUtil.getParentOfClass((PsiElement)property, true, JsonProperty.class)) == null) {
            return false;
        }
        String name = parent.getName();
        if (!REQUIRE_PROPERTY_NAME.equals(name) && !REQUIRE_DEV_PROPERTY_NAME.equals(name)) {
            return false;
        }
        return ComposerConfigUtils.isTopLevelProperty(parent);
    }

    @Contract(value="null -> null")
    @Nullable
    public static String getPackageName(@Nullable JsonProperty property) {
        if (property == null || !ComposerConfigUtils.isPackageProperty(property)) {
            return null;
        }
        String propertyName = property.getName();
        return StringUtil.isEmpty((String)propertyName) ? null : propertyName;
    }

    public static boolean belongsToCurrentComposerJson(@NotNull PsiElement element) {
        Project project;
        String currentConfigPath;
        if (element == null) {
            ComposerConfigUtils.$$$reportNull$$$0(17);
        }
        if ((currentConfigPath = ComposerConfigManager.getInstance(project = element.getProject()).getConfigPath(element)) == null) {
            return false;
        }
        VirtualFile containingConfigFile = ComposerConfigUtils.getContainingComposerJsonFile(element);
        if (containingConfigFile == null) {
            return false;
        }
        return VfsUtilCore.pathEqualsTo((VirtualFile)containingConfigFile, (String)currentConfigPath);
    }

    @NotNull
    public static String findVendorExecutablePath(Project project, @Nullable String configPath, @NotNull String exeName) {
        VirtualFile file;
        Pair<String, String> vendorToBin;
        VirtualFile composerConfig;
        if (exeName == null) {
            ComposerConfigUtils.$$$reportNull$$$0(18);
        }
        if (StringUtil.isNotEmpty((String)configPath) && (composerConfig = ComposerConfigUtils.findClosestComposerConfigBottomUp(project, configPath)) != null && (vendorToBin = ComposerConfigUtils.getVendorAndBinDirs(composerConfig)) != null && (file = composerConfig.getParent().findFileByRelativePath((String)vendorToBin.second + "/" + exeName)) != null) {
            String string = file.getPath();
            if (string == null) {
                ComposerConfigUtils.$$$reportNull$$$0(19);
            }
            return string;
        }
        VirtualFile projectDir = ProjectUtil.guessProjectDir((Project)project);
        String VENDOR_BIN_EXE = VENDOR_BIN + exeName;
        String string = projectDir != null ? projectDir.getPath() + VENDOR_BIN_EXE : VENDOR_BIN_EXE;
        if (string == null) {
            ComposerConfigUtils.$$$reportNull$$$0(20);
        }
        return string;
    }

    @Nullable
    private static VirtualFile findClosestComposerConfigBottomUp(@NotNull Project project, @NotNull String currentPath) {
        VirtualFile projectDir;
        if (project == null) {
            ComposerConfigUtils.$$$reportNull$$$0(21);
        }
        if (currentPath == null) {
            ComposerConfigUtils.$$$reportNull$$$0(22);
        }
        if ((projectDir = ProjectUtil.guessProjectDir((Project)project)) == null) {
            return null;
        }
        VirtualFile currentFile = projectDir.getFileSystem().findFileByPath(currentPath);
        if (currentFile == null) {
            return null;
        }
        VirtualFile composerJson = null;
        for (VirtualFile dir = currentFile.getParent(); dir != null && composerJson == null; dir = dir.getParent()) {
            composerJson = ComposerDetectionManager.findConfig(dir);
            if (dir.equals(projectDir)) break;
        }
        return composerJson;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 8, 9, 10, 11, 19, 20 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "composerJson";
                break;
            }
            case 2: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/composer/ComposerConfigUtils";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sectionName";
                break;
            }
            case 12: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 14: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exeName";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/composer/ComposerConfigUtils";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstalledPackagesFromLock";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getScripts";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "findVendorExecutablePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parseJson";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInstalledPackagesFromConfig";
                break;
            }
            case 2: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 19: 
            case 20: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getVendorAndBinDirs";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "containsSection";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getExtensions";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getScripts";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isScriptProperty";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isTopLevelProperty";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getContainingComposerJsonFile";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isPropertyKey";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isPackageProperty";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "belongsToCurrentComposerJson";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findVendorExecutablePath";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "findClosestComposerConfigBottomUp";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 8, 9, 10, 11, 19, 20 -> new IllegalStateException(string);
        };
    }
}

