/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.composer;

import com.intellij.DynamicBundle;
import com.intellij.execution.process.ScriptRunnerUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.composer.ComposerDataService;
import com.jetbrains.php.composer.ComposerExecutionForm;
import com.jetbrains.php.composer.ComposerJsonForm;
import com.jetbrains.php.config.PhpComposerFilesView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComposerPathForm {
    @NotNull
    private final Project myProject;
    @Nullable
    private final Runnable myValidationListener;
    private JPanel myMainPanel;
    private final boolean myShowJsonForm;
    private ComposerJsonForm myJsonForm;
    private final boolean myShowComposerFiles;
    private final boolean myShowExecutionForm;
    private final boolean myShowDownloadOption;
    @NotNull
    private final Disposable myDisposable;
    private JPanel myExecutionPanel;
    private ComposerExecutionForm myExecutionForm;
    private JLabel myErrorLabel;
    private JPanel myComposerFilesPanel;
    private PhpComposerFilesView myPhpComposerFilesView;

    public ComposerPathForm(@NotNull Project project, final @Nullable Runnable validationListener, boolean showComposerFiles, boolean showConfig, boolean showExecution, boolean showDownloadOption, @NotNull Disposable disposable) {
        if (project == null) {
            ComposerPathForm.$$$reportNull$$$0(0);
        }
        if (disposable == null) {
            ComposerPathForm.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myValidationListener = validationListener;
        this.myShowJsonForm = showConfig;
        this.myShowComposerFiles = showComposerFiles;
        this.myShowExecutionForm = showExecution;
        this.myShowDownloadOption = showDownloadOption;
        this.myDisposable = disposable;
        this.$$$setupUI$$$();
        this.myErrorLabel.setVisible(true);
        this.myErrorLabel.setFont(UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.MINI));
        this.myErrorLabel.setIcon(UIUtil.getBalloonWarningIcon());
        this.validatePaths();
        this.myExecutionForm.addDataListener(() -> this.validatePaths());
        DocumentAdapter documentAdapter = new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                ComposerPathForm.this.validatePaths();
                if (validationListener != null) {
                    validationListener.run();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/composer/ComposerPathForm$1", "textChanged"));
            }
        };
        this.myJsonForm.setChangeListener(documentAdapter);
        if (!this.myShowJsonForm || !this.myShowExecutionForm) {
            this.myExecutionPanel.setBorder(null);
        }
        if (showComposerFiles) {
            this.myComposerFilesPanel.setVisible(true);
            this.myComposerFilesPanel.add(this.myPhpComposerFilesView.getComponent());
        } else {
            this.myComposerFilesPanel.setVisible(false);
        }
    }

    private void createUIComponents() {
        this.myExecutionForm = new ComposerExecutionForm(this.myProject, this.myValidationListener, this.myShowExecutionForm, this.myShowDownloadOption, false, this.myDisposable);
        this.myJsonForm = new ComposerJsonForm(this.myProject, this.myShowJsonForm, !this.myShowComposerFiles);
        this.myPhpComposerFilesView = new PhpComposerFilesView(this.myProject, this.myDisposable);
    }

    private void validatePaths() {
        ValidationInfo info = this.validate();
        this.myErrorLabel.setText(info != null ? info.message : "");
        this.myErrorLabel.setVisible(info != null);
    }

    public JComponent getContentPane() {
        return this.myMainPanel;
    }

    public boolean isModified(ComposerDataService service) {
        if (this.myExecutionForm.isModified(service)) {
            return true;
        }
        if (this.myShowComposerFiles && this.myPhpComposerFilesView.isModified()) {
            return true;
        }
        return this.myJsonForm.isModified(service);
    }

    public void apply(ComposerDataService service) {
        this.myExecutionForm.apply(service);
        this.myJsonForm.apply(service);
        if (this.myShowComposerFiles) {
            this.myPhpComposerFilesView.apply();
        }
    }

    public void reset(ComposerDataService service) {
        this.myExecutionForm.reset(service);
        this.myJsonForm.reset(service);
        if (this.myShowComposerFiles) {
            this.myPhpComposerFilesView.reset();
        }
    }

    public void resetOrGuessDefaults(ComposerDataService service) {
        this.myExecutionForm.resetOrGuessDefaults(service);
        this.myJsonForm.reset(service);
        if (this.myShowComposerFiles) {
            this.myPhpComposerFilesView.reset();
        }
    }

    public ValidationInfo validate() {
        ValidationInfo info = this.myJsonForm.validate();
        if (info != null) {
            return info;
        }
        info = this.myExecutionForm.validate();
        if (info != null) {
            return new ValidationInfo(PhpBundle.message("framework.composer.path.form.execution.validation.wrapper", info.message));
        }
        return null;
    }

    public static ValidationInfo validateComposerPharPath(TextFieldWithBrowseButton textFieldWithBrowseButton) {
        String path = textFieldWithBrowseButton.getText();
        JComponent component = textFieldWithBrowseButton.getChildComponent();
        if (StringUtil.isEmptyOrSpaces((String)path)) {
            return new ValidationInfo(PhpBundle.message("framework.composer.path.form.empty.path.to.composer.phar", new Object[0]), component);
        }
        File file = new File(path);
        if (!file.exists()) {
            return new ValidationInfo(PhpBundle.message("framework.composer.file.0.is.not.found", path), component);
        }
        if (file.isDirectory()) {
            return new ValidationInfo(PhpBundle.message("framework.composer.path.validation.0.is.a.directory", path), component);
        }
        return null;
    }

    public static ValidationInfo validateComposerExecutablePath(TextFieldWithBrowseButton textFieldWithBrowseButton) {
        String path = textFieldWithBrowseButton.getText();
        JComponent component = textFieldWithBrowseButton.getChildComponent();
        if (StringUtil.isEmptyOrSpaces((String)path)) {
            return new ValidationInfo(PhpBundle.message("framework.composer.path.form.empty.path.to.composer.executable", new Object[0]), component);
        }
        if (!path.contains("/") && !path.contains("\\")) {
            String message = ComposerPathForm.validateExecutableFromPath(path);
            return message == null ? null : new ValidationInfo(message, component);
        }
        File file = new File(path);
        if (!file.exists()) {
            return new ValidationInfo(PhpBundle.message("framework.composer.file.0.is.not.found", path), component);
        }
        if (file.isDirectory()) {
            return new ValidationInfo(PhpBundle.message("framework.composer.path.validation.0.is.a.directory", path), component);
        }
        return null;
    }

    @Nullable
    @NlsContexts.DialogMessage
    static String validateExecutableFromPath(@NotNull String path) {
        boolean found;
        if (path == null) {
            ComposerPathForm.$$$reportNull$$$0(2);
        }
        if (found = ScriptRunnerUtil.isExecutableInPath((String)path)) {
            return null;
        }
        HtmlBuilder builder2 = new HtmlBuilder();
        if (SystemInfo.isWindows) {
            return builder2.append(PhpBundle.message("executable.0.was.not.found.in.path.please.make.sure.it.s.there.possible.solutions", path)).br().append(" - ").append(PhpBundle.message("if.you.ve.changed.the.path.recently.restart.the.ide", new Object[0])).br().append(" - ").append(PhpBundle.message("provide.the.full.path.to.executable", new Object[0])).br().append(" - ").append(PhpBundle.message("select.composer.phar.and.provide.the.full.path.to.it.or.select.download.composer.stable.phar.from.getcomposer.org", new Object[0])).wrapWith("html").toString();
        }
        return builder2.append(PhpBundle.message("executable.0.was.not.found.in.path.please.make.sure.it.s.there.possible.solutions1", path)).br().append(" - ").append(PhpBundle.message("if.you.ve.changed.the.path.recently.restart.the.ide1", new Object[0])).br().append(" - ").append(PhpBundle.message("provide.the.full.path.to.executable", new Object[0])).br().append(" - ").append(PhpBundle.message("select.composer.phar.and.provide.the.full.path.to.it.or.select.download.composer.stable.phar.from.getcomposer.org1", new Object[0])).wrapWith("html").toString();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        JLabel jLabel;
        JPanel jPanel3;
        this.createUIComponents();
        this.myMainPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myErrorLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/PhpBundle", ComposerPathForm.class).getString("composer.label.label"));
        jPanel3.add((Component)jLabel, new GridConstraints(4, 0, 1, 1, 10, 0, 7, 7, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myExecutionPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel3.add((Component)jPanel2, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)DynamicBundle.getBundle((String)"messages/PhpBundle", ComposerPathForm.class).getString("composer.border.title.execution"), (int)0, (int)0, null, null));
        ComposerExecutionForm composerExecutionForm = this.myExecutionForm;
        JComponent jComponent = composerExecutionForm.$$$getRootComponent$$$();
        jPanel2.add((Component)jComponent, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 3, null, null, null, 0, true));
        ComposerJsonForm composerJsonForm = this.myJsonForm;
        JComponent jComponent2 = composerJsonForm.$$$getRootComponent$$$();
        jPanel3.add((Component)jComponent2, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        this.myComposerFilesPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        ((Component)jPanel).setEnabled(true);
        jPanel.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel3.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 7, null, null, null));
        jPanel.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)DynamicBundle.getBundle((String)"messages/PhpBundle", ComposerPathForm.class).getString("php.project.configurable.composer.configs.tab.name"), (int)0, (int)0, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/composer/ComposerPathForm";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "validateExecutableFromPath";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

