/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.composer.actions;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.ThrowableNotNullFunction;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.composer.ComposerDataService;
import com.jetbrains.php.composer.ComposerUtils;
import com.jetbrains.php.composer.actions.ComposerAbstractAction;
import com.jetbrains.php.composer.actions.ComposerActionCommandExecutor;
import com.jetbrains.php.composer.actions.ComposerCommandExecutor;
import com.jetbrains.php.composer.actions.ComposerOptionsManager;
import com.jetbrains.php.composer.actions.log.ComposerLogMessageBuilder;
import com.jetbrains.php.composer.execution.ComposerExecution;
import com.jetbrains.php.composer.statistics.ComposerActionStatistics;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComposerRequirePackageAction
extends ComposerAbstractAction {
    public static final String COMMAND_NAME = "require";
    private final String myPackageName;
    private final boolean myDevMode;

    public ComposerRequirePackageAction(String packageName, boolean devMode) {
        this.myPackageName = packageName;
        this.myDevMode = devMode;
    }

    @Override
    protected void doPerformAction(@NotNull Project project, @NotNull VirtualFile configFile, @NotNull String placeForStatistics) {
        if (project == null) {
            ComposerRequirePackageAction.$$$reportNull$$$0(0);
        }
        if (configFile == null) {
            ComposerRequirePackageAction.$$$reportNull$$$0(1);
        }
        if (placeForStatistics == null) {
            ComposerRequirePackageAction.$$$reportNull$$$0(2);
        }
        ComposerCommandExecutor commandExecutor = this.createExecutor(project, configFile, placeForStatistics);
        commandExecutor.execute();
    }

    @Override
    public String getCommand() {
        return COMMAND_NAME;
    }

    @NotNull
    public ComposerCommandExecutor createExecutor(@NotNull Project project, @NotNull VirtualFile configFile, @Nullable String placeForStatistics) {
        if (project == null) {
            ComposerRequirePackageAction.$$$reportNull$$$0(3);
        }
        if (configFile == null) {
            ComposerRequirePackageAction.$$$reportNull$$$0(4);
        }
        return ComposerRequirePackageAction.createExecutor(project, this.myPackageName, ComposerDataService.getInstance(project).getComposerExecution(), configFile, ComposerOptionsManager.getRequireCommandLineOptions(this.myDevMode), placeForStatistics, false);
    }

    @NotNull
    public static ComposerCommandExecutor createExecutor(@NotNull Project project, final @NotNull String packageName, @NotNull ComposerExecution execution, final @NotNull VirtualFile configFile, @Nullable String commandLineOptions, @Nullable String placeForStatistics, boolean isLogCommand) {
        if (project == null) {
            ComposerRequirePackageAction.$$$reportNull$$$0(5);
        }
        if (packageName == null) {
            ComposerRequirePackageAction.$$$reportNull$$$0(6);
        }
        if (execution == null) {
            ComposerRequirePackageAction.$$$reportNull$$$0(7);
        }
        if (configFile == null) {
            ComposerRequirePackageAction.$$$reportNull$$$0(8);
        }
        ComposerActionStatistics statistics = placeForStatistics != null ? ComposerActionStatistics.create(ComposerActionStatistics.Action.REQUIRE, placeForStatistics) : null;
        return new ComposerActionCommandExecutor.WithConfig(project, execution, configFile, commandLineOptions, statistics, true, isLogCommand){

            @Override
            @NotNull
            protected List<String> getBasicCommand() {
                List<String> list = List.of(ComposerRequirePackageAction.COMMAND_NAME, packageName);
                if (list == null) {
                    1.$$$reportNull$$$0(0);
                }
                return list;
            }

            @Override
            @Nls
            protected String getProgressTitle() {
                return PhpBundle.message("framework.composer.require.task.title", packageName);
            }

            @Override
            @NlsSafe
            protected String getActionName() {
                return PhpBundle.message("framework.composer.require.action.name", new Object[0]);
            }

            @Override
            protected boolean handleAfterCommandExecution(boolean success) {
                ComposerUtils.refreshVendorDir(configFile);
                return success;
            }

            @Override
            protected ThrowableNotNullFunction<Project, ComposerCommandExecutor, ExecutionException> getExecutorGenerator() {
                return null;
            }

            @Override
            @Nls(capitalization=Nls.Capitalization.Title)
            @NotNull
            protected String getTaskTitle() {
                String string = PhpBundle.message("composer.require.package.task.title", new Object[0]);
                if (string == null) {
                    1.$$$reportNull$$$0(1);
                }
                return string;
            }

            @Override
            protected ComposerLogMessageBuilder.SummaryMessage createSuccessfulSummary() {
                return new ComposerLogMessageBuilder.SummaryMessage().appendText(packageName).appendText(" successfully installed for ").appendFileLink(this.myComposerJson, this.myProject).appendText(".");
            }

            @Override
            protected ComposerLogMessageBuilder.SummaryMessage createFailureSummary() {
                return new ComposerLogMessageBuilder.SummaryMessage().appendText("Failed to install ").appendText(packageName).appendText(" package for ").appendFileLink(this.myComposerJson, this.myProject).appendText(".");
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/jetbrains/php/composer/actions/ComposerRequirePackageAction$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getBasicCommand";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getTaskTitle";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    @Override
    protected boolean isAllowedPlace(@Nullable String place) {
        return super.isAllowedPlace(place) || Objects.equals(place, "Notification");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placeForStatistics";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "execution";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/composer/actions/ComposerRequirePackageAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "doPerformAction";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "createExecutor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

