/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.composer.actions;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ThrowableNotNullFunction;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.composer.ComposerDataService;
import com.jetbrains.php.composer.actions.ComposerAbstractAction;
import com.jetbrains.php.composer.actions.ComposerActionCommandExecutor;
import com.jetbrains.php.composer.actions.ComposerCommandExecutor;
import com.jetbrains.php.composer.actions.log.ComposerLogMessageBuilder;
import com.jetbrains.php.composer.execution.ComposerExecution;
import com.jetbrains.php.composer.statistics.ComposerActionStatistics;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import kotlin.Triple;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComposerStatusAction
extends ComposerAbstractAction {
    @NonNls
    public static final String ID = "ComposerStatusAction";
    public static final String COMMAND_NAME = "status";

    @Override
    protected void doPerformAction(@NotNull Project project, @NotNull VirtualFile configFile, @NotNull String placeForStatistics) {
        if (project == null) {
            ComposerStatusAction.$$$reportNull$$$0(0);
        }
        if (configFile == null) {
            ComposerStatusAction.$$$reportNull$$$0(1);
        }
        if (placeForStatistics == null) {
            ComposerStatusAction.$$$reportNull$$$0(2);
        }
        ComposerCommandExecutor commandExecutor = ComposerStatusAction.createExecutor(project, ComposerDataService.getInstance(project).getComposerExecution(), configFile, "--no-interaction --ansi --verbose", placeForStatistics);
        commandExecutor.execute();
    }

    @Override
    public String getCommand() {
        return COMMAND_NAME;
    }

    @NotNull
    protected static ComposerCommandExecutor createExecutor(@NotNull Project project, final @NotNull ComposerExecution execution, final @NotNull VirtualFile configFile, final @Nullable String commandLineOptions, @NotNull String placeForStatistics) {
        if (project == null) {
            ComposerStatusAction.$$$reportNull$$$0(3);
        }
        if (execution == null) {
            ComposerStatusAction.$$$reportNull$$$0(4);
        }
        if (configFile == null) {
            ComposerStatusAction.$$$reportNull$$$0(5);
        }
        if (placeForStatistics == null) {
            ComposerStatusAction.$$$reportNull$$$0(6);
        }
        ComposerActionStatistics actionStatistics = ComposerActionStatistics.create(ComposerActionStatistics.Action.STATUS, placeForStatistics);
        return new ComposerActionCommandExecutor.WithConfig(project, execution, configFile, commandLineOptions, actionStatistics, false, true){

            @Override
            @NotNull
            protected List<String> getBasicCommand() {
                List<String> list = Collections.singletonList(ComposerStatusAction.COMMAND_NAME);
                if (list == null) {
                    1.$$$reportNull$$$0(0);
                }
                return list;
            }

            @Override
            protected ThrowableNotNullFunction<Project, ComposerCommandExecutor, ExecutionException> getExecutorGenerator() {
                String configFilePath = configFile.getPath();
                return ComposerStatusAction.createExecutorGenerator(execution, configFilePath, commandLineOptions);
            }

            @Override
            protected ComposerLogMessageBuilder.SummaryMessage createSuccessfulSummary() {
                return new ComposerLogMessageBuilder.SummaryMessage("Composer found no local changes in dependencies of ").appendFileLink(this.myComposerJson, this.myProject).appendText(".");
            }

            @Override
            protected ComposerLogMessageBuilder.SummaryMessage createFailureSummary() {
                return new ComposerLogMessageBuilder.SummaryMessage("Composer found local changes in dependencies of ").appendFileLink(this.myComposerJson, this.myProject).appendText(".");
            }

            @Override
            @Nls
            protected String getProgressTitle() {
                return PhpBundle.message("checking.for.changes.in.code.of.dependencies", new Object[0]);
            }

            @Override
            @NlsSafe
            protected String getActionName() {
                return ComposerStatusAction.COMMAND_NAME;
            }

            @Override
            @Nls(capitalization=Nls.Capitalization.Title)
            @NotNull
            protected String getTaskTitle() {
                String string = PhpBundle.message("composer.checking.for.changes.in.code.of.dependencies.task.title", new Object[0]);
                if (string == null) {
                    1.$$$reportNull$$$0(1);
                }
                return string;
            }

            @Override
            @NotNull
            protected ComposerCommandExecutor.ComposerTextListener createTextListener(@NotNull ProgressIndicator indicator, @NotNull ComposerLogMessageBuilder builder2, @NotNull List<Pair<String, Key>> output) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (builder2 == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (output == null) {
                    1.$$$reportNull$$$0(4);
                }
                return new ComposerCommandExecutor.ComposerBaseTextListener(builder2, output, indicator){
                    private boolean stdErrorShown;
                    private final Queue<Triple<String, Key<?>, Key<?>>> outputToShow;
                    {
                        super(builder2, output, indicator);
                        this.stdErrorShown = false;
                        this.outputToShow = new LinkedList();
                    }

                    @Override
                    void textAvailable(@NotNull @NlsSafe String text, @NotNull Key attributes, @NotNull Key outputType) {
                        if (text == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (attributes == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        if (outputType == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        if (this.stdErrorShown) {
                            super.textAvailable(text, attributes, outputType);
                        } else if (outputType == ProcessOutputTypes.STDERR) {
                            super.textAvailable(text, attributes, outputType);
                            this.stdErrorShown = true;
                            this.printOutputToShow();
                        } else {
                            this.outputToShow.add(new Triple((Object)text, (Object)attributes, (Object)outputType));
                        }
                    }

                    private void printOutputToShow() {
                        Triple<String, Key<?>, Key<?>> triple = this.outputToShow.poll();
                        while (triple != null) {
                            super.textAvailable((String)triple.getFirst(), (Key)triple.getSecond(), (Key)triple.getThird());
                            triple = this.outputToShow.poll();
                        }
                    }

                    @Override
                    public void processTerminated(@NotNull ProcessEvent event) {
                        if (event == null) {
                            1.$$$reportNull$$$0(3);
                        }
                        this.printOutputToShow();
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "text";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "attributes";
                                break;
                            }
                            case 2: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "outputType";
                                break;
                            }
                            case 3: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "event";
                                break;
                            }
                        }
                        objectArray2[1] = "com/jetbrains/php/composer/actions/ComposerStatusAction$1$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "textAvailable";
                                break;
                            }
                            case 3: {
                                objectArray = objectArray2;
                                objectArray2[2] = "processTerminated";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                };
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 2, 3, 4 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/php/composer/actions/ComposerStatusAction$1";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "indicator";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "builder";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "output";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getBasicCommand";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getTaskTitle";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/php/composer/actions/ComposerStatusAction$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "createTextListener";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 2, 3, 4 -> new IllegalArgumentException(string);
                };
            }
        };
    }

    @NotNull
    private static ThrowableNotNullFunction<Project, ComposerCommandExecutor, ExecutionException> createExecutorGenerator(@NotNull ComposerExecution execution, @NotNull String configFilePath, @Nullable String commandLineOptions) {
        if (execution == null) {
            ComposerStatusAction.$$$reportNull$$$0(7);
        }
        if (configFilePath == null) {
            ComposerStatusAction.$$$reportNull$$$0(8);
        }
        ThrowableNotNullFunction throwableNotNullFunction = generatorProject -> {
            VirtualFile generatorConfigFile = LocalFileSystem.getInstance().findFileByPath(configFilePath);
            ComposerCommandExecutor.checkFileExists(configFilePath, generatorConfigFile);
            return ComposerStatusAction.createExecutor(generatorProject, execution, generatorConfigFile, commandLineOptions, "ComposerLogRerun");
        };
        if (throwableNotNullFunction == null) {
            ComposerStatusAction.$$$reportNull$$$0(9);
        }
        return throwableNotNullFunction;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configFile";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placeForStatistics";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "execution";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configFilePath";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/composer/actions/ComposerStatusAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/composer/actions/ComposerStatusAction";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createExecutorGenerator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doPerformAction";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createExecutor";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createExecutorGenerator";
                break;
            }
            case 9: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9 -> new IllegalStateException(string);
        };
    }
}

